/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.UnaryNwaOperation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.BuchiIsEmpty;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.NestedLassoWord;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;

public final class GetAcceptedLassoWord<LETTER, STATE>
extends UnaryNwaOperation<LETTER, STATE, IStateFactory<STATE>> {
    private final INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> mOperand;
    private final NestedLassoWord<LETTER> mAcceptedWord;

    public GetAcceptedLassoWord(AutomataLibraryServices automataLibraryServices, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider) throws AutomataOperationCanceledException {
        super(automataLibraryServices);
        this.mOperand = iNwaOutgoingLetterAndTransitionProvider;
        this.mLogger.info((Object)this.startMessage());
        BuchiIsEmpty<LETTER, STATE> buchiIsEmpty = new BuchiIsEmpty<LETTER, STATE>(this.mServices, iNwaOutgoingLetterAndTransitionProvider);
        if (buchiIsEmpty.getResult().booleanValue()) {
            throw new IllegalArgumentException("unable to get word from emtpy language");
        }
        this.mAcceptedWord = buchiIsEmpty.getAcceptingNestedLassoRun().getNestedLassoWord();
        this.mLogger.info((Object)this.exitMessage());
    }

    @Override
    protected INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> getOperand() {
        return this.mOperand;
    }

    @Override
    public NestedLassoWord<LETTER> getResult() {
        return this.mAcceptedWord;
    }

    @Override
    public String exitMessage() {
        return "Finished " + this.getOperationName() + ". Length of stem: " + this.mAcceptedWord.getStem().length() + " Length of loop:" + this.mAcceptedWord.getLoop().length();
    }

    @Override
    public boolean checkResult(IStateFactory<STATE> iStateFactory) throws AutomataLibraryException {
        return true;
    }
}

