/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.BinaryNwaOperation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaInclusionStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWord;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomataUtils;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.IsIncluded;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;

public class IsEquivalent<LETTER, STATE>
extends BinaryNwaOperation<LETTER, STATE, IStateFactory<STATE>> {
    private final INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> mFstOperand;
    private final INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> mSndOperand;
    private final boolean mResult;
    private NestedWord<LETTER> mCounterexample;
    private String mMessage;

    public IsEquivalent(AutomataLibraryServices automataLibraryServices, INwaInclusionStateFactory<STATE> iNwaInclusionStateFactory, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider2) throws AutomataLibraryException {
        super(automataLibraryServices);
        this.mFstOperand = iNwaOutgoingLetterAndTransitionProvider;
        this.mSndOperand = iNwaOutgoingLetterAndTransitionProvider2;
        if (!NestedWordAutomataUtils.sameAlphabet(this.mFstOperand, this.mSndOperand)) {
            throw new AutomataLibraryException(this.getClass(), "The operands have different alphabets.");
        }
        this.printStartMessage();
        this.mResult = this.checkEquivalence(iNwaInclusionStateFactory);
        this.printExitMessage();
    }

    @Override
    public INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> getFirstOperand() {
        return this.mFstOperand;
    }

    @Override
    public INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> getSecondOperand() {
        return this.mSndOperand;
    }

    @Override
    public Boolean getResult() {
        return this.mResult;
    }

    public NestedWord<LETTER> getCounterexample() {
        if (this.mResult) {
            throw new UnsupportedOperationException("No counterexample available.");
        }
        return this.mCounterexample;
    }

    public String getViolationMessage() {
        return this.mMessage;
    }

    private boolean checkEquivalence(INwaInclusionStateFactory<STATE> iNwaInclusionStateFactory) throws AutomataLibraryException {
        if (!this.checkInclusion(iNwaInclusionStateFactory, this.mFstOperand, this.mSndOperand)) {
            this.mMessage = "The first operand recognizes a word not recognized by the second one.";
            return false;
        }
        if (!this.checkInclusion(iNwaInclusionStateFactory, this.mSndOperand, this.mFstOperand)) {
            this.mMessage = "The second operand recognizes a word not recognized by the first one.";
            return false;
        }
        return true;
    }

    private boolean checkInclusion(INwaInclusionStateFactory<STATE> iNwaInclusionStateFactory, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider2) throws AutomataLibraryException {
        IsIncluded<LETTER, STATE> isIncluded = new IsIncluded<LETTER, STATE>(this.mServices, iNwaInclusionStateFactory, iNwaOutgoingLetterAndTransitionProvider, iNwaOutgoingLetterAndTransitionProvider2);
        if (!isIncluded.getResult().booleanValue()) {
            this.mCounterexample = isIncluded.getCounterexample().getWord();
            return false;
        }
        return true;
    }
}

