/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.inclusion;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedRun;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.NestedLassoRun;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.inclusion.AbstractGeneralizedAutomatonReachableStates;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.inclusion.StateContainer;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Set;

class LassoConstructor<LETTER, STATE> {
    private final AutomataLibraryServices mServices;
    private final AbstractGeneralizedAutomatonReachableStates<LETTER, STATE> mReach;
    private NestedRun<LETTER, STATE> mLoop;
    private NestedRun<LETTER, STATE> mStem;
    private StateContainer<LETTER, STATE> mGoal;
    private final NestedLassoRun<LETTER, STATE> mLasso;
    private final List<STATE> mSCC;
    private final Set<STATE> mSCCSet;

    LassoConstructor(AutomataLibraryServices automataLibraryServices, AbstractGeneralizedAutomatonReachableStates<LETTER, STATE> abstractGeneralizedAutomatonReachableStates, List<STATE> list) throws AutomataOperationCanceledException {
        this.mServices = automataLibraryServices;
        this.mReach = abstractGeneralizedAutomatonReachableStates;
        this.mSCC = list;
        this.mSCCSet = new HashSet<STATE>(this.mSCC.size());
        this.mSCCSet.addAll(this.mSCC);
        this.constructStemRun();
        this.constructLoopRun();
        this.mLasso = new NestedLassoRun<LETTER, STATE>(this.mStem, this.mLoop);
    }

    public NestedLassoRun<LETTER, STATE> getNestedLassoRun() {
        return this.mLasso;
    }

    private void constructLoopRun() throws AutomataOperationCanceledException {
        NestedRun nestedRun;
        Object object;
        Object object22;
        Object object32;
        LinkedList<STATE> linkedList = new LinkedList<STATE>();
        boolean bl = true;
        for (Object object32 : this.mSCC) {
            if (bl) {
                linkedList.addFirst(object32);
            } else {
                linkedList.addLast(object32);
            }
            if (!object32.equals(this.mGoal.getState())) continue;
            bl = false;
        }
        assert (linkedList.getFirst().equals(this.mGoal.getState()));
        this.mLoop = new NestedRun(this.mGoal.getState());
        linkedList.removeFirst();
        object32 = this.mGoal;
        HashSet<Integer> hashSet = new HashSet<Integer>(this.mReach.getAcceptanceLabels(((StateContainer)object32).getState()));
        Object object4 = this.mGoal.getState();
        for (Object object22 : linkedList) {
            this.testTimeoutCancelException(this.getClass());
            object = ((StateContainer)object32).getLetterOfSuccessor(object22);
            if (object != null) {
                hashSet.addAll(this.mReach.getAcceptanceLabels(object22));
                nestedRun = new NestedRun(((StateContainer)object32).getState(), object, -2, object22);
            } else {
                HashSet hashSet2 = new HashSet();
                HashSet<Object> hashSet3 = new HashSet<Object>();
                hashSet2.add(((StateContainer)object32).getState());
                hashSet3.add(object22);
                RunConstructor runConstructor = new RunConstructor(hashSet2, hashSet3, true);
                nestedRun = runConstructor.getNestedRun();
                hashSet.addAll(runConstructor.getLabels());
            }
            this.mLoop = this.mLoop.concatenate(nestedRun);
            object4 = object22;
            if (hashSet.size() == this.mReach.getAcceptanceSize()) break;
            object32 = this.mReach.getStateContainer(object22);
        }
        assert (hashSet.size() == this.mReach.getAcceptanceSize());
        if (object4.equals(this.mGoal.getState())) {
            object22 = this.mGoal.getLetterOfSuccessor(object4);
            assert (object22 != null);
            this.mLoop = new NestedRun<Object, STATE>(object4, object22, -2, object4);
            return;
        }
        object22 = new HashSet();
        HashSet hashSet4 = new HashSet();
        object22.add(object4);
        hashSet4.add(this.mGoal.getState());
        object = new RunConstructor(object22, hashSet4, true);
        nestedRun = ((RunConstructor)object).getNestedRun();
        this.mLoop = this.mLoop.concatenate(nestedRun);
    }

    private void constructStemRun() throws AutomataOperationCanceledException {
        RunConstructor runConstructor = new RunConstructor(this.mReach.getInitialStates(), this.mSCCSet, false);
        this.mStem = runConstructor.getNestedRun();
        this.mGoal = this.mReach.getStateContainer(this.mStem.getStateAtPosition(this.mStem.getLength() - 1));
        assert (this.mSCCSet.contains(this.mGoal.getState()));
    }

    private void testTimeoutCancelException(Class<?> clazz) throws AutomataOperationCanceledException {
        if (this.mServices.getProgressAwareTimer() != null && !this.mServices.getProgressAwareTimer().continueProcessing()) {
            throw new AutomataOperationCanceledException(clazz);
        }
    }

    private class ComparatorSuccessorInfo
    implements Comparator<SuccessorInfo> {
        private ComparatorSuccessorInfo() {
        }

        @Override
        public int compare(SuccessorInfo successorInfo, SuccessorInfo successorInfo2) {
            return successorInfo.mDistance - successorInfo2.mDistance;
        }
    }

    private class RunConstructor {
        private final Set<STATE> mSources;
        private final Set<STATE> mTargets;
        private NestedRun<LETTER, STATE> mNestedRun;
        private final Map<STATE, SuccessorInfo> mSuccInfo = new HashMap();
        private STATE mFoundState;
        private Set<Integer> mLabels;
        private final boolean mIsLoop;

        RunConstructor(Set<STATE> set, Set<STATE> set2, boolean bl) {
            this.mSources = set;
            this.mTargets = set2;
            this.mIsLoop = bl;
            if (this.mIsLoop) {
                this.mLabels = new HashSet<Integer>();
            }
        }

        NestedRun<LETTER, STATE> getNestedRun() throws AutomataOperationCanceledException {
            if (this.mNestedRun == null) {
                this.breathFirstSearch();
                this.constructRunBackwards();
            }
            return this.mNestedRun;
        }

        Set<Integer> getLabels() {
            return this.mLabels;
        }

        private SuccessorInfo getSuccessorInfoPrivate(STATE STATE) {
            SuccessorInfo successorInfo = this.mSuccInfo.get(STATE);
            if (successorInfo == null) {
                successorInfo = new SuccessorInfo(STATE);
                this.mSuccInfo.put(STATE, successorInfo);
            }
            return successorInfo;
        }

        private void constructRunBackwards() throws AutomataOperationCanceledException {
            SuccessorInfo successorInfo = this.mSuccInfo.get(this.mFoundState);
            if (successorInfo == null) {
                return;
            }
            this.mNestedRun = new NestedRun(this.mFoundState);
            if (this.mIsLoop) {
                this.mLabels.addAll(LassoConstructor.this.mReach.getAcceptanceLabels(this.mFoundState));
            }
            while (!this.mSources.contains(successorInfo.mState)) {
                LassoConstructor.this.testTimeoutCancelException(this.getClass());
                assert (successorInfo.mState.equals(this.mNestedRun.getStateAtPosition(0)));
                NestedRun nestedRun = new NestedRun(successorInfo.mPredState, successorInfo.mLetter, -2, successorInfo.mState);
                this.mNestedRun = nestedRun.concatenate(this.mNestedRun);
                successorInfo = this.mSuccInfo.get(successorInfo.mPredState);
                if (!this.mIsLoop) continue;
                this.mLabels.addAll(LassoConstructor.this.mReach.getAcceptanceLabels(successorInfo.mState));
            }
        }

        private void breathFirstSearch() throws AutomataOperationCanceledException {
            Object object;
            HashSet<Object> hashSet2;
            PriorityQueue<SuccessorInfo> priorityQueue = new PriorityQueue<SuccessorInfo>(new ComparatorSuccessorInfo());
            for (HashSet<Object> hashSet2 : this.mSources) {
                object = this.getSuccessorInfoPrivate(hashSet2);
                ((SuccessorInfo)object).mDistance = 0;
                priorityQueue.add((SuccessorInfo)object);
            }
            hashSet2 = new HashSet();
            while (!priorityQueue.isEmpty()) {
                LassoConstructor.this.testTimeoutCancelException(this.getClass());
                SuccessorInfo successorInfo = (SuccessorInfo)priorityQueue.remove();
                if (hashSet2.contains(successorInfo)) continue;
                if (this.mTargets.contains(successorInfo.mState)) {
                    this.mFoundState = successorInfo.mState;
                    break;
                }
                if (successorInfo.mDistance == Integer.MAX_VALUE) {
                    assert (false) : "Target not reachable";
                    break;
                }
                hashSet2.add(successorInfo.mState);
                object = LassoConstructor.this.mReach.getStateContainer(successorInfo.mState);
                for (OutgoingInternalTransition outgoingInternalTransition : ((StateContainer)object).internalSuccessors()) {
                    LassoConstructor.this.testTimeoutCancelException(this.getClass());
                    int n = successorInfo.mDistance + 1;
                    SuccessorInfo successorInfo2 = this.getSuccessorInfoPrivate(outgoingInternalTransition.getSucc());
                    if (successorInfo2.mDistance <= n || hashSet2.contains(outgoingInternalTransition.getSucc())) continue;
                    successorInfo2.mDistance = n;
                    successorInfo2.mLetter = outgoingInternalTransition.getLetter();
                    successorInfo2.mPredState = successorInfo.mState;
                    priorityQueue.remove(successorInfo2);
                    priorityQueue.add(successorInfo2);
                }
            }
        }
    }

    private class SuccessorInfo {
        final STATE mState;
        int mDistance;
        STATE mPredState;
        LETTER mLetter;

        SuccessorInfo(STATE STATE) {
            this.mState = STATE;
            this.mPredState = null;
            this.mLetter = null;
            this.mDistance = Integer.MAX_VALUE;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            SuccessorInfo successorInfo = (SuccessorInfo)object;
            return this.mState.equals(successorInfo.mState);
        }

        public int hashCode() {
            return Objects.hash(this.mState);
        }

        public String toString() {
            return "<" + String.valueOf(this.mState) + "," + this.mDistance + "," + String.valueOf(this.mPredState) + "," + String.valueOf(this.mLetter) + ">";
        }
    }
}

