/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.inclusion;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.IGeneralizedNwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWord;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.BuchiAccepts;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.GeneralizedBuchiAccepts;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.NestedLassoRun;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.NestedLassoWord;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.inclusion.GetLassoRunFromLassoWord;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UtilFixedCounterexample<LETTER extends IIcfgTransition<?>, STATE> {
    private final String PATH = "counterexamples";
    private final String SEPARATOR = "----";
    private final Map<String, LETTER> mMap = new HashMap<String, LETTER>();

    public NestedLassoWord<LETTER> getNestedLassoWord(INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider, String string, int n) {
        IIcfgTransition iIcfgTransition;
        File file = new File("counterexamples");
        if (!file.exists()) {
            return null;
        }
        String string2 = "counterexamples/" + string + n;
        File file2 = new File(string2);
        if (!file2.exists()) {
            return null;
        }
        this.mMap.clear();
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file2)));
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        if (!this.hasOnlyInternalLetters(iNwaOutgoingLetterAndTransitionProvider)) {
            return null;
        }
        this.addLettersToStringMap(this.mMap, iNwaOutgoingLetterAndTransitionProvider.getVpAlphabet().getInternalAlphabet());
        boolean bl = true;
        boolean bl2 = true;
        String string3 = null;
        NestedWord<IIcfgTransition> nestedWord = new NestedWord<IIcfgTransition>();
        NestedWord<IIcfgTransition> nestedWord2 = new NestedWord<IIcfgTransition>();
        try {
            while ((string3 = bufferedReader.readLine()) != null) {
                if (string3.startsWith("----")) {
                    bl = false;
                    continue;
                }
                iIcfgTransition = (IIcfgTransition)this.mMap.get(string3);
                if (iIcfgTransition == null) {
                    bl2 = false;
                    break;
                }
                NestedWord<IIcfgTransition> nestedWord3 = new NestedWord<IIcfgTransition>(iIcfgTransition, -2);
                if (bl) {
                    nestedWord = nestedWord.concatenate(nestedWord3);
                    continue;
                }
                nestedWord2 = nestedWord2.concatenate(nestedWord3);
            }
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        iIcfgTransition = null;
        if (bl2) {
            iIcfgTransition = new NestedLassoWord(nestedWord, nestedWord2);
        }
        return iIcfgTransition;
    }

    public NestedLassoRun<LETTER, STATE> getNestedLassoRun(AutomataLibraryServices automataLibraryServices, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider, String string, int n) throws AutomataOperationCanceledException {
        NestedLassoWord<LETTER> nestedLassoWord = this.getNestedLassoWord(iNwaOutgoingLetterAndTransitionProvider, string, n);
        if (nestedLassoWord == null) {
            return null;
        }
        return new GetLassoRunFromLassoWord<LETTER, STATE>(automataLibraryServices, iNwaOutgoingLetterAndTransitionProvider, nestedLassoWord).getNestedLassoRun();
    }

    private final void addLettersToStringMap(Map<String, LETTER> map, Set<LETTER> set) {
        for (IIcfgTransition iIcfgTransition : set) {
            String string = this.getLetterString(iIcfgTransition);
            if (map.containsKey(string)) {
                assert (false) : "Letters with the same string: " + String.valueOf(iIcfgTransition);
                continue;
            }
            map.put(string, iIcfgTransition);
        }
    }

    public final void writeNestedLassoRun(INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider, NestedLassoRun<LETTER, STATE> nestedLassoRun, String string, int n) {
        if (!this.hasOnlyInternalLetters(iNwaOutgoingLetterAndTransitionProvider)) {
            return;
        }
        File file = new File("counterexamples");
        if (!file.exists()) {
            return;
        }
        String string2 = "counterexamples/" + string + n;
        File file2 = new File(string2);
        this.writeWordToFile(nestedLassoRun.getNestedLassoWord(), file2);
    }

    private final void writeWordToFile(NestedLassoWord<LETTER> nestedLassoWord, File file) {
        PrintStream printStream = null;
        try {
            printStream = new PrintStream(file);
            this.writeLettersToFile(printStream, nestedLassoWord.getStem().asList());
            printStream.println("----");
            this.writeLettersToFile(printStream, nestedLassoWord.getLoop().asList());
            if (printStream != null) {
                printStream.close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
    }

    private final void writeLettersToFile(PrintStream printStream, List<LETTER> list) {
        for (IIcfgTransition iIcfgTransition : list) {
            printStream.println(this.getLetterString(iIcfgTransition));
        }
    }

    private final boolean hasOnlyInternalLetters(INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider) {
        return iNwaOutgoingLetterAndTransitionProvider.getVpAlphabet().getCallAlphabet().isEmpty() && iNwaOutgoingLetterAndTransitionProvider.getVpAlphabet().getReturnAlphabet().isEmpty();
    }

    private final String getLetterString(LETTER LETTER) {
        String string = String.valueOf(LETTER.getSource()) + "," + LETTER.toString() + String.valueOf(LETTER.getTarget());
        return string;
    }

    public void checkAcceptance(AutomataLibraryServices automataLibraryServices, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider, String string, int n) throws AutomataLibraryException {
        NestedLassoWord<LETTER> nestedLassoWord = this.getNestedLassoWord(iNwaOutgoingLetterAndTransitionProvider, string, n);
        if (nestedLassoWord == null) {
            throw new AssertionError((Object)"Empty word");
        }
        if (iNwaOutgoingLetterAndTransitionProvider instanceof IGeneralizedNwaOutgoingLetterAndTransitionProvider) {
            IGeneralizedNwaOutgoingLetterAndTransitionProvider iGeneralizedNwaOutgoingLetterAndTransitionProvider = (IGeneralizedNwaOutgoingLetterAndTransitionProvider)iNwaOutgoingLetterAndTransitionProvider;
            GeneralizedBuchiAccepts generalizedBuchiAccepts = new GeneralizedBuchiAccepts(automataLibraryServices, iGeneralizedNwaOutgoingLetterAndTransitionProvider, nestedLassoWord);
            System.err.println("Accepts: " + String.valueOf(generalizedBuchiAccepts.getResult()));
        } else {
            BuchiAccepts<LETTER, STATE> buchiAccepts = new BuchiAccepts<LETTER, STATE>(automataLibraryServices, iNwaOutgoingLetterAndTransitionProvider, nestedLassoWord);
            System.err.println("Accepts: " + String.valueOf(buchiAccepts.getResult()));
        }
    }
}

