/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.reachablestates;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.AutomatonDefinitionPrinter;
import de.uni_freiburg.informatik.ultimate.automata.LibraryIdentifiers;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.DownStateConsistencyCheck;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.IDoubleDeckerAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.VpAlphabet;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.BuchiAccepts;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.NestedLassoRun;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.oldapi.IOpWithDelayedDeadEndRemoval;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.inclusion.AbstractGeneralizedAutomatonReachableStates;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.reachablestates.AcceptingComponentsAnalysis;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.reachablestates.IAutomatonWithSccComputation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.reachablestates.StateContainer;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.reachablestates.StateContainerFieldAndMap;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.reachablestates.Summary;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IncomingCallTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IncomingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IncomingReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingCallTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.SummaryReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.RunningTaskInfo;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.util.InCaReCounter;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class NestedWordAutomatonReachableStates<LETTER, STATE>
implements IDoubleDeckerAutomaton<LETTER, STATE>,
IAutomatonWithSccComputation<LETTER, STATE> {
    private static final boolean EXT_RUN_CONSTRUCTION_TESTING = false;
    private static final boolean EXT_LASSO_CONSTRUCTION_TESTING = false;
    private final AutomataLibraryServices mServices;
    private final ILogger mLogger;
    private final INwaOutgoingTransitionProvider<LETTER, STATE> mOperand;
    private final VpAlphabet<LETTER> mVpAlphabet;
    private final Set<STATE> mInitialStates = new HashSet<STATE>();
    private final Set<STATE> mFinalStates = new HashSet<STATE>();
    private final Map<STATE, StateContainer<LETTER, STATE>> mStates = new HashMap<STATE, StateContainer<LETTER, STATE>>();
    private final Map<STATE, Map<LETTER, Map<STATE, Set<STATE>>>> mReturnSummary = new HashMap<STATE, Map<LETTER, Map<STATE, Set<STATE>>>>();
    private final InCaReCounter mNumberTransitions = new InCaReCounter();
    private final Set<LETTER> mEmptySetOfLetters = Collections.emptySet();
    private AncestorComputation mWithOutDeadEnds;
    private AncestorComputation mOnlyLiveStates;
    private AcceptingSummariesComputation mAcceptingSummaries;
    private AcceptingComponentsAnalysis<LETTER, STATE> mAcceptingComponentsAnalysis;

    public NestedWordAutomatonReachableStates(AutomataLibraryServices automataLibraryServices, INwaOutgoingTransitionProvider<LETTER, STATE> iNwaOutgoingTransitionProvider) throws AutomataOperationCanceledException {
        this.mServices = automataLibraryServices;
        this.mLogger = this.mServices.getLoggingService().getLogger(LibraryIdentifiers.PLUGIN_ID);
        this.mOperand = iNwaOutgoingTransitionProvider;
        this.mVpAlphabet = iNwaOutgoingTransitionProvider.getVpAlphabet();
        try {
            new ReachableStatesComputation();
            assert (this.checkTransitionsReturnedConsistent());
        }
        catch (ToolchainCanceledException toolchainCanceledException) {
            throw toolchainCanceledException;
        }
        catch (Error | RuntimeException throwable) {
            throw throwable;
        }
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)this.stateContainerInformation());
        }
        assert (new DownStateConsistencyCheck(this.mServices, this).getResult().booleanValue()) : "down states inconsistent";
    }

    private AutomataLibraryServices getServices() {
        return this.mServices;
    }

    private Map<STATE, StateContainer<LETTER, STATE>> getStatesMap() {
        return this.mStates;
    }

    private Collection<STATE> getInitialStatesPrivate() {
        return this.mInitialStates;
    }

    private Collection<STATE> getFinalStatesPrivate() {
        return this.mFinalStates;
    }

    private InCaReCounter getNumberTransitions() {
        return this.mNumberTransitions;
    }

    private void assertBuchiAcceptance(NestedLassoRun<LETTER, STATE> nestedLassoRun) throws AssertionError {
        try {
            assert (new BuchiAccepts(this.mServices, this, nestedLassoRun.getNestedLassoWord()).getResult().booleanValue());
        }
        catch (AutomataLibraryException automataLibraryException) {
            throw new AssertionError((Object)automataLibraryException);
        }
    }

    StateContainer<LETTER, STATE> getStateContainer(STATE STATE) {
        return this.mStates.get(STATE);
    }

    private String stateContainerInformation() {
        int n = 0;
        int n2 = 0;
        for (Map.Entry<STATE, StateContainer<LETTER, STATE>> entry : this.mStates.entrySet()) {
            StateContainer<LETTER, STATE> stateContainer = entry.getValue();
            if (!(stateContainer instanceof StateContainerFieldAndMap)) continue;
            if (((StateContainerFieldAndMap)stateContainer).mapModeIncoming()) {
                ++n;
            }
            if (!((StateContainerFieldAndMap)stateContainer).mapModeOutgoing()) continue;
            ++n2;
        }
        return this.mStates.size() + " StateContainers " + n + " in inMapMode" + n2 + " in outMapMode";
    }

    public AncestorComputation getWithOutDeadEnds() {
        return this.mWithOutDeadEnds;
    }

    public AncestorComputation getOnlyLiveStates() {
        return this.mOnlyLiveStates;
    }

    public final AcceptingComponentsAnalysis<LETTER, STATE> getOrComputeAcceptingComponents() {
        if (this.mAcceptingComponentsAnalysis == null) {
            this.computeAcceptingComponents();
        }
        return this.mAcceptingComponentsAnalysis;
    }

    public AcceptingSummariesComputation getAcceptingSummariesComputation() {
        return this.mAcceptingSummaries;
    }

    StateContainer<LETTER, STATE> obtainStateContainer(STATE STATE) {
        return this.mStates.get(STATE);
    }

    boolean isAccepting(Summary<LETTER, STATE> summary) {
        StateContainer<LETTER, STATE> stateContainer = summary.getHierPred();
        Set set = this.mAcceptingSummaries.getAcceptingSummaries().getImage(stateContainer);
        if (set == null) {
            return false;
        }
        return set.contains(summary);
    }

    @Override
    public int size() {
        return this.mStates.size();
    }

    @Override
    public String sizeInformation() {
        int n = this.mStates.size();
        StringBuilder stringBuilder = new StringBuilder().append(n).append(" states and ").append(this.mNumberTransitions).append(" transitions.");
        if (this.mAcceptingComponentsAnalysis != null) {
            int n2 = this.mNumberTransitions.getSum();
            int n3 = NestedWordAutomatonReachableStates.computeCyclomaticComplexity(n2, n, this.mAcceptingComponentsAnalysis.getSccComputation().getBalls().size());
            stringBuilder.append(" cyclomatic complexity: ").append(n3);
        }
        return stringBuilder.toString();
    }

    private static int computeCyclomaticComplexity(int n, int n2, int n3) {
        return n - n2 + n3;
    }

    @Override
    public VpAlphabet<LETTER> getVpAlphabet() {
        return this.mVpAlphabet;
    }

    @Override
    public IStateFactory<STATE> getStateFactory() {
        return this.mOperand.getStateFactory();
    }

    @Override
    public Set<STATE> getStates() {
        return this.mStates.keySet();
    }

    @Override
    public Set<STATE> getInitialStates() {
        return Collections.unmodifiableSet(this.mInitialStates);
    }

    @Override
    public Collection<STATE> getFinalStates() {
        return Collections.unmodifiableSet(this.mFinalStates);
    }

    @Override
    public boolean isInitial(STATE STATE) {
        return this.mOperand.isInitial(STATE);
    }

    @Override
    public boolean isFinal(STATE STATE) {
        return this.mOperand.isFinal(STATE);
    }

    @Override
    public STATE getEmptyStackState() {
        return this.mOperand.getEmptyStackState();
    }

    @Override
    public Set<LETTER> lettersInternal(STATE STATE) {
        return this.mStates.get(STATE).lettersInternal();
    }

    @Override
    public Set<LETTER> lettersCall(STATE STATE) {
        return this.mStates.get(STATE).lettersCall();
    }

    @Override
    public Set<LETTER> lettersReturn(STATE STATE, STATE STATE2) {
        return this.mStates.get(STATE).lettersReturn(STATE2);
    }

    @Override
    public Set<LETTER> lettersReturn(STATE STATE) {
        return this.mStates.get(STATE).lettersReturn();
    }

    @Override
    public Set<LETTER> lettersInternalIncoming(STATE STATE) {
        return this.mStates.get(STATE).lettersInternalIncoming();
    }

    @Override
    public Set<LETTER> lettersCallIncoming(STATE STATE) {
        return this.mStates.get(STATE).lettersCallIncoming();
    }

    @Override
    public Set<LETTER> lettersReturnIncoming(STATE STATE) {
        return this.mStates.get(STATE).lettersReturnIncoming();
    }

    @Override
    public Set<LETTER> lettersSummary(STATE STATE) {
        if (!this.mStates.containsKey(STATE)) {
            throw new IllegalArgumentException("State " + String.valueOf(STATE) + " unknown");
        }
        return this.lettersSummaryNoAssertion(STATE);
    }

    private Iterable<STATE> succInternal(STATE STATE, LETTER LETTER) {
        return this.mStates.get(STATE).succInternal(LETTER);
    }

    private Iterable<STATE> succCall(STATE STATE, LETTER LETTER) {
        return this.mStates.get(STATE).succCall(LETTER);
    }

    @Override
    public Iterable<STATE> hierarchicalPredecessorsOutgoing(STATE STATE, LETTER LETTER) {
        return this.mStates.get(STATE).hierPred(LETTER);
    }

    private Iterable<STATE> succReturn(STATE STATE, STATE STATE2, LETTER LETTER) {
        return this.mStates.get(STATE).succReturn(STATE2, LETTER);
    }

    private Iterable<STATE> predInternal(STATE STATE, LETTER LETTER) {
        return this.mStates.get(STATE).predInternal(LETTER);
    }

    private Iterable<STATE> predCall(STATE STATE, LETTER LETTER) {
        return this.mStates.get(STATE).predCall(LETTER);
    }

    void addReturnSummary(STATE STATE, STATE STATE2, LETTER LETTER, STATE STATE3) {
        Set<STATE> set;
        Map<STATE, Set<STATE>> map;
        Map<LETTER, Map<STATE, Set<STATE>>> map2 = this.mReturnSummary.get(STATE2);
        if (map2 == null) {
            map2 = new HashMap<LETTER, Map<STATE, Set<STATE>>>();
            this.mReturnSummary.put(STATE2, map2);
        }
        if ((map = map2.get(LETTER)) == null) {
            map = new HashMap<STATE, Set<STATE>>();
            map2.put(LETTER, map);
        }
        if ((set = map.get(STATE)) == null) {
            set = new HashSet<STATE>();
            map.put(STATE, set);
        }
        set.add(STATE3);
    }

    public Set<LETTER> lettersSummaryNoAssertion(STATE STATE) {
        Map<LETTER, Map<STATE, Set<STATE>>> map = this.mReturnSummary.get(STATE);
        return map == null ? this.mEmptySetOfLetters : map.keySet();
    }

    @Override
    public Iterable<SummaryReturnTransition<LETTER, STATE>> summarySuccessors(STATE STATE, LETTER LETTER) {
        HashSet<SummaryReturnTransition<LETTER, STATE>> hashSet = new HashSet<SummaryReturnTransition<LETTER, STATE>>();
        Map<LETTER, Map<STATE, Set<STATE>>> map = this.mReturnSummary.get(STATE);
        if (map == null) {
            return hashSet;
        }
        Map<STATE, Set<STATE>> map2 = map.get(LETTER);
        if (map2 == null) {
            return hashSet;
        }
        for (Map.Entry<STATE, Set<STATE>> entry : map2.entrySet()) {
            STATE STATE2 = entry.getKey();
            Set<STATE> set = entry.getValue();
            if (set == null) continue;
            for (STATE STATE3 : set) {
                SummaryReturnTransition<LETTER, STATE> summaryReturnTransition = new SummaryReturnTransition<LETTER, STATE>(STATE2, LETTER, STATE3);
                hashSet.add(summaryReturnTransition);
            }
        }
        return hashSet;
    }

    @Override
    public Iterable<SummaryReturnTransition<LETTER, STATE>> summarySuccessors(final STATE STATE) {
        return () -> new Iterator<SummaryReturnTransition<LETTER, STATE>>(){
            private Iterator<LETTER> mLetterIterator;
            private LETTER mCurrentLetter;
            private Iterator<SummaryReturnTransition<LETTER, STATE>> mCurrentIterator;
            {
                this.mLetterIterator = NestedWordAutomatonReachableStates.this.lettersSummaryNoAssertion(object).iterator();
                this.nextLetter();
            }

            private void nextLetter() {
                if (this.mLetterIterator.hasNext()) {
                    do {
                        this.mCurrentLetter = this.mLetterIterator.next();
                        this.mCurrentIterator = NestedWordAutomatonReachableStates.this.summarySuccessors(STATE, this.mCurrentLetter).iterator();
                    } while (!this.mCurrentIterator.hasNext() && this.mLetterIterator.hasNext());
                    if (!this.mCurrentIterator.hasNext()) {
                        this.mCurrentLetter = null;
                        this.mCurrentIterator = null;
                    }
                } else {
                    this.mCurrentLetter = null;
                    this.mCurrentIterator = null;
                }
            }

            @Override
            public boolean hasNext() {
                return this.mCurrentLetter != null;
            }

            @Override
            public SummaryReturnTransition<LETTER, STATE> next() {
                if (this.mCurrentLetter == null) {
                    throw new NoSuchElementException();
                }
                SummaryReturnTransition summaryReturnTransition = this.mCurrentIterator.next();
                if (!this.mCurrentIterator.hasNext()) {
                    this.nextLetter();
                }
                return summaryReturnTransition;
            }
        };
    }

    @Override
    public Iterable<IncomingInternalTransition<LETTER, STATE>> internalPredecessors(STATE STATE, LETTER LETTER) {
        return this.mStates.get(STATE).internalPredecessors(LETTER);
    }

    @Override
    public Iterable<IncomingInternalTransition<LETTER, STATE>> internalPredecessors(STATE STATE) {
        return this.mStates.get(STATE).internalPredecessors();
    }

    @Override
    public Iterable<IncomingCallTransition<LETTER, STATE>> callPredecessors(STATE STATE, LETTER LETTER) {
        return this.mStates.get(STATE).callPredecessors(LETTER);
    }

    @Override
    public Iterable<IncomingCallTransition<LETTER, STATE>> callPredecessors(STATE STATE) {
        return this.mStates.get(STATE).callPredecessors();
    }

    @Override
    public Iterable<OutgoingInternalTransition<LETTER, STATE>> internalSuccessors(STATE STATE, LETTER LETTER) {
        return this.mStates.get(STATE).internalSuccessors(LETTER);
    }

    @Override
    public Iterable<OutgoingInternalTransition<LETTER, STATE>> internalSuccessors(STATE STATE) {
        return this.mStates.get(STATE).internalSuccessors();
    }

    @Override
    public Iterable<OutgoingCallTransition<LETTER, STATE>> callSuccessors(STATE STATE, LETTER LETTER) {
        return this.mStates.get(STATE).callSuccessors(LETTER);
    }

    @Override
    public Iterable<OutgoingCallTransition<LETTER, STATE>> callSuccessors(STATE STATE) {
        return this.mStates.get(STATE).callSuccessors();
    }

    @Override
    public Iterable<IncomingReturnTransition<LETTER, STATE>> returnPredecessors(STATE STATE, STATE STATE2, LETTER LETTER) {
        return this.mStates.get(STATE).returnPredecessors(STATE2, LETTER);
    }

    @Override
    public Iterable<IncomingReturnTransition<LETTER, STATE>> returnPredecessors(STATE STATE, LETTER LETTER) {
        return this.mStates.get(STATE).returnPredecessors(LETTER);
    }

    @Override
    public Iterable<IncomingReturnTransition<LETTER, STATE>> returnPredecessors(STATE STATE) {
        return this.mStates.get(STATE).returnPredecessors();
    }

    @Override
    public Iterable<OutgoingReturnTransition<LETTER, STATE>> returnSuccessors(STATE STATE, STATE STATE2, LETTER LETTER) {
        return this.mStates.get(STATE).returnSuccessors(STATE2, LETTER);
    }

    @Override
    public Iterable<OutgoingReturnTransition<LETTER, STATE>> returnSuccessors(STATE STATE) {
        return this.mStates.get(STATE).returnSuccessors();
    }

    @Override
    public Iterable<OutgoingReturnTransition<LETTER, STATE>> returnSuccessorsGivenHier(STATE STATE, STATE STATE2) {
        return this.mStates.get(STATE).returnSuccessorsGivenHier(STATE2);
    }

    public void computeDeadEnds() {
        if (this.mWithOutDeadEnds != null) {
            return;
        }
        HashSet hashSet = new HashSet();
        for (STATE STATE : this.getFinalStates()) {
            StateContainer<LETTER, STATE> stateContainer = this.mStates.get(STATE);
            assert (stateContainer.getReachProp() != ReachProp.NODEADEND_AD && stateContainer.getReachProp() != ReachProp.NODEADEND_SD);
            hashSet.add(stateContainer);
        }
        this.mWithOutDeadEnds = new AncestorComputation(hashSet, ReachProp.NODEADEND_AD, ReachProp.NODEADEND_SD, StateContainer.DownStateProp.REACH_FINAL_ONCE, StateContainer.DownStateProp.REACHABLE_AFTER_DEADEND_REMOVAL);
    }

    public void computeAcceptingComponents() {
        if (this.mAcceptingComponentsAnalysis != null) {
            throw new AssertionError((Object)"SCCs are already computed");
        }
        assert (this.mAcceptingSummaries == null);
        this.mAcceptingSummaries = new AcceptingSummariesComputation();
        this.mAcceptingComponentsAnalysis = new AcceptingComponentsAnalysis(this.mServices, this, this.mAcceptingSummaries, this.mStates.keySet(), this.mInitialStates);
    }

    public void computeNonLiveStates() {
        if (this.mOnlyLiveStates != null) {
            return;
        }
        if (this.getOrComputeAcceptingComponents() == null) {
            this.computeAcceptingComponents();
        }
        HashSet<StateContainer<LETTER, STATE>> hashSet = new HashSet<StateContainer<LETTER, STATE>>(this.mAcceptingComponentsAnalysis.getStatesOfAllSccs());
        this.mOnlyLiveStates = new AncestorComputation(hashSet, ReachProp.LIVE_AD, ReachProp.LIVE_SD, StateContainer.DownStateProp.REACH_FINAL_INFTY, StateContainer.DownStateProp.REACHABLE_AFTER_NONLIVE_REMOVAL);
    }

    @Override
    public Set<STATE> getDownStates(STATE STATE) {
        StateContainer<LETTER, STATE> stateContainer = this.mStates.get(STATE);
        return stateContainer.getDownStates().keySet();
    }

    @Override
    public boolean isDoubleDecker(STATE STATE, STATE STATE2) {
        return this.getDownStates(STATE).contains(STATE2);
    }

    public static <E> boolean noElementIsNull(Collection<E> collection) {
        for (E e : collection) {
            if (e != null) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return AutomatonDefinitionPrinter.toString(this.mServices, "nwa", this);
    }

    @Override
    public Collection<AcceptingComponentsAnalysis.StronglyConnectedComponentWithAcceptanceInformation<LETTER, STATE>> computeBalls(Set<STATE> set, Set<STATE> set2) {
        if (!this.getStates().containsAll(set)) {
            throw new IllegalArgumentException("not a subset of the automaton's states: " + String.valueOf(set));
        }
        if (!set.containsAll(set2)) {
            throw new IllegalArgumentException("start states must be restricted to your subset");
        }
        if (this.mAcceptingSummaries == null) {
            this.mAcceptingSummaries = new AcceptingSummariesComputation();
        }
        AcceptingComponentsAnalysis acceptingComponentsAnalysis = new AcceptingComponentsAnalysis(this.mServices, this, this.mAcceptingSummaries, set, set2);
        return acceptingComponentsAnalysis.getSccComputation().getBalls();
    }

    public boolean containsInternalTransition(STATE STATE, LETTER LETTER, STATE STATE2) {
        return this.mStates.get(STATE).containsInternalTransition(LETTER, STATE2);
    }

    public boolean containsCallTransition(STATE STATE, LETTER LETTER, STATE STATE2) {
        return this.mStates.get(STATE).containsCallTransition(LETTER, STATE2);
    }

    public boolean containsReturnTransition(STATE STATE, STATE STATE2, LETTER LETTER, STATE STATE3) {
        return this.mStates.get(STATE).containsReturnTransition(STATE2, LETTER, STATE3);
    }

    protected boolean containsSummaryReturnTransition(STATE STATE, STATE STATE2, LETTER LETTER, STATE STATE3) {
        for (SummaryReturnTransition<LETTER, STATE> summaryReturnTransition : this.summarySuccessors(STATE2, LETTER)) {
            if (!STATE3.equals(summaryReturnTransition.getSucc()) || !STATE.equals(summaryReturnTransition.getLinPred())) continue;
            return true;
        }
        return false;
    }

    final boolean checkTransitionsReturnedConsistent() throws AutomataOperationCanceledException {
        boolean bl = true;
        for (STATE STATE : this.getStates()) {
            StateContainer stateContainer;
            if (!this.mServices.getProgressAwareTimer().continueProcessing()) {
                throw new AutomataOperationCanceledException(this.getClass());
            }
            for (IncomingInternalTransition<LETTER, STATE> incomingInternalTransition : this.internalPredecessors(STATE)) {
                assert (bl &= this.containsInternalTransition(incomingInternalTransition.getPred(), incomingInternalTransition.getLetter(), STATE));
                stateContainer = this.mStates.get(STATE);
                assert (bl &= stateContainer.lettersInternalIncoming().contains(incomingInternalTransition.getLetter()));
                assert (bl &= stateContainer.predInternal(incomingInternalTransition.getLetter()).contains(incomingInternalTransition.getPred()));
            }
            for (OutgoingInternalTransition outgoingInternalTransition : this.internalSuccessors(STATE)) {
                assert (bl &= this.containsInternalTransition(STATE, outgoingInternalTransition.getLetter(), outgoingInternalTransition.getSucc()));
                stateContainer = this.mStates.get(STATE);
                assert (bl &= stateContainer.lettersInternal().contains(outgoingInternalTransition.getLetter()));
                assert (bl &= stateContainer.succInternal(outgoingInternalTransition.getLetter()).contains(outgoingInternalTransition.getSucc()));
            }
            for (IncomingCallTransition incomingCallTransition : this.callPredecessors(STATE)) {
                assert (bl &= this.containsCallTransition(incomingCallTransition.getPred(), incomingCallTransition.getLetter(), STATE));
                stateContainer = this.mStates.get(STATE);
                assert (bl &= stateContainer.lettersCallIncoming().contains(incomingCallTransition.getLetter()));
                assert (bl &= stateContainer.predCall(incomingCallTransition.getLetter()).contains(incomingCallTransition.getPred()));
            }
            for (OutgoingCallTransition outgoingCallTransition : this.callSuccessors(STATE)) {
                assert (bl &= this.containsCallTransition(STATE, outgoingCallTransition.getLetter(), outgoingCallTransition.getSucc()));
                stateContainer = this.mStates.get(STATE);
                assert (bl &= stateContainer.lettersCall().contains(outgoingCallTransition.getLetter()));
                assert (bl &= stateContainer.succCall(outgoingCallTransition.getLetter()).contains(outgoingCallTransition.getSucc()));
            }
            for (IncomingReturnTransition incomingReturnTransition : this.returnPredecessors(STATE)) {
                assert (bl &= this.containsReturnTransition(incomingReturnTransition.getLinPred(), incomingReturnTransition.getHierPred(), incomingReturnTransition.getLetter(), STATE));
                assert (bl &= this.containsSummaryReturnTransition(incomingReturnTransition.getLinPred(), incomingReturnTransition.getHierPred(), incomingReturnTransition.getLetter(), STATE));
                stateContainer = this.mStates.get(STATE);
                assert (bl &= stateContainer.lettersReturnIncoming().contains(incomingReturnTransition.getLetter()));
                assert (bl &= stateContainer.predReturnHier(incomingReturnTransition.getLetter()).contains(incomingReturnTransition.getHierPred()));
                assert (bl &= stateContainer.predReturnLin(incomingReturnTransition.getLetter(), incomingReturnTransition.getHierPred()).contains(incomingReturnTransition.getLinPred()));
            }
            for (OutgoingReturnTransition outgoingReturnTransition : this.returnSuccessors(STATE)) {
                assert (bl &= this.containsReturnTransition(STATE, outgoingReturnTransition.getHierPred(), outgoingReturnTransition.getLetter(), outgoingReturnTransition.getSucc()));
                assert (bl &= this.containsSummaryReturnTransition(STATE, outgoingReturnTransition.getHierPred(), outgoingReturnTransition.getLetter(), outgoingReturnTransition.getSucc()));
                stateContainer = this.mStates.get(STATE);
                assert (bl &= stateContainer.lettersReturn().contains(outgoingReturnTransition.getLetter()));
                assert (bl &= stateContainer.hierPred(outgoingReturnTransition.getLetter()).contains(outgoingReturnTransition.getHierPred()));
                assert (bl &= stateContainer.succReturn(outgoingReturnTransition.getHierPred(), outgoingReturnTransition.getLetter()).contains(outgoingReturnTransition.getSucc()));
            }
            for (OutgoingInternalTransition outgoingInternalTransition : this.internalSuccessors(STATE)) {
                assert (bl &= this.containsInternalTransition(STATE, outgoingInternalTransition.getLetter(), outgoingInternalTransition.getSucc()));
            }
            for (OutgoingCallTransition outgoingCallTransition : this.callSuccessors(STATE)) {
                assert (bl &= this.containsCallTransition(STATE, outgoingCallTransition.getLetter(), outgoingCallTransition.getSucc()));
            }
            for (OutgoingReturnTransition outgoingReturnTransition : this.returnSuccessors(STATE)) {
                assert (bl &= this.containsReturnTransition(STATE, outgoingReturnTransition.getHierPred(), outgoingReturnTransition.getLetter(), outgoingReturnTransition.getSucc()));
            }
            for (IncomingInternalTransition incomingInternalTransition : this.internalPredecessors(STATE)) {
                assert (bl &= this.containsInternalTransition(incomingInternalTransition.getPred(), incomingInternalTransition.getLetter(), STATE));
            }
            for (IncomingCallTransition incomingCallTransition : this.callPredecessors(STATE)) {
                assert (bl &= this.containsCallTransition(incomingCallTransition.getPred(), incomingCallTransition.getLetter(), STATE));
            }
            for (IncomingReturnTransition incomingReturnTransition : this.returnPredecessors(STATE)) {
                assert (bl &= this.containsReturnTransition(incomingReturnTransition.getLinPred(), incomingReturnTransition.getHierPred(), incomingReturnTransition.getLetter(), STATE));
            }
        }
        return bl;
    }

    public boolean checkWorklistEmpty(STATE STATE) {
        StateContainer<LETTER, STATE> stateContainer = this.mStates.get(STATE);
        return stateContainer.getUnpropagatedDownStates() == null;
    }

    boolean checkStateEquality(STATE STATE, STATE STATE2) {
        return STATE == STATE2;
    }

    boolean checkStateContainerEquality(StateContainer<LETTER, STATE> stateContainer, StateContainer<LETTER, STATE> stateContainer2) {
        return stateContainer == stateContainer2;
    }

    class AcceptingSummariesComputation {
        private final ArrayDeque<StateContainer<LETTER, STATE>> mFinAncWorklist = new ArrayDeque();
        private final HashRelation<StateContainer<LETTER, STATE>, Summary<LETTER, STATE>> mAcceptingSummariesInner = new HashRelation();

        public AcceptingSummariesComputation() {
            this.init();
            while (!this.mFinAncWorklist.isEmpty()) {
                StateContainer stateContainer = this.mFinAncWorklist.removeFirst();
                this.propagateNewDownStates(stateContainer);
            }
        }

        public HashRelation<StateContainer<LETTER, STATE>, Summary<LETTER, STATE>> getAcceptingSummaries() {
            return this.mAcceptingSummariesInner;
        }

        private void init() {
            for (Object STATE : NestedWordAutomatonReachableStates.this.getFinalStatesPrivate()) {
                StateContainer stateContainer = NestedWordAutomatonReachableStates.this.getStatesMap().get(STATE);
                this.addNewDownStates(null, stateContainer, stateContainer.getDownStates().keySet());
            }
        }

        private void addNewDownStates(StateContainer<LETTER, STATE> stateContainer, StateContainer<LETTER, STATE> stateContainer2, Set<STATE> set) {
            if (NestedWordAutomatonReachableStates.this.checkStateContainerEquality(stateContainer, stateContainer2)) {
                return;
            }
            boolean bl = false;
            for (Object STATE : set) {
                boolean bl2 = stateContainer2.setDownProp(STATE, StateContainer.DownStateProp.REACHABLE_FROM_FINAL_WITHOUT_CALL);
                if (!bl2) continue;
                bl = true;
            }
            if (bl) {
                this.mFinAncWorklist.add(stateContainer2);
            }
        }

        private void propagateNewDownStates(StateContainer<LETTER, STATE> stateContainer) {
            StateContainer stateContainer2;
            Set set = stateContainer.getUnpropagatedDownStates();
            if (set == null) {
                return;
            }
            for (OutgoingInternalTransition iOutgoingTransitionlet : stateContainer.internalSuccessors()) {
                stateContainer2 = NestedWordAutomatonReachableStates.this.getStatesMap().get(iOutgoingTransitionlet.getSucc());
                this.addNewDownStates(stateContainer, stateContainer2, set);
            }
            for (SummaryReturnTransition summaryReturnTransition : NestedWordAutomatonReachableStates.this.summarySuccessors(stateContainer.getState())) {
                stateContainer2 = NestedWordAutomatonReachableStates.this.getStatesMap().get(summaryReturnTransition.getSucc());
                this.addNewDownStates(stateContainer, stateContainer2, set);
            }
            stateContainer.eraseUnpropagatedDownStates();
            for (OutgoingReturnTransition outgoingReturnTransition : stateContainer.returnSuccessors()) {
                stateContainer2 = NestedWordAutomatonReachableStates.this.getStatesMap().get(outgoingReturnTransition.getHierPred());
                StateContainer stateContainer3 = NestedWordAutomatonReachableStates.this.getStatesMap().get(outgoingReturnTransition.getSucc());
                Object STATE = outgoingReturnTransition.getHierPred();
                if (!stateContainer.hasDownProp(STATE, StateContainer.DownStateProp.REACHABLE_FROM_FINAL_WITHOUT_CALL)) continue;
                this.addNewDownStates(null, stateContainer3, stateContainer2.getDownStates().keySet());
                this.addAcceptingSummary(stateContainer2, stateContainer, outgoingReturnTransition.getLetter(), stateContainer3);
            }
        }

        private void addAcceptingSummary(StateContainer<LETTER, STATE> stateContainer, StateContainer<LETTER, STATE> stateContainer2, LETTER LETTER, StateContainer<LETTER, STATE> stateContainer3) {
            Summary summary = new Summary(stateContainer, stateContainer2, LETTER, stateContainer3);
            this.mAcceptingSummariesInner.addPair(stateContainer, summary);
        }
    }

    public class AncestorComputation {
        protected final ReachProp mRpAllDown;
        protected final ReachProp mRpSomeDown;
        protected final StateContainer.DownStateProp mDspReachPrecious;
        private final StateContainer.DownStateProp mDspReachableAfterRemoval;
        private final Set<STATE> mAncestors = new HashSet();
        private final Set<STATE> mAncestorsInitial = new HashSet();
        private final Set<STATE> mAncestorsAccepting = new HashSet();
        private final ArrayDeque<StateContainer<LETTER, STATE>> mNonReturnBackwardWorklist = new ArrayDeque();
        private final Set<StateContainer<LETTER, STATE>> mHasIncomingReturn = new HashSet();
        private final ArrayDeque<StateContainer<LETTER, STATE>> mPropagationWorklist = new ArrayDeque();

        AncestorComputation(HashSet<StateContainer<LETTER, STATE>> hashSet, ReachProp reachProp, ReachProp reachProp2, StateContainer.DownStateProp downStateProp, StateContainer.DownStateProp downStateProp2) {
            Object object;
            StateContainer stateContainer2;
            this.mRpAllDown = reachProp;
            this.mRpSomeDown = reachProp2;
            this.mDspReachPrecious = downStateProp;
            this.mDspReachableAfterRemoval = downStateProp2;
            for (StateContainer stateContainer2 : hashSet) {
                stateContainer2.setReachProp(this.mRpAllDown);
                this.mAncestors.add(stateContainer2.getState());
                this.mNonReturnBackwardWorklist.add(stateContainer2);
            }
            while (!this.mNonReturnBackwardWorklist.isEmpty()) {
                Iterator iterator;
                stateContainer2 = this.mNonReturnBackwardWorklist.removeFirst();
                if (NestedWordAutomatonReachableStates.this.getInitialStatesPrivate().contains(stateContainer2.getState())) {
                    this.mAncestorsInitial.add(stateContainer2.getState());
                }
                if (NestedWordAutomatonReachableStates.this.isFinal(stateContainer2.getState())) {
                    this.mAncestorsAccepting.add(stateContainer2.getState());
                }
                for (IncomingInternalTransition incomingInternalTransition : stateContainer2.internalPredecessors()) {
                    iterator = incomingInternalTransition.getPred();
                    object = NestedWordAutomatonReachableStates.this.getStatesMap().get(iterator);
                    if (((StateContainer)object).getReachProp() == this.mRpAllDown) continue;
                    ((StateContainer)object).setReachProp(this.mRpAllDown);
                    this.mAncestors.add(iterator);
                    this.mNonReturnBackwardWorklist.add((StateContainer)object);
                }
                for (IncomingReturnTransition incomingReturnTransition : stateContainer2.returnPredecessors()) {
                    iterator = incomingReturnTransition.getHierPred();
                    object = NestedWordAutomatonReachableStates.this.getStatesMap().get(iterator);
                    if (((StateContainer)object).getReachProp() != this.mRpAllDown) {
                        ((StateContainer)object).setReachProp(this.mRpAllDown);
                        this.mAncestors.add(iterator);
                        this.mNonReturnBackwardWorklist.add((StateContainer)object);
                    }
                    this.mHasIncomingReturn.add(stateContainer2);
                }
                for (IncomingCallTransition incomingCallTransition : stateContainer2.callPredecessors()) {
                    iterator = incomingCallTransition.getPred();
                    object = NestedWordAutomatonReachableStates.this.getStatesMap().get(iterator);
                    if (((StateContainer)object).getReachProp() == this.mRpAllDown) continue;
                    ((StateContainer)object).setReachProp(this.mRpAllDown);
                    this.mAncestors.add(iterator);
                    this.mNonReturnBackwardWorklist.add((StateContainer)object);
                }
            }
            for (StateContainer stateContainer2 : this.mHasIncomingReturn) {
                for (IncomingReturnTransition incomingReturnTransition : stateContainer2.returnPredecessors()) {
                    object = incomingReturnTransition.getLinPred();
                    StateContainer stateContainer3 = NestedWordAutomatonReachableStates.this.getStatesMap().get(object);
                    if (stateContainer3.getReachProp() == this.mRpAllDown) continue;
                    HashSet hashSet2 = new HashSet(1);
                    hashSet2.add(incomingReturnTransition.getHierPred());
                    this.addNewDownStates(null, stateContainer3, hashSet2);
                }
            }
            while (!this.mPropagationWorklist.isEmpty()) {
                stateContainer2 = this.mPropagationWorklist.removeFirst();
                this.propagateBackward(stateContainer2);
            }
            this.removeUnnecessaryInitialStates();
            this.propagateReachableAfterRemovalDoubleDeckers();
        }

        public Set<STATE> getStates() {
            return this.mAncestors;
        }

        public Set<STATE> getInitials() {
            return this.mAncestorsInitial;
        }

        public Set<STATE> getFinals() {
            return this.mAncestorsAccepting;
        }

        private void removeUnnecessaryInitialStates() {
            Iterator iterator = this.mAncestorsInitial.iterator();
            while (iterator.hasNext()) {
                boolean bl;
                Object STATE = iterator.next();
                StateContainer stateContainer = NestedWordAutomatonReachableStates.this.getStatesMap().get(STATE);
                if (stateContainer.getReachProp() == this.mRpAllDown || (bl = stateContainer.hasDownProp(NestedWordAutomatonReachableStates.this.getEmptyStackState(), StateContainer.DownStateProp.REACH_FINAL_ONCE))) continue;
                iterator.remove();
            }
        }

        private void propagateBackward(StateContainer<LETTER, STATE> stateContainer) {
            StateContainer stateContainer2;
            Object object;
            Set<Object> set = stateContainer.getUnpropagatedDownStates();
            stateContainer.eraseUnpropagatedDownStates();
            HashSet<Object> hashSet = null;
            for (IncomingInternalTransition object2 : stateContainer.internalPredecessors()) {
                object = object2.getPred();
                stateContainer2 = NestedWordAutomatonReachableStates.this.getStatesMap().get(object);
                if (stateContainer2.getReachProp() == this.mRpAllDown) continue;
                this.addNewDownStates(stateContainer, stateContainer2, set);
            }
            for (IncomingReturnTransition incomingReturnTransition : stateContainer.returnPredecessors()) {
                object = incomingReturnTransition.getHierPred();
                stateContainer2 = NestedWordAutomatonReachableStates.this.getStatesMap().get(object);
                if (stateContainer2.getReachProp() != this.mRpAllDown) {
                    this.addNewDownStates(stateContainer, stateContainer2, set);
                }
                Object STATE = incomingReturnTransition.getLinPred();
                StateContainer stateContainer3 = NestedWordAutomatonReachableStates.this.getStatesMap().get(STATE);
                if (stateContainer3.getReachProp() == this.mRpAllDown || !this.atLeastOneOccursAsDownState(stateContainer2, set)) continue;
                if (NestedWordAutomatonReachableStates.this.checkStateContainerEquality(stateContainer3, stateContainer)) {
                    boolean bl = stateContainer.hasDownProp(object, this.mDspReachPrecious);
                    if (bl) continue;
                    if (hashSet == null) {
                        hashSet = new HashSet<Object>();
                    }
                    hashSet.add(object);
                    continue;
                }
                HashSet<Object> hashSet2 = new HashSet<Object>(1);
                hashSet2.add(object);
                this.addNewDownStates(stateContainer, stateContainer3, hashSet2);
            }
            if (hashSet != null) {
                for (Object object3 : hashSet) {
                    stateContainer.setDownProp(object3, this.mDspReachPrecious);
                }
                assert (!this.mPropagationWorklist.contains(stateContainer));
                this.mPropagationWorklist.add(stateContainer);
            }
        }

        private boolean atLeastOneOccursAsDownState(StateContainer<LETTER, STATE> stateContainer, Set<STATE> set) {
            for (Object STATE : set) {
                if (!stateContainer.getDownStates().containsKey(STATE)) continue;
                return true;
            }
            return false;
        }

        private void addNewDownStates(StateContainer<LETTER, STATE> stateContainer, StateContainer<LETTER, STATE> stateContainer2, Set<STATE> set) {
            boolean bl;
            if (NestedWordAutomatonReachableStates.this.checkStateContainerEquality(stateContainer, stateContainer2)) {
                return;
            }
            boolean bl2 = bl = stateContainer2.getUnpropagatedDownStates() != null;
            assert (bl == this.mPropagationWorklist.contains(stateContainer2));
            assert (!bl || stateContainer2.getReachProp() == this.mRpSomeDown);
            boolean bl3 = false;
            for (Object STATE : set) {
                boolean bl4;
                if (!stateContainer2.getDownStates().containsKey(STATE) || !(bl4 = stateContainer2.setDownProp(STATE, this.mDspReachPrecious))) continue;
                bl3 = true;
            }
            if (bl3) {
                if (!bl) {
                    assert (!this.mPropagationWorklist.contains(stateContainer2));
                    this.mPropagationWorklist.add(stateContainer2);
                }
                if (stateContainer2.getReachProp() != this.mRpSomeDown) {
                    assert (stateContainer2.getReachProp() != this.mRpAllDown);
                    stateContainer2.setReachProp(this.mRpSomeDown);
                    assert (!this.mAncestors.contains(stateContainer2.getState()));
                    this.mAncestors.add(stateContainer2.getState());
                    if (NestedWordAutomatonReachableStates.this.isFinal(stateContainer2.getState())) {
                        this.mAncestorsAccepting.add(stateContainer2.getState());
                    }
                }
            }
        }

        public final void propagateReachableAfterRemovalDoubleDeckers() {
            LinkedHashSet linkedHashSet = new LinkedHashSet();
            HashSet hashSet = new HashSet();
            for (Object object : this.mAncestorsInitial) {
                assert (this.isInitial(object));
                Iterator iterator = NestedWordAutomatonReachableStates.this.getStatesMap().get(object);
                linkedHashSet.add((StateContainer)((Object)iterator));
                hashSet.add((StateContainer)((Object)iterator));
            }
            while (!linkedHashSet.isEmpty()) {
                StateContainer stateContainer;
                Object STATE;
                Object object;
                object = (StateContainer)linkedHashSet.iterator().next();
                linkedHashSet.remove(object);
                for (OutgoingInternalTransition outgoingInternalTransition : ((StateContainer)object).internalSuccessors()) {
                    STATE = outgoingInternalTransition.getSucc();
                    if (!this.mAncestors.contains(STATE)) continue;
                    stateContainer = NestedWordAutomatonReachableStates.this.getStatesMap().get(STATE);
                    boolean bl = this.propagateReachableAfterRemovalProperty((StateContainer)object, stateContainer);
                    this.addToWorklistIfModfiedOrNotVisited(linkedHashSet, hashSet, bl, stateContainer);
                }
                for (SummaryReturnTransition summaryReturnTransition : NestedWordAutomatonReachableStates.this.summarySuccessors(((StateContainer)object).getState())) {
                    StateContainer stateContainer2;
                    boolean bl;
                    STATE = summaryReturnTransition.getSucc();
                    if (!this.mAncestors.contains(STATE) || !this.mAncestors.contains(stateContainer = summaryReturnTransition.getLinPred()) || !(bl = this.checkDoubleDeckerProperty(stateContainer2 = NestedWordAutomatonReachableStates.this.getStatesMap().get(summaryReturnTransition.getLinPred()), ((StateContainer)object).getState(), this.mRpAllDown, this.mRpSomeDown, this.mDspReachPrecious))) continue;
                    stateContainer2 = NestedWordAutomatonReachableStates.this.getStatesMap().get(STATE);
                    bl = this.propagateReachableAfterRemovalProperty((StateContainer)object, stateContainer2);
                    this.addToWorklistIfModfiedOrNotVisited(linkedHashSet, hashSet, bl, stateContainer2);
                }
                for (OutgoingCallTransition outgoingCallTransition : ((StateContainer)object).callSuccessors()) {
                    STATE = outgoingCallTransition.getSucc();
                    if (!this.mAncestors.contains(STATE)) continue;
                    stateContainer = NestedWordAutomatonReachableStates.this.getStatesMap().get(STATE);
                    this.addToWorklistIfModfiedOrNotVisited(linkedHashSet, hashSet, false, stateContainer);
                }
            }
        }

        private boolean checkDoubleDeckerProperty(StateContainer<LETTER, STATE> stateContainer, STATE STATE, ReachProp reachProp, ReachProp reachProp2, StateContainer.DownStateProp downStateProp) throws AssertionError {
            boolean bl;
            if (stateContainer.getReachProp() == reachProp) {
                bl = true;
            } else if (stateContainer.getReachProp() == reachProp2) {
                assert (stateContainer.getDownStates().containsKey(STATE));
                bl = stateContainer.hasDownProp(STATE, downStateProp);
            } else {
                throw new AssertionError((Object)"DoubleDecker cannot reach precious");
            }
            return bl;
        }

        private void addToWorklistIfModfiedOrNotVisited(LinkedHashSet<StateContainer<LETTER, STATE>> linkedHashSet, Set<StateContainer<LETTER, STATE>> set, boolean bl, StateContainer<LETTER, STATE> stateContainer) {
            if (bl || !set.contains(stateContainer)) {
                linkedHashSet.add(stateContainer);
                set.add(stateContainer);
            }
        }

        private boolean propagateReachableAfterRemovalProperty(StateContainer<LETTER, STATE> stateContainer, StateContainer<LETTER, STATE> stateContainer2) throws AssertionError {
            boolean bl = false;
            if (stateContainer2.getReachProp() != this.mRpAllDown) {
                if (stateContainer2.getReachProp() == this.mRpSomeDown) {
                    for (Object STATE : stateContainer2.getDownStates().keySet()) {
                        if (stateContainer2.hasDownProp(STATE, this.mDspReachPrecious) || stateContainer2.hasDownProp(STATE, this.mDspReachableAfterRemoval) || !stateContainer.getDownStates().containsKey(STATE)) continue;
                        if (stateContainer.getReachProp() == this.mRpAllDown) {
                            bl |= stateContainer2.setDownProp(STATE, this.mDspReachableAfterRemoval);
                            continue;
                        }
                        if (!stateContainer.hasDownProp(STATE, this.mDspReachPrecious) && !stateContainer.hasDownProp(STATE, this.mDspReachableAfterRemoval)) continue;
                        bl |= stateContainer2.setDownProp(STATE, this.mDspReachableAfterRemoval);
                    }
                } else {
                    throw new AssertionError((Object)"succ will be removed");
                }
            }
            return bl;
        }

        public boolean isDownState(STATE STATE, STATE STATE2, DoubleDeckerReachability doubleDeckerReachability) {
            StateContainer stateContainer = NestedWordAutomatonReachableStates.this.getStatesMap().get(STATE);
            assert (stateContainer.getReachProp() == this.mRpAllDown || stateContainer.getReachProp() == this.mRpSomeDown);
            if (stateContainer.getDownStates().containsKey(STATE2)) {
                if (stateContainer.getReachProp() == this.mRpAllDown) {
                    assert (stateContainer.getDownStates().containsKey(STATE2));
                    return true;
                }
                assert (stateContainer.getReachProp() == this.mRpSomeDown);
                boolean bl = stateContainer.hasDownProp(STATE2, this.mDspReachPrecious);
                switch (doubleDeckerReachability) {
                    case CAN_REACH_PRECIOUS: {
                        return bl;
                    }
                    case REACHABLE_AFTER_REMOVAL_OF_PRECIOUS_NOT_REACHERS: {
                        boolean bl2 = bl || stateContainer.hasDownProp(STATE2, this.mDspReachableAfterRemoval);
                        return bl2;
                    }
                }
                throw new AssertionError();
            }
            return false;
        }

        public Set<STATE> getDownStates(STATE STATE, DoubleDeckerReachability doubleDeckerReachability) {
            Set set;
            StateContainer stateContainer = NestedWordAutomatonReachableStates.this.getStatesMap().get(STATE);
            if (stateContainer.getReachProp() == this.mRpAllDown) {
                set = stateContainer.getDownStates().keySet();
            } else {
                assert (stateContainer.getReachProp() == this.mRpSomeDown);
                set = new HashSet();
                block4: for (Object STATE2 : stateContainer.getDownStates().keySet()) {
                    boolean bl = stateContainer.hasDownProp(STATE2, this.mDspReachPrecious);
                    switch (doubleDeckerReachability) {
                        case CAN_REACH_PRECIOUS: {
                            if (!bl) continue block4;
                            set.add(STATE2);
                            break;
                        }
                        case REACHABLE_AFTER_REMOVAL_OF_PRECIOUS_NOT_REACHERS: {
                            boolean bl2;
                            boolean bl3 = bl2 = bl || stateContainer.hasDownProp(STATE2, this.mDspReachableAfterRemoval);
                            if (!bl2) continue block4;
                            set.add(STATE2);
                            break;
                        }
                        default: {
                            throw new AssertionError();
                        }
                    }
                }
            }
            return set;
        }

        public boolean isInitial(STATE STATE) {
            if (!NestedWordAutomatonReachableStates.this.getInitialStatesPrivate().contains(STATE)) {
                throw new IllegalArgumentException("Not initial state");
            }
            StateContainer stateContainer = NestedWordAutomatonReachableStates.this.getStatesMap().get(STATE);
            if (stateContainer.getReachProp() == this.mRpAllDown) {
                return true;
            }
            return stateContainer.hasDownProp(NestedWordAutomatonReachableStates.this.getEmptyStackState(), this.mDspReachPrecious);
        }

        public Iterable<IOpWithDelayedDeadEndRemoval.UpDownEntry<STATE>> getRemovedUpDownEntry() {
            return () -> new Iterator<IOpWithDelayedDeadEndRemoval.UpDownEntry<STATE>>(){
                private Iterator<STATE> mUpIterator;
                private STATE mUp;
                private Iterator<STATE> mDownIterator;
                private STATE mDown;
                private boolean mHasNext = true;
                private StateContainer<LETTER, STATE> mStateContainer;
                {
                    this.mUpIterator = NestedWordAutomatonReachableStates.this.getStatesMap().keySet().iterator();
                    if (this.mUpIterator.hasNext()) {
                        this.mUp = this.mUpIterator.next();
                        this.mStateContainer = NestedWordAutomatonReachableStates.this.getStatesMap().get(this.mUp);
                        this.mDownIterator = this.mStateContainer.getDownStates().keySet().iterator();
                    } else {
                        this.mHasNext = false;
                    }
                    this.computeNextElement();
                }

                private void computeNextElement() {
                    this.mDown = null;
                    while (this.mDown == null && this.mHasNext) {
                        if (this.mStateContainer.getReachProp() != AncestorComputation.this.mRpAllDown && this.mDownIterator.hasNext()) {
                            Object STATE = this.mDownIterator.next();
                            if (this.mStateContainer.getReachProp() == ReachProp.REACHABLE) {
                                this.mDown = STATE;
                                continue;
                            }
                            if (!$assertionsDisabled && this.mStateContainer.getReachProp() != AncestorComputation.this.mRpSomeDown) {
                                throw new AssertionError();
                            }
                            if (this.mStateContainer.hasDownProp(STATE, AncestorComputation.this.mDspReachPrecious)) continue;
                            this.mDown = STATE;
                            continue;
                        }
                        if (this.mUpIterator.hasNext()) {
                            this.mUp = this.mUpIterator.next();
                            this.mStateContainer = NestedWordAutomatonReachableStates.this.getStatesMap().get(this.mUp);
                            this.mDownIterator = this.mStateContainer.getDownStates().keySet().iterator();
                            continue;
                        }
                        this.mHasNext = false;
                    }
                }

                @Override
                public boolean hasNext() {
                    return this.mHasNext;
                }

                @Override
                public IOpWithDelayedDeadEndRemoval.UpDownEntry<STATE> next() {
                    Object STATE;
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    Set set = AncestorComputation.this.computeState2CallSuccs(this.mDown);
                    if (set.size() > 1) {
                        throw new UnsupportedOperationException("State has more than one call successor");
                    }
                    if (set.size() == 1) {
                        STATE = set.iterator().next();
                    } else {
                        STATE = null;
                        if (!$assertionsDisabled && !NestedWordAutomatonReachableStates.this.checkStateEquality(this.mDown, NestedWordAutomatonReachableStates.this.getEmptyStackState())) {
                            throw new AssertionError();
                        }
                    }
                    IOpWithDelayedDeadEndRemoval.UpDownEntry<Object> upDownEntry = new IOpWithDelayedDeadEndRemoval.UpDownEntry<Object>(this.mUp, this.mDown, STATE);
                    this.computeNextElement();
                    return upDownEntry;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        Set<STATE> computeState2CallSuccs(STATE STATE) {
            HashSet hashSet = new HashSet();
            if (!NestedWordAutomatonReachableStates.this.checkStateEquality(STATE, NestedWordAutomatonReachableStates.this.getEmptyStackState())) {
                for (OutgoingCallTransition outgoingCallTransition : NestedWordAutomatonReachableStates.this.callSuccessors(STATE)) {
                    hashSet.add(outgoingCallTransition.getSucc());
                }
            }
            return hashSet;
        }
    }

    public static enum DoubleDeckerReachability {
        CAN_REACH_PRECIOUS,
        REACHABLE_AFTER_REMOVAL_OF_PRECIOUS_NOT_REACHERS;

    }

    static enum InCaRe {
        INTERNAL,
        CALL,
        RETURN,
        SUMMARY;

    }

    public static enum ReachProp {
        REACHABLE,
        NODEADEND_AD,
        NODEADEND_SD,
        FINANC,
        LIVE_AD,
        LIVE_SD;

    }

    private class ReachableStatesComputation {
        private static final String OPERAND_CONTAINS_TRANSITION_TWICE = "Operand contains transition twice: ";
        private int mNumberOfConstructedStates;
        private final LinkedList<StateContainer<LETTER, STATE>> mForwardWorklist = new LinkedList();
        private final LinkedList<StateContainer<LETTER, STATE>> mDownPropagationWorklist = new LinkedList();

        ReachableStatesComputation() throws AutomataOperationCanceledException {
            this.addInitialStates(NestedWordAutomatonReachableStates.this.mOperand.getInitialStates());
            while (true) {
                Object object;
                if (!this.mForwardWorklist.isEmpty()) {
                    Object object2;
                    Set set2;
                    if (!NestedWordAutomatonReachableStates.this.getServices().getProgressAwareTimer().continueProcessing()) {
                        object = this.constructRunningTaskInfo();
                        throw new AutomataOperationCanceledException((RunningTaskInfo)object);
                    }
                    object = this.mForwardWorklist.remove(0);
                    ((StateContainer)object).eraseUnpropagatedDownStates();
                    HashSet hashSet = null;
                    if (this.candidateForOutgoingReturn(((StateContainer)object).getState())) {
                        for (Set set2 : ((StateContainer)object).getDownStates().keySet()) {
                            if (NestedWordAutomatonReachableStates.this.checkStateEquality(set2, NestedWordAutomatonReachableStates.this.getEmptyStackState()) || (object2 = this.addReturnsAndSuccessors((StateContainer)object, (Object)set2)) == null) continue;
                            if (hashSet == null) {
                                hashSet = new HashSet();
                            }
                            hashSet.addAll((Collection)object2);
                        }
                    }
                    this.addInternalsAndSuccessors((StateContainer)object);
                    set2 = this.addCallsAndSuccessors((StateContainer)object);
                    if (set2 != null) {
                        if (hashSet == null) {
                            hashSet = new HashSet();
                        }
                        hashSet.addAll(set2);
                    }
                    if (hashSet == null) continue;
                    assert (!hashSet.isEmpty());
                    object2 = hashSet.iterator();
                    while (object2.hasNext()) {
                        Iterator<Object> iterator = object2.next();
                        ((StateContainer)object).addReachableDownState(iterator);
                    }
                    this.mDownPropagationWorklist.add((StateContainer)object);
                    continue;
                }
                while (this.mForwardWorklist.isEmpty() && !this.mDownPropagationWorklist.isEmpty()) {
                    if (!NestedWordAutomatonReachableStates.this.getServices().getProgressAwareTimer().continueProcessing()) {
                        object = this.constructRunningTaskInfo();
                        throw new AutomataOperationCanceledException((RunningTaskInfo)object);
                    }
                    object = this.mDownPropagationWorklist.remove(0);
                    this.propagateNewDownStates((StateContainer)object);
                }
                if (this.mDownPropagationWorklist.isEmpty() && this.mForwardWorklist.isEmpty()) break;
            }
            assert (this.mForwardWorklist.isEmpty());
            assert (this.mDownPropagationWorklist.isEmpty());
            assert (NestedWordAutomatonReachableStates.this.checkTransitionsReturnedConsistent());
        }

        private RunningTaskInfo constructRunningTaskInfo() {
            String string = AbstractGeneralizedAutomatonReachableStates.constructRunningTaskInfoMessage(this.mNumberOfConstructedStates, NestedWordAutomatonReachableStates.this.mOperand.getClass());
            return new RunningTaskInfo(this.getClass(), string);
        }

        private void addInitialStates(Iterable<STATE> iterable) {
            for (Object STATE : iterable) {
                NestedWordAutomatonReachableStates.this.getInitialStatesPrivate().add(STATE);
                HashMap hashMap = new HashMap();
                hashMap.put(NestedWordAutomatonReachableStates.this.getEmptyStackState(), 0);
                StateContainer stateContainer = this.addState(STATE, hashMap);
                NestedWordAutomatonReachableStates.this.getStatesMap().put(STATE, stateContainer);
            }
        }

        private StateContainer<LETTER, STATE> addState(STATE STATE, HashMap<STATE, Integer> hashMap) {
            assert (!NestedWordAutomatonReachableStates.this.getStatesMap().containsKey(STATE));
            if (NestedWordAutomatonReachableStates.this.mOperand.isFinal(STATE)) {
                NestedWordAutomatonReachableStates.this.getFinalStatesPrivate().add(STATE);
            }
            boolean bl = this.candidateForOutgoingReturn(STATE);
            StateContainerFieldAndMap stateContainerFieldAndMap = new StateContainerFieldAndMap(STATE, this.mNumberOfConstructedStates, hashMap, bl);
            ++this.mNumberOfConstructedStates;
            NestedWordAutomatonReachableStates.this.getStatesMap().put(STATE, stateContainerFieldAndMap);
            this.mForwardWorklist.add(stateContainerFieldAndMap);
            return stateContainerFieldAndMap;
        }

        private boolean candidateForOutgoingReturn(STATE STATE) {
            if (NestedWordAutomatonReachableStates.this.mOperand.hasModifiableAlphabet()) {
                return true;
            }
            return !NestedWordAutomatonReachableStates.this.getVpAlphabet().getReturnAlphabet().isEmpty();
        }

        private void addInternalsAndSuccessors(StateContainer<LETTER, STATE> stateContainer) throws AutomataOperationCanceledException {
            Object STATE = stateContainer.getState();
            for (OutgoingInternalTransition outgoingInternalTransition : NestedWordAutomatonReachableStates.this.mOperand.internalSuccessors(STATE)) {
                Object object;
                if (!NestedWordAutomatonReachableStates.this.getServices().getProgressAwareTimer().continueProcessing()) {
                    object = this.constructRunningTaskInfo();
                    throw new AutomataOperationCanceledException((RunningTaskInfo)object);
                }
                object = outgoingInternalTransition.getSucc();
                StateContainer stateContainer2 = NestedWordAutomatonReachableStates.this.getStatesMap().get(object);
                if (stateContainer2 == null) {
                    stateContainer2 = this.addState(object, new HashMap(stateContainer.getDownStates()));
                } else {
                    this.addNewDownStates(stateContainer, stateContainer2, stateContainer.getDownStates().keySet());
                }
                assert (!NestedWordAutomatonReachableStates.this.containsCallTransition(STATE, outgoingInternalTransition.getLetter(), object)) : "Operand contains transition twice: " + String.valueOf(STATE) + String.valueOf(outgoingInternalTransition.getSucc());
                stateContainer.addInternalOutgoing(outgoingInternalTransition);
                stateContainer2.addInternalIncoming(new IncomingInternalTransition(STATE, outgoingInternalTransition.getLetter()));
                NestedWordAutomatonReachableStates.this.getNumberTransitions().incIn();
            }
        }

        private Set<STATE> addCallsAndSuccessors(StateContainer<LETTER, STATE> stateContainer) throws AutomataOperationCanceledException {
            boolean bl = false;
            Object STATE = stateContainer.getState();
            for (OutgoingCallTransition object : NestedWordAutomatonReachableStates.this.mOperand.callSuccessors(stateContainer.getState())) {
                Object object2;
                if (!NestedWordAutomatonReachableStates.this.getServices().getProgressAwareTimer().continueProcessing()) {
                    object2 = this.constructRunningTaskInfo();
                    throw new AutomataOperationCanceledException((RunningTaskInfo)object2);
                }
                object2 = object.getSucc();
                StateContainer stateContainer2 = NestedWordAutomatonReachableStates.this.getStatesMap().get(object2);
                HashMap hashMap = new HashMap();
                hashMap.put(stateContainer.getState(), 0);
                if (stateContainer2 == null) {
                    stateContainer2 = this.addState(object2, hashMap);
                } else {
                    this.addNewDownStates(stateContainer, stateContainer2, hashMap.keySet());
                    if (NestedWordAutomatonReachableStates.this.checkStateContainerEquality(stateContainer, stateContainer2)) {
                        bl = true;
                    }
                }
                assert (!NestedWordAutomatonReachableStates.this.containsCallTransition(STATE, object.getLetter(), object2)) : "Operand contains transition twice: " + String.valueOf(STATE) + String.valueOf(object.getSucc());
                stateContainer.addCallOutgoing(object);
                stateContainer2.addCallIncoming(new IncomingCallTransition(STATE, object.getLetter()));
                NestedWordAutomatonReachableStates.this.getNumberTransitions().incCa();
            }
            if (bl) {
                HashSet hashSet = new HashSet(1);
                hashSet.add(STATE);
                return this.newDownStatesSelfloop(stateContainer, hashSet);
            }
            return null;
        }

        private Set<STATE> addReturnsAndSuccessors(StateContainer<LETTER, STATE> stateContainer, STATE STATE) throws AutomataOperationCanceledException {
            boolean bl = false;
            Object STATE2 = stateContainer.getState();
            StateContainer stateContainer2 = null;
            for (OutgoingReturnTransition outgoingReturnTransition : NestedWordAutomatonReachableStates.this.mOperand.returnSuccessorsGivenHier(STATE2, STATE)) {
                Object object;
                if (!NestedWordAutomatonReachableStates.this.getServices().getProgressAwareTimer().continueProcessing()) {
                    object = this.constructRunningTaskInfo();
                    throw new AutomataOperationCanceledException((RunningTaskInfo)object);
                }
                assert (STATE.equals(outgoingReturnTransition.getHierPred()));
                if (stateContainer2 == null) {
                    stateContainer2 = NestedWordAutomatonReachableStates.this.getStatesMap().get(STATE);
                }
                object = outgoingReturnTransition.getSucc();
                StateContainer stateContainer3 = NestedWordAutomatonReachableStates.this.getStatesMap().get(object);
                if (stateContainer3 == null) {
                    stateContainer3 = this.addState(object, new HashMap(stateContainer2.getDownStates()));
                } else {
                    this.addNewDownStates(stateContainer, stateContainer3, stateContainer2.getDownStates().keySet());
                    if (NestedWordAutomatonReachableStates.this.checkStateContainerEquality(stateContainer, stateContainer3)) {
                        bl = true;
                    }
                }
                assert (!NestedWordAutomatonReachableStates.this.containsReturnTransition(STATE2, STATE, outgoingReturnTransition.getLetter(), object)) : "Operand contains transition twice: " + String.valueOf(STATE2) + String.valueOf(outgoingReturnTransition.getSucc());
                stateContainer.addReturnOutgoing(outgoingReturnTransition);
                stateContainer3.addReturnIncoming(new IncomingReturnTransition(stateContainer.getState(), STATE, outgoingReturnTransition.getLetter()));
                NestedWordAutomatonReachableStates.this.addReturnSummary(STATE2, STATE, outgoingReturnTransition.getLetter(), object);
                NestedWordAutomatonReachableStates.this.getNumberTransitions().incRe();
            }
            if (bl) {
                return this.newDownStatesSelfloop(stateContainer, stateContainer2.getDownStates().keySet());
            }
            return null;
        }

        private Set<STATE> newDownStatesSelfloop(StateContainer<LETTER, STATE> stateContainer, Set<STATE> set) {
            HashSet hashSet = null;
            for (Object STATE : set) {
                if (stateContainer.getDownStates().containsKey(STATE)) continue;
                if (hashSet == null) {
                    hashSet = new HashSet();
                }
                hashSet.add(STATE);
            }
            return hashSet;
        }

        private void addNewDownStates(StateContainer<LETTER, STATE> stateContainer, StateContainer<LETTER, STATE> stateContainer2, Set<STATE> set) {
            if (NestedWordAutomatonReachableStates.this.checkStateContainerEquality(stateContainer, stateContainer2)) {
                return;
            }
            boolean bl = false;
            for (Object STATE : set) {
                boolean bl2 = stateContainer2.addReachableDownState(STATE);
                if (!bl2) continue;
                bl = true;
            }
            if (bl) {
                this.mDownPropagationWorklist.add(stateContainer2);
            }
        }

        /*
         * WARNING - void declaration
         */
        private void propagateNewDownStates(StateContainer<LETTER, STATE> stateContainer) throws AutomataOperationCanceledException {
            Object object;
            Set set = stateContainer.getUnpropagatedDownStates();
            if (set == null) {
                return;
            }
            for (OutgoingInternalTransition object2 : stateContainer.internalSuccessors()) {
                object = NestedWordAutomatonReachableStates.this.getStatesMap().get(object2.getSucc());
                this.addNewDownStates(stateContainer, (StateContainer)object, set);
            }
            for (SummaryReturnTransition summaryReturnTransition : NestedWordAutomatonReachableStates.this.summarySuccessors(stateContainer.getState())) {
                object = NestedWordAutomatonReachableStates.this.getStatesMap().get(summaryReturnTransition.getSucc());
                this.addNewDownStates(stateContainer, (StateContainer)object, set);
            }
            if (this.candidateForOutgoingReturn(stateContainer.getState())) {
                void var3_8;
                Object var3_7 = null;
                for (Iterator iterator : stateContainer.getUnpropagatedDownStates()) {
                    Set set2;
                    if (NestedWordAutomatonReachableStates.this.checkStateEquality(iterator, NestedWordAutomatonReachableStates.this.getEmptyStackState()) || (set2 = this.addReturnsAndSuccessors(stateContainer, iterator)) == null) continue;
                    if (var3_8 == null) {
                        HashSet hashSet = new HashSet();
                    }
                    var3_8.addAll(set2);
                }
                stateContainer.eraseUnpropagatedDownStates();
                if (var3_8 != null) {
                    assert (!var3_8.isEmpty());
                    for (Iterator iterator : var3_8) {
                        stateContainer.addReachableDownState(iterator);
                    }
                    this.mDownPropagationWorklist.add(stateContainer);
                }
            } else {
                stateContainer.eraseUnpropagatedDownStates();
            }
        }
    }
}

