/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.automatascriptinterpreter;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.alternating.AlternatingAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.alternating.BooleanExpression;
import de.uni_freiburg.informatik.ultimate.automata.counting.CountingAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.counting.datastructures.CountingAutomatonDataStructure;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.EpsilonNestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.VpAlphabet;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.netdatastructures.BoundedPetriNet;
import de.uni_freiburg.informatik.ultimate.automata.rabin.RabinAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IEmptyStackStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.StringFactory;
import de.uni_freiburg.informatik.ultimate.automata.tree.IRankedLetter;
import de.uni_freiburg.informatik.ultimate.automata.tree.StringRankedLetter;
import de.uni_freiburg.informatik.ultimate.automata.tree.TreeAutomatonBU;
import de.uni_freiburg.informatik.ultimate.automata.tree.TreeAutomatonRule;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResultWithSeverity;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.plugins.generator.automatascriptinterpreter.CountingAutomataUtils;
import de.uni_freiburg.informatik.ultimate.plugins.generator.automatascriptinterpreter.IMessagePrinter;
import de.uni_freiburg.informatik.ultimate.plugins.generator.automatascriptinterpreter.InterpreterException;
import de.uni_freiburg.informatik.ultimate.plugins.generator.automatascriptinterpreter.TestFileInterpreter;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AST.AbstractNestedwordAutomatonAST;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AST.AlternatingAutomatonAST;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AST.AutomataDefinitionsAST;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AST.CountingAutomatonAST;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AST.EpsilonNestedwordAutomatonAST;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AST.NestedwordAutomatonAST;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AST.PetriNetAutomatonAST;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AST.RabinAutomatonAST;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AST.TreeAutomatonAST;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AST.TreeAutomatonRankedAST;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AtsASTNode;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ImmutableSet;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap2;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class AutomataDefinitionInterpreter {
    private static final String UNDEFINED_PLACE = "undefined place: ";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String EXCEPTION_THROWN = "Exception thrown";
    private static final boolean UNIFY_OBJECTS = false;
    private final Map<String, Object> mAutomata = new HashMap<String, Object>();
    private ILocation mErrorLocation;
    private final IMessagePrinter mMessagePrinter;
    private final ILogger mLogger;
    private final IUltimateServiceProvider mServices;
    private final NestedMap2<String, Integer, StringRankedLetter> mLetterToRank;

    public AutomataDefinitionInterpreter(IMessagePrinter iMessagePrinter, ILogger iLogger, IUltimateServiceProvider iUltimateServiceProvider) {
        this.mMessagePrinter = iMessagePrinter;
        this.mLogger = iLogger;
        this.mServices = iUltimateServiceProvider;
        this.mLetterToRank = new NestedMap2();
    }

    public void interpret(AutomataDefinitionsAST automataDefinitionsAST) {
        List list = automataDefinitionsAST.getListOfAutomataDefinitions();
        for (AtsASTNode atsASTNode : list) {
            try {
                if (atsASTNode instanceof NestedwordAutomatonAST) {
                    this.interpret((NestedwordAutomatonAST)atsASTNode);
                    continue;
                }
                if (atsASTNode instanceof EpsilonNestedwordAutomatonAST) {
                    this.interpret((EpsilonNestedwordAutomatonAST)atsASTNode);
                    continue;
                }
                if (atsASTNode instanceof PetriNetAutomatonAST) {
                    this.interpret((PetriNetAutomatonAST)atsASTNode);
                    continue;
                }
                if (atsASTNode instanceof AlternatingAutomatonAST) {
                    this.interpret((AlternatingAutomatonAST)atsASTNode);
                    continue;
                }
                if (atsASTNode instanceof TreeAutomatonAST) {
                    this.interpret((TreeAutomatonAST)atsASTNode);
                    continue;
                }
                if (atsASTNode instanceof TreeAutomatonRankedAST) {
                    this.interpret((TreeAutomatonRankedAST)atsASTNode);
                    continue;
                }
                if (atsASTNode instanceof CountingAutomatonAST) {
                    this.interpret((CountingAutomatonAST)atsASTNode);
                    continue;
                }
                if (atsASTNode instanceof RabinAutomatonAST) {
                    this.interpret((RabinAutomatonAST)atsASTNode);
                    continue;
                }
                throw new AssertionError((Object)("unsupported kind of automaton " + String.valueOf(atsASTNode)));
            }
            catch (Exception exception) {
                this.mMessagePrinter.printMessage(IResultWithSeverity.Severity.ERROR, TestFileInterpreter.LoggerSeverity.DEBUG, exception.getMessage() + LINE_SEPARATOR + String.valueOf(exception.getStackTrace()), EXCEPTION_THROWN, atsASTNode);
            }
        }
    }

    public void interpret(AlternatingAutomatonAST alternatingAutomatonAST) {
        this.mErrorLocation = alternatingAutomatonAST.getLocation();
        HashSet hashSet = new HashSet(alternatingAutomatonAST.getAlphabet());
        AlternatingAutomaton alternatingAutomaton = new AlternatingAutomaton(hashSet);
        List list = alternatingAutomatonAST.getStates();
        List list2 = alternatingAutomatonAST.getFinalStates();
        for (String string : list) {
            alternatingAutomaton.addState((Object)string);
            if (!list2.contains(string)) continue;
            alternatingAutomaton.setStateFinal((Object)string);
        }
        for (Map.Entry entry : alternatingAutomatonAST.getTransitions().entrySet()) {
            String string = (String)((Set)entry.getValue()).iterator().next();
            LinkedList<BooleanExpression> linkedList = AutomataDefinitionInterpreter.parseBooleanExpressions((AlternatingAutomaton<String, String>)alternatingAutomaton, string);
            for (BooleanExpression booleanExpression : linkedList) {
                alternatingAutomaton.addTransition((Object)((String)((Pair)entry.getKey()).getSecond()), (Object)((String)((Pair)entry.getKey()).getFirst()), booleanExpression);
            }
        }
        LinkedList<BooleanExpression> linkedList = AutomataDefinitionInterpreter.parseBooleanExpressions((AlternatingAutomaton<String, String>)alternatingAutomaton, alternatingAutomatonAST.getAcceptingFunction());
        for (BooleanExpression booleanExpression : linkedList) {
            alternatingAutomaton.addAcceptingConjunction(booleanExpression);
        }
        alternatingAutomaton.setReversed(alternatingAutomatonAST.isReversed());
        this.mAutomata.put(alternatingAutomatonAST.getName(), alternatingAutomaton);
    }

    public void interpret(TreeAutomatonAST treeAutomatonAST) {
        Object object;
        this.mErrorLocation = treeAutomatonAST.getLocation();
        TreeAutomatonBU treeAutomatonBU = new TreeAutomatonBU();
        for (String string : treeAutomatonAST.getStates()) {
            treeAutomatonBU.addState((Object)string);
        }
        for (String string : treeAutomatonAST.getFinalStates()) {
            treeAutomatonBU.addFinalState((Object)string);
        }
        for (String string : treeAutomatonAST.getTransitions()) {
            object = this.getOrConstructStringRankedLetter(string.getSymbol(), string.getSourceStates().size());
            treeAutomatonBU.addRule(new TreeAutomatonRule((IRankedLetter)object, string.getSourceStates(), (Object)string.getTargetState()));
        }
        for (String string : treeAutomatonAST.getAlphabet()) {
            object = this.mLetterToRank.get((Object)string);
            if (object == null || object.isEmpty()) {
                treeAutomatonBU.addLetter((IRankedLetter)new StringRankedLetter(string, -1));
                continue;
            }
            for (Map.Entry entry : object.entrySet()) {
                treeAutomatonBU.addLetter((IRankedLetter)((StringRankedLetter)entry.getValue()));
            }
        }
        this.mAutomata.put(treeAutomatonAST.getName(), treeAutomatonBU);
    }

    private StringRankedLetter getStringRankedLetter(String string, int n) {
        assert (this.mLetterToRank.get((Object)string, (Object)n) != null);
        return (StringRankedLetter)this.mLetterToRank.get((Object)string, (Object)n);
    }

    private StringRankedLetter getOrConstructStringRankedLetter(String string, int n) {
        String string2 = string;
        StringRankedLetter stringRankedLetter = (StringRankedLetter)this.mLetterToRank.get((Object)string2, (Object)n);
        if (stringRankedLetter == null) {
            stringRankedLetter = new StringRankedLetter(string2, n);
            this.mLetterToRank.put((Object)string, (Object)n, (Object)stringRankedLetter);
        }
        return stringRankedLetter;
    }

    public void interpret(TreeAutomatonRankedAST treeAutomatonRankedAST) {
        this.mErrorLocation = treeAutomatonRankedAST.getLocation();
        TreeAutomatonBU treeAutomatonBU = new TreeAutomatonBU();
        List list = treeAutomatonRankedAST.getRankedAlphabet();
        for (Object object : list) {
            for (String string : object.getAlphabet()) {
                treeAutomatonBU.addLetter((IRankedLetter)this.getOrConstructStringRankedLetter(string, Integer.parseInt(object.getRank())));
            }
        }
        for (Object object : treeAutomatonRankedAST.getStates()) {
            treeAutomatonBU.addState(object);
        }
        for (Object object : treeAutomatonRankedAST.getFinalStates()) {
            treeAutomatonBU.addFinalState(object);
        }
        for (Object object : treeAutomatonRankedAST.getTransitions()) {
            if (object.getSourceStates().isEmpty()) {
                treeAutomatonBU.addRule(new TreeAutomatonRule((IRankedLetter)this.getStringRankedLetter(object.getSymbol(), object.getSourceStates().size()), Collections.singletonList("elim0arySymbol_" + object.getSymbol()), (Object)object.getTargetState()));
                continue;
            }
            treeAutomatonBU.addRule(new TreeAutomatonRule((IRankedLetter)this.getStringRankedLetter(object.getSymbol(), object.getSourceStates().size()), object.getSourceStates(), (Object)object.getTargetState()));
        }
        this.mAutomata.put(treeAutomatonRankedAST.getName(), treeAutomatonBU);
    }

    public void interpret(NestedwordAutomatonAST nestedwordAutomatonAST) {
        this.mErrorLocation = nestedwordAutomatonAST.getLocation();
        NestedWordAutomaton<String, String> nestedWordAutomaton = AutomataDefinitionInterpreter.constructNestedWordAutomaton((AbstractNestedwordAutomatonAST)nestedwordAutomatonAST, this.mServices);
        this.mAutomata.put(nestedwordAutomatonAST.getName(), nestedWordAutomaton);
    }

    private void interpret(EpsilonNestedwordAutomatonAST epsilonNestedwordAutomatonAST) {
        this.mErrorLocation = epsilonNestedwordAutomatonAST.getLocation();
        EpsilonNestedWordAutomaton<String, String, NestedWordAutomaton<String, String>> epsilonNestedWordAutomaton = AutomataDefinitionInterpreter.constructEpsilonNestedWordAutomaton(epsilonNestedwordAutomatonAST, this.mServices);
        this.mAutomata.put(epsilonNestedwordAutomatonAST.getName(), epsilonNestedWordAutomaton);
    }

    public static EpsilonNestedWordAutomaton<String, String, NestedWordAutomaton<String, String>> constructEpsilonNestedWordAutomaton(EpsilonNestedwordAutomatonAST epsilonNestedwordAutomatonAST, IUltimateServiceProvider iUltimateServiceProvider) {
        NestedWordAutomaton<String, String> nestedWordAutomaton = AutomataDefinitionInterpreter.constructNestedWordAutomaton((AbstractNestedwordAutomatonAST)epsilonNestedwordAutomatonAST, iUltimateServiceProvider);
        EpsilonNestedWordAutomaton epsilonNestedWordAutomaton = new EpsilonNestedWordAutomaton(nestedWordAutomaton, epsilonNestedwordAutomatonAST.getEpsilonTransitions());
        return epsilonNestedWordAutomaton;
    }

    public static NestedWordAutomaton<String, String> constructNestedWordAutomaton(AbstractNestedwordAutomatonAST abstractNestedwordAutomatonAST, IUltimateServiceProvider iUltimateServiceProvider) {
        Map.Entry entry4;
        String string;
        String string2;
        Object object = (String)AutomataDefinitionInterpreter.checkForDuplicate(abstractNestedwordAutomatonAST.getStates());
        if (object != null) {
            throw new IllegalArgumentException("State " + (String)object + " contained twice in states.");
        }
        object = (String)AutomataDefinitionInterpreter.checkForDuplicate(abstractNestedwordAutomatonAST.getInitialStates());
        if (object != null) {
            throw new IllegalArgumentException("State " + (String)object + " contained twice in initial states.");
        }
        object = (String)AutomataDefinitionInterpreter.checkForDuplicate(abstractNestedwordAutomatonAST.getFinalStates());
        if (object != null) {
            throw new IllegalArgumentException("State " + (String)object + " contained twice in final states.");
        }
        AutomataDefinitionInterpreter.checkThatInitialAndFinalStatesExist(abstractNestedwordAutomatonAST);
        object = new HashSet(abstractNestedwordAutomatonAST.getInitialStates());
        HashSet hashSet = new HashSet(abstractNestedwordAutomatonAST.getFinalStates());
        Map<String, String> map = null;
        Map<String, String> map2 = null;
        Map<String, String> map3 = null;
        Map<String, String> map4 = null;
        Set set = Collections.unmodifiableSet(new HashSet(abstractNestedwordAutomatonAST.getInternalAlphabet()));
        Set set2 = Collections.unmodifiableSet(new HashSet(abstractNestedwordAutomatonAST.getCallAlphabet()));
        Set set3 = Collections.unmodifiableSet(new HashSet(abstractNestedwordAutomatonAST.getReturnAlphabet()));
        NestedWordAutomaton nestedWordAutomaton = new NestedWordAutomaton(new AutomataLibraryServices(iUltimateServiceProvider), new VpAlphabet(set, set2, set3), (IEmptyStackStateFactory)new StringFactory());
        for (String object2 : abstractNestedwordAutomatonAST.getStates()) {
            nestedWordAutomaton.addState(object.contains(object2), hashSet.contains(object2), (Object)object2);
        }
        for (Map.Entry entry2 : abstractNestedwordAutomatonAST.getInternalTransitions().entrySet()) {
            string2 = AutomataDefinitionInterpreter.unifyIfNeeded((String)((Pair)entry2.getKey()).getFirst(), map4);
            for (String string3 : (Set)entry2.getValue()) {
                string = AutomataDefinitionInterpreter.unifyIfNeeded(string3, map4);
                entry4 = AutomataDefinitionInterpreter.unifyIfNeeded((String)((Pair)entry2.getKey()).getSecond(), map);
                if (!set.contains(entry4)) {
                    throw new IllegalArgumentException("Letter " + (String)((Object)entry4) + " not in internal alphabet");
                }
                nestedWordAutomaton.addInternalTransition((Object)string2, (Object)entry4, (Object)string);
            }
        }
        for (Map.Entry entry3 : abstractNestedwordAutomatonAST.getCallTransitions().entrySet()) {
            string2 = AutomataDefinitionInterpreter.unifyIfNeeded((String)((Pair)entry3.getKey()).getFirst(), map4);
            for (String string3 : (Set)entry3.getValue()) {
                string = AutomataDefinitionInterpreter.unifyIfNeeded(string3, map4);
                entry4 = AutomataDefinitionInterpreter.unifyIfNeeded((String)((Pair)entry3.getKey()).getSecond(), map2);
                if (!set2.contains(entry4)) {
                    throw new IllegalArgumentException("Letter " + (String)((Object)entry4) + " not in call alphabet");
                }
                nestedWordAutomaton.addCallTransition((Object)string2, (Object)entry4, (Object)string);
            }
        }
        for (String string4 : abstractNestedwordAutomatonAST.getReturnTransitions().keySet()) {
            string2 = AutomataDefinitionInterpreter.unifyIfNeeded(string4, map4);
            for (String string3 : ((Map)abstractNestedwordAutomatonAST.getReturnTransitions().get(string2)).keySet()) {
                string = AutomataDefinitionInterpreter.unifyIfNeeded(string3, map4);
                for (Map.Entry entry4 : ((Map)((Map)abstractNestedwordAutomatonAST.getReturnTransitions().get(string2)).get(string)).entrySet()) {
                    String string5 = AutomataDefinitionInterpreter.unifyIfNeeded((String)entry4.getKey(), map3);
                    if (!set3.contains(string5)) {
                        throw new IllegalArgumentException("Letter " + string5 + " not in return alphabet");
                    }
                    for (String string6 : (Set)entry4.getValue()) {
                        String string7 = AutomataDefinitionInterpreter.unifyIfNeeded(string6, map4);
                        nestedWordAutomaton.addReturnTransition((Object)string2, (Object)string, (Object)string5, (Object)string7);
                    }
                }
            }
        }
        return nestedWordAutomaton;
    }

    private void interpret(CountingAutomatonAST countingAutomatonAST) throws InterpreterException {
        CountingAutomatonDataStructure<String, String> countingAutomatonDataStructure = CountingAutomataUtils.constructCountingAutomaton(this.mServices, countingAutomatonAST);
        CountingAutomaton<String, String> countingAutomaton = CountingAutomataUtils.translateDataStructureToAutomaton(this.mServices, countingAutomatonDataStructure);
        Objects.nonNull(countingAutomaton);
        this.mAutomata.put(countingAutomatonAST.getName(), countingAutomaton);
    }

    private void interpret(RabinAutomatonAST rabinAutomatonAST) throws InterpreterException {
        NestedMap2 nestedMap2 = new NestedMap2();
        rabinAutomatonAST.getTransitions().forEach((pair, set) -> {
            Object object = nestedMap2.put((Object)((String)pair.getFirst()), (Object)((String)pair.getSecond()), set);
        });
        RabinAutomaton rabinAutomaton = new RabinAutomaton(new HashSet(rabinAutomatonAST.getAlphabet()), new HashSet(rabinAutomatonAST.getStates()), new HashSet(rabinAutomatonAST.getInitialStates()), new HashSet(rabinAutomatonAST.getAcceptingStates()), new HashSet(rabinAutomatonAST.getFiniteStates()), nestedMap2);
        this.mAutomata.put(rabinAutomatonAST.getName(), rabinAutomaton);
    }

    public static <E> E checkForDuplicate(List<E> list) {
        HashSet<E> hashSet = new HashSet<E>();
        for (E e : list) {
            boolean bl = hashSet.add(e);
            if (bl) continue;
            return e;
        }
        return null;
    }

    private static void checkThatInitialAndFinalStatesExist(AbstractNestedwordAutomatonAST abstractNestedwordAutomatonAST) {
        Object object2;
        HashSet hashSet = new HashSet(abstractNestedwordAutomatonAST.getStates());
        List list = abstractNestedwordAutomatonAST.getInitialStates();
        for (Object object2 : list) {
            if (hashSet.contains(object2)) continue;
            throw new IllegalArgumentException("Initial state " + (String)object2 + " not in set of states");
        }
        object2 = abstractNestedwordAutomatonAST.getFinalStates();
        Iterator iterator = object2.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (hashSet.contains(string)) continue;
            throw new IllegalArgumentException("Final state " + (String)string + " not in set of states");
        }
    }

    public void interpret(PetriNetAutomatonAST petriNetAutomatonAST) {
        this.mErrorLocation = petriNetAutomatonAST.getLocation();
        BoundedPetriNet boundedPetriNet = new BoundedPetriNet(new AutomataLibraryServices(this.mServices), new HashSet(petriNetAutomatonAST.getAlphabet()), false);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string : petriNetAutomatonAST.getPlaces()) {
            boolean bl = boundedPetriNet.addPlace((Object)string, petriNetAutomatonAST.getInitialMarkings().containsPlace(string), petriNetAutomatonAST.getAcceptingPlaces().contains(string));
            if (!bl) {
                throw new AssertionError((Object)("Petri net must not contain place twice: " + string));
            }
            hashMap.put(string, string);
        }
        for (String string : petriNetAutomatonAST.getTransitions()) {
            Object object2;
            HashSet<String> hashSet = new HashSet<String>();
            for (Object object2 : string.getPreds()) {
                if (!hashMap.containsKey(object2)) {
                    throw new IllegalArgumentException(UNDEFINED_PLACE + (String)object2);
                }
                hashSet.add((String)hashMap.get(object2));
            }
            object2 = new HashSet();
            for (Object object3 : string.getSuccs()) {
                if (!hashMap.containsKey(object3)) {
                    throw new IllegalArgumentException(UNDEFINED_PLACE + (String)object3);
                }
                object2.add((String)hashMap.get(object3));
            }
            boundedPetriNet.addTransition((Object)string.getSymbol(), ImmutableSet.of(hashSet), ImmutableSet.of((Set)object2));
        }
        this.mAutomata.put(petriNetAutomatonAST.getName(), boundedPetriNet);
    }

    private static String unifyIfNeeded(String string, Map<String, String> map) {
        return string;
    }

    private static LinkedList<BooleanExpression> parseBooleanExpressions(AlternatingAutomaton<String, String> alternatingAutomaton, String string) {
        LinkedList<BooleanExpression> linkedList = new LinkedList<BooleanExpression>();
        if ("true".equals(string)) {
            linkedList.add(new BooleanExpression(new BitSet(), new BitSet()));
        } else if (!"false".equals(string)) {
            String[] stringArray;
            String[] stringArray2 = stringArray = string.split("\\|");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string2;
                String string3 = stringArray2[n2];
                String[] stringArray3 = string3.split("&");
                LinkedList<String> linkedList2 = new LinkedList<String>();
                LinkedList<String> linkedList3 = new LinkedList<String>();
                String[] stringArray4 = stringArray3;
                int n3 = stringArray3.length;
                int n4 = 0;
                while (n4 < n3) {
                    string2 = stringArray4[n4];
                    if (string2.startsWith("~")) {
                        linkedList3.add(string2.substring(1));
                    } else {
                        linkedList2.add(string2);
                    }
                    ++n4;
                }
                string2 = alternatingAutomaton.generateCube((Object[])linkedList2.toArray(new String[linkedList2.size()]), (Object[])linkedList3.toArray(new String[linkedList3.size()]));
                linkedList.add((BooleanExpression)string2);
                ++n2;
            }
        }
        return linkedList;
    }

    public Map<String, Object> getAutomata() {
        return this.mAutomata;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("AutomataDefinitionInterpreter [");
        if (this.mAutomata != null) {
            stringBuilder.append("#AutomataDefinitions: ");
            stringBuilder.append(this.mAutomata.size());
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public ILocation getErrorLocation() {
        return this.mErrorLocation;
    }
}

