/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.ast;

import de.uni_freiburg.informatik.ultimate.boogie.ast.BoogieASTNode;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstTransformer;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstVisitor;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableLHS;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;

public final class JoinStatement
extends Statement {
    private static final long serialVersionUID = 1L;
    private static final Predicate<BoogieASTNode> VALIDATOR = BoogieASTNode.VALIDATORS.get(JoinStatement.class);
    Expression[] threadID;
    VariableLHS[] lhs;

    public JoinStatement(ILocation iLocation, Expression[] expressionArray, VariableLHS[] variableLHSArray) {
        super(iLocation);
        this.threadID = expressionArray;
        this.lhs = variableLHSArray;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid JoinStatement: " + String.valueOf((Object)this);
    }

    @Override
    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("JoinStatement").append('[');
        if (this.threadID == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append('[');
            n = 0;
            while (n < this.threadID.length) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append((Object)this.threadID[n]);
                ++n;
            }
            stringBuffer.append(']');
        }
        stringBuffer.append(',');
        if (this.lhs == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append('[');
            n = 0;
            while (n < this.lhs.length) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append((Object)this.lhs[n]);
                ++n;
            }
            stringBuffer.append(']');
        }
        return stringBuffer.append(']').toString();
    }

    public Expression[] getThreadID() {
        return this.threadID;
    }

    public VariableLHS[] getLhs() {
        return this.lhs;
    }

    @Override
    public List<BoogieASTNode> getOutgoingNodes() {
        List<BoogieASTNode> list = super.getOutgoingNodes();
        if (this.threadID != null) {
            list.addAll(Arrays.asList(this.threadID));
        }
        if (this.lhs != null) {
            list.addAll(Arrays.asList(this.lhs));
        }
        return list;
    }

    @Override
    public void accept(GeneratedBoogieAstVisitor generatedBoogieAstVisitor) {
        if (!generatedBoogieAstVisitor.visit((Statement)this)) {
            return;
        }
        if (generatedBoogieAstVisitor.visit(this)) {
            BoogieASTNode boogieASTNode;
            int n;
            int n2;
            BoogieASTNode[] boogieASTNodeArray;
            if (this.threadID != null) {
                boogieASTNodeArray = this.threadID;
                n2 = this.threadID.length;
                n = 0;
                while (n < n2) {
                    boogieASTNode = boogieASTNodeArray[n];
                    ((Expression)boogieASTNode).accept(generatedBoogieAstVisitor);
                    ++n;
                }
            }
            if (this.lhs != null) {
                boogieASTNodeArray = this.lhs;
                n2 = this.lhs.length;
                n = 0;
                while (n < n2) {
                    boogieASTNode = boogieASTNodeArray[n];
                    ((VariableLHS)boogieASTNode).accept(generatedBoogieAstVisitor);
                    ++n;
                }
            }
        }
    }

    @Override
    public Statement accept(GeneratedBoogieAstTransformer generatedBoogieAstTransformer) {
        Object object;
        Object object2;
        int n;
        Statement statement = generatedBoogieAstTransformer.transform(this);
        if (statement != this) {
            return statement;
        }
        boolean bl = false;
        ArrayList<VariableLHS[]> arrayList = new ArrayList<VariableLHS[]>();
        if (this.threadID != null) {
            Expression[] expressionArray = this.threadID;
            n = this.threadID.length;
            int n2 = 0;
            while (n2 < n) {
                object2 = expressionArray[n2];
                object = ((Expression)((Object)object2)).accept(generatedBoogieAstTransformer);
                bl = bl || object != object2;
                arrayList.add((VariableLHS[])object);
                ++n2;
            }
        }
        object2 = new ArrayList();
        if (this.lhs != null) {
            object = this.lhs;
            int n3 = this.lhs.length;
            n = 0;
            while (n < n3) {
                VariableLHS variableLHS = object[n];
                VariableLHS variableLHS2 = (VariableLHS)variableLHS.accept(generatedBoogieAstTransformer);
                bl = bl || variableLHS2 != variableLHS;
                ((ArrayList)object2).add(variableLHS2);
                ++n;
            }
        }
        if (bl) {
            return new JoinStatement(this.loc, arrayList.toArray(new Expression[0]), ((ArrayList)object2).toArray(new VariableLHS[0]));
        }
        return this;
    }
}

