/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.ast;

import de.uni_freiburg.informatik.ultimate.boogie.ast.BoogieASTNode;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstTransformer;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstVisitor;
import de.uni_freiburg.informatik.ultimate.core.model.models.IBoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;

public final class StructConstructor
extends Expression {
    private static final long serialVersionUID = 1L;
    private static final Predicate<BoogieASTNode> VALIDATOR = BoogieASTNode.VALIDATORS.get(StructConstructor.class);
    String[] fieldIdentifiers;
    Expression[] fieldValues;

    public StructConstructor(ILocation iLocation, String[] stringArray, Expression[] expressionArray) {
        super(iLocation);
        this.fieldIdentifiers = stringArray;
        this.fieldValues = expressionArray;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid StructConstructor: " + String.valueOf((Object)this);
    }

    public StructConstructor(ILocation iLocation, IBoogieType iBoogieType, String[] stringArray, Expression[] expressionArray) {
        super(iLocation, iBoogieType);
        this.fieldIdentifiers = stringArray;
        this.fieldValues = expressionArray;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid StructConstructor: " + String.valueOf((Object)this);
    }

    @Override
    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("StructConstructor").append('[');
        if (this.fieldIdentifiers == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append('[');
            n = 0;
            while (n < this.fieldIdentifiers.length) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(this.fieldIdentifiers[n]);
                ++n;
            }
            stringBuffer.append(']');
        }
        stringBuffer.append(',');
        if (this.fieldValues == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append('[');
            n = 0;
            while (n < this.fieldValues.length) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append((Object)this.fieldValues[n]);
                ++n;
            }
            stringBuffer.append(']');
        }
        return stringBuffer.append(']').toString();
    }

    public String[] getFieldIdentifiers() {
        return this.fieldIdentifiers;
    }

    public Expression[] getFieldValues() {
        return this.fieldValues;
    }

    @Override
    public List<BoogieASTNode> getOutgoingNodes() {
        List<BoogieASTNode> list = super.getOutgoingNodes();
        if (this.fieldValues != null) {
            list.addAll(Arrays.asList(this.fieldValues));
        }
        return list;
    }

    @Override
    public void accept(GeneratedBoogieAstVisitor generatedBoogieAstVisitor) {
        if (!generatedBoogieAstVisitor.visit((Expression)this)) {
            return;
        }
        if (generatedBoogieAstVisitor.visit(this) && this.fieldValues != null) {
            Expression[] expressionArray = this.fieldValues;
            int n = this.fieldValues.length;
            int n2 = 0;
            while (n2 < n) {
                Expression expression = expressionArray[n2];
                expression.accept(generatedBoogieAstVisitor);
                ++n2;
            }
        }
    }

    @Override
    public Expression accept(GeneratedBoogieAstTransformer generatedBoogieAstTransformer) {
        Expression expression = generatedBoogieAstTransformer.transform(this);
        if (expression != this) {
            return expression;
        }
        boolean bl = false;
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        if (this.fieldValues != null) {
            Expression[] expressionArray = this.fieldValues;
            int n = this.fieldValues.length;
            int n2 = 0;
            while (n2 < n) {
                Expression expression2 = expressionArray[n2];
                Expression expression3 = expression2.accept(generatedBoogieAstTransformer);
                bl = bl || expression3 != expression2;
                arrayList.add(expression3);
                ++n2;
            }
        }
        if (bl) {
            return new StructConstructor(this.loc, this.type, this.fieldIdentifiers, arrayList.toArray(new Expression[0]));
        }
        return this;
    }
}

