/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.werner;

import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.werner.SymbolicMemory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;

public class Backbone {
    private final Deque<IcfgEdge> mPath;
    private final Deque<IcfgLocation> mNodes;
    private final List<IcfgLocation> mNestedLoops;
    private TransFormula mFormula;
    private TermVariable mPathCounter;
    private UnmodifiableTransFormula mCondition;
    private SymbolicMemory mSymbolicMemory;
    private Term mAbstractPathCondition;
    private Boolean mIsNested;

    public Backbone(IcfgEdge icfgEdge) {
        this.mPath = new ArrayDeque<IcfgEdge>();
        this.mPath.addLast(icfgEdge);
        this.mNodes = new ArrayDeque<IcfgLocation>();
        this.mNodes.add((IcfgLocation)icfgEdge.getSource());
        this.mFormula = null;
        this.mPathCounter = null;
        this.mCondition = null;
        this.mSymbolicMemory = null;
        this.mNestedLoops = new ArrayList<IcfgLocation>();
        this.mIsNested = false;
        this.mAbstractPathCondition = null;
    }

    public Backbone(UnmodifiableTransFormula unmodifiableTransFormula) {
        this.mPath = null;
        this.mNodes = null;
        this.mFormula = unmodifiableTransFormula;
        this.mPathCounter = null;
        this.mCondition = null;
        this.mSymbolicMemory = null;
        this.mNestedLoops = new ArrayList<IcfgLocation>();
        this.mIsNested = false;
        this.mAbstractPathCondition = null;
    }

    public Backbone(Backbone backbone) {
        this.mPath = new ArrayDeque<IcfgEdge>(backbone.getPath());
        this.mNodes = new ArrayDeque<IcfgLocation>(backbone.getNodes());
        this.mFormula = null;
        this.mPathCounter = null;
        this.mCondition = null;
        this.mSymbolicMemory = null;
        this.mNestedLoops = new ArrayList<IcfgLocation>();
        this.mIsNested = false;
        this.mAbstractPathCondition = null;
    }

    public void setPathCounter(TermVariable termVariable) {
        this.mPathCounter = termVariable;
    }

    public void setCondition(UnmodifiableTransFormula unmodifiableTransFormula) {
        this.mCondition = unmodifiableTransFormula;
    }

    public void setFormula(TransFormula transFormula) {
        this.mFormula = transFormula;
    }

    public void setSymbolicMemory(SymbolicMemory symbolicMemory) {
        this.mSymbolicMemory = symbolicMemory;
    }

    public void setAbstractPathCondition(Term term) {
        this.mAbstractPathCondition = term;
    }

    public void addNestedLoop(IcfgLocation icfgLocation) {
        this.mNestedLoops.add(icfgLocation);
        this.mIsNested = true;
    }

    public void addTransition(IcfgEdge icfgEdge) {
        this.mPath.addLast(icfgEdge);
        this.mNodes.addLast((IcfgLocation)icfgEdge.getSource());
    }

    public Deque<IcfgEdge> getPath() {
        return this.mPath;
    }

    public Deque<IcfgLocation> getNodes() {
        return this.mNodes;
    }

    public TermVariable getPathCounter() {
        return this.mPathCounter;
    }

    public TransFormula getFormula() {
        return this.mFormula;
    }

    public UnmodifiableTransFormula getCondition() {
        return this.mCondition;
    }

    public List<IcfgLocation> getNestedLoops() {
        return this.mNestedLoops;
    }

    public SymbolicMemory getSymbolicMemory() {
        return this.mSymbolicMemory;
    }

    public Term getAbstractPathCondition() {
        return this.mAbstractPathCondition;
    }

    public Boolean isNested() {
        return this.mIsNested;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" { ");
        for (IcfgLocation icfgLocation : this.mNodes) {
            stringBuilder.append(String.valueOf(icfgLocation) + " -> ");
        }
        stringBuilder.append(String.valueOf(this.mPath.getLast().getTarget()) + " } ");
        return stringBuilder.toString();
    }
}

