/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.ModifiableGlobalsTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgCallTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgReturnTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.scripttransfer.TermTransferrer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.PureSubstitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.ModifiableNestedFormulas;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.NestedFormulas;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.MultiElementCounter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class NestedSsaBuilder<L extends IAction> {
    private final ILogger mLogger;
    private final Script mTcScript;
    private final Map<IProgramVar, Term> currentGlobalVarVersion = new HashMap<IProgramVar, Term>();
    protected Map<IProgramVar, Term> currentLocalAndOldVarVersion;
    protected final Stack<Map<IProgramVar, Term>> mCurrentVersionStack = new Stack();
    private Integer mStartOfCallingContext;
    private final Stack<Integer> mStartOfCallingContextStack = new Stack();
    private final Map<IProgramVar, TreeMap<Integer, Term>> mIndexedVarRepresentative = new HashMap<IProgramVar, TreeMap<Integer, Term>>();
    protected final Map<Term, IProgramVar> mConstants2BoogieVar = new HashMap<Term, IProgramVar>();
    protected final NestedFormulas<L, UnmodifiableTransFormula, IPredicate> mFormulas;
    protected final ModifiableNestedFormulas<L, Term, Term> mSsa;
    protected final ModifiableNestedFormulas<L, Map<Term, Term>, Map<Term, Term>> mVariable2Constant;
    private final ModifiableGlobalsTable mModGlobVarManager;
    private final Map<String, Term> mIndexedConstants = new HashMap<String, Term>();
    protected String mCurrentProcedure;
    protected final Map<Integer, Integer> mPendingContext2PendingReturn = new HashMap<Integer, Integer>();
    private final boolean mTransferToScriptNeeded;
    private final TermTransferrer mTermTransferrer;
    private final MultiElementCounter<TermVariable> mConstForTvCounter = new MultiElementCounter();

    public NestedSsaBuilder(ManagedScript managedScript, CfgSmtToolkit cfgSmtToolkit, NestedFormulas<L, UnmodifiableTransFormula, IPredicate> nestedFormulas, ILogger iLogger) {
        this.mLogger = iLogger;
        this.mTcScript = managedScript.getScript();
        this.mFormulas = nestedFormulas;
        this.mModGlobVarManager = cfgSmtToolkit.getModifiableGlobalsTable();
        this.mSsa = new ModifiableNestedFormulas(nestedFormulas.getCounterexample(), new TreeMap());
        this.mVariable2Constant = new ModifiableNestedFormulas(nestedFormulas.getCounterexample(), new TreeMap());
        this.mTransferToScriptNeeded = managedScript != cfgSmtToolkit.getManagedScript();
        this.mTermTransferrer = this.mTransferToScriptNeeded ? new TermTransferrer(cfgSmtToolkit.getManagedScript().getScript(), this.mTcScript) : null;
        this.buildSSA();
    }

    protected void buildSSA() {
        VariableVersioneer variableVersioneer;
        Object object;
        String string;
        Object object2;
        UnmodifiableTransFormula unmodifiableTransFormula;
        VariableVersioneer variableVersioneer2;
        IPredicate iPredicate;
        IIcfgCallTransition iIcfgCallTransition;
        int n;
        Set set = this.mFormulas.getTrace().getPendingReturns().keySet();
        Integer[] integerArray = set.toArray(new Integer[set.size()]);
        int n2 = integerArray.length;
        this.mStartOfCallingContext = -1 - n2;
        this.currentLocalAndOldVarVersion = new HashMap<IProgramVar, Term>();
        int n3 = n2 - 1;
        while (n3 >= 0) {
            n = integerArray[n3];
            this.mPendingContext2PendingReturn.put(this.mStartOfCallingContext, n);
            IIcfgReturnTransition iIcfgReturnTransition = (IIcfgReturnTransition)this.mFormulas.getTrace().getSymbol(n);
            iIcfgCallTransition = iIcfgReturnTransition.getCorrespondingCall();
            this.mCurrentProcedure = iIcfgCallTransition.getPrecedingProcedure();
            this.reVersionModifiableGlobals();
            if (n3 == n2 - 1) {
                this.reVersionModifiableOldVars();
            }
            iPredicate = this.mFormulas.getPendingContext(n);
            variableVersioneer2 = new VariableVersioneer(iPredicate);
            variableVersioneer2.versionPredicate();
            this.mSsa.setPendingContext(n, variableVersioneer2.getVersioneeredTerm());
            this.mVariable2Constant.setPendingContext(n, variableVersioneer2.getSubstitutionMapping());
            unmodifiableTransFormula = iIcfgCallTransition.getTransformula();
            object2 = new VariableVersioneer(unmodifiableTransFormula);
            ((VariableVersioneer)object2).versionInVars();
            string = iIcfgCallTransition.getSucceedingProcedure();
            object = this.mFormulas.getOldVarAssignment(n);
            variableVersioneer = new VariableVersioneer((UnmodifiableTransFormula)object);
            variableVersioneer.versionInVars();
            this.mStartOfCallingContextStack.push(this.mStartOfCallingContext);
            this.mStartOfCallingContext = this.mStartOfCallingContext + 1;
            this.mCurrentProcedure = string;
            this.mCurrentVersionStack.push(this.currentLocalAndOldVarVersion);
            this.currentLocalAndOldVarVersion = new HashMap<IProgramVar, Term>();
            variableVersioneer.versionAssignedVars(this.mStartOfCallingContext);
            ((VariableVersioneer)object2).versionAssignedVars(this.mStartOfCallingContext);
            ((VariableVersioneer)object2).replaceAuxVars();
            this.mSsa.setOldVarAssignmentAtPos(n, variableVersioneer.getVersioneeredTerm());
            this.mVariable2Constant.setOldVarAssignmentAtPos(n, variableVersioneer.getSubstitutionMapping());
            this.mSsa.setLocalVarAssignmentAtPos(n, ((VariableVersioneer)object2).getVersioneeredTerm());
            this.mVariable2Constant.setLocalVarAssignmentAtPos(n, ((VariableVersioneer)object2).getSubstitutionMapping());
            --n3;
        }
        assert (this.mStartOfCallingContext == -1);
        if (this.mCurrentProcedure == null) {
            assert (n2 == 0);
            IAction iAction = (IAction)this.mFormulas.getTrace().getSymbol(0);
            this.mCurrentProcedure = iAction.getPrecedingProcedure();
        }
        this.reVersionModifiableGlobals();
        if (integerArray.length == 0) {
            this.reVersionModifiableOldVars();
        }
        VariableVersioneer variableVersioneer3 = new VariableVersioneer(this.mFormulas.getPrecondition());
        variableVersioneer3.versionPredicate();
        this.mSsa.setPrecondition(variableVersioneer3.getVersioneeredTerm());
        this.mVariable2Constant.setPrecondition(variableVersioneer3.getSubstitutionMapping());
        n = 0;
        int n4 = 0;
        while (n4 < this.mFormulas.getTrace().length()) {
            iIcfgCallTransition = (IAction)this.mFormulas.getTrace().getSymbol(n4);
            iPredicate = this.mFormulas.getTrace().isCallPosition(n4) ? this.mFormulas.getLocalVarAssignment(n4) : this.mFormulas.getFormulaFromNonCallPos(n4);
            assert (iPredicate != null) : "CodeBlock " + String.valueOf(iIcfgCallTransition) + " has no TransFormula";
            variableVersioneer2 = new VariableVersioneer((UnmodifiableTransFormula)iPredicate);
            variableVersioneer2.versionInVars();
            if (this.mFormulas.getTrace().isCallPosition(n4)) {
                assert (iIcfgCallTransition instanceof IIcfgCallTransition) : "current implementation supports only Call";
                if (this.mFormulas.getTrace().isPendingCall(n4)) {
                    ++n;
                }
                unmodifiableTransFormula = iIcfgCallTransition;
                this.mCurrentProcedure = object2 = unmodifiableTransFormula.getSucceedingProcedure();
                string = this.mFormulas.getOldVarAssignment(n4);
                object = new VariableVersioneer((UnmodifiableTransFormula)string);
                ((VariableVersioneer)object).versionInVars();
                this.mStartOfCallingContextStack.push(this.mStartOfCallingContext);
                this.mStartOfCallingContext = n4;
                this.mCurrentVersionStack.push(this.currentLocalAndOldVarVersion);
                this.currentLocalAndOldVarVersion = new HashMap<IProgramVar, Term>();
                ((VariableVersioneer)object).versionAssignedVars(n4);
                this.mSsa.setOldVarAssignmentAtPos(n4, ((VariableVersioneer)object).getVersioneeredTerm());
                this.mVariable2Constant.setOldVarAssignmentAtPos(n4, ((VariableVersioneer)object).getSubstitutionMapping());
                variableVersioneer = this.mFormulas.getGlobalVarAssignment(n4);
                VariableVersioneer variableVersioneer4 = new VariableVersioneer((UnmodifiableTransFormula)variableVersioneer);
                variableVersioneer4.versionInVars();
                variableVersioneer4.versionAssignedVars(n4);
                this.mSsa.setGlobalVarAssignmentAtPos(n4, variableVersioneer4.getVersioneeredTerm());
                this.mVariable2Constant.setGlobalVarAssignmentAtPos(n4, variableVersioneer4.getSubstitutionMapping());
            }
            if (this.mFormulas.getTrace().isReturnPosition(n4)) {
                unmodifiableTransFormula = (IIcfgReturnTransition)iIcfgCallTransition;
                this.mCurrentProcedure = unmodifiableTransFormula.getCallerProgramPoint().getProcedure();
                this.currentLocalAndOldVarVersion = this.mCurrentVersionStack.pop();
                this.mStartOfCallingContext = this.mStartOfCallingContextStack.pop();
            }
            variableVersioneer2.versionAssignedVars(n4);
            variableVersioneer2.versionBranchEncoders(n4);
            variableVersioneer2.replaceAuxVars();
            if (this.mFormulas.getTrace().isCallPosition(n4)) {
                this.mSsa.setLocalVarAssignmentAtPos(n4, variableVersioneer2.getVersioneeredTerm());
                this.mVariable2Constant.setLocalVarAssignmentAtPos(n4, variableVersioneer2.getSubstitutionMapping());
            } else {
                this.mSsa.setFormulaAtNonCallPos(n4, variableVersioneer2.getVersioneeredTerm());
                this.mVariable2Constant.setFormulaAtNonCallPos(n4, variableVersioneer2.getSubstitutionMapping());
            }
            ++n4;
        }
        assert (this.mCurrentVersionStack.size() == n);
        assert (n > 0 || this.mStartOfCallingContext == -1 - n2);
        assert (n == 0 || n2 == 0);
        VariableVersioneer variableVersioneer5 = new VariableVersioneer(this.mFormulas.getPostcondition());
        variableVersioneer5.versionPredicate();
        this.mSsa.setPostcondition(variableVersioneer5.getVersioneeredTerm());
        this.mVariable2Constant.setPostcondition(variableVersioneer5.getSubstitutionMapping());
    }

    protected void reVersionModifiableGlobals() {
        Set set = this.mModGlobVarManager.getModifiedBoogieVars(this.mCurrentProcedure);
        for (IProgramVar iProgramVar : set) {
            this.setCurrentVarVersion(iProgramVar, this.mStartOfCallingContext);
        }
    }

    protected void reVersionModifiableOldVars() {
        Set set = this.mModGlobVarManager.getModifiedBoogieVars(this.mCurrentProcedure);
        for (IProgramNonOldVar iProgramNonOldVar : set) {
            IProgramOldVar iProgramOldVar = iProgramNonOldVar.getOldVar();
            this.setCurrentVarVersion((IProgramVar)iProgramOldVar, this.mStartOfCallingContext);
        }
    }

    public static String branchEncoderConstantName(TermVariable termVariable, int n) {
        String string = termVariable.getName() + "_" + n;
        return string;
    }

    public Map<Term, IProgramVar> getConstants2BoogieVar() {
        return this.mConstants2BoogieVar;
    }

    public Map<IProgramVar, TreeMap<Integer, Term>> getIndexedVarRepresentative() {
        return this.mIndexedVarRepresentative;
    }

    public NestedFormulas<L, Term, Term> getSsa() {
        return this.mSsa;
    }

    public ModifiableNestedFormulas<L, Map<Term, Term>, Map<Term, Term>> getVariable2Constant() {
        return this.mVariable2Constant;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Term getCurrentVarVersion(IProgramVar iProgramVar) {
        if (iProgramVar.isGlobal()) {
            if (iProgramVar instanceof IProgramOldVar) {
                assert (iProgramVar.isOldvar());
                IProgramOldVar iProgramOldVar = (IProgramOldVar)iProgramVar;
                if (this.mModGlobVarManager.isModifiable(iProgramOldVar, this.mCurrentProcedure)) {
                    return this.currentLocalAndOldVarVersion.get(iProgramOldVar);
                }
                if (iProgramOldVar.getNonOldVar() != null) return this.getOrSetCurrentGlobalVarVersion((IProgramVar)iProgramOldVar.getNonOldVar());
                throw new IllegalStateException("missing non-old var for oldVar " + String.valueOf(iProgramOldVar));
            }
            if (iProgramVar instanceof IProgramNonOldVar) {
                IProgramNonOldVar iProgramNonOldVar = (IProgramNonOldVar)iProgramVar;
                return this.getOrSetCurrentGlobalVarVersion((IProgramVar)iProgramNonOldVar);
            }
            if (!(iProgramVar instanceof IProgramConst)) throw new AssertionError((Object)("unknown kind of IProgramVar " + iProgramVar.getClass().getSimpleName()));
            return this.getOrSetCurrentGlobalVarVersion(iProgramVar);
        }
        Term term = this.currentLocalAndOldVarVersion.get(iProgramVar);
        if (term != null) return term;
        return this.setCurrentVarVersion(iProgramVar, this.mStartOfCallingContext);
    }

    private Term getOrSetCurrentGlobalVarVersion(IProgramVar iProgramVar) {
        assert (iProgramVar instanceof IProgramNonOldVar || iProgramVar instanceof IProgramConst) : "not global";
        Term term = this.currentGlobalVarVersion.get(iProgramVar);
        if (term == null) {
            term = this.setCurrentVarVersion(iProgramVar, -1);
        }
        return term;
    }

    private Term setCurrentVarVersion(IProgramVar iProgramVar, int n) {
        Term term = this.buildVersion(iProgramVar, n);
        if (iProgramVar.isGlobal()) {
            if (iProgramVar.isOldvar()) {
                assert (n == this.mStartOfCallingContext) : "oldVars may only be assigned at entry of procedure";
                this.currentLocalAndOldVarVersion.put(iProgramVar, term);
            } else {
                this.currentGlobalVarVersion.put(iProgramVar, term);
            }
        } else {
            this.currentLocalAndOldVarVersion.put(iProgramVar, term);
        }
        return term;
    }

    private Term buildVersion(IProgramVar iProgramVar, int n) {
        Term term;
        TreeMap<Integer, Object> treeMap = this.mIndexedVarRepresentative.get(iProgramVar);
        if (treeMap == null) {
            treeMap = new TreeMap();
            this.mIndexedVarRepresentative.put(iProgramVar, treeMap);
        }
        assert (!treeMap.containsKey(n)) : "version was already constructed";
        if (iProgramVar instanceof IProgramConst) {
            term = this.transferToCurrentScriptIfNecessary((Term)iProgramVar.getDefaultConstant());
        } else {
            Sort sort = this.transferToCurrentScriptIfNecessary(iProgramVar.getTermVariable()).getSort();
            term = PredicateUtils.getIndexedConstant((String)iProgramVar.getGloballyUniqueId(), (Sort)sort, (int)n, this.mIndexedConstants, (Script)this.mTcScript);
        }
        treeMap.put(n, term);
        return term;
    }

    private boolean modifiedInCurrentCallingContext(IProgramVar iProgramVar) {
        int n;
        UnmodifiableTransFormula unmodifiableTransFormula;
        if (!iProgramVar.isGlobal()) {
            throw new IllegalArgumentException(String.valueOf(iProgramVar) + " no global var");
        }
        if (this.mStartOfCallingContext >= 0) {
            unmodifiableTransFormula = this.mFormulas.getOldVarAssignment(this.mStartOfCallingContext);
        } else {
            if (this.mStartOfCallingContext == -1) {
                return true;
            }
            assert (this.mStartOfCallingContext < -1);
            n = this.mPendingContext2PendingReturn.get(this.mStartOfCallingContext);
            unmodifiableTransFormula = this.mFormulas.getOldVarAssignment(n);
        }
        n = iProgramVar.isOldvar() ? (int)(unmodifiableTransFormula.getAssignedVars().contains(iProgramVar) ? 1 : 0) : (int)(unmodifiableTransFormula.getInVars().containsKey(iProgramVar) ? 1 : 0);
        return n != 0;
    }

    private Term transferToCurrentScriptIfNecessary(Term term) {
        Term term2 = this.mTransferToScriptNeeded ? this.mTermTransferrer.transform(term) : term;
        return term2;
    }

    private TermVariable transferToCurrentScriptIfNecessary(TermVariable termVariable) {
        TermVariable termVariable2 = this.mTransferToScriptNeeded ? (TermVariable)this.mTermTransferrer.transform((Term)termVariable) : termVariable;
        return termVariable2;
    }

    class VariableVersioneer {
        private final UnmodifiableTransFormula mTF;
        private final IPredicate mPred;
        private final Map<Term, Term> mSubstitutionMapping = new HashMap<Term, Term>();
        private final Term mFormula;

        public VariableVersioneer(UnmodifiableTransFormula unmodifiableTransFormula) {
            this.mTF = Objects.requireNonNull(unmodifiableTransFormula);
            this.mPred = null;
            this.mFormula = NestedSsaBuilder.this.transferToCurrentScriptIfNecessary(unmodifiableTransFormula.getFormula());
        }

        public VariableVersioneer(IPredicate iPredicate) {
            this.mTF = null;
            this.mPred = iPredicate;
            this.mFormula = NestedSsaBuilder.this.transferToCurrentScriptIfNecessary(iPredicate.getFormula());
        }

        public void versionInVars() {
            for (IProgramVar iProgramVar : this.mTF.getInVars().keySet()) {
                TermVariable termVariable = NestedSsaBuilder.this.transferToCurrentScriptIfNecessary((TermVariable)this.mTF.getInVars().get(iProgramVar));
                Term term = NestedSsaBuilder.this.getCurrentVarVersion(iProgramVar);
                NestedSsaBuilder.this.mConstants2BoogieVar.put(term, iProgramVar);
                this.mSubstitutionMapping.put((Term)termVariable, term);
            }
        }

        public void versionAssignedVars(int n) {
            for (IProgramVar iProgramVar : this.mTF.getAssignedVars()) {
                Term term = NestedSsaBuilder.this.setCurrentVarVersion(iProgramVar, n);
                NestedSsaBuilder.this.mConstants2BoogieVar.put(term, iProgramVar);
                TermVariable termVariable = (TermVariable)this.mTF.getOutVars().get(iProgramVar);
                if (termVariable == null) continue;
                TermVariable termVariable2 = NestedSsaBuilder.this.transferToCurrentScriptIfNecessary(termVariable);
                this.mSubstitutionMapping.put((Term)termVariable2, term);
            }
        }

        public void versionBranchEncoders(int n) {
            for (TermVariable termVariable : this.mTF.getBranchEncoders()) {
                termVariable = NestedSsaBuilder.this.transferToCurrentScriptIfNecessary(termVariable);
                String string = NestedSsaBuilder.branchEncoderConstantName(termVariable, n);
                NestedSsaBuilder.this.mTcScript.declareFun(string, new Sort[0], termVariable.getSort());
                this.mSubstitutionMapping.put((Term)termVariable, NestedSsaBuilder.this.mTcScript.term(string, new Term[0]));
            }
        }

        public void replaceAuxVars() {
            for (TermVariable termVariable : this.mTF.getAuxVars()) {
                termVariable = NestedSsaBuilder.this.transferToCurrentScriptIfNecessary(termVariable);
                Term term = this.constructFreshConstant(termVariable);
                this.mSubstitutionMapping.put((Term)termVariable, term);
            }
        }

        private Term constructFreshConstant(TermVariable termVariable) {
            Integer n = NestedSsaBuilder.this.mConstForTvCounter.increment((Object)termVariable);
            String string = SmtUtils.removeSmtQuoteCharacters((String)termVariable.getName()) + "_fresh_" + String.valueOf(n);
            Sort sort = termVariable.getSort();
            NestedSsaBuilder.this.mTcScript.declareFun(string, new Sort[0], sort);
            return NestedSsaBuilder.this.mTcScript.term(string, new Term[0]);
        }

        public void versionPredicate() {
            for (IProgramVar iProgramVar : this.mPred.getVars()) {
                TermVariable termVariable = NestedSsaBuilder.this.transferToCurrentScriptIfNecessary(iProgramVar.getTermVariable());
                Term term = NestedSsaBuilder.this.getCurrentVarVersion(iProgramVar);
                NestedSsaBuilder.this.mConstants2BoogieVar.put(term, iProgramVar);
                this.mSubstitutionMapping.put((Term)termVariable, term);
            }
        }

        public Term getVersioneeredTerm() {
            Term term = PureSubstitution.apply((Script)NestedSsaBuilder.this.mTcScript, this.mSubstitutionMapping, (Term)this.mFormula);
            assert (term.getFreeVars().length == 0) : "free vars in versioneered term: " + Arrays.stream(term.getFreeVars()).map(termVariable -> termVariable.toString()).collect(Collectors.joining(","));
            return term;
        }

        public Map<Term, Term> getSubstitutionMapping() {
            return this.mSubstitutionMapping;
        }
    }
}

