/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure;

import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.SimpleList;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCAppTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CClosure;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.ReverseTrigger;

public class CCParentInfo {
    int mFuncSymbNr;
    SimpleList<CCAppTerm.Parent> mCCParents;
    CCParentInfo mNext;
    SimpleList<ReverseTrigger> mReverseTriggers;

    public CCParentInfo() {
        this.mFuncSymbNr = -1;
    }

    private CCParentInfo(int n, CCParentInfo cCParentInfo) {
        this.mFuncSymbNr = n;
        this.mCCParents = new SimpleList();
        this.mNext = cCParentInfo;
        this.mReverseTriggers = new SimpleList();
    }

    private CCParentInfo(CCParentInfo cCParentInfo, CCParentInfo cCParentInfo2) {
        this(cCParentInfo.mFuncSymbNr, cCParentInfo2);
        this.mCCParents.joinList(cCParentInfo.mCCParents);
        this.mReverseTriggers.joinList(cCParentInfo.mReverseTriggers);
    }

    public void addParentInfo(int n, CCAppTerm.Parent parent, boolean bl, CClosure cClosure) {
        CCParentInfo cCParentInfo = this;
        while (cCParentInfo.mNext != null && cCParentInfo.mNext.mFuncSymbNr <= n) {
            cCParentInfo = cCParentInfo.mNext;
            if (cCParentInfo.mFuncSymbNr != n) continue;
            cCParentInfo.mCCParents.prependIntoJoined(parent, bl);
            return;
        }
        cCParentInfo.mNext = new CCParentInfo(n, cCParentInfo.mNext);
        cCParentInfo.mNext.mCCParents.prependIntoJoined(parent, bl);
    }

    public void mergeParentInfo(CCParentInfo cCParentInfo) {
        CCParentInfo cCParentInfo2 = this;
        cCParentInfo = cCParentInfo.mNext;
        while (cCParentInfo != null) {
            int n = cCParentInfo.mFuncSymbNr;
            while (cCParentInfo2.mNext != null && cCParentInfo2.mNext.mFuncSymbNr < n) {
                cCParentInfo2 = cCParentInfo2.mNext;
            }
            if (cCParentInfo2.mNext != null && cCParentInfo2.mNext.mFuncSymbNr == n) {
                cCParentInfo2 = cCParentInfo2.mNext;
                cCParentInfo2.mCCParents.joinList(cCParentInfo.mCCParents);
                cCParentInfo2.mReverseTriggers.joinList(cCParentInfo.mReverseTriggers);
            } else {
                cCParentInfo2 = cCParentInfo2.mNext = new CCParentInfo(cCParentInfo, cCParentInfo2.mNext);
            }
            cCParentInfo = cCParentInfo.mNext;
        }
    }

    public void unmergeParentInfo(CCParentInfo cCParentInfo) {
        CCParentInfo cCParentInfo2 = this;
        cCParentInfo = cCParentInfo.mNext;
        while (cCParentInfo != null) {
            int n = cCParentInfo.mFuncSymbNr;
            while (cCParentInfo2.mNext.mFuncSymbNr < n) {
                cCParentInfo2 = cCParentInfo2.mNext;
            }
            CCParentInfo cCParentInfo3 = cCParentInfo2.mNext;
            assert (cCParentInfo3.mFuncSymbNr == n);
            cCParentInfo3.mCCParents.unjoinList(cCParentInfo.mCCParents);
            cCParentInfo3.mReverseTriggers.unjoinList(cCParentInfo.mReverseTriggers);
            if (!cCParentInfo3.mCCParents.isEmpty() || !cCParentInfo3.mReverseTriggers.isEmpty()) {
                cCParentInfo2 = cCParentInfo3;
            }
            cCParentInfo = cCParentInfo.mNext;
        }
    }

    CCParentInfo getInfo(int n) {
        CCParentInfo cCParentInfo = this;
        while (cCParentInfo.mNext != null && cCParentInfo.mNext.mFuncSymbNr <= n) {
            cCParentInfo = cCParentInfo.mNext;
            if (cCParentInfo.mFuncSymbNr != n) continue;
            return cCParentInfo;
        }
        return null;
    }

    CCParentInfo createInfo(int n) {
        CCParentInfo cCParentInfo = this;
        while (cCParentInfo.mNext != null && cCParentInfo.mNext.mFuncSymbNr <= n) {
            cCParentInfo = cCParentInfo.mNext;
            if (cCParentInfo.mFuncSymbNr != n) continue;
            return cCParentInfo;
        }
        cCParentInfo.mNext = new CCParentInfo(n, cCParentInfo.mNext);
        return cCParentInfo.mNext;
    }

    CCParentInfo getExistingParentInfo(int n) {
        CCParentInfo cCParentInfo = this;
        while (cCParentInfo.mNext != null && cCParentInfo.mNext.mFuncSymbNr <= n) {
            cCParentInfo = cCParentInfo.mNext;
            if (cCParentInfo.mFuncSymbNr != n) continue;
            return cCParentInfo;
        }
        return null;
    }

    public SimpleList<CCAppTerm.Parent> getParentInfo(int n) {
        CCParentInfo cCParentInfo = this.mNext;
        while (cCParentInfo != null && cCParentInfo.mFuncSymbNr < n) {
            cCParentInfo = cCParentInfo.mNext;
        }
        if (cCParentInfo != null && cCParentInfo.mFuncSymbNr == n) {
            return cCParentInfo.mCCParents;
        }
        return new SimpleList<CCAppTerm.Parent>();
    }
}

