/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.concurrency;

import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.Word;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedRun;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWord;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.IDfsOrder;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.ISleepSetStateFactory;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.IRunningTaskStackProvider;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.RunningTaskInfo;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.interpolant.QualifiedTracePredicates;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.tracehandling.IRefinementEngineResult;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder.independence.ConditionalCommutativityChecker;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling.IIpAbStrategyModule;
import de.uni_freiburg.informatik.ultimate.util.Lazy;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ImmutableSet;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import de.uni_freiburg.informatik.ultimate.util.statistics.AbstractStatisticsDataProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsDataProvider;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ConditionalCommutativityCounterexampleChecker<L extends IAction> {
    private final ILogger mLogger;
    private final IDfsOrder<L, IPredicate> mDfsOrder;
    private final ConditionalCommutativityChecker<L> mChecker;
    private final ISleepSetStateFactory<L, IPredicate, IPredicate> mSleepSetFactory;
    private final Function<Word<L>, IIpAbStrategyModule<L>> mAutomatonBuilderFactory;
    private final int mPathProgramThreshold;
    private final int mImperfectProofRetries;
    private final Map<Set<?>, Integer> mPreviouslySeenPathPrograms = new HashMap();
    private final Set<Triple<List<Object>, L, L>> mHopelessConditionChecks = new HashSet<Triple<List<Object>, L, L>>();
    private final Map<Triple<List<Object>, L, L>, Integer> mFailedConditionChecks = new HashMap<Triple<List<Object>, L, L>, Integer>();
    private final Statistics mStatistics;

    public ConditionalCommutativityCounterexampleChecker(IUltimateServiceProvider iUltimateServiceProvider, IDfsOrder<L, IPredicate> iDfsOrder, ConditionalCommutativityChecker<L> conditionalCommutativityChecker, ISleepSetStateFactory<L, IPredicate, IPredicate> iSleepSetStateFactory, Function<Word<L>, IIpAbStrategyModule<L>> function, int n, int n2) {
        this.mLogger = iUltimateServiceProvider.getLoggingService().getLogger(ConditionalCommutativityCounterexampleChecker.class);
        this.mDfsOrder = iDfsOrder;
        this.mChecker = conditionalCommutativityChecker;
        this.mSleepSetFactory = Objects.requireNonNull(iSleepSetStateFactory);
        this.mAutomatonBuilderFactory = function;
        this.mStatistics = new Statistics(conditionalCommutativityChecker);
        this.mPathProgramThreshold = n;
        this.mImperfectProofRetries = n2;
    }

    public IRefinementEngineResult<L, NestedWordAutomaton<L, IPredicate>> getCommutativityProof(NestedRun<L, IPredicate> nestedRun, List<Object> list) {
        Set<Object> set = Set.copyOf(list);
        int n = this.mPreviouslySeenPathPrograms.getOrDefault(set, 0) + 1;
        this.mPreviouslySeenPathPrograms.put(set, n);
        this.mLogger.info("Examining path program with hash %d, occurence #%d", new Object[]{set.hashCode(), n});
        if (n < this.mPathProgramThreshold) {
            this.mLogger.info("Commutativity condition synthesis is only active after more than %d occurrences. Skipping...", new Object[]{this.mPathProgramThreshold});
            return null;
        }
        this.mLogger.info((Object)"Trying to synthesize and prove commutativity condition.");
        int n2 = 0;
        while (n2 < nestedRun.getStateSequence().size() - 2) {
            IAction iAction;
            IAction iAction2;
            IPredicate iPredicate = (IPredicate)nestedRun.getStateSequence().get(n2);
            if (this.isNonMinimalityPoint(iPredicate, iAction2 = (IAction)nestedRun.getWord().getSymbol(n2), iAction = (IAction)nestedRun.getWord().getSymbol(n2 + 1))) {
                NestedWord nestedWord = nestedRun.getWord().getSubWord(0, n2);
                List<Object> list2 = list.subList(0, n2 + 1);
                Triple triple = new Triple(list, (Object)iAction2, (Object)iAction);
                if (this.mHopelessConditionChecks.contains(triple)) {
                    this.mLogger.info("Commutativity condition check at non-minimality point %d is hopeless, skipping.", new Object[]{n2});
                } else {
                    this.mLogger.info("Performing commutativity condition check at non-minimality point %d", new Object[]{n2});
                    ConditionalCommutativityChecker.Result result = this.mChecker.checkConditionalCommutativity((Word)nestedWord, list2, iPredicate, iAction2, iAction);
                    switch (result.getType()) {
                        case SUCCESS: {
                            this.mStatistics.reportSuccessfulCommutativityProof();
                            this.mLogger.info("Successfully proved commutativity at non-minimality point %d. Constructing proof automaton...", new Object[]{n2});
                            return this.buildAutomaton((Word<L>)nestedWord, (IRefinementEngineResult<L, Collection<QualifiedTracePredicates>>)result.getRefinementResult());
                        }
                        case CONDITION_NOT_SATISFIED: 
                        case UNKNOWN_CHECK: {
                            this.mLogger.info("Commutativity condition check yielded %s. Marking as hopeless.", new Object[]{result.getType()});
                            this.mHopelessConditionChecks.add(triple);
                            break;
                        }
                        case ALREADY_INDEPENDENT: {
                            this.mLogger.warn((Object)"Statements were already independent.");
                            break;
                        }
                        case PROOF_IMPERFECT: {
                            int n3 = this.mFailedConditionChecks.getOrDefault(triple, 0) + 1;
                            this.mLogger.info("Commutativity condition check failed due to imperfect proof (attempt %d of %d).", new Object[]{n3, this.mImperfectProofRetries + 1});
                            if (n3 <= this.mImperfectProofRetries) {
                                this.mFailedConditionChecks.put(triple, n3);
                                break;
                            }
                            this.mFailedConditionChecks.remove(triple);
                            this.mHopelessConditionChecks.add(triple);
                            break;
                        }
                        case NO_CONDITION_FOUND: {
                            this.mLogger.info((Object)"No commutativity condition found.");
                        }
                    }
                }
            }
            ++n2;
        }
        this.mLogger.warn((Object)"Failed to synthesize and prove commutativity condition.");
        return null;
    }

    public IStatisticsDataProvider getStatistics() {
        return this.mStatistics;
    }

    private boolean isNonMinimalityPoint(IPredicate iPredicate, L l, L l2) {
        ImmutableSet immutableSet = this.mSleepSetFactory.getSleepSet((Object)iPredicate);
        return immutableSet.contains(l2) || this.mDfsOrder.getOrder((Object)iPredicate).compare(l, l2) > 0;
    }

    private IRefinementEngineResult<L, NestedWordAutomaton<L, IPredicate>> buildAutomaton(Word<L> word, IRefinementEngineResult<L, Collection<QualifiedTracePredicates>> iRefinementEngineResult) {
        List<QualifiedTracePredicates> list = ((Collection)iRefinementEngineResult.getInfeasibilityProof()).stream().filter(QualifiedTracePredicates::isPerfect).collect(Collectors.toList());
        List<QualifiedTracePredicates> list2 = ((Collection)iRefinementEngineResult.getInfeasibilityProof()).stream().filter(qualifiedTracePredicates -> !qualifiedTracePredicates.isPerfect()).collect(Collectors.toList());
        IIpAbStrategyModule<L> iIpAbStrategyModule = this.mAutomatonBuilderFactory.apply(word);
        try {
            IIpAbStrategyModule.IpAbStrategyModuleResult<L> ipAbStrategyModuleResult = iIpAbStrategyModule.buildInterpolantAutomaton(list, list2);
            return new IRefinementEngineResult.BasicRefinementEngineResult(Script.LBool.UNSAT, ipAbStrategyModuleResult.getAutomaton(), null, false, ipAbStrategyModuleResult.getUsedTracePredicates(), new Lazy(() -> iRefinementEngineResult.getHoareTripleChecker()), new Lazy(() -> iRefinementEngineResult.getPredicateUnifier()));
        }
        catch (AutomataOperationCanceledException automataOperationCanceledException) {
            throw new ToolchainCanceledException((IRunningTaskStackProvider)automataOperationCanceledException, new RunningTaskInfo(iIpAbStrategyModule.getClass(), "computing interpolant automaton"));
        }
    }

    private static class Statistics
    extends AbstractStatisticsDataProvider {
        private int mSuccessfulCommutativityProofs;

        public Statistics(ConditionalCommutativityChecker<?> conditionalCommutativityChecker) {
            this.declareCounter("SuccessfulCommutativityProofs", () -> this.mSuccessfulCommutativityProofs);
            this.forward("ConComChecker Statistics", () -> conditionalCommutativityChecker.getStatistics());
        }

        public void reportSuccessfulCommutativityProof() {
            ++this.mSuccessfulCommutativityProofs;
        }
    }
}

