/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.Word;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaInclusionStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedRun;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.VpAlphabet;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.Difference;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.IsEmpty;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IEmptyStackStateFactory;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IProgramExecution;
import de.uni_freiburg.informatik.ultimate.lib.mcr.IInterpolantProvider;
import de.uni_freiburg.informatik.ultimate.lib.mcr.McrAutomatonBuilder;
import de.uni_freiburg.informatik.ultimate.lib.mcr.McrTraceCheckResult;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.HoareTripleCheckerUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.IHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.interpolant.IInterpolatingTraceCheck;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.interpolant.InterpolantComputationStatus;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.tracecheck.ITraceCheckPreferences;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.tracecheck.TraceCheckReasonUnknown;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.PredicateFactoryRefinement;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.interpolantautomata.transitionappender.DeterministicInterpolantAutomaton;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsDataProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Mcr<L extends IIcfgTransition<?>>
implements IInterpolatingTraceCheck<L> {
    private final ILogger mLogger;
    private final IPredicateUnifier mPredicateUnifier;
    private final IUltimateServiceProvider mServices;
    private final AutomataLibraryServices mAutomataServices;
    private final CfgSmtToolkit mToolkit;
    private final IEmptyStackStateFactory<IPredicate> mEmptyStackStateFactory;
    private final VpAlphabet<L> mAlphabet;
    private final IMcrResultProvider<L> mResultProvider;
    private final IHoareTripleChecker mHoareTripleChecker;
    private final IInterpolantProvider<L> mInterpolantProvider;
    private final McrTraceCheckResult<L> mResult;

    public Mcr(IUltimateServiceProvider iUltimateServiceProvider, ILogger iLogger, ITraceCheckPreferences iTraceCheckPreferences, IPredicateUnifier iPredicateUnifier, IEmptyStackStateFactory<IPredicate> iEmptyStackStateFactory, List<L> list, Set<L> set, IMcrResultProvider<L> iMcrResultProvider, IInterpolantProvider<L> iInterpolantProvider) throws AutomataLibraryException {
        this.mLogger = iLogger;
        this.mPredicateUnifier = iPredicateUnifier;
        this.mServices = iUltimateServiceProvider;
        this.mAutomataServices = new AutomataLibraryServices(this.mServices);
        this.mAlphabet = new VpAlphabet(set);
        this.mToolkit = iTraceCheckPreferences.getCfgSmtToolkit();
        this.mEmptyStackStateFactory = iEmptyStackStateFactory;
        this.mResultProvider = iMcrResultProvider;
        this.mHoareTripleChecker = HoareTripleCheckerUtils.constructEfficientHoareTripleCheckerWithCaching((IUltimateServiceProvider)this.mServices, (HoareTripleCheckerUtils.HoareTripleChecks)HoareTripleCheckerUtils.HoareTripleChecks.INCREMENTAL, (CfgSmtToolkit)this.mToolkit, (IPredicateUnifier)this.mPredicateUnifier);
        this.mInterpolantProvider = iInterpolantProvider;
        this.mResult = this.exploreInterleavings(list);
    }

    private McrTraceCheckResult<L> exploreInterleavings(List<L> list) throws AutomataLibraryException {
        ManagedScript managedScript = this.mToolkit.getManagedScript();
        McrAutomatonBuilder mcrAutomatonBuilder = new McrAutomatonBuilder(list, this.mPredicateUnifier, this.mEmptyStackStateFactory, this.mLogger, this.mAlphabet, this.mServices);
        PredicateFactory predicateFactory = new PredicateFactory(this.mServices, managedScript, this.mToolkit.getSymbolTable());
        PredicateFactoryRefinement predicateFactoryRefinement = new PredicateFactoryRefinement(this.mServices, managedScript, predicateFactory, false, Collections.emptySet());
        ArrayList<INestedWordAutomaton<L, IPredicate>> arrayList = new ArrayList<INestedWordAutomaton<L, IPredicate>>();
        NestedWordAutomaton nestedWordAutomaton = mcrAutomatonBuilder.buildMhbAutomaton(predicateFactory);
        NestedRun nestedRun = new IsEmpty(this.mAutomataServices, (INwaOutgoingLetterAndTransitionProvider)nestedWordAutomaton).getNestedRun();
        int n = 0;
        McrTraceCheckResult<L> mcrTraceCheckResult = null;
        while (nestedRun != null) {
            this.mLogger.info((Object)("---- MCR iteration " + n + " ----"));
            ++n;
            mcrTraceCheckResult = this.mResultProvider.getResult((Word<L>)nestedRun.getWord());
            List list2 = nestedRun.getWord().asList();
            if (mcrTraceCheckResult.isCorrect() != Script.LBool.UNSAT) {
                return mcrTraceCheckResult;
            }
            NestedWordAutomaton nestedWordAutomaton2 = mcrAutomatonBuilder.buildInterpolantAutomaton(list2, Arrays.asList(mcrTraceCheckResult.getInterpolants()), this.mInterpolantProvider);
            DeterministicInterpolantAutomaton deterministicInterpolantAutomaton = new DeterministicInterpolantAutomaton(this.mServices, this.mToolkit, this.mHoareTripleChecker, nestedWordAutomaton2, this.mPredicateUnifier, false, false);
            arrayList.add((INestedWordAutomaton<L, IPredicate>)nestedWordAutomaton2);
            nestedWordAutomaton = new Difference(this.mAutomataServices, (INwaInclusionStateFactory)predicateFactoryRefinement, (INwaOutgoingLetterAndTransitionProvider)nestedWordAutomaton, deterministicInterpolantAutomaton).getResult();
            nestedRun = new IsEmpty(this.mAutomataServices, (INwaOutgoingLetterAndTransitionProvider)nestedWordAutomaton).getNestedRun();
        }
        mcrTraceCheckResult.setAutomaton(this.unionAutomata(arrayList));
        return mcrTraceCheckResult;
    }

    private NestedWordAutomaton<L, IPredicate> unionAutomata(List<INestedWordAutomaton<L, IPredicate>> list) {
        NestedWordAutomaton nestedWordAutomaton = new NestedWordAutomaton(this.mAutomataServices, this.mAlphabet, this.mEmptyStackStateFactory);
        IPredicate iPredicate = this.mPredicateUnifier.getTruePredicate();
        nestedWordAutomaton.addState(true, false, (Object)iPredicate);
        nestedWordAutomaton.addState(false, true, (Object)this.mPredicateUnifier.getFalsePredicate());
        for (INestedWordAutomaton<L, IPredicate> iNestedWordAutomaton : list) {
            LinkedList<IPredicate> linkedList = new LinkedList<IPredicate>();
            HashSet<IPredicate> hashSet = new HashSet<IPredicate>();
            linkedList.add(iPredicate);
            while (!linkedList.isEmpty()) {
                IPredicate iPredicate2 = (IPredicate)linkedList.remove();
                if (!hashSet.add(iPredicate2)) continue;
                for (OutgoingInternalTransition outgoingInternalTransition : iNestedWordAutomaton.internalSuccessors((Object)iPredicate2)) {
                    IPredicate iPredicate3 = (IPredicate)outgoingInternalTransition.getSucc();
                    if (!nestedWordAutomaton.contains((Object)iPredicate3)) {
                        nestedWordAutomaton.addState(false, false, (Object)iPredicate3);
                    }
                    nestedWordAutomaton.addInternalTransition((Object)iPredicate2, (Object)((IIcfgTransition)outgoingInternalTransition.getLetter()), (Object)iPredicate3);
                    linkedList.add(iPredicate3);
                }
            }
        }
        return nestedWordAutomaton;
    }

    public NestedWordAutomaton<L, IPredicate> getAutomaton() {
        return this.mResult.getAutomaton();
    }

    public List<L> getTrace() {
        return this.mResult.getTrace();
    }

    public IPredicate[] getInterpolants() {
        return this.mResult.getInterpolants();
    }

    public IPredicateUnifier getPredicateUnifier() {
        return this.mPredicateUnifier;
    }

    public boolean isPerfectSequence() {
        return false;
    }

    public InterpolantComputationStatus getInterpolantComputationStatus() {
        return switch (this.isCorrect()) {
            case Script.LBool.UNSAT -> new InterpolantComputationStatus();
            case Script.LBool.SAT -> new InterpolantComputationStatus(InterpolantComputationStatus.ItpErrorStatus.TRACE_FEASIBLE, null);
            case Script.LBool.UNKNOWN -> throw new UnsupportedOperationException();
            default -> throw new MatchException(null, null);
        };
    }

    public Script.LBool isCorrect() {
        return this.mResult.isCorrect();
    }

    public IPredicate getPrecondition() {
        return this.mPredicateUnifier.getTruePredicate();
    }

    public IPredicate getPostcondition() {
        return this.mPredicateUnifier.getFalsePredicate();
    }

    public Map<Integer, IPredicate> getPendingContexts() {
        return Collections.emptyMap();
    }

    public boolean providesRcfgProgramExecution() {
        return this.mResult.providesExecution();
    }

    public IProgramExecution<L, Term> getRcfgProgramExecution() {
        return this.mResult.getExecution();
    }

    public IStatisticsDataProvider getStatistics() {
        return this.mResult.getStatistics();
    }

    public TraceCheckReasonUnknown getTraceCheckReasonUnknown() {
        return new TraceCheckReasonUnknown(TraceCheckReasonUnknown.Reason.SOLVER_RESPONSE_OTHER, null, TraceCheckReasonUnknown.ExceptionHandlingCategory.KNOWN_THROW);
    }

    public boolean wasTracecheckFinishedNormally() {
        return true;
    }

    public static interface IMcrResultProvider<LETTER extends IIcfgTransition<?>> {
        public McrTraceCheckResult<LETTER> getResult(Word<LETTER> var1);
    }
}

