/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.witnesschecking;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.VpAlphabet;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingCallTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssumeStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.BasicPredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IMLPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.ISLPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateUtils;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.Call;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.CodeBlock;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.GotoEdge;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.ParallelComposition;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.Return;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.SequentialComposition;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.StatementSequence;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.Summary;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.predicates.MLPredicateWithWitnessNode;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.predicates.SPredicateWithWitnessNode;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.witnesschecking.WitnessLocationMatcher;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap3;
import de.uni_freiburg.informatik.ultimate.witnessparser.graph.WitnessEdge;
import de.uni_freiburg.informatik.ultimate.witnessparser.graph.WitnessNode;
import de.uni_freiburg.informatik.ultimate.witnessparser.graph.WitnessNodeAnnotation;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class GraphMLWitnessProductAutomaton<LETTER extends IIcfgTransition<?>>
implements INwaOutgoingLetterAndTransitionProvider<LETTER, IPredicate> {
    private static final Integer STUTTERING_STEPS_LIMIT = 10;
    private final PredicateFactory mPredicateFactory;
    private final INwaOutgoingLetterAndTransitionProvider<LETTER, IPredicate> mControlFlowAutomaton;
    private final INwaOutgoingLetterAndTransitionProvider<WitnessEdge, WitnessNode> mWitnessAutomaton;
    private final NestedMap3<IPredicate, WitnessNode, Integer, ProductState> mCfg2Witness2Result = new NestedMap3();
    private final Map<IPredicate, ProductState> mResult2Product = new HashMap<IPredicate, ProductState>();
    private final IPredicate mEmptyStackState;
    private final Set<IPredicate> mInitialStates;
    private final Set<IPredicate> mFinalStates;
    private final WitnessLocationMatcher<LETTER> mWitnessLocationMatcher;
    private final LinkedHashSet<WitnessEdge> mBadWitnessEdges = new LinkedHashSet();
    private final Set<WitnessEdge> mGoodWitnessEdges = new HashSet<WitnessEdge>();

    public GraphMLWitnessProductAutomaton(IUltimateServiceProvider iUltimateServiceProvider, INwaOutgoingLetterAndTransitionProvider<LETTER, IPredicate> iNwaOutgoingLetterAndTransitionProvider, INwaOutgoingLetterAndTransitionProvider<WitnessEdge, WitnessNode> iNwaOutgoingLetterAndTransitionProvider2, PredicateFactory predicateFactory) {
        this.mWitnessLocationMatcher = new WitnessLocationMatcher<LETTER>(iUltimateServiceProvider, iNwaOutgoingLetterAndTransitionProvider, iNwaOutgoingLetterAndTransitionProvider2);
        this.mControlFlowAutomaton = iNwaOutgoingLetterAndTransitionProvider;
        this.mWitnessAutomaton = iNwaOutgoingLetterAndTransitionProvider2;
        this.mPredicateFactory = predicateFactory;
        this.mFinalStates = new HashSet<IPredicate>();
        this.mInitialStates = this.constructInitialStates();
        this.mEmptyStackState = predicateFactory.newEmptyStackPredicate();
    }

    private ProductState getOrConstructProductState(IPredicate iPredicate, WitnessNode witnessNode, Integer n) {
        ProductState productState = (ProductState)this.mCfg2Witness2Result.get((Object)iPredicate, (Object)witnessNode, (Object)n);
        if (productState == null) {
            productState = new ProductState(iPredicate, witnessNode, n);
            this.mCfg2Witness2Result.put((Object)iPredicate, (Object)witnessNode, (Object)n, (Object)productState);
            this.mResult2Product.put(productState.getResultState(), productState);
            if (this.mControlFlowAutomaton.isFinal((Object)iPredicate) && this.mWitnessAutomaton.isFinal((Object)witnessNode)) {
                this.mFinalStates.add(productState.getResultState());
            }
        }
        return productState;
    }

    public Set<LETTER> getAlphabet() {
        throw new UnsupportedOperationException("has three alphabets");
    }

    public int size() {
        return this.mResult2Product.size();
    }

    public String sizeInformation() {
        return null;
    }

    public VpAlphabet<LETTER> getVpAlphabet() {
        return this.mControlFlowAutomaton.getVpAlphabet();
    }

    public IStateFactory<IPredicate> getStateFactory() {
        return this.mControlFlowAutomaton.getStateFactory();
    }

    public IPredicate getEmptyStackState() {
        return this.mEmptyStackState;
    }

    private Set<IPredicate> constructInitialStates() {
        HashSet<IPredicate> hashSet = new HashSet<IPredicate>();
        for (IPredicate iPredicate : this.mControlFlowAutomaton.getInitialStates()) {
            for (WitnessNode witnessNode : this.mWitnessAutomaton.getInitialStates()) {
                ProductState productState = this.getOrConstructProductState(iPredicate, witnessNode, 0);
                hashSet.add(productState.getResultState());
            }
        }
        return hashSet;
    }

    public Iterable<IPredicate> getInitialStates() {
        ArrayList<IPredicate> arrayList = new ArrayList<IPredicate>();
        for (IPredicate iPredicate : this.mControlFlowAutomaton.getInitialStates()) {
            for (WitnessNode witnessNode : this.mWitnessAutomaton.getInitialStates()) {
                ProductState productState = this.getOrConstructProductState(iPredicate, witnessNode, 0);
                arrayList.add(productState.getResultState());
            }
        }
        return arrayList;
    }

    public boolean isInitial(IPredicate iPredicate) {
        return this.mInitialStates.contains(iPredicate);
    }

    public boolean isFinal(IPredicate iPredicate) {
        assert (this.mResult2Product.containsKey(iPredicate)) : "unknown state";
        return this.mFinalStates.contains(iPredicate);
    }

    public Set<LETTER> lettersInternal(IPredicate iPredicate) {
        ProductState productState = this.mResult2Product.get(iPredicate);
        return this.mControlFlowAutomaton.lettersInternal((Object)productState.getCfgAutomatonState());
    }

    public Set<LETTER> lettersCall(IPredicate iPredicate) {
        ProductState productState = this.mResult2Product.get(iPredicate);
        return this.mControlFlowAutomaton.lettersCall((Object)productState.getCfgAutomatonState());
    }

    public Set<LETTER> lettersReturn(IPredicate iPredicate, IPredicate iPredicate2) {
        ProductState productState = this.mResult2Product.get(iPredicate);
        ProductState productState2 = this.mResult2Product.get(iPredicate2);
        return this.mControlFlowAutomaton.lettersReturn((Object)productState.getCfgAutomatonState(), (Object)productState2.getCfgAutomatonState());
    }

    public Collection<OutgoingInternalTransition<LETTER, IPredicate>> constructInternalSuccessors(IPredicate iPredicate, LETTER LETTER) {
        ProductState productState = this.mResult2Product.get(iPredicate);
        ArrayList<OutgoingInternalTransition<LETTER, IPredicate>> arrayList = new ArrayList<OutgoingInternalTransition<LETTER, IPredicate>>();
        for (OutgoingInternalTransition outgoingInternalTransition : this.mControlFlowAutomaton.internalSuccessors((Object)productState.getCfgAutomatonState(), LETTER)) {
            Set<IPredicate> set = this.computeSuccessorStates(false, productState, LETTER, (IPredicate)outgoingInternalTransition.getSucc());
            for (IPredicate iPredicate2 : set) {
                arrayList.add(new OutgoingInternalTransition(LETTER, (Object)iPredicate2));
            }
        }
        return arrayList;
    }

    public Iterable<OutgoingInternalTransition<LETTER, IPredicate>> internalSuccessors(IPredicate iPredicate, LETTER LETTER) {
        return this.constructInternalSuccessors(iPredicate, LETTER);
    }

    public Iterable<OutgoingInternalTransition<LETTER, IPredicate>> internalSuccessors(IPredicate iPredicate) {
        ArrayList<OutgoingInternalTransition<LETTER, IPredicate>> arrayList = new ArrayList<OutgoingInternalTransition<LETTER, IPredicate>>();
        for (IIcfgTransition iIcfgTransition : this.lettersInternal(iPredicate)) {
            arrayList.addAll(this.constructInternalSuccessors(iPredicate, iIcfgTransition));
        }
        return arrayList;
    }

    public Collection<OutgoingCallTransition<LETTER, IPredicate>> constructCallSuccessors(IPredicate iPredicate, LETTER LETTER) {
        ProductState productState = this.mResult2Product.get(iPredicate);
        ArrayList<OutgoingCallTransition<LETTER, IPredicate>> arrayList = new ArrayList<OutgoingCallTransition<LETTER, IPredicate>>();
        for (OutgoingCallTransition outgoingCallTransition : this.mControlFlowAutomaton.callSuccessors((Object)productState.getCfgAutomatonState(), LETTER)) {
            Set<IPredicate> set = this.computeSuccessorStates(true, productState, LETTER, (IPredicate)outgoingCallTransition.getSucc());
            for (IPredicate iPredicate2 : set) {
                arrayList.add(new OutgoingCallTransition(LETTER, (Object)iPredicate2));
            }
        }
        return arrayList;
    }

    public Iterable<OutgoingCallTransition<LETTER, IPredicate>> callSuccessors(IPredicate iPredicate, LETTER LETTER) {
        return this.constructCallSuccessors(iPredicate, LETTER);
    }

    public Iterable<OutgoingCallTransition<LETTER, IPredicate>> callSuccessors(IPredicate iPredicate) {
        ArrayList<OutgoingCallTransition<LETTER, IPredicate>> arrayList = new ArrayList<OutgoingCallTransition<LETTER, IPredicate>>();
        for (IIcfgTransition iIcfgTransition : this.lettersCall(iPredicate)) {
            arrayList.addAll(this.constructCallSuccessors(iPredicate, iIcfgTransition));
        }
        return arrayList;
    }

    public Iterable<OutgoingReturnTransition<LETTER, IPredicate>> returnSuccessors(IPredicate iPredicate, IPredicate iPredicate2, LETTER LETTER) {
        return this.constructReturnSuccessors(iPredicate, iPredicate2, LETTER);
    }

    public Iterable<OutgoingReturnTransition<LETTER, IPredicate>> returnSuccessorsGivenHier(IPredicate iPredicate, IPredicate iPredicate2) {
        ArrayList<OutgoingReturnTransition<LETTER, IPredicate>> arrayList = new ArrayList<OutgoingReturnTransition<LETTER, IPredicate>>();
        for (IIcfgTransition iIcfgTransition : this.lettersReturn(iPredicate, iPredicate2)) {
            arrayList.addAll(this.constructReturnSuccessors(iPredicate, iPredicate2, iIcfgTransition));
        }
        return arrayList;
    }

    public Collection<OutgoingReturnTransition<LETTER, IPredicate>> constructReturnSuccessors(IPredicate iPredicate, IPredicate iPredicate2, LETTER LETTER) {
        ProductState productState = this.mResult2Product.get(iPredicate);
        ProductState productState2 = this.mResult2Product.get(iPredicate2);
        ArrayList<OutgoingReturnTransition<LETTER, IPredicate>> arrayList = new ArrayList<OutgoingReturnTransition<LETTER, IPredicate>>();
        for (OutgoingReturnTransition outgoingReturnTransition : this.mControlFlowAutomaton.returnSuccessors((Object)productState.getCfgAutomatonState(), (Object)productState2.getCfgAutomatonState(), LETTER)) {
            Set<IPredicate> set = this.computeSuccessorStates(false, productState, LETTER, (IPredicate)outgoingReturnTransition.getSucc());
            for (IPredicate iPredicate3 : set) {
                arrayList.add(new OutgoingReturnTransition((Object)iPredicate2, LETTER, (Object)iPredicate3));
            }
        }
        return arrayList;
    }

    private Set<IPredicate> computeSuccessorStates(boolean bl, ProductState productState, LETTER LETTER, IPredicate iPredicate) {
        LinkedHashSet<IPredicate> linkedHashSet = new LinkedHashSet<IPredicate>();
        ArrayDeque<WitnessNode> arrayDeque = new ArrayDeque<WitnessNode>();
        HashSet<WitnessNode> hashSet = new HashSet<WitnessNode>();
        arrayDeque.add(productState.getWitnessNode());
        hashSet.add(productState.getWitnessNode());
        while (!arrayDeque.isEmpty()) {
            WitnessNode witnessNode = (WitnessNode)arrayDeque.removeFirst();
            for (Object object : this.mWitnessAutomaton.internalSuccessors((Object)witnessNode)) {
                for (OutgoingInternalTransition<WitnessEdge, WitnessNode> outgoingInternalTransition : this.skipNonLETTEREdges((OutgoingInternalTransition<WitnessEdge, WitnessNode>)object, new HashSet<WitnessNode>())) {
                    if (GraphMLWitnessProductAutomaton.isSink((WitnessNode)outgoingInternalTransition.getSucc())) continue;
                    if (this.isCompatible((IIcfgTransition<?>)LETTER, (WitnessEdge)outgoingInternalTransition.getLetter())) {
                        this.mGoodWitnessEdges.add((WitnessEdge)outgoingInternalTransition.getLetter());
                        ProductState productState2 = this.getOrConstructProductState(iPredicate, (WitnessNode)outgoingInternalTransition.getSucc(), 0);
                        linkedHashSet.add(productState2.getResultState());
                        if (hashSet.contains(outgoingInternalTransition.getSucc())) continue;
                        arrayDeque.addLast((WitnessNode)outgoingInternalTransition.getSucc());
                        hashSet.add((WitnessNode)outgoingInternalTransition.getSucc());
                        continue;
                    }
                    this.mBadWitnessEdges.add((WitnessEdge)outgoingInternalTransition.getLetter());
                }
            }
        }
        if (productState.getStutteringSteps() < STUTTERING_STEPS_LIMIT && (!bl || linkedHashSet.isEmpty())) {
            Object object;
            int n = GraphMLWitnessProductAutomaton.isStateOfInitFunction(productState.mCfgAutomatonState) ? productState.getStutteringSteps() : productState.getStutteringSteps() + 1;
            object = this.getOrConstructProductState(iPredicate, productState.getWitnessNode(), n);
            linkedHashSet.add(((ProductState)object).getResultState());
        }
        return linkedHashSet;
    }

    private static boolean isStateOfInitFunction(IPredicate iPredicate) {
        return PredicateUtils.streamLocations((IPredicate)iPredicate).anyMatch(icfgLocation -> "ULTIMATE.init".equals(icfgLocation.getProcedure()));
    }

    private static boolean isSink(WitnessNode witnessNode) {
        WitnessNodeAnnotation witnessNodeAnnotation = WitnessNodeAnnotation.getAnnotation((IElement)witnessNode);
        if (witnessNodeAnnotation == null) {
            return false;
        }
        return witnessNodeAnnotation.isSink();
    }

    private Collection<OutgoingInternalTransition<WitnessEdge, WitnessNode>> skipNonLETTEREdges(OutgoingInternalTransition<WitnessEdge, WitnessNode> outgoingInternalTransition, Set<WitnessNode> set) {
        HashSet<OutgoingInternalTransition<WitnessEdge, WitnessNode>> hashSet = new HashSet<OutgoingInternalTransition<WitnessEdge, WitnessNode>>();
        if (this.isLETTEREdge((WitnessEdge)outgoingInternalTransition.getLetter())) {
            hashSet.add(outgoingInternalTransition);
        } else if (!set.contains(outgoingInternalTransition.getSucc())) {
            set.add((WitnessNode)outgoingInternalTransition.getSucc());
            for (OutgoingInternalTransition outgoingInternalTransition2 : this.mWitnessAutomaton.internalSuccessors((Object)((WitnessNode)outgoingInternalTransition.getSucc()))) {
                hashSet.addAll(this.skipNonLETTEREdges((OutgoingInternalTransition<WitnessEdge, WitnessNode>)outgoingInternalTransition2, set));
            }
        }
        return hashSet;
    }

    private boolean isLETTEREdge(WitnessEdge witnessEdge) {
        return this.mWitnessLocationMatcher.isMatchedWitnessEdge(witnessEdge);
    }

    public boolean isCompatible(IIcfgTransition<?> iIcfgTransition, WitnessEdge witnessEdge) {
        if (iIcfgTransition instanceof Call) {
            Call call = (Call)iIcfgTransition;
            return this.isCompatible(call, witnessEdge);
        }
        if (iIcfgTransition instanceof ParallelComposition) {
            ParallelComposition parallelComposition = (ParallelComposition)iIcfgTransition;
            return this.isCompatible(parallelComposition, witnessEdge);
        }
        if (iIcfgTransition instanceof Return) {
            Return return_ = (Return)iIcfgTransition;
            return this.isCompatible(return_, witnessEdge);
        }
        if (iIcfgTransition instanceof SequentialComposition) {
            SequentialComposition sequentialComposition = (SequentialComposition)iIcfgTransition;
            return this.isCompatible(sequentialComposition, witnessEdge);
        }
        if (iIcfgTransition instanceof StatementSequence) {
            StatementSequence statementSequence = (StatementSequence)iIcfgTransition;
            return this.isCompatible(statementSequence, witnessEdge);
        }
        if (iIcfgTransition instanceof Summary) {
            Summary summary = (Summary)iIcfgTransition;
            return this.isCompatible((Statement)summary.getCallStatement(), witnessEdge);
        }
        if (iIcfgTransition instanceof GotoEdge) {
            GotoEdge gotoEdge = (GotoEdge)iIcfgTransition;
            return this.isCompatible(gotoEdge, witnessEdge);
        }
        return this.isCompatible(ILocation.getAnnotation(iIcfgTransition), witnessEdge);
    }

    boolean isCompatible(GotoEdge gotoEdge, WitnessEdge witnessEdge) {
        return this.isCompatible(ILocation.getAnnotation((IElement)gotoEdge), witnessEdge);
    }

    boolean isCompatible(Call call, WitnessEdge witnessEdge) {
        return this.isCompatible((Statement)call.getCallStatement(), witnessEdge);
    }

    boolean isCompatible(ParallelComposition parallelComposition, WitnessEdge witnessEdge) {
        for (CodeBlock codeBlock : parallelComposition.getCodeBlocks()) {
            if (!this.isCompatible((IIcfgTransition<?>)codeBlock, witnessEdge)) continue;
            return true;
        }
        return false;
    }

    boolean isCompatible(Return return_, WitnessEdge witnessEdge) {
        if (this.isCompatible(ILocation.getAnnotation((IElement)return_), witnessEdge)) {
            return true;
        }
        return this.isCompatible(return_.getCorrespondingCall(), witnessEdge);
    }

    boolean isCompatible(SequentialComposition sequentialComposition, WitnessEdge witnessEdge) {
        for (CodeBlock codeBlock : sequentialComposition.getCodeBlocks()) {
            if (!this.isCompatible((IIcfgTransition<?>)codeBlock, witnessEdge)) continue;
            return true;
        }
        return false;
    }

    boolean isCompatible(StatementSequence statementSequence, WitnessEdge witnessEdge) {
        for (Statement statement : statementSequence.getStatements()) {
            if (!this.isCompatible(statement, witnessEdge)) continue;
            return true;
        }
        return false;
    }

    boolean isCompatible(Statement statement, WitnessEdge witnessEdge) {
        if (statement instanceof AssumeStatement) {
            AssumeStatement assumeStatement = (AssumeStatement)statement;
            return this.isCompatible(assumeStatement.getFormula().getLocation(), witnessEdge);
        }
        return this.isCompatible(statement.getLocation(), witnessEdge);
    }

    private boolean isCompatible(ILocation iLocation, WitnessEdge witnessEdge) {
        return this.mWitnessLocationMatcher.isCompatible(iLocation, witnessEdge);
    }

    private LinkedHashSet<WitnessEdge> getBadWitnessEdges() {
        LinkedHashSet<WitnessEdge> linkedHashSet = new LinkedHashSet<WitnessEdge>(this.mBadWitnessEdges);
        linkedHashSet.removeAll(this.mGoodWitnessEdges);
        return linkedHashSet;
    }

    public String generateBadWitnessInformation() {
        LinkedHashSet<WitnessEdge> linkedHashSet = this.getBadWitnessEdges();
        if (linkedHashSet.isEmpty()) {
            return "no bad witness edges";
        }
        WitnessEdge witnessEdge = (WitnessEdge)linkedHashSet.iterator().next();
        Set<ILocation> set = this.mWitnessLocationMatcher.getCorrespondingLocations(witnessEdge);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(linkedHashSet.size());
        stringBuilder.append(" bad witness edges. ");
        stringBuilder.append("First bad witness edge ");
        stringBuilder.append(witnessEdge);
        stringBuilder.append(" Corresponding locations: ");
        stringBuilder.append(set);
        return stringBuilder.toString();
    }

    private class ProductState {
        private final IPredicate mCfgAutomatonState;
        private final WitnessNode mWitnessNode;
        private final Integer mStutteringSteps;
        private final IPredicate mResultState;

        public ProductState(IPredicate iPredicate, WitnessNode witnessNode, Integer n) {
            this.mCfgAutomatonState = iPredicate;
            this.mWitnessNode = witnessNode;
            this.mStutteringSteps = n;
            this.mResultState = this.constructNewResultState(iPredicate, witnessNode, n);
        }

        private IPredicate constructNewResultState(IPredicate iPredicate, WitnessNode witnessNode, Integer n) {
            if (iPredicate instanceof ISLPredicate) {
                ISLPredicate iSLPredicate = (ISLPredicate)iPredicate;
                return SPredicateWithWitnessNode.construct((BasicPredicateFactory)GraphMLWitnessProductAutomaton.this.mPredicateFactory, iSLPredicate.getProgramPoint(), witnessNode, n);
            }
            return MLPredicateWithWitnessNode.construct((BasicPredicateFactory)GraphMLWitnessProductAutomaton.this.mPredicateFactory, ((IMLPredicate)iPredicate).getProgramPoints(), witnessNode, n);
        }

        public IPredicate getCfgAutomatonState() {
            return this.mCfgAutomatonState;
        }

        public WitnessNode getWitnessNode() {
            return this.mWitnessNode;
        }

        public Integer getStutteringSteps() {
            return this.mStutteringSteps;
        }

        public IPredicate getResultState() {
            return this.mResultState;
        }

        public String toString() {
            return this.mResultState.toString();
        }
    }
}

