/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.lassoranker;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.BuchiDifferenceFKV;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.BuchiIsEmpty;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.NestedLassoRun;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.NestedLassoWord;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IDeterminizeStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IEmptyStackStateFactory;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.ISLPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.SmtFreePredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.cfg2automaton.Cfg2Automaton;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.lassoranker.AbstractLassoExtractor;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.lassoranker.LassoAutomatonBuilder;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.PredicateFactoryResultChecking;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;

public class LassoExtractorBuchi<LETTER extends IIcfgTransition<?>>
extends AbstractLassoExtractor<LETTER> {
    private final IUltimateServiceProvider mServices;
    private final INwaOutgoingLetterAndTransitionProvider<LETTER, IPredicate> mCfgAutomaton;
    private INwaOutgoingLetterAndTransitionProvider<LETTER, IPredicate> mLassoAutomaton;
    private final PredicateFactoryResultChecking mPredicateFactoryRc;
    private final CfgSmtToolkit mCsToolkit;
    private final PredicateFactory mPredicateFactory;
    private final ILogger mLogger;

    public LassoExtractorBuchi(IUltimateServiceProvider iUltimateServiceProvider, IIcfg<IcfgLocation> iIcfg, CfgSmtToolkit cfgSmtToolkit, PredicateFactory predicateFactory, ILogger iLogger) throws AutomataLibraryException {
        this.mServices = Objects.requireNonNull(iUltimateServiceProvider);
        this.mLogger = Objects.requireNonNull(iLogger);
        this.mCsToolkit = Objects.requireNonNull(cfgSmtToolkit);
        this.mPredicateFactory = Objects.requireNonNull(predicateFactory);
        this.mPredicateFactoryRc = new PredicateFactoryResultChecking((SmtFreePredicateFactory)this.mPredicateFactory);
        this.mCfgAutomaton = this.constructCfgAutomaton(iIcfg, this.mCsToolkit);
        NestedLassoRun nestedLassoRun = new BuchiIsEmpty(new AutomataLibraryServices(this.mServices), this.mCfgAutomaton).getAcceptingNestedLassoRun();
        if (nestedLassoRun == null) {
            this.mLassoFound = false;
            this.mSomeNoneForErrorReport = LassoExtractorBuchi.extractSomeNodeForErrorReport(iIcfg);
        } else {
            NestedLassoWord nestedLassoWord = nestedLassoRun.getNestedLassoWord();
            this.mLassoAutomaton = new LassoAutomatonBuilder(this.mCfgAutomaton.getVpAlphabet(), (IEmptyStackStateFactory<IPredicate>)this.mPredicateFactoryRc, this.mPredicateFactory, nestedLassoWord.getStem(), nestedLassoWord.getLoop(), this.mServices).getResult();
            INestedWordAutomaton iNestedWordAutomaton = new BuchiDifferenceFKV(new AutomataLibraryServices(this.mServices), (IDeterminizeStateFactory)this.mPredicateFactoryRc, this.mCfgAutomaton, this.mLassoAutomaton).getResult();
            boolean bl = new BuchiIsEmpty(new AutomataLibraryServices(this.mServices), (INwaOutgoingLetterAndTransitionProvider)iNestedWordAutomaton).getResult();
            if (bl) {
                this.mLassoFound = true;
                this.mHonda = LassoExtractorBuchi.extractHonda(nestedLassoRun);
                this.mStem = nestedLassoRun.getNestedLassoWord().getStem();
                this.mLoop = nestedLassoRun.getNestedLassoWord().getLoop();
            } else {
                this.mLassoFound = false;
                this.mSomeNoneForErrorReport = LassoExtractorBuchi.extractSomeNodeForErrorReport(iIcfg);
            }
        }
    }

    private static IcfgLocation extractSomeNodeForErrorReport(IIcfg<?> iIcfg) {
        return (IcfgLocation)iIcfg.getProcedureEntryNodes().entrySet().iterator().next().getValue();
    }

    private static IcfgLocation extractHonda(NestedLassoRun<?, IPredicate> nestedLassoRun) {
        return ((ISLPredicate)nestedLassoRun.getLoop().getStateAtPosition(0)).getProgramPoint();
    }

    private INwaOutgoingLetterAndTransitionProvider<LETTER, IPredicate> constructCfgAutomaton(IIcfg<IcfgLocation> iIcfg, CfgSmtToolkit cfgSmtToolkit) {
        HashSet hashSet = new HashSet();
        for (Map map : iIcfg.getProgramPoints().values()) {
            hashSet.addAll(map.values());
        }
        return Cfg2Automaton.constructAutomatonWithSPredicates((IUltimateServiceProvider)this.mServices, iIcfg, (IEmptyStackStateFactory)this.mPredicateFactoryRc, hashSet, (boolean)true, (PredicateFactory)this.mPredicateFactory);
    }
}

