/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker.termination;

import de.uni_freiburg.informatik.ultimate.lassoranker.termination.SupportingInvariant;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.rankingfunctions.RankingFunction;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;

public class TerminationArgument
implements Serializable {
    private static final long serialVersionUID = 3480670605705583627L;
    private final RankingFunction mranking_function;
    private final Collection<SupportingInvariant> msupporting_invariants;
    private final Set<Term> mArrayIndexSupportingInvariants;

    public TerminationArgument(RankingFunction rankingFunction, Collection<SupportingInvariant> collection, Set<Term> set) {
        assert (rankingFunction != null);
        this.mranking_function = rankingFunction;
        assert (collection != null);
        this.msupporting_invariants = new ArrayList<SupportingInvariant>();
        for (SupportingInvariant supportingInvariant : collection) {
            if (supportingInvariant.isTrue()) continue;
            this.msupporting_invariants.add(supportingInvariant);
        }
        this.mArrayIndexSupportingInvariants = set;
    }

    public RankingFunction getRankingFunction() {
        return this.mranking_function;
    }

    public Collection<SupportingInvariant> getSupportingInvariants() {
        return Collections.unmodifiableCollection(this.msupporting_invariants);
    }

    public Collection<Term> getArrayIndexSupportingInvariants() {
        return Collections.unmodifiableCollection(this.mArrayIndexSupportingInvariants);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Termination argument consisting of:\n");
        stringBuilder.append("Ranking function ");
        stringBuilder.append(this.mranking_function);
        stringBuilder.append("\n");
        stringBuilder.append("Supporting invariants ");
        stringBuilder.append(this.msupporting_invariants);
        return stringBuilder.toString();
    }
}

