/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures.poset;

import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.poset.CanonicalPartialComparatorForMaps;
import de.uni_freiburg.informatik.ultimate.util.datastructures.poset.ILattice;
import de.uni_freiburg.informatik.ultimate.util.datastructures.poset.IPartialComparator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class CanonicalLatticeForMaps<K, V>
extends CanonicalPartialComparatorForMaps<K, V>
implements ILattice<Map<K, V>> {
    private final ILattice<V> mLattice;
    private final Set<K> mKeyDomain;
    private final Map<K, V> mTop;

    public CanonicalLatticeForMaps(ILattice<V> iLattice) {
        super(iLattice);
        this.mLattice = iLattice;
        this.mKeyDomain = null;
        this.mTop = null;
    }

    public CanonicalLatticeForMaps(ILattice<V> iLattice, Set<K> set) {
        super(iLattice);
        this.mLattice = iLattice;
        this.mKeyDomain = Objects.requireNonNull(set);
        Object v = iLattice.getTop();
        this.mTop = this.mKeyDomain.stream().collect(Collectors.toMap(Function.identity(), object2 -> v));
    }

    @Override
    public IPartialComparator.ComparisonResult compare(Map<K, V> map, Map<K, V> map2) {
        assert (this.checkDomain(map));
        assert (this.checkDomain(map2));
        return super.compare(map, map2);
    }

    @Override
    public Map<K, V> getBottom() {
        return Collections.emptyMap();
    }

    @Override
    public Map<K, V> getTop() {
        if (this.mTop == null) {
            throw new UnsupportedOperationException("Map lattice has no top element unless key domain is finite");
        }
        return this.mTop;
    }

    @Override
    public Map<K, V> supremum(Map<K, V> map, Map<K, V> map2) {
        assert (this.checkDomain(map));
        assert (this.checkDomain(map2));
        HashMap<K, V> hashMap = new HashMap<K, V>();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            V v = map2.containsKey(entry.getKey()) ? this.mLattice.supremum(entry.getValue(), map2.get(entry.getKey())) : entry.getValue();
            hashMap.put(entry.getKey(), v);
        }
        for (Map.Entry<K, V> entry : map2.entrySet()) {
            if (hashMap.containsKey(entry.getKey())) continue;
            hashMap.put(entry.getKey(), entry.getValue());
        }
        return hashMap;
    }

    @Override
    public Map<K, V> infimum(Map<K, V> map, Map<K, V> map2) {
        Map<K, V> map3;
        Map<K, V> map4;
        assert (this.checkDomain(map));
        assert (this.checkDomain(map2));
        if (map.size() < map2.size()) {
            map4 = map;
            map3 = map2;
        } else {
            map4 = map2;
            map3 = map;
        }
        HashMap<K, V> hashMap = new HashMap<K, V>();
        for (Map.Entry<K, V> entry : map4.entrySet()) {
            if (!map3.containsKey(entry.getKey())) continue;
            V v = this.mLattice.infimum(entry.getValue(), map3.get(entry.getKey()));
            hashMap.put(entry.getKey(), v);
        }
        return hashMap;
    }

    private boolean checkDomain(Map<K, V> map) {
        boolean bl;
        boolean bl2 = bl = this.mKeyDomain == null || this.mKeyDomain.containsAll(map.keySet());
        assert (bl) : "map with unexpected keys: " + String.valueOf(DataStructureUtils.difference(map.keySet(), this.mKeyDomain));
        return bl;
    }
}

