/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.treeautomizer.graph;

import de.uni_freiburg.informatik.ultimate.automata.tree.TreeAutomatonRule;
import de.uni_freiburg.informatik.ultimate.lib.chc.HcHeadVar;
import de.uni_freiburg.informatik.ultimate.lib.chc.HcSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.chc.HornClause;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.IncrementalPlicationChecker;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.PureSubstitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.QuotedObject;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class HCHoareTripleChecker {
    private final PredicateUnifier mPredicateUnifier;
    private final ManagedScript mManagedScript;
    private final HcSymbolTable mSymbolTable;

    public HCHoareTripleChecker(PredicateUnifier predicateUnifier, ManagedScript managedScript, HcSymbolTable hcSymbolTable) {
        this.mPredicateUnifier = predicateUnifier;
        this.mManagedScript = managedScript;
        this.mSymbolTable = hcSymbolTable;
    }

    private void assertPreconditions(List<IPredicate> list, HornClause hornClause) {
        this.mManagedScript.echo((Object)this, new QuotedObject("starting Hoare triple check"));
        int n = 0;
        while (n < list.size()) {
            TermVariable termVariable;
            this.mManagedScript.echo((Object)this, new QuotedObject("asserting body component nr " + n + ":"));
            HashMap<TermVariable, Term> hashMap = new HashMap<TermVariable, Term>();
            IPredicate iPredicate = list.get(n);
            TermVariable[] termVariableArray = iPredicate.getFormula().getFreeVars();
            int n2 = termVariableArray.length;
            int n3 = 0;
            while (n3 < n2) {
                termVariable = termVariableArray[n3];
                HcHeadVar hcHeadVar = (HcHeadVar)this.mSymbolTable.getProgramVar(termVariable);
                Term term = (Term)((List)hornClause.getBodyPredToArgs().get(n)).get(hcHeadVar.getIndex());
                hashMap.put(hcHeadVar.getTermVariable(), term);
                ++n3;
            }
            termVariable = PureSubstitution.apply((ManagedScript)this.mManagedScript, hashMap, (Term)iPredicate.getFormula());
            Term term = this.close((Term)termVariable);
            this.mManagedScript.assertTerm((Object)this, term);
            ++n;
        }
    }

    public IncrementalPlicationChecker.Validity check(List<IPredicate> list, HornClause hornClause, IPredicate iPredicate) {
        List<Object> list2;
        if (hornClause.getBodyPredicates().size() == 0) {
            assert (list.isEmpty() || list.size() == 1 && list.get(0).getClosedFormula().toStringDirect().equals("true"));
            list2 = Collections.emptyList();
        } else {
            list2 = list;
        }
        this.mManagedScript.lock((Object)this);
        this.mManagedScript.push((Object)this, 1);
        this.assertPreconditions(list2, hornClause);
        this.mManagedScript.echo((Object)this, new QuotedObject("asserting horn clause constraint: "));
        Term term = this.close(hornClause.getConstraintFormula());
        this.mManagedScript.assertTerm((Object)this, term);
        this.mManagedScript.echo((Object)this, new QuotedObject("asserting negated post condition: "));
        Term term2 = SmtUtils.not((Script)this.mManagedScript.getScript(), (Term)iPredicate.getClosedFormula());
        this.mManagedScript.assertTerm((Object)this, term2);
        Script.LBool lBool = this.mManagedScript.checkSat((Object)this);
        this.mManagedScript.echo((Object)this, new QuotedObject("finishing Hoare triple check"));
        this.mManagedScript.pop((Object)this, 1);
        this.mManagedScript.unlock((Object)this);
        return IncrementalPlicationChecker.convertLBool2Validity((Script.LBool)lBool);
    }

    private Term close(Term term) {
        HashMap<TermVariable, ApplicationTerm> hashMap = new HashMap<TermVariable, ApplicationTerm>();
        TermVariable[] termVariableArray = term.getFreeVars();
        int n = termVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            TermVariable termVariable = termVariableArray[n2];
            IProgramVar iProgramVar = this.mSymbolTable.getProgramVar(termVariable);
            hashMap.put(termVariable, iProgramVar.getDefaultConstant());
            ++n2;
        }
        return PureSubstitution.apply((ManagedScript)this.mManagedScript, hashMap, (Term)term);
    }

    public IncrementalPlicationChecker.Validity check(TreeAutomatonRule<HornClause, IPredicate> treeAutomatonRule) {
        return this.check(treeAutomatonRule.getSource(), (HornClause)treeAutomatonRule.getLetter(), (IPredicate)treeAutomatonRule.getDest());
    }

    public IPredicate getFalsePredicate() {
        return this.mPredicateUnifier.getFalsePredicate();
    }
}

