/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.XjunctPartialQuantifierElimination;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class XnfPlr
extends XjunctPartialQuantifierElimination {
    public XnfPlr(ManagedScript managedScript, IUltimateServiceProvider iUltimateServiceProvider) {
        super(managedScript, iUltimateServiceProvider);
    }

    @Override
    public String getName() {
        return "positive literal removal";
    }

    @Override
    public String getAcronym() {
        return "PLR";
    }

    @Override
    public boolean resultIsXjunction() {
        return true;
    }

    @Override
    public Term[] tryToEliminate(int n, Term[] termArray, Set<TermVariable> set) {
        TermVariable termVariable22;
        if (n == 1) {
            return termArray;
        }
        ArrayList<TermVariable> arrayList = new ArrayList<TermVariable>(set.size());
        for (TermVariable termVariable22 : set) {
            if (!SmtSortUtils.isBoolSort(termVariable22.getSort())) continue;
            arrayList.add(termVariable22);
        }
        termVariable22 = new HashMap();
        Term term = this.mScript.term("true", new Term[0]);
        Term term2 = this.mScript.term("false", new Term[0]);
        block1: for (TermVariable termArray22 : arrayList) {
            Term[] termArray2 = termArray;
            int n2 = termArray.length;
            int n3 = 0;
            while (n3 < n2) {
                Term term3 = termArray2[n3];
                if (term3 instanceof ApplicationTerm) {
                    ApplicationTerm applicationTerm = (ApplicationTerm)term3;
                    if (applicationTerm.getFunction().getName().equals("not") && applicationTerm.getParameters()[0].equals(termArray22)) {
                        if (this.mLogger.isDebugEnabled()) {
                            this.mLogger.debug((Object)String.format("eliminated quantifier via %s for %s", this.getAcronym(), termArray22));
                        }
                        termVariable22.put(termArray22, term2);
                        continue block1;
                    }
                } else if (term3.equals(termArray22)) {
                    termVariable22.put(termArray22, term);
                    if (!this.mLogger.isDebugEnabled()) continue block1;
                    this.mLogger.debug((Object)String.format("eliminated quantifier via %s for %s", this.getAcronym(), termArray22));
                    continue block1;
                }
                ++n3;
            }
        }
        if (termVariable22.isEmpty()) {
            return termArray;
        }
        Term[] termArray3 = (Term[])termArray.clone();
        int n4 = 0;
        while (n4 < termArray.length) {
            termArray3[n4] = Substitution.apply(this.mMgdScript, (Map<? extends Term, ? extends Term>)termVariable22, termArray[n4]);
            ++n4;
        }
        return termArray3;
    }
}

