/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie;

import de.uni_freiburg.informatik.ultimate.boogie.BitvectorFactory;
import de.uni_freiburg.informatik.ultimate.boogie.DeclarationInformation;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ArrayAccessExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ArrayStoreExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Attribute;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BinaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BitVectorAccessExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BitvecLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BoogieASTNode;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BooleanLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.FunctionApplication;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IdentifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IfThenElseExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IntegerLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.QuantifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.RealLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.StringLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.StructAccessExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.StructConstructor;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Trigger;
import de.uni_freiburg.informatik.ultimate.boogie.ast.UnaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VarList;
import de.uni_freiburg.informatik.ultimate.boogie.ast.WildcardExpression;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.IBoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.Boogie2SMT;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.Boogie2SmtSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.IOperationTranslator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.TypeSortTranslator;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.BitvectorConstant;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ScopedHashMap;
import java.lang.runtime.SwitchBootstraps;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class Expression2Term {
    private static final String ERROR_UNSUPPORTED_EXPRESSION = "Unsupported expression ";
    private static final String OVERAPPROXIMATION = "overapproximation";
    private final IUltimateServiceProvider mServices;
    private final Script mScript;
    private final TypeSortTranslator mTypeSortTranslator;
    private final IOperationTranslator mOperationTranslator;
    private final Boogie2SmtSymbolTable mBoogie2SmtSymbolTable;
    private final ManagedScript mVariableManager;
    private final boolean mOverapproximateFunctions = false;
    private final ScopedHashMap<String, TermVariable> mQuantifiedVariables = new ScopedHashMap();
    private IIdentifierTranslator[] mSmtIdentifierProviders;
    private Map<String, ILocation> mOverapproximations;
    private Collection<TermVariable> mAuxVars;
    private int mOldContextScopeDepth = 0;

    public Expression2Term(IUltimateServiceProvider iUltimateServiceProvider, Script script, TypeSortTranslator typeSortTranslator, Boogie2SmtSymbolTable boogie2SmtSymbolTable, IOperationTranslator iOperationTranslator, ManagedScript managedScript) {
        this.mServices = iUltimateServiceProvider;
        this.mScript = script;
        this.mTypeSortTranslator = typeSortTranslator;
        this.mBoogie2SmtSymbolTable = boogie2SmtSymbolTable;
        this.mOperationTranslator = iOperationTranslator;
        this.mVariableManager = managedScript;
    }

    public SingleTermResult translateToTerm(IIdentifierTranslator[] iIdentifierTranslatorArray, Expression expression) {
        assert (this.mSmtIdentifierProviders == null) : this.getClass().getSimpleName() + " in use";
        assert (this.mQuantifiedVariables.isEmpty()) : this.getClass().getSimpleName() + " in use";
        assert (this.mOverapproximations == null) : this.getClass().getSimpleName() + " in use";
        assert (this.mAuxVars == null) : this.getClass().getSimpleName() + " in use";
        this.mSmtIdentifierProviders = iIdentifierTranslatorArray;
        this.mAuxVars = new ArrayList<TermVariable>();
        this.mOverapproximations = new HashMap<String, ILocation>();
        Term term = this.translate(expression);
        SingleTermResult singleTermResult = new SingleTermResult(this.mOverapproximations, this.mAuxVars, term);
        this.mSmtIdentifierProviders = null;
        this.mAuxVars = null;
        this.mOverapproximations = null;
        return singleTermResult;
    }

    public MultiTermResult translateToTerms(IIdentifierTranslator[] iIdentifierTranslatorArray, Expression[] expressionArray) {
        assert (this.mSmtIdentifierProviders == null) : this.getClass().getSimpleName() + " in use";
        assert (this.mQuantifiedVariables.isEmpty()) : this.getClass().getSimpleName() + " in use";
        assert (this.mOverapproximations == null) : this.getClass().getSimpleName() + " in use";
        assert (this.mAuxVars == null) : this.getClass().getSimpleName() + " in use";
        this.mSmtIdentifierProviders = iIdentifierTranslatorArray;
        this.mAuxVars = new ArrayList<TermVariable>();
        this.mOverapproximations = new HashMap<String, ILocation>();
        Term[] termArray = new Term[expressionArray.length];
        int n = 0;
        while (n < expressionArray.length) {
            termArray[n] = this.translate(expressionArray[n]);
            ++n;
        }
        MultiTermResult multiTermResult = new MultiTermResult(this.mOverapproximations, this.mAuxVars, termArray);
        this.mSmtIdentifierProviders = null;
        this.mAuxVars = null;
        this.mOverapproximations = null;
        return multiTermResult;
    }

    private Term getSmtIdentifier(String string, DeclarationInformation declarationInformation, boolean bl, BoogieASTNode boogieASTNode) {
        assert (declarationInformation != null) : "no declaration information";
        if (this.mQuantifiedVariables.containsKey((Object)string)) {
            return (Term)this.mQuantifiedVariables.get((Object)string);
        }
        IIdentifierTranslator[] iIdentifierTranslatorArray = this.mSmtIdentifierProviders;
        int n = this.mSmtIdentifierProviders.length;
        int n2 = 0;
        while (n2 < n) {
            IIdentifierTranslator iIdentifierTranslator = iIdentifierTranslatorArray[n2];
            Term term = iIdentifierTranslator.getSmtIdentifier(string, declarationInformation, bl, boogieASTNode);
            if (term != null) {
                return term;
            }
            ++n2;
        }
        throw new AssertionError((Object)("found no translation for id " + string));
    }

    private boolean isOldContext() {
        return this.mOldContextScopeDepth > 0;
    }

    private Term translate(Expression expression) {
        Expression expression2 = expression;
        Objects.requireNonNull(expression2);
        Expression expression3 = expression2;
        Term term = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BitvecLiteral.class, BooleanLiteral.class, IntegerLiteral.class, RealLiteral.class, ArrayAccessExpression.class, ArrayStoreExpression.class, BinaryExpression.class, BitVectorAccessExpression.class, FunctionApplication.class, IdentifierExpression.class, IfThenElseExpression.class, QuantifierExpression.class, UnaryExpression.class, WildcardExpression.class, StructAccessExpression.class, StringLiteral.class, StructConstructor.class}, (Object)expression3, 0)) {
            case 0 -> {
                BitvecLiteral var4_3 = (BitvecLiteral)expression3;
                yield this.mOperationTranslator.bitvecTranslation(var4_3);
            }
            case 1 -> {
                BooleanLiteral var5_4 = (BooleanLiteral)expression3;
                yield this.mOperationTranslator.booleanTranslation(var5_4);
            }
            case 2 -> {
                IntegerLiteral var6_5 = (IntegerLiteral)expression3;
                yield this.mOperationTranslator.integerTranslation(var6_5);
            }
            case 3 -> {
                RealLiteral var7_6 = (RealLiteral)expression3;
                yield this.mOperationTranslator.realTranslation(var7_6);
            }
            case 4 -> {
                ArrayAccessExpression var8_7 = (ArrayAccessExpression)expression3;
                yield this.translateArrayAccess(var8_7);
            }
            case 5 -> {
                ArrayStoreExpression var9_8 = (ArrayStoreExpression)expression3;
                yield this.translateArrayStore(var9_8);
            }
            case 6 -> {
                BinaryExpression var10_9 = (BinaryExpression)expression3;
                yield this.translateBinaryExpression(var10_9);
            }
            case 7 -> {
                BitVectorAccessExpression var11_10 = (BitVectorAccessExpression)expression3;
                yield this.translateBitVectorAccess(var11_10);
            }
            case 8 -> {
                FunctionApplication var12_11 = (FunctionApplication)expression3;
                yield this.translateFunctionApplication(var12_11);
            }
            case 9 -> {
                IdentifierExpression var13_12 = (IdentifierExpression)expression3;
                yield this.getSmtIdentifier(var13_12.getIdentifier(), var13_12.getDeclarationInformation(), this.isOldContext(), (BoogieASTNode)expression);
            }
            case 10 -> {
                IfThenElseExpression var14_13 = (IfThenElseExpression)expression3;
                yield this.translateIfThenElse(var14_13);
            }
            case 11 -> {
                QuantifierExpression var15_14 = (QuantifierExpression)expression3;
                yield this.translateQuantifierExpression(var15_14);
            }
            case 12 -> {
                UnaryExpression var16_15 = (UnaryExpression)expression3;
                yield this.translateUnaryExpression(var16_15);
            }
            case 13 -> {
                WildcardExpression var17_16 = (WildcardExpression)expression3;
                throw new AssertionError((Object)(ERROR_UNSUPPORTED_EXPRESSION + String.valueOf(expression)));
            }
            case 14 -> {
                StructAccessExpression var18_17 = (StructAccessExpression)expression3;
                throw new AssertionError((Object)(ERROR_UNSUPPORTED_EXPRESSION + String.valueOf(expression)));
            }
            case 15 -> {
                StringLiteral var19_18 = (StringLiteral)expression3;
                throw new AssertionError((Object)(ERROR_UNSUPPORTED_EXPRESSION + String.valueOf(expression)));
            }
            case 16 -> {
                StructConstructor var20_19 = (StructConstructor)expression3;
                throw new AssertionError((Object)(ERROR_UNSUPPORTED_EXPRESSION + String.valueOf(expression)));
            }
            default -> throw new MatchException(null, null);
        };
        assert (term != null) : "failed to translate " + expression.getClass().getSimpleName() + ": " + String.valueOf(expression);
        assert (Expression2Term.resultContainsNoNull(term));
        return term;
    }

    private Term translateArrayAccess(ArrayAccessExpression arrayAccessExpression) {
        Term term = this.translate(arrayAccessExpression.getArray());
        Expression[] expressionArray = arrayAccessExpression.getIndices();
        int n = expressionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Expression expression = expressionArray[n2];
            Term term2 = this.translate(expression);
            term = SmtUtils.select((Script)this.mScript, (Term)term, (Term)term2);
            ++n2;
        }
        return term;
    }

    private Term translateArrayStore(ArrayStoreExpression arrayStoreExpression) {
        Expression[] expressionArray = arrayStoreExpression.getIndices();
        assert (expressionArray.length > 0);
        Term[] termArray = new Term[expressionArray.length];
        Term[] termArray2 = new Term[expressionArray.length];
        termArray[0] = this.translate(arrayStoreExpression.getArray());
        int n = 0;
        while (n < expressionArray.length - 1) {
            termArray2[n] = this.translate(expressionArray[n]);
            termArray[n + 1] = SmtUtils.select((Script)this.mScript, (Term)termArray[n], (Term)termArray2[n]);
            ++n;
        }
        termArray2[expressionArray.length - 1] = this.translate(expressionArray[expressionArray.length - 1]);
        Term term = this.translate(arrayStoreExpression.getValue());
        int n2 = expressionArray.length - 1;
        while (n2 >= 0) {
            term = SmtUtils.store((Script)this.mScript, (Term)termArray[n2], (Term)termArray2[n2], (Term)term);
            --n2;
        }
        return term;
    }

    private Term translateBinaryExpression(BinaryExpression binaryExpression) {
        BinaryExpression.Operator operator = binaryExpression.getOperator();
        if (operator == BinaryExpression.Operator.COMPNEQ) {
            String string = this.mOperationTranslator.opTranslation(BinaryExpression.Operator.COMPEQ, binaryExpression.getLeft().getType(), binaryExpression.getRight().getType());
            String string2 = this.mOperationTranslator.opTranslation(UnaryExpression.Operator.LOGICNEG, (IBoogieType)BoogieType.TYPE_BOOL);
            return SmtUtils.unfTerm((Script)this.mScript, (String)string2, null, null, (Term[])new Term[]{SmtUtils.unfTerm((Script)this.mScript, (String)string, null, null, (Term[])new Term[]{this.translate(binaryExpression.getLeft()), this.translate(binaryExpression.getRight())})});
        }
        String string = this.mOperationTranslator.opTranslation(operator, binaryExpression.getLeft().getType(), binaryExpression.getRight().getType());
        return SmtUtils.unfTerm((Script)this.mScript, (String)string, null, null, (Term[])new Term[]{this.translate(binaryExpression.getLeft()), this.translate(binaryExpression.getRight())});
    }

    private Term translateBitVectorAccess(BitVectorAccessExpression bitVectorAccessExpression) {
        BigInteger[] bigIntegerArray = new BigInteger[]{BigInteger.valueOf((long)bitVectorAccessExpression.getEnd() - 1L), BigInteger.valueOf(bitVectorAccessExpression.getStart())};
        return this.mScript.term("extract", SmtUtils.toStringArray((BigInteger[])bigIntegerArray), null, new Term[]{this.translate(bitVectorAccessExpression.getBitvec())});
    }

    private Term translateFunctionApplication(FunctionApplication functionApplication) {
        Map<String, Expression[]> map = this.mBoogie2SmtSymbolTable.getAttributes(functionApplication.getIdentifier());
        String string = Boogie2SmtSymbolTable.checkForAttributeDefinedIdentifier(map, OVERAPPROXIMATION);
        if (string != null) {
            Sort sort = this.mTypeSortTranslator.getSort(functionApplication.getType(), (BoogieASTNode)functionApplication);
            TermVariable termVariable = this.mVariableManager.constructFreshTermVariable(functionApplication.getIdentifier(), sort);
            this.mAuxVars.add(termVariable);
            this.mOverapproximations.put(string, functionApplication.getLocation());
            return termVariable;
        }
        IBoogieType[] iBoogieTypeArray = new IBoogieType[functionApplication.getArguments().length];
        int n = 0;
        while (n < functionApplication.getArguments().length) {
            iBoogieTypeArray[n] = functionApplication.getArguments()[n].getType();
            ++n;
        }
        Sort[] sortArray = new Sort[functionApplication.getArguments().length];
        int n2 = 0;
        while (n2 < functionApplication.getArguments().length) {
            sortArray[n2] = this.mTypeSortTranslator.getSort(functionApplication.getArguments()[n2].getType(), (BoogieASTNode)functionApplication);
            ++n2;
        }
        Term[] termArray = new Term[functionApplication.getArguments().length];
        int n3 = 0;
        while (n3 < functionApplication.getArguments().length) {
            termArray[n3] = this.translate(functionApplication.getArguments()[n3]);
            ++n3;
        }
        String string2 = this.mOperationTranslator.funcApplication(functionApplication.getIdentifier(), iBoogieTypeArray);
        if (string2 == null) {
            throw new IllegalArgumentException("unknown function" + functionApplication.getIdentifier());
        }
        String[] stringArray = Boogie2SmtSymbolTable.checkForIndices(map);
        BitvectorConstant.BvOp bvOp = BitvectorFactory.getSupportedBitvectorOperation((String)string2);
        if (bvOp == null) {
            return this.mScript.term(string2, stringArray, null, termArray);
        }
        return SmtUtils.unfTerm((Script)this.mScript, (String)string2, (String[])stringArray, null, (Term[])termArray);
    }

    private Term translateIfThenElse(IfThenElseExpression ifThenElseExpression) {
        Term term = this.translate(ifThenElseExpression.getCondition());
        Term term2 = this.translate(ifThenElseExpression.getThenPart());
        Term term3 = this.translate(ifThenElseExpression.getElsePart());
        return SmtUtils.ite((Script)this.mScript, (Term)term, (Term)term2, (Term)term3);
    }

    private Term translateQuantifierExpression(QuantifierExpression quantifierExpression) {
        String string;
        Object object;
        int n;
        IBoogieType iBoogieType;
        VarList varList;
        String[] stringArray = quantifierExpression.getTypeParams();
        VarList[] varListArray = quantifierExpression.getParameters();
        int n2 = stringArray.length;
        VarList[] varListArray2 = varListArray;
        int n3 = varListArray.length;
        int n4 = 0;
        while (n4 < n3) {
            varList = varListArray2[n4];
            n2 += varList.getIdentifiers().length;
            ++n4;
        }
        varList = new TermVariable[n2];
        n4 = 0;
        this.mQuantifiedVariables.beginScope();
        VarList[] varListArray3 = varListArray;
        int n5 = varListArray.length;
        int n6 = 0;
        while (n6 < n5) {
            VarList varList2 = varListArray3[n6];
            iBoogieType = varList2.getType().getBoogieType();
            Sort sort = this.mTypeSortTranslator.getSort(iBoogieType, (BoogieASTNode)quantifierExpression);
            n = 0;
            while (n < varList2.getIdentifiers().length) {
                object = varList2.getIdentifiers()[n];
                string = "q" + Boogie2SMT.quoteId(varList2.getIdentifiers()[n]);
                varList[n4] = this.mScript.variable(string, sort);
                this.mQuantifiedVariables.put(object, (Object)varList[n4]);
                ++n4;
                ++n;
            }
            ++n6;
        }
        Term term = this.translate(quantifierExpression.getSubformula());
        n6 = (int)Arrays.stream(quantifierExpression.getAttributes()).filter(Trigger.class::isInstance).count();
        varListArray3 = new Term[n6][];
        n4 = 0;
        object = quantifierExpression.getAttributes();
        n = ((Attribute[])object).length;
        int n7 = 0;
        while (n7 < n) {
            iBoogieType = object[n7];
            if (iBoogieType instanceof Trigger) {
                string = (Trigger)iBoogieType;
                Expression[] expressionArray = string.getTriggers();
                Term[] termArray = new Term[expressionArray.length];
                int n8 = 0;
                while (n8 < expressionArray.length) {
                    Term term2;
                    termArray[n8] = term2 = this.translate(expressionArray[n8]);
                    ++n8;
                }
                varListArray3[n4] = termArray;
                ++n4;
            }
            ++n7;
        }
        this.mQuantifiedVariables.endScope();
        try {
            int n9 = quantifierExpression.isUniversal() ? 1 : 0;
            return this.mScript.quantifier(n9, (TermVariable[])varList, term, (Term[][])varListArray3);
        }
        catch (SMTLIBException sMTLIBException) {
            if ("Cannot create quantifier in quantifier-free logic".equals(sMTLIBException.getMessage())) {
                Boogie2SMT.reportUnsupportedSyntax((BoogieASTNode)quantifierExpression, "Setting does not support quantifiers", this.mServices);
            }
            throw sMTLIBException;
        }
    }

    private Term translateUnaryExpression(UnaryExpression unaryExpression) {
        UnaryExpression.Operator operator = unaryExpression.getOperator();
        if (operator == UnaryExpression.Operator.OLD) {
            ++this.mOldContextScopeDepth;
            Term term = this.translate(unaryExpression.getExpr());
            --this.mOldContextScopeDepth;
            return term;
        }
        String string = this.mOperationTranslator.opTranslation(operator, unaryExpression.getExpr().getType());
        return SmtUtils.unfTerm((Script)this.mScript, (String)string, null, null, (Term[])new Term[]{this.translate(unaryExpression.getExpr())});
    }

    private static boolean resultContainsNoNull(Term term) {
        return term.toString() != null;
    }

    @FunctionalInterface
    public static interface IIdentifierTranslator {
        public Term getSmtIdentifier(String var1, DeclarationInformation var2, boolean var3, BoogieASTNode var4);
    }

    public record MultiTermResult(Map<String, ILocation> overapproximations, Collection<TermVariable> auxiliaryVars, Term[] terms) {
    }

    public record SingleTermResult(Map<String, ILocation> overapproximations, Collection<TermVariable> auxiliaryVars, Term term) {
    }
}

