/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.ModifiableGlobalsTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.ICallAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.HoareTripleCheckerStatisticsGenerator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.SdHoareTripleCheckHelper;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateCoverageChecker;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.IncrementalPlicationChecker;

class CallCheckHelper
extends SdHoareTripleCheckHelper<ICallAction> {
    private static final String PRE_HIER_ERROR = "Unexpected hierarchical precondition for call action";

    CallCheckHelper(IPredicateCoverageChecker iPredicateCoverageChecker, IPredicate iPredicate, IPredicate iPredicate2, HoareTripleCheckerStatisticsGenerator hoareTripleCheckerStatisticsGenerator, ModifiableGlobalsTable modifiableGlobalsTable) {
        super(iPredicateCoverageChecker, iPredicate, iPredicate2, hoareTripleCheckerStatisticsGenerator, modifiableGlobalsTable);
    }

    @Override
    public IncrementalPlicationChecker.Validity sdecToFalse(IPredicate iPredicate, IPredicate iPredicate2, ICallAction iCallAction) {
        assert (iPredicate2 == null) : "Unexpected hierarchical precondition for call action";
        if (this.containsConflictingNonModifiableOldVars(iCallAction.getPrecedingProcedure(), iPredicate)) {
            return null;
        }
        this.mStatistics.getSDtfsCounter().incCa();
        return IncrementalPlicationChecker.Validity.INVALID;
    }

    @Override
    public boolean isInductiveSelfloop(IPredicate iPredicate, IPredicate iPredicate2, ICallAction iCallAction, IPredicate iPredicate3) {
        assert (iPredicate2 == null) : "Unexpected hierarchical precondition for call action";
        if (iPredicate != iPredicate3) {
            return false;
        }
        String string = iCallAction.getPrecedingProcedure();
        for (IProgramVar iProgramVar : iPredicate.getVars()) {
            if (!iProgramVar.isGlobal()) {
                return false;
            }
            if (!iProgramVar.isOldvar() || !this.mModifiableGlobals.isModifiable((IProgramOldVar)iProgramVar, string)) continue;
            return false;
        }
        this.mStatistics.getSDsluCounter().incCa();
        return true;
    }

    @Override
    public IncrementalPlicationChecker.Validity sdec(IPredicate iPredicate, IPredicate iPredicate2, ICallAction iCallAction, IPredicate iPredicate3) {
        assert (iPredicate2 == null) : "Unexpected hierarchical precondition for call action";
        String string = iCallAction.getPrecedingProcedure();
        String string2 = iCallAction.getSucceedingProcedure();
        if (this.mModifiableGlobals.containsNonModifiableOldVars(iPredicate, string) || this.mModifiableGlobals.containsNonModifiableOldVars(iPredicate3, string2)) {
            return null;
        }
        if (!CallCheckHelper.disjointFunctions(iPredicate, iPredicate3)) {
            return null;
        }
        for (IProgramVar serializable2 : iPredicate3.getVars()) {
            if (serializable2.isOldvar()) {
                return null;
            }
            if (!serializable2.isGlobal() || !iPredicate.getVars().contains(serializable2)) continue;
            return null;
        }
        UnmodifiableTransFormula unmodifiableTransFormula = iCallAction.getLocalVarsAssignment();
        if (!CallCheckHelper.varsDisjointFromOutVars(iPredicate, unmodifiableTransFormula)) {
            return null;
        }
        if (!CallCheckHelper.varsDisjointFromOutVars(iPredicate3, unmodifiableTransFormula)) {
            return null;
        }
        this.mStatistics.getSDsCounter().incCa();
        return IncrementalPlicationChecker.Validity.INVALID;
    }

    @Override
    public IncrementalPlicationChecker.Validity sdLazyEc(IPredicate iPredicate, IPredicate iPredicate2, ICallAction iCallAction, IPredicate iPredicate3) {
        assert (iPredicate2 == null) : "Unexpected hierarchical precondition for call action";
        if (CallCheckHelper.isOrIteFormula(iPredicate3)) {
            return this.sdec(iPredicate, (IPredicate)null, iCallAction, iPredicate3);
        }
        UnmodifiableTransFormula unmodifiableTransFormula = iCallAction.getLocalVarsAssignment();
        boolean bl = !CallCheckHelper.varsDisjointFromInVars(iPredicate, unmodifiableTransFormula);
        for (IProgramVar iProgramVar : iPredicate3.getVars()) {
            if (iProgramVar.isGlobal() || unmodifiableTransFormula.getOutVars().containsKey(iProgramVar) && bl) continue;
            this.mStatistics.getSdLazyCounter().incCa();
            return IncrementalPlicationChecker.Validity.INVALID;
        }
        return null;
    }
}

