/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.debug;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;

public final class DeclarationAdder
extends TermTransformer {
    private final Set<FunctionSymbol> mFuncSymbols;
    private final Set<TermVariable> mTermSymbols;
    private final PrintWriter mWriter;

    public DeclarationAdder(PrintWriter printWriter) {
        this.mWriter = printWriter;
        this.mFuncSymbols = new HashSet<FunctionSymbol>();
        this.mTermSymbols = new HashSet<TermVariable>();
    }

    protected void convert(Term term) {
        TermVariable termVariable;
        if (term instanceof ApplicationTerm) {
            FunctionSymbol functionSymbol = ((ApplicationTerm)term).getFunction();
            if (!functionSymbol.isIntern() && this.mFuncSymbols.add(functionSymbol)) {
                this.mWriter.append("(declare-fun ").append(functionSymbol.getName()).append(" () ").append(functionSymbol.getReturnSort().toString()).append(")").println();
            }
        } else if (term instanceof TermVariable && this.mTermSymbols.add(termVariable = (TermVariable)term)) {
            this.mWriter.append("(declare-fun ").append(termVariable.getName()).append(" () ").append(termVariable.getSort().toString()).append(")").println();
        }
        super.convert(term);
    }
}

