/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.tracehandling;

import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IProgramExecution;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.IHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.interpolant.InterpolantComputationStatus;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.interpolant.QualifiedTracePredicates;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.tracecheck.TraceCheckReasonUnknown;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.tracehandling.IIpgStrategyModule;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.tracehandling.IRefinementEngine;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.tracehandling.IRefinementEngineResult;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.tracehandling.IRefinementStrategy;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.tracehandling.ITraceCheckStrategyModule;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.tracehandling.RefinementEngineStatisticsGenerator;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.Lazy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public final class AutomatonFreeRefinementEngine<L extends IAction>
implements IRefinementEngine<L, Collection<QualifiedTracePredicates>> {
    private final ILogger mLogger;
    private final IRefinementStrategy<L> mStrategy;
    private final RefinementEngineStatisticsGenerator mRefinementEngineStatistics;
    private final Script.LBool mFeasibility;
    private IProgramExecution<L, Term> mIcfgProgramExecution;
    private List<QualifiedTracePredicates> mUsedTracePredicates;
    private boolean mSomePerfectSequenceFound;
    private List<QualifiedTracePredicates> mQualifiedTracePredicates;
    private String mUsedTraceCheckFingerprint;
    private final IUltimateServiceProvider mServices;

    public AutomatonFreeRefinementEngine(IUltimateServiceProvider iUltimateServiceProvider, ILogger iLogger, IRefinementStrategy<L> iRefinementStrategy) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = iLogger;
        this.mStrategy = iRefinementStrategy;
        this.mRefinementEngineStatistics = new RefinementEngineStatisticsGenerator();
        this.mFeasibility = this.executeStrategy();
        this.mRefinementEngineStatistics.finishRefinementEngineRun();
    }

    private IHoareTripleChecker getHoareTripleChecker() {
        IHoareTripleChecker iHoareTripleChecker = this.mStrategy.getHoareTripleChecker(this);
        if (iHoareTripleChecker != null) {
            this.mLogger.info("Using hoare triple checker %s provided by strategy", new Object[]{iHoareTripleChecker.getClass().getSimpleName()});
        }
        return iHoareTripleChecker;
    }

    private IPredicateUnifier getPredicateUnifier() {
        IPredicateUnifier iPredicateUnifier = this.mStrategy.getPredicateUnifier(this);
        assert (iPredicateUnifier != null);
        this.mLogger.info("Using predicate unifier %s provided by strategy %s", new Object[]{iPredicateUnifier.getClass().getSimpleName(), this.mStrategy.getName()});
        return iPredicateUnifier;
    }

    @Override
    public RefinementEngineStatisticsGenerator getRefinementEngineStatistics() {
        return this.mRefinementEngineStatistics;
    }

    private Script.LBool executeStrategy() {
        this.mLogger.info("Executing refinement strategy %s", new Object[]{this.mStrategy.getName()});
        Script.LBool lBool = this.checkFeasibility();
        if (lBool == Script.LBool.UNKNOWN) {
            this.abortIfTimeout(String.format("Timeout during %s", this.mStrategy.getName()));
            this.mLogger.warn("Strategy %s was unsuccessful and could not determine trace feasibility", new Object[]{this.mStrategy.getName()});
            return lBool;
        }
        if (lBool == Script.LBool.SAT) {
            this.mLogger.info("Strategy %s found a feasible trace", new Object[]{this.mStrategy.getName()});
            return lBool;
        }
        if (lBool == Script.LBool.UNSAT) {
            this.mLogger.info("Strategy %s found an infeasible trace", new Object[]{this.mStrategy.getName()});
            return this.generateProof();
        }
        throw new UnsupportedOperationException("Unknown LBool: " + String.valueOf(lBool));
    }

    private Script.LBool generateProof() {
        ArrayList<QualifiedTracePredicates> arrayList = new ArrayList<QualifiedTracePredicates>();
        ArrayList<QualifiedTracePredicates> arrayList2 = new ArrayList<QualifiedTracePredicates>();
        while (this.mStrategy.hasNextInterpolantGenerator(Collections.unmodifiableList(arrayList), Collections.unmodifiableList(arrayList2))) {
            IIpgStrategyModule<?, L> iIpgStrategyModule = this.tryExecuteInterpolantGenerator();
            if (iIpgStrategyModule == null) continue;
            Collection<QualifiedTracePredicates> collection = iIpgStrategyModule.getPerfectInterpolantSequences();
            arrayList.addAll(collection);
            Collection<QualifiedTracePredicates> collection2 = iIpgStrategyModule.getImperfectInterpolantSequences();
            arrayList2.addAll(collection2);
            this.mLogger.info("%s provided %s perfect and %s imperfect interpolant sequences", new Object[]{AutomatonFreeRefinementEngine.getModuleFingerprintString(iIpgStrategyModule), collection.size(), collection2.size()});
            iIpgStrategyModule.aggregateStatistics(this.mRefinementEngineStatistics);
        }
        this.logStats(arrayList, arrayList2);
        if (!arrayList.isEmpty()) {
            this.mSomePerfectSequenceFound = true;
        }
        if (arrayList.isEmpty() && arrayList2.isEmpty()) {
            this.mLogger.error("Strategy %s failed to provide any proof altough trace is infeasible", new Object[]{this.mStrategy.getName()});
            this.mQualifiedTracePredicates = null;
            return Script.LBool.UNKNOWN;
        }
        this.mQualifiedTracePredicates = this.mStrategy.mergeInterpolants(arrayList, arrayList2);
        this.mUsedTracePredicates = this.mQualifiedTracePredicates;
        return Script.LBool.UNSAT;
    }

    private void logStats(List<QualifiedTracePredicates> list, List<QualifiedTracePredicates> list2) {
        if (!this.mLogger.isInfoEnabled()) {
            return;
        }
        this.mLogger.info("Found %s perfect and %s imperfect interpolant sequences.", new Object[]{list.size(), list2.size()});
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        HashSet<IPredicate> hashSet = new HashSet<IPredicate>();
        for (QualifiedTracePredicates qualifiedTracePredicates : list) {
            arrayList.add(new HashSet<IPredicate>(qualifiedTracePredicates.getPredicates()).size());
            hashSet.addAll(qualifiedTracePredicates.getPredicates());
        }
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        for (QualifiedTracePredicates qualifiedTracePredicates : list2) {
            arrayList2.add(new HashSet<IPredicate>(qualifiedTracePredicates.getPredicates()).size());
            hashSet.addAll(qualifiedTracePredicates.getPredicates());
        }
        this.mLogger.info((Object)("Number of different interpolants: perfect sequences " + String.valueOf(arrayList) + " imperfect sequences " + String.valueOf(arrayList2) + " total " + hashSet.size()));
    }

    private Script.LBool checkFeasibility() {
        while (this.mStrategy.hasNextFeasilibityCheck()) {
            ITraceCheckStrategyModule<L, ?> iTraceCheckStrategyModule = this.mStrategy.nextFeasibilityCheck();
            this.abortIfTimeout("Timeout during feasibility check between " + this.mUsedTraceCheckFingerprint + " and " + AutomatonFreeRefinementEngine.getModuleFingerprintString(iTraceCheckStrategyModule));
            this.mUsedTraceCheckFingerprint = AutomatonFreeRefinementEngine.getModuleFingerprintString(iTraceCheckStrategyModule);
            this.logModule("Using trace check", iTraceCheckStrategyModule);
            Script.LBool lBool = iTraceCheckStrategyModule.isCorrect();
            if (lBool == Script.LBool.SAT) {
                if (iTraceCheckStrategyModule.providesRcfgProgramExecution()) {
                    this.mIcfgProgramExecution = iTraceCheckStrategyModule.getRcfgProgramExecution();
                }
                iTraceCheckStrategyModule.aggregateStatistics(this.mRefinementEngineStatistics);
                return lBool;
            }
            if (lBool == Script.LBool.UNSAT) {
                iTraceCheckStrategyModule.aggregateStatistics(this.mRefinementEngineStatistics);
                return lBool;
            }
            this.abortIfNecessaryOnUnknown(iTraceCheckStrategyModule.getTraceCheckReasonUnknown());
            iTraceCheckStrategyModule.aggregateStatistics(this.mRefinementEngineStatistics);
        }
        return Script.LBool.UNKNOWN;
    }

    private void abortIfTimeout(String string) {
        if (!this.mServices.getProgressMonitorService().continueProcessing()) {
            throw new ToolchainCanceledException(this.getClass(), string);
        }
    }

    private void abortIfNecessaryOnUnknown(TraceCheckReasonUnknown traceCheckReasonUnknown) {
        if (traceCheckReasonUnknown.getException() == null) {
            return;
        }
        TraceCheckReasonUnknown.ExceptionHandlingCategory exceptionHandlingCategory = traceCheckReasonUnknown.getExceptionHandlingCategory();
        switch (exceptionHandlingCategory) {
            case KNOWN_IGNORE: 
            case KNOWN_DEPENDING: 
            case KNOWN_THROW: {
                if (!this.mLogger.isErrorEnabled()) break;
                this.mLogger.error((Object)("Caught known exception: " + traceCheckReasonUnknown.getException().getMessage()));
                break;
            }
            case UNKNOWN: {
                if (!this.mLogger.isErrorEnabled()) break;
                this.mLogger.error((Object)("Caught unknown exception: " + traceCheckReasonUnknown.getException().getMessage()));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown exception category: " + String.valueOf((Object)exceptionHandlingCategory));
            }
        }
        this.throwIfNecessary(traceCheckReasonUnknown.getExceptionHandlingCategory(), traceCheckReasonUnknown.getException());
    }

    private IIpgStrategyModule<?, L> tryExecuteInterpolantGenerator() {
        InterpolantComputationStatus interpolantComputationStatus;
        IIpgStrategyModule<?, L> iIpgStrategyModule = this.mStrategy.nextInterpolantGenerator();
        this.abortIfTimeout("Timeout during proof generation before using " + AutomatonFreeRefinementEngine.getModuleFingerprintString(iIpgStrategyModule));
        try {
            this.logModule("Using interpolant generator", iIpgStrategyModule);
            interpolantComputationStatus = iIpgStrategyModule.getInterpolantComputationStatus();
            if (interpolantComputationStatus == null) {
                this.mLogger.fatal((Object)"No interpolant computation status provided, assuming failure");
                throw new AssertionError((Object)(String.valueOf(iIpgStrategyModule.getClass()) + " provided no interpolant computation status"));
            }
            if (interpolantComputationStatus.wasComputationSuccessful()) {
                return iIpgStrategyModule;
            }
        }
        catch (ToolchainCanceledException toolchainCanceledException) {
            throw toolchainCanceledException;
        }
        catch (Exception exception) {
            if (TraceCheckReasonUnknown.ExceptionHandlingCategory.UNKNOWN.throwException(this.mStrategy.getExceptionBlacklist())) {
                this.mLogger.fatal((Object)("Exception during interpolant generation: " + exception.getClass().getSimpleName()));
                throw exception;
            }
            this.mLogger.fatal((Object)"Ignoring exception!", (Throwable)exception);
            return null;
        }
        TraceCheckReasonUnknown.ExceptionHandlingCategory exceptionHandlingCategory = switch (interpolantComputationStatus.getStatus()) {
            case InterpolantComputationStatus.ItpErrorStatus.ALGORITHM_FAILED -> TraceCheckReasonUnknown.ExceptionHandlingCategory.KNOWN_IGNORE;
            case InterpolantComputationStatus.ItpErrorStatus.OTHER -> TraceCheckReasonUnknown.ExceptionHandlingCategory.UNKNOWN;
            case InterpolantComputationStatus.ItpErrorStatus.SMT_SOLVER_CANNOT_INTERPOLATE_INPUT -> TraceCheckReasonUnknown.ExceptionHandlingCategory.KNOWN_IGNORE;
            case InterpolantComputationStatus.ItpErrorStatus.SMT_SOLVER_CRASH -> TraceCheckReasonUnknown.ExceptionHandlingCategory.KNOWN_DEPENDING;
            case InterpolantComputationStatus.ItpErrorStatus.TRACE_FEASIBLE -> {
                String var4_6 = "Tracecheck %s said UNSAT, interpolant generator %s failed with %s".formatted(new Object[]{this.mUsedTraceCheckFingerprint, AutomatonFreeRefinementEngine.getModuleFingerprintString(iIpgStrategyModule), interpolantComputationStatus.getStatus()});
                throw new IllegalStateException(var4_6);
            }
            default -> throw new MatchException(null, null);
        };
        this.throwIfNecessary(exceptionHandlingCategory, interpolantComputationStatus.getException());
        String string = interpolantComputationStatus.getException() == null ? String.valueOf((Object)interpolantComputationStatus.getStatus()) : interpolantComputationStatus.getException().getMessage();
        this.mLogger.warn((Object)("Interpolation failed due to " + String.valueOf((Object)exceptionHandlingCategory) + ": " + string));
        return null;
    }

    private void throwIfNecessary(TraceCheckReasonUnknown.ExceptionHandlingCategory exceptionHandlingCategory, Throwable throwable) {
        boolean bl = exceptionHandlingCategory.throwException(this.mStrategy.getExceptionBlacklist());
        if (bl) {
            this.mLogger.warn((Object)"Global settings require throwing the following exception");
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new AssertionError((Object)throwable);
        }
    }

    private void logModule(String string, Object object) {
        this.mLogger.info("%s %s", new Object[]{string, AutomatonFreeRefinementEngine.getModuleFingerprintString(object)});
    }

    private static String getModuleFingerprintString(Object object) {
        return String.format("%s [%s]", object.getClass().getSimpleName(), object.hashCode());
    }

    @Override
    public IRefinementEngineResult<L, Collection<QualifiedTracePredicates>> getResult() {
        return new IRefinementEngineResult.BasicRefinementEngineResult<L, List<QualifiedTracePredicates>>(this.mFeasibility, this.mQualifiedTracePredicates, this.mIcfgProgramExecution, this.mSomePerfectSequenceFound, this.mUsedTracePredicates, (Lazy<IHoareTripleChecker>)new Lazy(this::getHoareTripleChecker), (Lazy<IPredicateUnifier>)new Lazy(this::getPredicateUnifier));
    }
}

