/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.evaluator;

import de.uni_freiburg.informatik.ultimate.boogie.ast.BinaryExpression;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractState;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.BooleanValue;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.INonrelationalValue;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.INonrelationalValueFactory;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.NonrelationalEvaluationResult;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.NonrelationalUtils;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.evaluator.EvaluatorLogger;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.evaluator.EvaluatorUtils;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.evaluator.IEvaluationResult;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.evaluator.NAryEvaluator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.function.BiFunction;

public class BinaryExpressionEvaluator<VALUE extends INonrelationalValue<VALUE>, STATE extends IAbstractState<STATE>>
extends NAryEvaluator<VALUE, STATE> {
    private final EvaluatorLogger mLogger;
    private final EvaluatorUtils.EvaluatorType mEvaluatorType;
    private final int mMaxParallelSates;
    private final INonrelationalValueFactory<VALUE> mNonrelationalValueFactory;
    private BinaryExpression.Operator mOperator;
    private final VALUE mTopValue;

    public BinaryExpressionEvaluator(EvaluatorLogger evaluatorLogger, EvaluatorUtils.EvaluatorType evaluatorType, int n, int n2, INonrelationalValueFactory<VALUE> iNonrelationalValueFactory) {
        super(n2, iNonrelationalValueFactory, evaluatorLogger);
        this.mLogger = evaluatorLogger;
        this.mEvaluatorType = evaluatorType;
        this.mMaxParallelSates = n;
        this.mNonrelationalValueFactory = iNonrelationalValueFactory;
        this.mTopValue = this.mNonrelationalValueFactory.createTopValue();
    }

    @Override
    public Collection<IEvaluationResult<VALUE>> evaluate(STATE STATE) {
        assert (STATE != null);
        ArrayList arrayList = new ArrayList();
        Collection collection = this.getSubEvaluator(0).evaluate(STATE, this.getCurrentEvaluationRecursion() + 1);
        Collection collection2 = this.getSubEvaluator(1).evaluate(STATE, this.getCurrentEvaluationRecursion() + 1);
        for (IEvaluationResult iEvaluationResult : collection) {
            for (IEvaluationResult iEvaluationResult2 : collection2) {
                Collection collection3 = this.evaluate(this.mOperator, iEvaluationResult, iEvaluationResult2);
                this.mLogger.logEvaluation(this.mOperator, collection3, iEvaluationResult, iEvaluationResult2);
                arrayList.addAll(collection3);
            }
        }
        assert (!arrayList.isEmpty());
        return NonrelationalUtils.mergeIfNecessary(arrayList, this.mMaxParallelSates);
    }

    private Collection<IEvaluationResult<VALUE>> evaluate(BinaryExpression.Operator operator, IEvaluationResult<VALUE> iEvaluationResult, IEvaluationResult<VALUE> iEvaluationResult2) {
        INonrelationalValue iNonrelationalValue = (INonrelationalValue)iEvaluationResult.getValue();
        INonrelationalValue iNonrelationalValue2 = (INonrelationalValue)iEvaluationResult2.getValue();
        switch (operator) {
            case ARITHPLUS: {
                return this.onlyValue(iNonrelationalValue.add(iNonrelationalValue2));
            }
            case ARITHMINUS: {
                return this.onlyValue(iNonrelationalValue.subtract(iNonrelationalValue2));
            }
            case ARITHMUL: {
                return this.onlyValue(iNonrelationalValue.multiply(iNonrelationalValue2));
            }
            case ARITHDIV: {
                return this.evaluateArithDiv(iEvaluationResult, iEvaluationResult2);
            }
            case ARITHMOD: {
                assert (this.mEvaluatorType == EvaluatorUtils.EvaluatorType.INTEGER) : "Type error: modulo is not defined on reals";
                return this.onlyValue(iNonrelationalValue.modulo(iNonrelationalValue2));
            }
            case LOGICAND: {
                return this.onlyBoolean(iEvaluationResult.getBooleanValue().and(iEvaluationResult2.getBooleanValue()));
            }
            case LOGICOR: {
                return this.onlyBoolean(iEvaluationResult.getBooleanValue().or(iEvaluationResult2.getBooleanValue()));
            }
            case LOGICIMPLIES: {
                throw new UnsupportedOperationException("Implications should have been removed during expression normalization.");
            }
            case LOGICIFF: {
                throw new UnsupportedOperationException("If and only if expressions should have been removed during expression normalization.");
            }
            case COMPEQ: {
                return this.evaluateCompEq(iEvaluationResult, iEvaluationResult2);
            }
            case COMPNEQ: {
                if (!this.getSubEvaluator(0).containsBool() && !this.getSubEvaluator(1).containsBool()) {
                    return this.onlyBoolean(iNonrelationalValue.isNotEqual(iNonrelationalValue2));
                }
                return this.onlyTop();
            }
            case COMPGT: {
                if (!iNonrelationalValue.canHandleReals()) {
                    this.mLogger.warnOverapproximatingOperator(this.mOperator);
                }
                return this.evaluateCompare(iNonrelationalValue, iNonrelationalValue2, this::greaterThan, this::greaterThanBool);
            }
            case COMPGEQ: {
                return this.evaluateCompare(iNonrelationalValue, iNonrelationalValue2, this::greaterOrEqual, this::greaterOrEqualBool);
            }
            case COMPLT: {
                if (!iNonrelationalValue.canHandleReals()) {
                    this.mLogger.warnOverapproximatingOperator(this.mOperator);
                }
                return this.evaluateCompare(iNonrelationalValue, iNonrelationalValue2, this::lessThan, this::lessThanBool);
            }
            case COMPLEQ: {
                return this.evaluateCompare(iNonrelationalValue, iNonrelationalValue2, this::lessOrEqual, this::lessOrEqualBool);
            }
        }
        this.mLogger.warnUnknownOperator(this.mOperator);
        return this.onlyTop();
    }

    private Collection<IEvaluationResult<VALUE>> evaluateArithDiv(IEvaluationResult<VALUE> iEvaluationResult, IEvaluationResult<VALUE> iEvaluationResult2) {
        switch (this.mEvaluatorType) {
            case INTEGER: {
                return this.onlyValue(((INonrelationalValue)iEvaluationResult.getValue()).divideInteger((INonrelationalValue)iEvaluationResult2.getValue()));
            }
            case REAL: {
                return this.onlyValue(((INonrelationalValue)iEvaluationResult.getValue()).divideReal((INonrelationalValue)iEvaluationResult2.getValue()));
            }
        }
        throw new UnsupportedOperationException("Division on types other than integers and reals is undefined.");
    }

    private Collection<IEvaluationResult<VALUE>> evaluateCompare(VALUE VALUE, VALUE VALUE2, BiFunction<VALUE, VALUE, VALUE> biFunction, BiFunction<VALUE, VALUE, BooleanValue> biFunction2) {
        INonrelationalValue iNonrelationalValue = (INonrelationalValue)biFunction.apply(VALUE, VALUE2);
        BooleanValue booleanValue = iNonrelationalValue.isBottom() ? BooleanValue.FALSE : biFunction2.apply(VALUE, VALUE2);
        if (!booleanValue.isSingleton()) {
            return this.both(iNonrelationalValue, booleanValue);
        }
        ArrayList<IEvaluationResult<VALUE>> arrayList = new ArrayList<IEvaluationResult<VALUE>>();
        arrayList.add(new NonrelationalEvaluationResult<INonrelationalValue>(iNonrelationalValue, booleanValue));
        BooleanValue booleanValue2 = booleanValue.neg();
        Collection collection = this.getSubEvaluator(0).getType() == EvaluatorUtils.EvaluatorType.INTEGER ? iNonrelationalValue.complementInteger() : iNonrelationalValue.complement();
        for (INonrelationalValue iNonrelationalValue2 : collection) {
            arrayList.add(new NonrelationalEvaluationResult<INonrelationalValue>(iNonrelationalValue2, booleanValue2));
        }
        return arrayList;
    }

    private Collection<IEvaluationResult<VALUE>> evaluateCompEq(IEvaluationResult<VALUE> iEvaluationResult, IEvaluationResult<VALUE> iEvaluationResult2) {
        BooleanValue booleanValue = BooleanValue.INVALID;
        if (this.getSubEvaluator(0).containsBool() || this.getSubEvaluator(1).containsBool()) {
            booleanValue = iEvaluationResult.getBooleanValue().intersect(iEvaluationResult2.getBooleanValue()) != BooleanValue.BOTTOM ? BooleanValue.TRUE : BooleanValue.BOTTOM;
        }
        INonrelationalValue iNonrelationalValue = ((INonrelationalValue)iEvaluationResult.getValue()).intersect((INonrelationalValue)iEvaluationResult2.getValue());
        if (booleanValue.isBottom() || iNonrelationalValue.isBottom()) {
            booleanValue = BooleanValue.FALSE;
        } else if (!this.getSubEvaluator(0).containsBool() && !this.getSubEvaluator(1).containsBool()) {
            booleanValue = ((INonrelationalValue)iEvaluationResult.getValue()).isEqual((INonrelationalValue)iEvaluationResult2.getValue());
        }
        return Collections.singletonList(new NonrelationalEvaluationResult<INonrelationalValue>(iNonrelationalValue, booleanValue));
    }

    @Override
    public Collection<STATE> inverseEvaluate(IEvaluationResult<VALUE> iEvaluationResult, STATE STATE) {
        HashSet<STATE> hashSet = new HashSet<STATE>();
        INonrelationalValue iNonrelationalValue = (INonrelationalValue)iEvaluationResult.getValue();
        BooleanValue booleanValue = iEvaluationResult.getBooleanValue();
        Collection collection = this.getSubEvaluator(0).evaluate(STATE, this.getCurrentEvaluationRecursion() + 1);
        Collection collection2 = this.getSubEvaluator(1).evaluate(STATE, this.getCurrentEvaluationRecursion() + 1);
        for (IEvaluationResult iEvaluationResult2 : collection) {
            for (IEvaluationResult iEvaluationResult3 : collection2) {
                INonrelationalValue iNonrelationalValue2 = (INonrelationalValue)iEvaluationResult2.getValue();
                INonrelationalValue iNonrelationalValue3 = (INonrelationalValue)iEvaluationResult3.getValue();
                NonrelationalEvaluationResult<INonrelationalValue> nonrelationalEvaluationResult = new NonrelationalEvaluationResult<INonrelationalValue>(iNonrelationalValue2, booleanValue);
                NonrelationalEvaluationResult<INonrelationalValue> nonrelationalEvaluationResult2 = new NonrelationalEvaluationResult<INonrelationalValue>(iNonrelationalValue3, booleanValue);
                switch (this.mOperator) {
                    case LOGICAND: {
                        Collection collection3 = this.getSubEvaluator(0).inverseEvaluate(nonrelationalEvaluationResult, STATE, this.getCurrentInverseEvaluationRecursion() + 1);
                        Collection collection4 = this.getSubEvaluator(1).inverseEvaluate(nonrelationalEvaluationResult2, STATE, this.getCurrentInverseEvaluationRecursion() + 1);
                        hashSet.addAll(this.crossIntersect(collection3, collection4));
                        break;
                    }
                    case LOGICOR: {
                        this.getSubEvaluator(0).inverseEvaluate(nonrelationalEvaluationResult, STATE, this.getCurrentInverseEvaluationRecursion() + 1).forEach(hashSet::add);
                        this.getSubEvaluator(1).inverseEvaluate(nonrelationalEvaluationResult2, STATE, this.getCurrentInverseEvaluationRecursion() + 1).forEach(hashSet::add);
                        break;
                    }
                    case LOGICIMPLIES: {
                        throw new UnsupportedOperationException("Implications should have been removed from expressions during expression normalization.");
                    }
                    case LOGICIFF: {
                        throw new UnsupportedOperationException("If and only if expressions should have been removed during expression normalization.");
                    }
                    case COMPEQ: {
                        BooleanValue booleanValue2 = iEvaluationResult2.getBooleanValue().intersect(iEvaluationResult3.getBooleanValue());
                        if ((this.getSubEvaluator(0).containsBool() || this.getSubEvaluator(1).containsBool()) && booleanValue2 == BooleanValue.TOP) {
                            hashSet.add(STATE);
                            break;
                        }
                        INonrelationalValue iNonrelationalValue4 = this.inverseEvaluate(iNonrelationalValue, iNonrelationalValue2, iNonrelationalValue3, true);
                        INonrelationalValue iNonrelationalValue5 = this.inverseEvaluate(iNonrelationalValue, iNonrelationalValue3, iNonrelationalValue2, false);
                        NonrelationalEvaluationResult<INonrelationalValue> nonrelationalEvaluationResult3 = new NonrelationalEvaluationResult<INonrelationalValue>(iNonrelationalValue4, iEvaluationResult3.getBooleanValue());
                        NonrelationalEvaluationResult<INonrelationalValue> nonrelationalEvaluationResult4 = new NonrelationalEvaluationResult<INonrelationalValue>(iNonrelationalValue5, iEvaluationResult2.getBooleanValue());
                        Collection collection5 = this.getSubEvaluator(0).inverseEvaluate(nonrelationalEvaluationResult3, STATE, this.getCurrentInverseEvaluationRecursion() + 1);
                        Collection collection6 = this.getSubEvaluator(1).inverseEvaluate(nonrelationalEvaluationResult4, STATE, this.getCurrentInverseEvaluationRecursion() + 1);
                        hashSet.addAll(this.crossIntersect(collection5, collection6));
                        break;
                    }
                    case COMPNEQ: {
                        if (this.getSubEvaluator(0).containsBool() || this.getSubEvaluator(1).containsBool()) {
                            throw new UnsupportedOperationException("COMPNEQ operator should not occur for boolean formulas.");
                        }
                    }
                    case COMPLT: 
                    case COMPGT: 
                    case COMPLEQ: 
                    case COMPGEQ: 
                    case ARITHPLUS: 
                    case ARITHMINUS: 
                    case ARITHMUL: 
                    case ARITHDIV: 
                    case ARITHMOD: {
                        INonrelationalValue iNonrelationalValue6 = this.inverseEvaluate(iNonrelationalValue, iNonrelationalValue2, iNonrelationalValue3, true);
                        INonrelationalValue iNonrelationalValue7 = this.inverseEvaluate(iNonrelationalValue, iNonrelationalValue3, iNonrelationalValue2, false);
                        NonrelationalEvaluationResult<INonrelationalValue> nonrelationalEvaluationResult5 = new NonrelationalEvaluationResult<INonrelationalValue>(iNonrelationalValue6, booleanValue);
                        NonrelationalEvaluationResult<INonrelationalValue> nonrelationalEvaluationResult6 = new NonrelationalEvaluationResult<INonrelationalValue>(iNonrelationalValue7, booleanValue);
                        Collection collection7 = this.getSubEvaluator(0).inverseEvaluate(nonrelationalEvaluationResult5, STATE, this.getCurrentInverseEvaluationRecursion() + 1);
                        Collection collection8 = this.getSubEvaluator(1).inverseEvaluate(nonrelationalEvaluationResult6, STATE, this.getCurrentInverseEvaluationRecursion() + 1);
                        hashSet.addAll(this.crossIntersect(collection7, collection8));
                        break;
                    }
                    default: {
                        this.mLogger.warnUnknownOperator(this.mOperator);
                        hashSet.add(STATE);
                    }
                }
                if (!hashSet.isEmpty()) continue;
                hashSet.add(STATE);
            }
        }
        assert (!hashSet.isEmpty());
        return NonrelationalUtils.mergeStatesIfNecessary(hashSet, this.mMaxParallelSates);
    }

    private Collection<STATE> crossIntersect(Collection<STATE> collection, Collection<STATE> collection2) {
        HashSet<IAbstractState> hashSet = new HashSet<IAbstractState>(collection.size() * collection2.size());
        for (IAbstractState iAbstractState : collection) {
            for (IAbstractState iAbstractState2 : collection2) {
                hashSet.add(iAbstractState.intersect(iAbstractState2));
            }
        }
        return hashSet;
    }

    private VALUE inverseEvaluate(VALUE VALUE, VALUE VALUE2, VALUE VALUE3, boolean bl) {
        VALUE VALUE4;
        switch (this.mOperator) {
            case ARITHPLUS: {
                VALUE4 = VALUE.subtract(VALUE3);
                VALUE4 = VALUE4.intersect(VALUE2);
                break;
            }
            case ARITHMINUS: {
                VALUE4 = bl ? VALUE.add(VALUE3) : VALUE3.subtract(VALUE);
                VALUE4 = VALUE4.intersect(VALUE2);
                break;
            }
            case ARITHMUL: {
                if (this.mEvaluatorType == EvaluatorUtils.EvaluatorType.INTEGER) {
                    VALUE4 = VALUE.divideInteger(VALUE3);
                } else if (this.mEvaluatorType == EvaluatorUtils.EvaluatorType.REAL) {
                    VALUE4 = VALUE.divideReal(VALUE3);
                } else {
                    throw new UnsupportedOperationException("Division on types other than integers and reals is not defined.");
                }
                VALUE4 = VALUE4.intersect(VALUE2);
                break;
            }
            case ARITHDIV: {
                if (this.mEvaluatorType == EvaluatorUtils.EvaluatorType.INTEGER) {
                    VALUE4 = VALUE2;
                } else if (this.mEvaluatorType == EvaluatorUtils.EvaluatorType.REAL) {
                    VALUE4 = bl ? VALUE.multiply(VALUE3) : VALUE3.divideReal(VALUE);
                } else {
                    throw new UnsupportedOperationException("Division on types other than integers and reals is not defined.");
                }
                VALUE4 = VALUE4.intersect(VALUE2);
                break;
            }
            case ARITHMOD: {
                if (!VALUE3.canHandleModulo()) {
                    this.mLogger.warnOverapproximatingOperator(this.mOperator);
                }
                VALUE4 = VALUE3.inverseModulo(VALUE, VALUE2, bl);
                break;
            }
            case COMPLEQ: {
                VALUE4 = VALUE3.inverseLessOrEqual(VALUE2, bl);
                break;
            }
            case COMPLT: {
                if (!VALUE3.canHandleReals()) {
                    this.mLogger.warnOverapproximatingOperator(this.mOperator);
                }
                VALUE4 = VALUE3.inverseLessThan(VALUE2, bl);
                break;
            }
            case COMPGEQ: {
                VALUE4 = VALUE3.inverseGreaterOrEqual(VALUE2, bl);
                break;
            }
            case COMPGT: {
                if (!VALUE3.canHandleReals()) {
                    this.mLogger.warnOverapproximatingOperator(this.mOperator);
                }
                VALUE4 = VALUE3.inverseGreaterThan(VALUE2, bl);
                break;
            }
            case COMPEQ: {
                VALUE4 = VALUE3.inverseEquality(VALUE2, VALUE);
                break;
            }
            case COMPNEQ: {
                VALUE4 = VALUE3.inverseNotEqual(VALUE2, VALUE);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Not implemented: " + String.valueOf(this.mOperator));
            }
        }
        return VALUE4;
    }

    @Override
    public boolean hasFreeOperands() {
        return this.getNumberOfSubEvaluators() < 2;
    }

    @Override
    public boolean containsBool() {
        return this.getSubEvaluator(0).containsBool() || this.getSubEvaluator(1).containsBool();
    }

    @Override
    public void setOperator(Object object) {
        assert (object != null);
        assert (object instanceof BinaryExpression.Operator);
        this.mOperator = (BinaryExpression.Operator)object;
    }

    @Override
    public int getArity() {
        return 2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(').append(this.getSubEvaluator(0));
        switch (this.mOperator) {
            case ARITHDIV: {
                stringBuilder.append(" / ");
                break;
            }
            case ARITHMINUS: {
                stringBuilder.append(" - ");
                break;
            }
            case ARITHMOD: {
                stringBuilder.append(" % ");
                break;
            }
            case ARITHMUL: {
                stringBuilder.append(" * ");
                break;
            }
            case ARITHPLUS: {
                stringBuilder.append(" + ");
                break;
            }
            case COMPEQ: {
                stringBuilder.append(" == ");
                break;
            }
            case COMPGEQ: {
                stringBuilder.append(" >= ");
                break;
            }
            case COMPGT: {
                stringBuilder.append(" > ");
                break;
            }
            case COMPLEQ: {
                stringBuilder.append(" <= ");
                break;
            }
            case COMPLT: {
                stringBuilder.append(" < ");
                break;
            }
            case COMPNEQ: {
                stringBuilder.append(" != ");
                break;
            }
            case LOGICAND: {
                stringBuilder.append(" && ");
                break;
            }
            case LOGICIFF: {
                stringBuilder.append(" <==> ");
                break;
            }
            case LOGICIMPLIES: {
                stringBuilder.append(" ==> ");
                break;
            }
            case LOGICOR: {
                stringBuilder.append(" || ");
                break;
            }
            default: {
                this.mOperator.name();
            }
        }
        stringBuilder.append(this.getSubEvaluator(1)).append(')');
        return stringBuilder.toString();
    }

    private Collection<IEvaluationResult<VALUE>> both(VALUE VALUE, BooleanValue booleanValue) {
        assert (VALUE != null);
        assert (booleanValue != null);
        assert (booleanValue != BooleanValue.INVALID);
        return Collections.singletonList(new NonrelationalEvaluationResult<VALUE>(VALUE, booleanValue));
    }

    private Collection<IEvaluationResult<VALUE>> onlyValue(VALUE VALUE) {
        assert (VALUE != null);
        return Collections.singletonList(new NonrelationalEvaluationResult<VALUE>(VALUE, BooleanValue.INVALID));
    }

    private Collection<IEvaluationResult<VALUE>> onlyBoolean(BooleanValue booleanValue) {
        assert (booleanValue != null);
        assert (booleanValue != BooleanValue.INVALID);
        return Collections.singletonList(new NonrelationalEvaluationResult<VALUE>(this.mTopValue, booleanValue));
    }

    private Collection<IEvaluationResult<VALUE>> onlyTop() {
        return Collections.singletonList(new NonrelationalEvaluationResult<VALUE>(this.mTopValue, BooleanValue.TOP));
    }

    private VALUE greaterThan(VALUE VALUE, VALUE VALUE2) {
        return VALUE.greaterThan(VALUE2);
    }

    private VALUE greaterOrEqual(VALUE VALUE, VALUE VALUE2) {
        return VALUE.greaterOrEqual(VALUE2);
    }

    private VALUE lessThan(VALUE VALUE, VALUE VALUE2) {
        return VALUE.lessThan(VALUE2);
    }

    private VALUE lessOrEqual(VALUE VALUE, VALUE VALUE2) {
        return VALUE.lessOrEqual(VALUE2);
    }

    private BooleanValue greaterThanBool(VALUE VALUE, VALUE VALUE2) {
        return VALUE.isGreaterThan(VALUE2);
    }

    private BooleanValue greaterOrEqualBool(VALUE VALUE, VALUE VALUE2) {
        return VALUE.isGreaterOrEqual(VALUE2);
    }

    private BooleanValue lessThanBool(VALUE VALUE, VALUE VALUE2) {
        return VALUE.isLessThan(VALUE2);
    }

    private BooleanValue lessOrEqualBool(VALUE VALUE, VALUE VALUE2) {
        return VALUE.isLessOrEqual(VALUE2);
    }

    @Override
    public EvaluatorUtils.EvaluatorType getType() {
        assert (this.getSubEvaluator(0).getType() == this.getSubEvaluator(1).getType());
        return this.mEvaluatorType;
    }
}

