/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.transformula.arraytheory;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.normalforms.DnfTransformer;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class SMTTheoryTransitionRelationProvider {
    private final ManagedScript mMgdScript;
    private final IUltimateServiceProvider mServices;

    public SMTTheoryTransitionRelationProvider(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript) {
        this.mServices = iUltimateServiceProvider;
        this.mMgdScript = managedScript;
    }

    public Set<TransFormula> getTransitionRelationDNF(IcfgEdge icfgEdge) {
        UnmodifiableTransFormula unmodifiableTransFormula = icfgEdge.getTransformula();
        if (unmodifiableTransFormula.isInfeasible() == UnmodifiableTransFormula.Infeasibility.INFEASIBLE) {
            this.mMgdScript.lock((Object)this);
            Term term2 = this.mMgdScript.term((Object)this, "false", new Term[0]);
            this.mMgdScript.unlock((Object)this);
            return Collections.singleton(this.buildNewDisjunctTf(term2, (TransFormula)unmodifiableTransFormula));
        }
        Term term3 = new DnfTransformer(this.mMgdScript, this.mServices).transform(unmodifiableTransFormula.getFormula());
        Term[] termArray = SmtUtils.getDisjuncts((Term)term3);
        HashSet<TransFormula> hashSet = new HashSet<TransFormula>();
        Term[] termArray2 = termArray;
        int n = termArray.length;
        int n2 = 0;
        while (n2 < n) {
            Term term4 = termArray2[n2];
            Term[] termArray3 = SmtUtils.getConjuncts((Term)term4);
            List list = Arrays.stream(termArray3, 0, termArray3.length).filter(term -> this.isTheoryLiteral((Term)term)).collect(Collectors.toList());
            Term term5 = SmtUtils.and((Script)this.mMgdScript.getScript(), list);
            hashSet.add(this.buildNewDisjunctTf(term5, (TransFormula)unmodifiableTransFormula));
            ++n2;
        }
        return hashSet;
    }

    private boolean isTheoryLiteral(Term term) {
        assert ("Bool".equals(term.getSort().getName()));
        return SmtUtils.isFunctionApplication((Term)term, (String)"distinct") || SmtUtils.isFunctionApplication((Term)term, (String)"=") || SmtUtils.isFunctionApplication((Term)term, (String)"not") && SmtUtils.isFunctionApplication((Term)((ApplicationTerm)term).getParameters()[0], (String)"=");
    }

    private TransFormula buildNewDisjunctTf(Term term, TransFormula transFormula) {
        Map map = transFormula.getInVars();
        Map map2 = transFormula.getOutVars();
        Set set = transFormula.getNonTheoryConsts();
        Set set2 = Collections.emptySet();
        boolean bl = transFormula.getAuxVars().isEmpty();
        TransFormulaBuilder transFormulaBuilder = new TransFormulaBuilder(map, map2, set.isEmpty(), set, set2.isEmpty(), set2, bl);
        transFormulaBuilder.setFormula(term);
        transFormulaBuilder.setInfeasibility(UnmodifiableTransFormula.Infeasibility.NOT_DETERMINED);
        UnmodifiableTransFormula unmodifiableTransFormula = transFormulaBuilder.finishConstruction(this.mMgdScript);
        return unmodifiableTransFormula;
    }
}

