/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.DisjunctiveAbstractState;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractState;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.AbsIntPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.BasicPredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.util.AbsIntUtil;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ImmutableSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class AbsIntPredicateUnifier<STATE extends IAbstractState<STATE>>
extends PredicateUnifier {
    public AbsIntPredicateUnifier(ILogger iLogger, IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, BasicPredicateFactory basicPredicateFactory, IIcfgSymbolTable iIcfgSymbolTable, IPredicate ... iPredicateArray) {
        super(iLogger, iUltimateServiceProvider, managedScript, basicPredicateFactory, iIcfgSymbolTable, SmtUtils.SimplificationTechnique.NONE, iPredicateArray);
    }

    protected IPredicate constructNewPredicate(Term term, IPredicate iPredicate) {
        IPredicate iPredicate2 = super.constructNewPredicate(term, iPredicate);
        if (iPredicate2 instanceof AbsIntPredicate) {
            assert (this.assertValidPredicate((AbsIntPredicate)iPredicate2)) : "Created invalid predicate";
            return iPredicate2;
        }
        if (iPredicate instanceof AbsIntPredicate) {
            AbsIntPredicate absIntPredicate = new AbsIntPredicate(iPredicate2, ((AbsIntPredicate)iPredicate).getAbstractStates());
            assert (this.assertValidPredicate(absIntPredicate)) : "Created invalid predicate";
            return absIntPredicate;
        }
        return iPredicate2;
    }

    protected IPredicate postProcessPredicateForConjunction(IPredicate iPredicate2, Set<IPredicate> set2) {
        Set set3 = set2.stream().map(iPredicate -> ((AbsIntPredicate)iPredicate).getAbstractStates()).map(set -> DisjunctiveAbstractState.createDisjunction((Collection)set)).collect(Collectors.toSet());
        Set set4 = AbsIntUtil.synchronizeVariables(set3);
        assert (this.sameVars(set4.stream().flatMap(disjunctiveAbstractState -> disjunctiveAbstractState.getStates().stream()).collect(Collectors.toSet()))) : "Synchronize failed";
        DisjunctiveAbstractState disjunctiveAbstractState3 = (DisjunctiveAbstractState)set4.stream().reduce((disjunctiveAbstractState, disjunctiveAbstractState2) -> disjunctiveAbstractState.intersect(disjunctiveAbstractState2)).orElseThrow(() -> new AssertionError((Object)"No predicates given"));
        AbsIntPredicate absIntPredicate = new AbsIntPredicate(iPredicate2, (IAbstractState)disjunctiveAbstractState3);
        assert (this.assertValidPredicate(absIntPredicate)) : "Created invalid predicate";
        return absIntPredicate;
    }

    protected IPredicate postProcessPredicateForDisjunction(IPredicate iPredicate, Set<IPredicate> set) {
        if (iPredicate instanceof AbsIntPredicate) {
            return iPredicate;
        }
        AbsIntPredicate absIntPredicate = new AbsIntPredicate(iPredicate, this.toDisjunctiveState(set));
        assert (this.assertValidPredicate(absIntPredicate)) : "Created invalid predicate";
        return absIntPredicate;
    }

    private DisjunctiveAbstractState<STATE> toDisjunctiveState(Set<IPredicate> set) {
        if (set == null || set.isEmpty()) {
            return new DisjunctiveAbstractState();
        }
        HashSet<IAbstractState> hashSet = new HashSet<IAbstractState>();
        for (IPredicate iPredicate : set) {
            Set set2 = ((AbsIntPredicate)iPredicate).getAbstractStates();
            for (IAbstractState iAbstractState : set2) {
                if (iAbstractState instanceof DisjunctiveAbstractState) {
                    hashSet.addAll(((DisjunctiveAbstractState)iAbstractState).getStates());
                    continue;
                }
                hashSet.add(iAbstractState);
            }
        }
        return DisjunctiveAbstractState.createDisjunction((Collection)AbsIntUtil.synchronizeVariables(hashSet));
    }

    private boolean sameVars(Set<STATE> set) {
        ImmutableSet immutableSet = ((IAbstractState)set.iterator().next()).getVariables();
        return set.stream().allMatch(arg_0 -> AbsIntPredicateUnifier.lambda$5((Set)immutableSet, arg_0));
    }

    private boolean assertValidPredicate(AbsIntPredicate<?> absIntPredicate) {
        Script script = this.mMgdScript.getScript();
        List list = absIntPredicate.getAbstractStates().stream().map(iAbstractState -> iAbstractState.getTerm(script)).collect(Collectors.toList());
        Term term = SmtUtils.and((Script)script, list);
        Term term2 = script.term("distinct", new Term[]{absIntPredicate.getFormula(), term});
        Script.LBool lBool = SmtUtils.checkSatTerm((Script)script, (Term)term2);
        if (lBool == Script.LBool.UNSAT || lBool == Script.LBool.UNKNOWN) {
            return true;
        }
        this.mLogger.fatal((Object)"Invalid predicate! Predicate and state conjunction should be equal, but it is not.");
        this.mLogger.fatal((Object)("Pred: " + SmtUtils.simplify((ManagedScript)this.mMgdScript, (Term)absIntPredicate.getFormula(), (IUltimateServiceProvider)this.mServices, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.SIMPLIFY_DDA).toStringDirect()));
        this.mLogger.fatal((Object)("States: " + SmtUtils.simplify((ManagedScript)this.mMgdScript, (Term)term, (IUltimateServiceProvider)this.mServices, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.SIMPLIFY_DDA).toStringDirect()));
        this.mLogger.fatal((Object)"Conjunctive states: ");
        for (IAbstractState iAbstractState2 : absIntPredicate.getAbstractStates()) {
            this.mLogger.fatal((Object)iAbstractState2.toLogString());
            this.mLogger.fatal((Object)SmtUtils.simplify((ManagedScript)this.mMgdScript, (Term)iAbstractState2.getTerm(script), (IUltimateServiceProvider)this.mServices, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.SIMPLIFY_DDA).toStringDirect());
        }
        return false;
    }

    private static /* synthetic */ boolean lambda$5(Set set, IAbstractState iAbstractState) {
        return iAbstractState.getVariables().equals((Object)set);
    }
}

