/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.interpolantconsolidation;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.ISLPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.SPredicate;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.PredicateFactoryRefinement;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class PredicateFactoryForInterpolantConsolidation
extends PredicateFactoryRefinement {
    private final Map<IPredicate, Set<IPredicate>> mLocationsToSetOfPredicates = new HashMap<IPredicate, Set<IPredicate>>();
    private final Map<IPredicate, AbstractMap.SimpleEntry<IPredicate, IPredicate>> mIntersectedPredicateToArgumentPredicates = new HashMap<IPredicate, AbstractMap.SimpleEntry<IPredicate, IPredicate>>();
    private final Map<AbstractMap.SimpleEntry<IPredicate, IPredicate>, IPredicate> mArgumentPredicatesToIntersectedPredicate = new HashMap<AbstractMap.SimpleEntry<IPredicate, IPredicate>, IPredicate>();

    public PredicateFactoryForInterpolantConsolidation(IUltimateServiceProvider iUltimateServiceProvider, CfgSmtToolkit cfgSmtToolkit, PredicateFactory predicateFactory, boolean bl) {
        super(iUltimateServiceProvider, cfgSmtToolkit.getManagedScript(), predicateFactory, bl, null);
    }

    public Map<IPredicate, Set<IPredicate>> getLocationsToSetOfPredicates() {
        return this.mLocationsToSetOfPredicates;
    }

    public void removeBadPredicates(Set<IPredicate> set) {
        for (IPredicate iPredicate : set) {
            AbstractMap.SimpleEntry<IPredicate, IPredicate> simpleEntry = this.mIntersectedPredicateToArgumentPredicates.get(iPredicate);
            Set<IPredicate> set2 = this.mLocationsToSetOfPredicates.get(simpleEntry.getKey());
            set2.remove(simpleEntry.getValue());
        }
    }

    public IPredicate getIntersectedPredicate(IPredicate iPredicate, IPredicate iPredicate2) {
        AbstractMap.SimpleEntry<IPredicate, IPredicate> simpleEntry = new AbstractMap.SimpleEntry<IPredicate, IPredicate>(iPredicate, iPredicate2);
        return this.mArgumentPredicatesToIntersectedPredicate.get(simpleEntry);
    }

    @Override
    public IPredicate intersection(IPredicate iPredicate, IPredicate iPredicate2) {
        Term term;
        assert (iPredicate instanceof ISLPredicate);
        IcfgLocation icfgLocation = ((ISLPredicate)iPredicate).getProgramPoint();
        SPredicate sPredicate = this.mPredicateFactory.newSPredicate(icfgLocation, term = this.mPredicateFactory.and(new IPredicate[]{iPredicate, iPredicate2}).getFormula());
        if (this.mIntersectedPredicateToArgumentPredicates.containsKey(sPredicate)) {
            throw new AssertionError((Object)"States of difference automaton are not unique!");
        }
        AbstractMap.SimpleEntry<IPredicate, IPredicate> simpleEntry = new AbstractMap.SimpleEntry<IPredicate, IPredicate>(iPredicate, iPredicate2);
        this.mIntersectedPredicateToArgumentPredicates.put((IPredicate)sPredicate, simpleEntry);
        this.mArgumentPredicatesToIntersectedPredicate.put(simpleEntry, (IPredicate)sPredicate);
        if (this.mLocationsToSetOfPredicates.containsKey(iPredicate)) {
            Set<IPredicate> set = this.mLocationsToSetOfPredicates.get(iPredicate);
            set.add(iPredicate2);
        } else {
            HashSet<IPredicate> hashSet = new HashSet<IPredicate>();
            hashSet.add(iPredicate2);
            this.mLocationsToSetOfPredicates.put(iPredicate, hashSet);
        }
        return sPredicate;
    }

    public void removeConsolidatedPredicatesOnDifferentLevels(Map<IPredicate, Integer> map) {
        int n = Collections.max(map.values());
        for (IPredicate iPredicate : this.mLocationsToSetOfPredicates.keySet()) {
            Set<IPredicate> set = this.mLocationsToSetOfPredicates.get(iPredicate);
            if (set.isEmpty()) continue;
            Set<Object> set2 = new HashSet();
            int[] nArray = new int[n];
            for (IPredicate iPredicate2 : set) {
                IPredicate iPredicate3 = this.getIntersectedPredicate(iPredicate, iPredicate2);
                int n2 = map.get(iPredicate3);
                int n3 = n2 - 1;
                nArray[n3] = nArray[n3] + 1;
            }
            int n4 = PredicateFactoryForInterpolantConsolidation.getIndexOfMaxValue(nArray);
            if (nArray[n4 - 1] <= 1) {
                set2 = set;
            } else {
                for (IPredicate iPredicate4 : set) {
                    IPredicate iPredicate5 = this.getIntersectedPredicate(iPredicate, iPredicate4);
                    int n5 = map.get(iPredicate5);
                    if (n5 == n4) continue;
                    set2.add(iPredicate4);
                }
            }
            set.removeAll(set2);
        }
    }

    private static int getIndexOfMaxValue(int[] nArray) {
        int n = 0;
        int n2 = 1;
        while (n2 < nArray.length) {
            if (nArray[n2] > nArray[n]) {
                n = n2;
            }
            ++n2;
        }
        return n;
    }
}

