/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.predicates;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.BasicCallAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.BasicInternalAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.BasicReturnAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.ICallAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IInternalAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IReturnAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.HoareTripleCheckerStatisticsGenerator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.IncrementalHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.IncrementalPlicationChecker;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SubtermPropertyChecker;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.Activator;
import java.util.function.Predicate;

public class FaultLocalizationRelevanceChecker {
    private static final boolean mUseUnsatCores = false;
    private final IUltimateServiceProvider mServices;
    private final ILogger mLogger;
    private final FaultLocalizationHoareTripleChecker mHoareTripleChecker;
    private final ManagedScript mManagedScript;

    public FaultLocalizationRelevanceChecker(IUltimateServiceProvider iUltimateServiceProvider, CfgSmtToolkit cfgSmtToolkit) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = this.mServices.getLoggingService().getLogger(Activator.PLUGIN_ID);
        this.mHoareTripleChecker = new FaultLocalizationHoareTripleChecker(cfgSmtToolkit);
        this.mManagedScript = cfgSmtToolkit.getManagedScript();
    }

    public ERelevanceStatus relevanceInternal(IPredicate iPredicate, IInternalAction iInternalAction, IPredicate iPredicate2) {
        ERelevanceStatus eRelevanceStatus = this.computeRelevancyInternalWithoutUnsatCores(iPredicate, iInternalAction, iPredicate2);
        this.mHoareTripleChecker.clearAssertionStack();
        return eRelevanceStatus;
    }

    private ERelevanceStatus computeRelevancyInternalWithoutUnsatCores(IPredicate iPredicate, IInternalAction iInternalAction, IPredicate iPredicate2) {
        IncrementalPlicationChecker.Validity validity = this.mHoareTripleChecker.checkInternal(iPredicate, this.constructHavocedInternalAction(this.mServices, iInternalAction, this.mManagedScript), iPredicate2);
        return switch (validity) {
            case IncrementalPlicationChecker.Validity.INVALID -> {
                IncrementalPlicationChecker.Validity var6_5 = this.mHoareTripleChecker.checkInternal(iPredicate, iInternalAction, iPredicate2);
                switch (var6_5) {
                    case INVALID: {
                        yield ERelevanceStatus.Sat;
                    }
                    case UNKNOWN: 
                    case NOT_CHECKED: {
                        yield ERelevanceStatus.unknown;
                    }
                    case VALID: {
                        yield ERelevanceStatus.InUnsatCore;
                    }
                }
                throw new AssertionError();
            }
            case IncrementalPlicationChecker.Validity.UNKNOWN, IncrementalPlicationChecker.Validity.NOT_CHECKED -> ERelevanceStatus.unknown;
            case IncrementalPlicationChecker.Validity.VALID -> ERelevanceStatus.NotInUnsatCore;
            default -> throw new AssertionError();
        };
    }

    public ERelevanceStatus relevanceCall(IPredicate iPredicate, ICallAction iCallAction, IPredicate iPredicate2) {
        ERelevanceStatus eRelevanceStatus = this.computeRelevancyCallWithoutUnsatCores(iPredicate, iCallAction, iPredicate2);
        this.mHoareTripleChecker.clearAssertionStack();
        return eRelevanceStatus;
    }

    private ERelevanceStatus computeRelevancyCallWithoutUnsatCores(IPredicate iPredicate, ICallAction iCallAction, IPredicate iPredicate2) {
        IncrementalPlicationChecker.Validity validity = this.mHoareTripleChecker.checkCall(iPredicate, this.constructHavocedCallAction(this.mServices, iCallAction, this.mManagedScript), iPredicate2);
        return switch (validity) {
            case IncrementalPlicationChecker.Validity.INVALID -> {
                IncrementalPlicationChecker.Validity var6_5 = this.mHoareTripleChecker.checkCall(iPredicate, iCallAction, iPredicate2);
                switch (var6_5) {
                    case INVALID: {
                        yield ERelevanceStatus.Sat;
                    }
                    case UNKNOWN: 
                    case NOT_CHECKED: {
                        yield ERelevanceStatus.unknown;
                    }
                    case VALID: {
                        yield ERelevanceStatus.InUnsatCore;
                    }
                }
                throw new AssertionError();
            }
            case IncrementalPlicationChecker.Validity.UNKNOWN, IncrementalPlicationChecker.Validity.NOT_CHECKED -> ERelevanceStatus.unknown;
            case IncrementalPlicationChecker.Validity.VALID -> ERelevanceStatus.NotInUnsatCore;
            default -> throw new AssertionError();
        };
    }

    public ERelevanceStatus relevanceReturn(IPredicate iPredicate, IPredicate iPredicate2, IReturnAction iReturnAction, IPredicate iPredicate3) {
        ERelevanceStatus eRelevanceStatus = this.computeRelevancyReturnWithoutUnsatCores(iPredicate, iPredicate2, iReturnAction, iPredicate3);
        this.mHoareTripleChecker.clearAssertionStack();
        return eRelevanceStatus;
    }

    private ERelevanceStatus computeRelevancyReturnWithoutUnsatCores(IPredicate iPredicate, IPredicate iPredicate2, IReturnAction iReturnAction, IPredicate iPredicate3) {
        IncrementalPlicationChecker.Validity validity = this.mHoareTripleChecker.checkReturn(iPredicate, iPredicate2, this.constructHavocedReturnAction(this.mServices, iReturnAction, this.mManagedScript), iPredicate3);
        return switch (validity) {
            case IncrementalPlicationChecker.Validity.INVALID -> {
                IncrementalPlicationChecker.Validity var7_6 = this.mHoareTripleChecker.checkReturn(iPredicate, iPredicate2, iReturnAction, iPredicate3);
                switch (var7_6) {
                    case INVALID: {
                        yield ERelevanceStatus.Sat;
                    }
                    case UNKNOWN: 
                    case NOT_CHECKED: {
                        yield ERelevanceStatus.unknown;
                    }
                    case VALID: {
                        yield ERelevanceStatus.InUnsatCore;
                    }
                }
                throw new AssertionError();
            }
            case IncrementalPlicationChecker.Validity.UNKNOWN, IncrementalPlicationChecker.Validity.NOT_CHECKED -> ERelevanceStatus.unknown;
            case IncrementalPlicationChecker.Validity.VALID -> ERelevanceStatus.NotInUnsatCore;
            default -> throw new AssertionError();
        };
    }

    private ERelevanceStatus getResult(IncrementalPlicationChecker.Validity validity, FaultLocalizationHoareTripleChecker faultLocalizationHoareTripleChecker) {
        return switch (validity) {
            case IncrementalPlicationChecker.Validity.INVALID -> ERelevanceStatus.Sat;
            case IncrementalPlicationChecker.Validity.VALID -> {
                boolean var4_4 = faultLocalizationHoareTripleChecker.doesUnsatCoreContainTransition();
                yield var4_4 ? ERelevanceStatus.InUnsatCore : ERelevanceStatus.NotInUnsatCore;
            }
            case IncrementalPlicationChecker.Validity.UNKNOWN -> ERelevanceStatus.unknown;
            default -> throw new IllegalArgumentException(String.format("Hoare triple check returned status '%s'.", validity));
        };
    }

    public HoareTripleCheckerStatisticsGenerator getHoareTripleCheckerStatistics() {
        return this.mHoareTripleChecker.getStatistics();
    }

    public IInternalAction constructHavocedInternalAction(IUltimateServiceProvider iUltimateServiceProvider, IInternalAction iInternalAction, ManagedScript managedScript) {
        return new BasicInternalAction(iInternalAction.getPrecedingProcedure(), iInternalAction.getSucceedingProcedure(), this.constructHavoc(iUltimateServiceProvider, iInternalAction.getTransformula(), managedScript));
    }

    public ICallAction constructHavocedCallAction(IUltimateServiceProvider iUltimateServiceProvider, ICallAction iCallAction, ManagedScript managedScript) {
        return new BasicCallAction(iCallAction.getPrecedingProcedure(), iCallAction.getSucceedingProcedure(), this.constructHavoc(iUltimateServiceProvider, iCallAction.getLocalVarsAssignment(), managedScript));
    }

    public IReturnAction constructHavocedReturnAction(IUltimateServiceProvider iUltimateServiceProvider, IReturnAction iReturnAction, ManagedScript managedScript) {
        return new BasicReturnAction(iReturnAction.getPrecedingProcedure(), iReturnAction.getSucceedingProcedure(), this.constructHavoc(iUltimateServiceProvider, iReturnAction.getAssignmentOfReturn(), managedScript), this.constructHavoc(iUltimateServiceProvider, iReturnAction.getLocalVarsAssignmentOfCall(), managedScript));
    }

    public UnmodifiableTransFormula constructHavoc(IUltimateServiceProvider iUltimateServiceProvider, UnmodifiableTransFormula unmodifiableTransFormula, ManagedScript managedScript) {
        UnmodifiableTransFormula unmodifiableTransFormula2 = FaultLocalizationRelevanceChecker.containsArraySort(unmodifiableTransFormula.getFormula()) ? TransFormulaUtils.computeGuardedHavoc((UnmodifiableTransFormula)unmodifiableTransFormula, (ManagedScript)managedScript, (IUltimateServiceProvider)iUltimateServiceProvider, (boolean)true) : TransFormulaUtils.constructHavoc((TransFormula)unmodifiableTransFormula, (ManagedScript)managedScript);
        return unmodifiableTransFormula2;
    }

    private static boolean containsArraySort(Term term2) {
        Predicate<Term> predicate = term -> SmtSortUtils.isArraySort((Sort)term.getSort());
        return new SubtermPropertyChecker(predicate).isSatisfiedBySomeSubterm(term2);
    }

    public static enum ERelevanceStatus {
        Sat,
        InUnsatCore,
        NotInUnsatCore,
        unknown;

    }

    private static class FaultLocalizationHoareTripleChecker
    extends IncrementalHoareTripleChecker {
        public FaultLocalizationHoareTripleChecker(CfgSmtToolkit cfgSmtToolkit) {
            super(cfgSmtToolkit, false);
        }

        public IncrementalPlicationChecker.Validity checkInternal(IPredicate iPredicate, IInternalAction iInternalAction, IPredicate iPredicate2) {
            this.prepareAssertionStackAndAddTransition((IAction)iInternalAction);
            this.prepareAssertionStackAndAddPrecondition(iPredicate);
            this.prepareAssertionStackAndAddPostcond(iPredicate2);
            return this.checkValidity();
        }

        public IncrementalPlicationChecker.Validity checkCall(IPredicate iPredicate, ICallAction iCallAction, IPredicate iPredicate2) {
            this.prepareAssertionStackAndAddTransition((IAction)iCallAction);
            this.prepareAssertionStackAndAddPrecondition(iPredicate);
            this.prepareAssertionStackAndAddPostcond(iPredicate2);
            return this.checkValidity();
        }

        public IncrementalPlicationChecker.Validity checkReturn(IPredicate iPredicate, IPredicate iPredicate2, IReturnAction iReturnAction, IPredicate iPredicate3) {
            this.prepareAssertionStackAndAddTransition((IAction)iReturnAction);
            this.prepareAssertionStackAndAddPrecondition(iPredicate);
            this.prepareAssertionStackAndAddHierpred(iPredicate2);
            this.prepareAssertionStackAndAddPostcond(iPredicate3);
            return this.checkValidity();
        }

        public boolean doesUnsatCoreContainTransition() {
            Term[] termArray;
            Term[] termArray2 = termArray = this.mManagedScript.getUnsatCore((Object)this);
            int n = termArray.length;
            int n2 = 0;
            while (n2 < n) {
                Term term = termArray2[n2];
                ApplicationTerm applicationTerm = (ApplicationTerm)term;
                if (applicationTerm.getFunction().getApplicationString().equals("codeBlock")) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }
}

