/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.acceleratedinterpolation.AcceleratedInterpolation;
import de.uni_freiburg.informatik.ultimate.lib.acceleratedinterpolation.AcceleratedInterpolationCore;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.interpolant.IInterpolatingTraceCheck;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.tracehandling.RefinementEngineStatisticsGenerator;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.Counterexample;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling.IpTcStrategyModuleBase;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling.TaCheckAndRefinementPreferences;

public class IpTcStrategyModuleAcceleratedInterpolation<L extends IIcfgTransition<?>>
extends IpTcStrategyModuleBase<IInterpolatingTraceCheck<L>, L> {
    private final Counterexample<L> mCounterexample;
    private final IPredicateUnifier mPredicateUnifier;
    private final TaCheckAndRefinementPreferences<L> mPrefs;
    private final ILogger mLogger;
    private final Class<L> mTransitionClazz;
    private final ManagedScript mScript;
    private final IUltimateServiceProvider mServices;
    private final AcceleratedInterpolationCore.IStrategySupplier<L> mStrategySupplier;

    public IpTcStrategyModuleAcceleratedInterpolation(IUltimateServiceProvider iUltimateServiceProvider, ILogger iLogger, Counterexample<L> counterexample, IPredicateUnifier iPredicateUnifier, TaCheckAndRefinementPreferences<L> taCheckAndRefinementPreferences, AcceleratedInterpolationCore.IStrategySupplier<L> iStrategySupplier, Class<L> clazz) {
        this.mServices = iUltimateServiceProvider;
        this.mCounterexample = counterexample;
        this.mPredicateUnifier = iPredicateUnifier;
        this.mLogger = iLogger;
        this.mPrefs = taCheckAndRefinementPreferences;
        this.mTransitionClazz = clazz;
        this.mScript = this.mPrefs.getCfgSmtToolkit().getManagedScript();
        this.mStrategySupplier = iStrategySupplier;
    }

    @Override
    protected IInterpolatingTraceCheck<L> construct() {
        return new AcceleratedInterpolation(this.mServices, this.mLogger, this.mPrefs, this.mScript, this.mPredicateUnifier, this.mCounterexample, this.mTransitionClazz, this.mPrefs.getLoopAccelerationTechnique(), this.mStrategySupplier);
    }

    public void aggregateStatistics(RefinementEngineStatisticsGenerator refinementEngineStatisticsGenerator) {
        refinementEngineStatisticsGenerator.addStatistics(RefinementEngineStatisticsGenerator.RefinementEngineStatisticsDefinitions.ACCELERATED_INTERPOLATION, this.getOrConstruct().getStatistics());
    }

    @Override
    public IPredicateUnifier getPredicateUnifier() {
        return this.mPredicateUnifier;
    }
}

