/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.convert;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.util.HashUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public final class SMTAffineTerm {
    private final Map<Term, Rational> mSummands = new LinkedHashMap<Term, Rational>();
    private Rational mConstant = Rational.ZERO;

    public SMTAffineTerm() {
    }

    public SMTAffineTerm(Term term) {
        this();
        Term[] termArray = term instanceof ApplicationTerm && ((ApplicationTerm)term).getFunction().getName().equals("+") ? ((ApplicationTerm)term).getParameters() : new Term[]{term};
        Term[] termArray2 = termArray;
        int n = termArray.length;
        int n2 = 0;
        while (n2 < n) {
            Term[] termArray3;
            Term term2;
            Term term3 = termArray2[n2];
            Rational rational = Rational.ONE;
            if (term3 instanceof ApplicationTerm && ((ApplicationTerm)term3).getFunction().getName() == "*" && (term2 = SMTAffineTerm.parseConstant((termArray3 = ((ApplicationTerm)term3).getParameters())[0])) instanceof ConstantTerm) {
                rational = SMTAffineTerm.convertConstant((ConstantTerm)term2);
                if (termArray3.length == 2) {
                    term3 = termArray3[1];
                } else {
                    Term[] termArray4 = new Term[termArray3.length - 1];
                    System.arraycopy(termArray3, 1, termArray4, 0, termArray4.length);
                    term3 = term3.getTheory().term(((ApplicationTerm)term3).getFunction(), termArray4);
                }
            }
            if (term3 instanceof ApplicationTerm && ((ApplicationTerm)term3).getFunction().getName() == "-" && ((ApplicationTerm)term3).getParameters().length == 1) {
                rational = rational.negate();
                term3 = ((ApplicationTerm)term3).getParameters()[0];
            }
            if (term3 instanceof ApplicationTerm && ((ApplicationTerm)term3).getFunction().getName() == "to_real") {
                term3 = ((ApplicationTerm)term3).getParameters()[0];
            }
            if ((term3 = SMTAffineTerm.parseConstant(term3)) instanceof ConstantTerm) {
                assert (rational == Rational.ONE && this.mConstant == Rational.ZERO);
                this.mConstant = SMTAffineTerm.convertConstant((ConstantTerm)term3);
            } else {
                assert (!this.mSummands.containsKey(term3));
                this.mSummands.put(term3, rational);
            }
            ++n2;
        }
    }

    public static SMTAffineTerm create(Term term) {
        return new SMTAffineTerm(term);
    }

    public static boolean isToReal(Term term) {
        return term instanceof ApplicationTerm && ((ApplicationTerm)term).getFunction().getName().equals("to_real");
    }

    public static Term parseConstant(Term term) {
        Rational rational;
        Term term2;
        Rational rational2;
        boolean bl = false;
        if (term instanceof ApplicationTerm && ((ApplicationTerm)term).getFunction().getName().equals("/")) {
            rational2 = ((ApplicationTerm)term).getParameters();
            term2 = rational2[0];
            if (SMTAffineTerm.isToReal(rational2[1])) {
                rational2[1] = ((ApplicationTerm)rational2[1]).getParameters()[0];
            }
            if (!(rational2[1] instanceof ConstantTerm)) {
                return term;
            }
            rational = SMTAffineTerm.convertConstant((ConstantTerm)rational2[1]);
            if (rational == Rational.ZERO) {
                return term;
            }
        } else {
            term2 = term;
            rational = Rational.ONE;
        }
        if (term2 instanceof ApplicationTerm && ((ApplicationTerm)term2).getFunction().getName().equals("-") && ((ApplicationTerm)term2).getParameters().length == 1) {
            term2 = ((ApplicationTerm)term2).getParameters()[0];
            bl = true;
        }
        if (SMTAffineTerm.isToReal(term2)) {
            term2 = ((ApplicationTerm)term2).getParameters()[0];
        }
        if (!(term2 instanceof ConstantTerm)) {
            return term;
        }
        rational2 = SMTAffineTerm.convertConstant((ConstantTerm)term2).mul(rational.inverse());
        if (bl) {
            rational2 = rational2.negate();
        }
        return rational2.toTerm(term.getSort());
    }

    public void mul(Rational rational) {
        if (rational == Rational.ZERO) {
            this.mSummands.clear();
            this.mConstant = Rational.ZERO;
            return;
        }
        for (Map.Entry<Term, Rational> entry : this.mSummands.entrySet()) {
            entry.setValue(entry.getValue().mul(rational));
        }
        this.mConstant = this.mConstant.mul(rational);
    }

    public void add(Rational rational) {
        this.mConstant = this.mConstant.add(rational);
    }

    public void add(Rational rational, Term term) {
        SMTAffineTerm sMTAffineTerm = new SMTAffineTerm(term);
        this.add(rational, sMTAffineTerm);
    }

    public void add(Rational rational, SMTAffineTerm sMTAffineTerm) {
        for (Map.Entry<Term, Rational> entry : sMTAffineTerm.mSummands.entrySet()) {
            Term term = entry.getKey();
            Rational rational2 = rational.mul(entry.getValue());
            if (this.mSummands.containsKey(term)) {
                Rational rational3 = this.mSummands.get(term).add(rational2);
                if (rational3.equals((Object)Rational.ZERO)) {
                    this.mSummands.remove(term);
                    continue;
                }
                this.mSummands.put(term, rational3);
                continue;
            }
            this.mSummands.put(term, rational2);
        }
        this.mConstant = this.mConstant.add(rational.mul(sMTAffineTerm.mConstant));
    }

    public void add(SMTAffineTerm sMTAffineTerm) {
        this.add(Rational.ONE, sMTAffineTerm);
    }

    public static Rational convertConstant(ConstantTerm constantTerm) {
        Rational rational;
        Object object = constantTerm.getValue();
        if (object instanceof BigInteger) {
            rational = Rational.valueOf((BigInteger)((BigInteger)object), (BigInteger)BigInteger.ONE);
        } else if (object instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)object;
            if (bigDecimal.scale() <= 0) {
                BigInteger bigInteger = bigDecimal.toBigInteger();
                rational = Rational.valueOf((BigInteger)bigInteger, (BigInteger)BigInteger.ONE);
            } else {
                BigInteger bigInteger = bigDecimal.unscaledValue();
                BigInteger bigInteger2 = BigInteger.TEN.pow(bigDecimal.scale());
                rational = Rational.valueOf((BigInteger)bigInteger, (BigInteger)bigInteger2);
            }
        } else if (object instanceof Rational) {
            rational = (Rational)object;
        } else {
            throw new InternalError("Something went wrong with constants!");
        }
        return rational;
    }

    public void div(Rational rational) {
        this.mul(rational.inverse());
    }

    public void negate() {
        this.mul(Rational.MONE);
    }

    public boolean isConstant() {
        return this.mSummands.isEmpty();
    }

    public Rational getConstant() {
        return this.mConstant;
    }

    Rational getCoefficient(Term term) {
        Rational rational = this.mSummands.get(term);
        return rational == null ? Rational.ZERO : rational;
    }

    public Rational getGcd() {
        assert (!this.mSummands.isEmpty());
        Iterator<Rational> iterator = this.mSummands.values().iterator();
        Rational rational = iterator.next().abs();
        while (iterator.hasNext()) {
            rational = rational.gcd(iterator.next().abs());
        }
        return rational;
    }

    public Map<Term, Rational> getSummands() {
        return this.mSummands;
    }

    public Term toTerm(Sort sort) {
        assert (sort.isNumericSort());
        Theory theory = sort.getTheory();
        int n = this.mSummands.size();
        if (n == 0 || !this.mConstant.equals((Object)Rational.ZERO)) {
            ++n;
        }
        Term[] termArray = new Term[n];
        int n2 = 0;
        for (Map.Entry<Term, Rational> entry : this.mSummands.entrySet()) {
            Term term = entry.getKey();
            if (!term.getSort().equals(sort)) {
                term = theory.term("to_real", new Term[]{term});
            }
            if (!entry.getValue().equals((Object)Rational.ONE)) {
                Term term2 = entry.getValue().toTerm(sort);
                term = theory.term("*", new Term[]{term2, term});
            }
            termArray[n2++] = term;
        }
        if (n2 < n) {
            termArray[n2++] = this.mConstant.toTerm(sort);
        }
        return n == 1 ? termArray[0] : theory.term("+", termArray);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = "";
        for (Map.Entry<Term, Rational> entry : this.mSummands.entrySet()) {
            stringBuilder.append(string);
            String string2 = entry.getKey().toString();
            if (entry.getValue() == Rational.ONE) {
                stringBuilder.append(string2);
            } else if (entry.getValue() == Rational.MONE) {
                stringBuilder.append("-").append(string2);
            } else {
                stringBuilder.append(entry.getValue()).append(" * ").append(string2);
            }
            string = " + ";
        }
        if (this.mSummands.isEmpty() || this.mConstant != Rational.ZERO) {
            stringBuilder.append(string).append(this.mConstant);
        }
        return stringBuilder.toString();
    }

    public boolean isAllIntSummands() {
        for (Map.Entry<Term, Rational> entry : this.mSummands.entrySet()) {
            if (entry.getKey().getSort().getName().equals("Int")) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (!(object instanceof SMTAffineTerm)) {
            return false;
        }
        SMTAffineTerm sMTAffineTerm = (SMTAffineTerm)object;
        return this.mSummands.equals(sMTAffineTerm.mSummands) && this.mConstant.equals((Object)sMTAffineTerm.mConstant);
    }

    public int hashCode() {
        return HashUtils.hashJenkins((int)this.mConstant.hashCode(), this.mSummands);
    }

    public static final Rational constDiv(Rational rational, Rational rational2) {
        Rational rational3 = rational.div(rational2);
        return rational2.isNegative() ? rational3.ceil() : rational3.floor();
    }

    public static Rational mod(Rational rational, Rational rational2) {
        Rational rational3 = rational.sub(SMTAffineTerm.constDiv(rational, rational2).mul(rational2));
        return rational3;
    }

    public void mod(Rational rational) {
        Iterator<Map.Entry<Term, Rational>> iterator = this.mSummands.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Term, Rational> entry = iterator.next();
            Rational rational2 = SMTAffineTerm.mod(entry.getValue(), rational);
            if (rational2 == Rational.ZERO) {
                iterator.remove();
                continue;
            }
            entry.setValue(rational2);
        }
        this.mConstant = SMTAffineTerm.mod(this.mConstant, rational);
    }
}

