/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.ematching;

import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CClosure;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.ematching.EMatching;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.ematching.ICode;
import java.util.Arrays;
import java.util.List;

public class FindCode
implements ICode {
    private final EMatching mEMatching;
    private final CClosure mCClosure;
    private final FunctionSymbol mFunc;
    private final int mOutRegIndex;
    private final ICode mRemainingCode;

    public FindCode(EMatching eMatching, CClosure cClosure, FunctionSymbol functionSymbol, int n, ICode iCode) {
        this.mEMatching = eMatching;
        this.mCClosure = cClosure;
        this.mFunc = functionSymbol;
        this.mOutRegIndex = n;
        this.mRemainingCode = iCode;
    }

    @Override
    public void execute(CCTerm[] cCTermArray, int n) {
        if (this.mFunc.getParameterSorts().length > 0) {
            this.mEMatching.installFindTrigger(this.mFunc, this.mOutRegIndex, this.mRemainingCode, cCTermArray, n);
        }
        List<CCTerm> list = this.mCClosure.getAllFuncApps(this.mFunc);
        for (CCTerm cCTerm : list) {
            CCTerm[] cCTermArray2 = Arrays.copyOf(cCTermArray, cCTermArray.length);
            cCTermArray2[this.mOutRegIndex] = cCTerm;
            this.mEMatching.addCode(this.mRemainingCode, cCTermArray2, n > 0 ? n : 0);
        }
    }

    public String toString() {
        return "find(" + String.valueOf(this.mFunc) + ", r" + this.mOutRegIndex + ",\n" + this.mRemainingCode.toString() + ")";
    }
}

