/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.witnessparser.graph;

import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.ModernAnnotations;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelUtils;
import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.Visualizable;
import de.uni_freiburg.informatik.ultimate.witnessparser.Activator;
import de.uni_freiburg.informatik.ultimate.witnessparser.graph.WitnessNode;

public class WitnessNodeAnnotation
extends ModernAnnotations {
    private static final long serialVersionUID = 1L;
    private static final String KEY = Activator.PLUGIN_ID + "_Node";
    @Visualizable
    private final boolean mIsInitial;
    @Visualizable
    private final boolean mIsError;
    @Visualizable
    private final boolean mIsSink;
    @Visualizable
    private final String mInvariant;

    public WitnessNodeAnnotation(boolean bl, boolean bl2, boolean bl3, String string) {
        this.mIsInitial = bl;
        this.mIsError = bl2;
        this.mIsSink = bl3;
        this.mInvariant = string;
    }

    public String getInvariant() {
        return this.mInvariant;
    }

    public boolean isInitial() {
        return this.mIsInitial;
    }

    public boolean isError() {
        return this.mIsError;
    }

    public boolean isSink() {
        return this.mIsSink;
    }

    public boolean isDefault() {
        return !this.mIsInitial && !this.mIsError && !this.mIsSink && this.mInvariant == null;
    }

    public void annotate(IElement iElement) {
        if (iElement instanceof WitnessNode) {
            this.annotate((WitnessNode)iElement);
        }
    }

    public void annotate(WitnessNode witnessNode) {
        witnessNode.getPayload().getAnnotations().put(KEY, this);
    }

    public static WitnessNodeAnnotation getAnnotation(IElement iElement) {
        return (WitnessNodeAnnotation)ModelUtils.getAnnotation((IElement)iElement, (String)KEY, iAnnotations -> (WitnessNodeAnnotation)((Object)iAnnotations));
    }
}

