/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker.variables;

import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.TermException;
import de.uni_freiburg.informatik.ultimate.lassoranker.LinearInequality;
import de.uni_freiburg.informatik.ultimate.lassoranker.exceptions.TermIsNotAffineException;
import de.uni_freiburg.informatik.ultimate.lassoranker.exceptions.UnknownFunctionException;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.ArrayList;
import java.util.List;

public class InequalityConverter {
    private static LinearInequality convertAtom(ApplicationTerm applicationTerm) throws TermException {
        LinearInequality linearInequality;
        if (applicationTerm.getParameters().length != 2) {
            throw new TermIsNotAffineException("Unsupported number of parameters", (Term)applicationTerm);
        }
        String string = applicationTerm.getFunction().getName();
        LinearInequality linearInequality2 = LinearInequality.fromTerm(applicationTerm.getParameters()[0]);
        LinearInequality linearInequality3 = LinearInequality.fromTerm(applicationTerm.getParameters()[1]);
        if (string.equals(">=")) {
            linearInequality3.mult(Rational.MONE);
            linearInequality = linearInequality2;
            linearInequality.add(linearInequality3);
            linearInequality.setStrict(false);
        } else if (string.equals("<=")) {
            linearInequality2.mult(Rational.MONE);
            linearInequality = linearInequality2;
            linearInequality.add(linearInequality3);
            linearInequality.setStrict(false);
        } else if (string.equals(">")) {
            linearInequality3.mult(Rational.MONE);
            linearInequality = linearInequality2;
            linearInequality.add(linearInequality3);
            linearInequality.setStrict(true);
        } else if (string.equals("<")) {
            linearInequality = linearInequality2;
            linearInequality.mult(Rational.MONE);
            linearInequality.add(linearInequality3);
            linearInequality.setStrict(true);
        } else {
            throw new TermIsNotAffineException("Expected an inequality.", (Term)applicationTerm);
        }
        return linearInequality;
    }

    /*
     * Unable to fully structure code
     */
    public static List<LinearInequality> convert(Term var0, NlaHandling var1_1) throws TermException {
        block8: {
            block9: {
                block7: {
                    var2_2 = new ArrayList<LinearInequality>();
                    if (!(var0 instanceof ApplicationTerm)) ** GOTO lbl40
                    var3_3 = (ApplicationTerm)var0;
                    var4_4 = var3_3.getFunction().getName();
                    if (!var4_4.equals("and")) break block7;
                    var8_5 = var3_3.getParameters();
                    var7_6 = var8_5.length;
                    var6_8 = 0;
                    while (var6_8 < var7_6) {
                        var5_10 = var8_5[var6_8];
                        var2_2.addAll(InequalityConverter.convert(var5_10, var1_1));
                        ++var6_8;
                    }
                    break block8;
                }
                if (!var4_4.equals("true")) break block9;
                var5_11 = new LinearInequality();
                var2_2.add(var5_11);
                break block8;
            }
            if (!var4_4.equals("=")) ** GOTO lbl34
            var5_12 = var3_3.getParameters()[0];
            var6_9 = var5_12.getSort();
            if (var6_9.isNumericSort()) {
                var7_7 = InequalityConverter.tryToConvertAtom(var1_1, var3_3);
                var2_2.add(var7_7);
            } else {
                if (SmtSortUtils.isBoolSort((Sort)var6_9)) {
                    throw new TermException("Term is not in DNF", var0);
                }
                throw new TermException("Unknown sort in equality", var0);
lbl34:
                // 1 sources

                if (var4_4.equals("<") || var4_4.equals(">") || var4_4.equals("<=") || var4_4.equals(">=")) {
                    var5_13 = InequalityConverter.tryToConvertAtom(var1_1, var3_3);
                    var2_2.add(var5_13);
                } else {
                    throw new UnknownFunctionException(var3_3);
lbl40:
                    // 1 sources

                    if (var0 instanceof TermVariable) {
                        throw new TermException("Term is not in DNF", var0);
                    }
                    throw new TermException("Expected application term", var0);
                }
            }
        }
        return var2_2;
    }

    private static LinearInequality tryToConvertAtom(NlaHandling nlaHandling, ApplicationTerm applicationTerm) throws TermException, TermIsNotAffineException {
        LinearInequality linearInequality;
        try {
            linearInequality = InequalityConverter.convertAtom(applicationTerm);
        }
        catch (TermIsNotAffineException termIsNotAffineException) {
            if (termIsNotAffineException.getMessage().equals("Product with more than one non-constant factors found")) {
                linearInequality = switch (nlaHandling) {
                    case NlaHandling.EXCEPTION -> throw termIsNotAffineException;
                    case NlaHandling.OVERAPPROXIMATE -> new LinearInequality();
                    case NlaHandling.UNDERAPPROXIMATE -> LinearInequality.constructFalse();
                    default -> throw new MatchException(null, null);
                };
            }
            throw termIsNotAffineException;
        }
        return linearInequality;
    }

    public static enum NlaHandling {
        OVERAPPROXIMATE,
        UNDERAPPROXIMATE,
        EXCEPTION;

    }
}

