/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata;

import de.uni_freiburg.informatik.ultimate.util.CoreUtil;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Map;

public abstract class GeneralAutomatonPrinter {
    public static final char QUOTE = '\"';
    public static final String NEW_LINE = System.lineSeparator();
    private final PrintWriter mPrintWriter;
    private StringBuilder mStringBuilder;

    protected GeneralAutomatonPrinter(PrintWriter printWriter) {
        this.mPrintWriter = printWriter;
        this.mStringBuilder = new StringBuilder();
    }

    protected void finish() {
        BufferedWriter bufferedWriter = new BufferedWriter(this.mPrintWriter);
        try {
            bufferedWriter.write(this.mStringBuilder.toString());
            bufferedWriter.flush();
            this.mStringBuilder = new StringBuilder();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    protected final void println(String string) {
        this.mStringBuilder.append(string).append(CoreUtil.getPlatformLineSeparator());
    }

    protected final void println(char c) {
        this.mStringBuilder.append(c).append(CoreUtil.getPlatformLineSeparator());
    }

    protected final void print(String string) {
        this.mStringBuilder.append(string);
    }

    protected final void printElement(String string) {
        this.mStringBuilder.append(string).append(' ');
    }

    protected final void print(char c) {
        this.mStringBuilder.append(c);
    }

    protected final void print(StringBuilder stringBuilder) {
        this.mStringBuilder.append((CharSequence)stringBuilder);
    }

    protected final void printAutomatonPrefix() {
        this.println(" = (");
    }

    protected final void printAutomatonSuffix() {
        this.println(");");
    }

    protected final void printValues(Map<?, String> map) {
        this.printCollection(map.values());
    }

    protected void printCollection(Collection<String> collection) {
        for (String string : collection) {
            this.printElement(string);
        }
    }

    private static String getCollectionPrefix(String string) {
        return String.format("\t%s = {", string);
    }

    protected final void printCollectionPrefix(String string) {
        this.print(GeneralAutomatonPrinter.getCollectionPrefix(string));
    }

    protected final void printlnCollectionPrefix(String string) {
        this.println(GeneralAutomatonPrinter.getCollectionPrefix(string));
    }

    private static String replaceBackslashes(Object object) {
        return object.toString().replace('\"', '\"');
    }

    public static final String quoteAndReplaceBackslashes(Object object) {
        return "\"" + GeneralAutomatonPrinter.replaceBackslashes(object) + "\"";
    }

    public static final String quoteAndReplaceBackslashes(Object object, String string) {
        return "\"" + GeneralAutomatonPrinter.replaceBackslashes(object) + string + "\"";
    }

    protected final void printCollectionSuffix() {
        this.println("},");
    }

    protected final void printOneTransitionPrefix() {
        this.print("\t\t(");
    }

    protected final void printOneTransitionSuffix() {
        this.println(')');
    }

    protected final void printTransitionsSuffix() {
        this.print("\t}");
    }

    protected final void printTransitionListSeparator() {
        this.println(",");
    }

    protected final void printLastTransitionLineSeparator() {
        this.println("");
    }
}

