/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.alternating;

public final class BitUtil {
    private static final long[] MASKS_SINGLE_BIT = new long[64];

    static {
        int n = 0;
        while (n < MASKS_SINGLE_BIT.length) {
            BitUtil.MASKS_SINGLE_BIT[n] = 1L << n;
            ++n;
        }
    }

    private BitUtil() {
    }

    public static long setBit(long l, int n, boolean bl) {
        if (bl) {
            return BitUtil.setBit(l, n);
        }
        return BitUtil.unsetBit(l, n);
    }

    public static long setBit(long l, int n) {
        return l | MASKS_SINGLE_BIT[n];
    }

    public static long unsetBit(long l, int n) {
        return l & (MASKS_SINGLE_BIT[n] ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static int getNextSetBit(long l, int n) {
        int n2 = n;
        while (n2 < 64) {
            if (BitUtil.getBit(l, n2)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public static boolean getBit(long l, int n) {
        return (l & MASKS_SINGLE_BIT[n]) != 0L;
    }

    public static String getText(long l) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (n < 64) {
            long l2 = l & 1L;
            stringBuilder.append(l2 == 1L ? 1 : 0);
            l >>>= 1;
            ++n;
        }
        return stringBuilder.toString();
    }
}

