/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.alternating;

import java.util.BitSet;
import java.util.List;
import java.util.Map;

public class BooleanExpression {
    private final BitSet mAlpha;
    private final BitSet mBeta;
    private BooleanExpression mNextConjunctExpression;

    public BooleanExpression(BitSet bitSet, BitSet bitSet2) {
        this.mAlpha = bitSet;
        this.mBeta = bitSet2;
    }

    public void addConjunction(BooleanExpression booleanExpression) {
        if (!this.containsConjunction(booleanExpression)) {
            if (this.mNextConjunctExpression != null) {
                this.mNextConjunctExpression.addConjunction(booleanExpression);
            } else {
                this.mNextConjunctExpression = booleanExpression;
            }
        }
    }

    public boolean containsConjunction(BooleanExpression booleanExpression) {
        if (this.equals(booleanExpression)) {
            return true;
        }
        if (this.mNextConjunctExpression != null) {
            this.mNextConjunctExpression.containsConjunction(booleanExpression);
        }
        return false;
    }

    public boolean getResult(BitSet bitSet) {
        BitSet bitSet2 = (BitSet)bitSet.clone();
        bitSet2.and(this.mAlpha);
        bitSet2.xor(this.mBeta);
        if (bitSet2.isEmpty()) {
            return true;
        }
        if (this.mNextConjunctExpression != null) {
            return this.mNextConjunctExpression.getResult(bitSet);
        }
        return false;
    }

    public BooleanExpression cloneShifted(Map<Integer, Integer> map, int n) {
        Map.Entry<Integer, Integer> entry2;
        BitSet bitSet = new BitSet(n);
        BitSet bitSet2 = new BitSet(n);
        for (Map.Entry<Integer, Integer> entry2 : map.entrySet()) {
            if (this.mAlpha.get((Integer)entry2.getKey())) {
                bitSet.set((Integer)entry2.getValue());
            }
            if (!this.mBeta.get((Integer)entry2.getKey())) continue;
            bitSet2.set((Integer)entry2.getValue());
        }
        entry2 = new BooleanExpression(bitSet, bitSet2);
        if (this.mNextConjunctExpression != null) {
            ((BooleanExpression)((Object)entry2)).mNextConjunctExpression = this.mNextConjunctExpression.cloneShifted(map, n);
        }
        return entry2;
    }

    public boolean equals(BooleanExpression booleanExpression) {
        return this.mAlpha.equals(booleanExpression.mAlpha) && this.mBeta.equals(booleanExpression.mBeta);
    }

    public <T> String toString(List<T> list) {
        Object object = "";
        int n = 0;
        int n2 = 0;
        while (n2 < list.size()) {
            if (this.mAlpha.get(n2)) {
                if (n != 0) {
                    object = (String)object + " ^ ";
                }
                if (!this.mBeta.get(n2)) {
                    object = (String)object + "~";
                }
                object = (String)object + String.valueOf(list.get(n2));
                ++n;
            }
            ++n2;
        }
        if (this.mNextConjunctExpression != null) {
            if (n > 1) {
                object = "(" + (String)object + ")";
            }
            object = (String)object + " v " + this.mNextConjunctExpression.toString(list);
        }
        return object;
    }

    public BitSet getAlpha() {
        return this.mAlpha;
    }

    public BitSet getBeta() {
        return this.mBeta;
    }

    public BooleanExpression getNextConjunctExpression() {
        return this.mNextConjunctExpression;
    }
}

