/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.SetOfStates;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaSuccessorStateProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.VpAlphabet;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.LevelRankingState;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.StateWithRankInfo;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.NwaToBuchiWrapper;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.complement.BuchiNwaComplement;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.complement.NCSB;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.complement.StateNwaNCSB;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.util.IntIterator;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.util.IntSet;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.util.UtilIntSet;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IBuchiComplementNcsbStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class BuchiComplementNCSBSimpleNwa2<LETTER, STATE>
implements INwaSuccessorStateProvider<LETTER, STATE> {
    private final AutomataLibraryServices mServices;
    private final SetOfStates<STATE> mSetOfStates;
    private final INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> mOperand;
    private final IBuchiComplementNcsbStateFactory<STATE> mStateFactory;
    private final StateWithRankInfo<STATE> mEmptyStackStateWri;
    private final BuchiNwaComplement mComplementBuchi;
    private final Map<LETTER, Integer> mLetterIdMap;
    private final Map<Integer, STATE> mIdStateMap;
    private final Map<STATE, Integer> mStateIdMap;
    private final NwaToBuchiWrapper<LETTER, STATE> mOperandBuchi;
    private final Map<LevelRankingState<LETTER, STATE>, STATE> mDet2res = new HashMap<LevelRankingState<LETTER, STATE>, STATE>();
    private final Map<Integer, LevelRankingState<LETTER, STATE>> mInt2LevelRanks = new HashMap<Integer, LevelRankingState<LETTER, STATE>>();

    public BuchiComplementNCSBSimpleNwa2(AutomataLibraryServices automataLibraryServices, IBuchiComplementNcsbStateFactory<STATE> iBuchiComplementNcsbStateFactory, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider) throws AutomataOperationCanceledException {
        Object object2;
        IntSet intSet3;
        this.mServices = automataLibraryServices;
        this.mOperand = iNwaOutgoingLetterAndTransitionProvider;
        this.mStateFactory = iBuchiComplementNcsbStateFactory;
        this.mSetOfStates = new SetOfStates(this.mStateFactory.createEmptyStackState());
        this.mIdStateMap = new HashMap<Integer, STATE>();
        this.mStateIdMap = new HashMap<STATE, Integer>();
        int n = 0;
        this.mLetterIdMap = new HashMap<LETTER, Integer>();
        VpAlphabet vpAlphabet = iNwaOutgoingLetterAndTransitionProvider.getVpAlphabet();
        IntSet intSet2 = UtilIntSet.newIntSet();
        for (IntSet intSet3 : vpAlphabet.getCallAlphabet()) {
            this.mLetterIdMap.put(intSet3, n);
            intSet2.set(n);
            ++n;
        }
        intSet3 = UtilIntSet.newIntSet();
        for (Object object2 : vpAlphabet.getInternalAlphabet()) {
            this.mLetterIdMap.put(object2, n);
            intSet3.set(n);
            ++n;
        }
        object2 = UtilIntSet.newIntSet();
        for (Iterator iterator : vpAlphabet.getReturnAlphabet()) {
            this.mLetterIdMap.put(iterator, n);
            object2.set(n);
            ++n;
        }
        this.mEmptyStackStateWri = new StateWithRankInfo<STATE>(this.mSetOfStates.getEmptyStackState());
        this.mOperandBuchi = new NwaToBuchiWrapper<LETTER, STATE>(intSet2, intSet3, (IntSet)object2, this.mLetterIdMap, iNwaOutgoingLetterAndTransitionProvider);
        this.mComplementBuchi = new BuchiNwaComplement(this.mOperandBuchi);
        this.constructInitialState();
    }

    private void constructInitialState() {
        IntSet intSet = this.mComplementBuchi.getInitialStates();
        IntIterator intIterator = intSet.iterator();
        while (intIterator.hasNext()) {
            int n = intIterator.next();
            this.getOrAdd(true, n);
        }
    }

    protected STATE getRelatedSTATE(int n) {
        LevelRankingState<LETTER, STATE> levelRankingState = this.constructLevelRankingState(n);
        STATE STATE = this.mStateFactory.buchiComplementNcsb(levelRankingState);
        this.mDet2res.put(levelRankingState, STATE);
        return STATE;
    }

    private StateWithRankInfo<STATE> getStackState(int n) {
        StateWithRankInfo<STATE> stateWithRankInfo = null;
        stateWithRankInfo = n == -1 ? this.mEmptyStackStateWri : new StateWithRankInfo<STATE>(this.mOperandBuchi.getNwaSTATE(n));
        return stateWithRankInfo;
    }

    protected LevelRankingState<LETTER, STATE> constructLevelRankingState(int n) {
        LevelRankingState<LETTER, STATE> levelRankingState = this.mInt2LevelRanks.get(n);
        if (levelRankingState != null) {
            return levelRankingState;
        }
        StateNwaNCSB stateNwaNCSB = (StateNwaNCSB)this.mComplementBuchi.getState(n);
        NCSB nCSB = stateNwaNCSB.getNCSB();
        levelRankingState = new LevelRankingState<LETTER, STATE>(this.mOperand);
        IntSet intSet = nCSB.getBSet();
        IntSet intSet2 = nCSB.getNSet();
        this.addLevelRankingState(levelRankingState, intSet2, 3, false);
        intSet2 = nCSB.copyCSet();
        intSet2.andNot(intSet);
        this.addLevelRankingState(levelRankingState, intSet2, 2, false);
        intSet2 = nCSB.copyCSet();
        intSet2.and(intSet);
        this.addLevelRankingState(levelRankingState, intSet2, 2, true);
        this.addLevelRankingState(levelRankingState, nCSB.getSSet(), 1, false);
        return levelRankingState;
    }

    private void addLevelRankingState(LevelRankingState<LETTER, STATE> levelRankingState, IntSet intSet, int n, boolean bl) {
        IntIterator intIterator = intSet.iterator();
        while (intIterator.hasNext()) {
            int n2 = intIterator.next();
            int n3 = this.mComplementBuchi.getDownState(n2);
            int n4 = this.mComplementBuchi.getUpState(n2);
            levelRankingState.addRank(this.getStackState(n3), this.mOperandBuchi.getNwaSTATE(n4), n, bl);
        }
    }

    private STATE getOrAdd(boolean bl, int n) {
        STATE STATE = this.mIdStateMap.get(n);
        if (STATE == null) {
            STATE = this.getRelatedSTATE(n);
            this.mIdStateMap.put(n, STATE);
            this.mStateIdMap.put(STATE, n);
            this.mSetOfStates.addState(bl, this.mComplementBuchi.isFinal(n), STATE);
        } else assert (!bl);
        return STATE;
    }

    @Override
    public Iterable<STATE> getInitialStates() {
        return this.mSetOfStates.getInitialStates();
    }

    @Override
    public VpAlphabet<LETTER> getVpAlphabet() {
        return this.mOperand.getVpAlphabet();
    }

    @Override
    public IStateFactory<STATE> getStateFactory() {
        return this.mStateFactory;
    }

    @Override
    public boolean isInitial(STATE STATE) {
        return this.mSetOfStates.isInitial(STATE);
    }

    @Override
    public boolean isFinal(STATE STATE) {
        return this.mSetOfStates.isAccepting(STATE);
    }

    @Override
    public STATE getEmptyStackState() {
        return this.mSetOfStates.getEmptyStackState();
    }

    @Override
    public int size() {
        return this.mSetOfStates.getStates().size();
    }

    @Override
    public String sizeInformation() {
        return "State size: " + this.mSetOfStates.getStates().size();
    }

    @Override
    public Collection<STATE> internalSuccessors(STATE STATE, LETTER LETTER) {
        int n = this.mLetterIdMap.get(LETTER);
        StateNwaNCSB stateNwaNCSB = (StateNwaNCSB)this.mComplementBuchi.getState(this.mStateIdMap.get(STATE));
        IntSet intSet = stateNwaNCSB.getSuccessorsInternal(n);
        return this.computeSuccessors(intSet);
    }

    @Override
    public Collection<STATE> callSuccessors(STATE STATE, LETTER LETTER) {
        int n = this.mLetterIdMap.get(LETTER);
        StateNwaNCSB stateNwaNCSB = (StateNwaNCSB)this.mComplementBuchi.getState(this.mStateIdMap.get(STATE));
        IntSet intSet = stateNwaNCSB.getSuccessorsCall(n);
        return this.computeSuccessors(intSet);
    }

    private Collection<STATE> computeSuccessors(IntSet intSet) {
        IntIterator intIterator = intSet.iterator();
        ArrayList<STATE> arrayList = new ArrayList<STATE>();
        while (intIterator.hasNext()) {
            STATE STATE = this.getOrAdd(false, intIterator.next());
            arrayList.add(STATE);
        }
        return arrayList;
    }

    @Override
    public Collection<STATE> returnSuccessorsGivenHier(STATE STATE, STATE STATE2, LETTER LETTER) {
        int n = this.mLetterIdMap.get(LETTER);
        StateNwaNCSB stateNwaNCSB = (StateNwaNCSB)this.mComplementBuchi.getState(this.mStateIdMap.get(STATE));
        IntSet intSet = stateNwaNCSB.getSuccessorsReturn(this.mStateIdMap.get(STATE2), n);
        return this.computeSuccessors(intSet);
    }

    @Override
    public IElement transformToUltimateModel(AutomataLibraryServices automataLibraryServices) throws AutomataOperationCanceledException {
        throw new UnsupportedOperationException();
    }
}

