/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.Analyze;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.AGameGraph;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.GameGraphSuccessorProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.SimulationOrMinimizationType;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.performance.CountingMeasure;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.performance.MultipleDataOption;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.performance.SimulationPerformance;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.performance.TimeMeasure;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.DuplicatorVertex;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.SpoilerVertex;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.Vertex;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.VertexPmReverseComparator;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IProgressAwareTimer;
import de.uni_freiburg.informatik.ultimate.util.scc.DefaultStronglyConnectedComponentFactory;
import de.uni_freiburg.informatik.ultimate.util.scc.SccComputation;
import de.uni_freiburg.informatik.ultimate.util.scc.StronglyConnectedComponent;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Set;

public abstract class ASimulation<LETTER, STATE> {
    protected INestedWordAutomaton<LETTER, STATE> mResult;
    private final ILogger mLogger;
    private final SimulationPerformance mPerformance;
    private final IProgressAwareTimer mProgressTimer;
    private SccComputation<Vertex<LETTER, STATE>, StronglyConnectedComponent<Vertex<LETTER, STATE>>> mSccComp;
    private final IStateFactory<STATE> mStateFactory;
    private boolean mUseSccs;
    private final VertexPmReverseComparator<LETTER, STATE> mVertexComp;
    private PriorityQueue<Vertex<LETTER, STATE>> mWorkingList;

    public ASimulation(IProgressAwareTimer iProgressAwareTimer, ILogger iLogger, boolean bl, IStateFactory<STATE> iStateFactory, SimulationOrMinimizationType simulationOrMinimizationType) throws AutomataOperationCanceledException {
        Objects.requireNonNull(iProgressAwareTimer);
        this.mProgressTimer = iProgressAwareTimer;
        this.mLogger = iLogger;
        this.mUseSccs = bl;
        this.mStateFactory = iStateFactory;
        this.mVertexComp = new VertexPmReverseComparator();
        this.mSccComp = null;
        this.mPerformance = new SimulationPerformance(simulationOrMinimizationType, bl);
    }

    public void doSimulation() throws AutomataOperationCanceledException {
        this.mPerformance.startTimeMeasure(TimeMeasure.OVERALL);
        this.mPerformance.startTimeMeasure(TimeMeasure.SIMULATION_ONLY);
        if (this.mUseSccs) {
            this.mPerformance.startTimeMeasure(TimeMeasure.BUILD_SCC);
            DefaultStronglyConnectedComponentFactory defaultStronglyConnectedComponentFactory = new DefaultStronglyConnectedComponentFactory();
            GameGraphSuccessorProvider<LETTER, STATE> gameGraphSuccessorProvider = new GameGraphSuccessorProvider<LETTER, STATE>(this.getGameGraph());
            this.mSccComp = new SccComputation(this.mLogger, gameGraphSuccessorProvider, (SccComputation.IStronglyConnectedComponentFactory)defaultStronglyConnectedComponentFactory, this.getGameGraph().getSize(), this.getGameGraph().getVertices());
            Iterator iterator = new LinkedList(this.mSccComp.getSCCs()).iterator();
            this.mPerformance.stopTimeMeasure(TimeMeasure.BUILD_SCC);
            int n = 0;
            while (iterator.hasNext()) {
                StronglyConnectedComponent stronglyConnectedComponent = (StronglyConnectedComponent)iterator.next();
                iterator.remove();
                this.efficientLiftingAlgorithm(this.calculateInfinityOfSCC(stronglyConnectedComponent), stronglyConnectedComponent.getNodes());
                ++n;
            }
            this.mPerformance.setCountingMeasure(CountingMeasure.SCCS, n);
        } else {
            this.efficientLiftingAlgorithm(this.getGameGraph().getGlobalInfinity(), null);
            this.mPerformance.addTimeMeasureValue(TimeMeasure.BUILD_SCC, -1L);
            this.mPerformance.setCountingMeasure(CountingMeasure.SCCS, -1);
        }
        this.simulationHook();
        this.mPerformance.stopTimeMeasure(TimeMeasure.SIMULATION_ONLY);
        this.mResult = this.getGameGraph().generateAutomatonFromGraph();
        long l = this.mPerformance.stopTimeMeasure(TimeMeasure.OVERALL);
        long l2 = this.mPerformance.getTimeMeasureResult(TimeMeasure.BUILD_GRAPH, MultipleDataOption.ADDITIVE);
        if (l2 != -1L) {
            l += l2;
            this.mPerformance.addTimeMeasureValue(TimeMeasure.OVERALL, l2);
        }
        this.retrieveGeneralAutomataPerformance();
        this.mLogger.info((Object)((this.mUseSccs ? "SCC version" : "nonSCC version") + " took " + l + " milliseconds."));
    }

    public INestedWordAutomaton<LETTER, STATE> getResult() {
        return this.mResult;
    }

    public SimulationPerformance getSimulationPerformance() {
        return this.mPerformance;
    }

    public IStateFactory<STATE> getStateFactory() {
        return this.mStateFactory;
    }

    public String toString() {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        String string = System.lineSeparator();
        stringBuilder.append("SimulationResults sr = (");
        stringBuilder.append(string + "\tuseSCCs = " + this.isUsingSCCs());
        stringBuilder.append(string + "\tglobalInfinity = " + this.getGameGraph().getGlobalInfinity());
        if (this.getResult() != null) {
            stringBuilder.append(string + "\tbuechi size after = " + this.getResult().size() + " states");
        }
        stringBuilder.append(string + "\tprogress measure = {");
        for (SpoilerVertex vertex : this.getGameGraph().getSpoilerVertices()) {
            n = this.getGameGraph().getGlobalInfinity();
            if (this.isUsingSCCs()) {
                for (StronglyConnectedComponent stronglyConnectedComponent : this.getSccComp().getSCCs()) {
                    if (!stronglyConnectedComponent.getNodes().contains(vertex)) continue;
                    n = this.calculateInfinityOfSCC(stronglyConnectedComponent);
                }
            }
            stringBuilder.append(string + "\t\t<(" + String.valueOf(vertex.getQ0()) + ", " + String.valueOf(vertex.getQ1()) + "), pm:" + vertex.getPM(null, this.getGameGraph().getGlobalInfinity()) + " of " + n + ">");
        }
        for (DuplicatorVertex duplicatorVertex : this.getGameGraph().getDuplicatorVertices()) {
            n = this.getGameGraph().getGlobalInfinity();
            if (this.isUsingSCCs()) {
                for (StronglyConnectedComponent stronglyConnectedComponent : this.getSccComp().getSCCs()) {
                    if (!stronglyConnectedComponent.getNodes().contains(duplicatorVertex)) continue;
                    n = this.calculateInfinityOfSCC(stronglyConnectedComponent);
                }
            }
            stringBuilder.append(string + "\t\t<(" + String.valueOf(duplicatorVertex.getQ0()) + ", " + String.valueOf(duplicatorVertex.getQ1()) + ", " + String.valueOf(duplicatorVertex.getLetter()) + "), pm:" + duplicatorVertex.getPM(null, this.getGameGraph().getGlobalInfinity()) + " of " + n + ">");
        }
        stringBuilder.append(string + "\t},");
        stringBuilder.append(string + "\tbest neighbor measure = {");
        for (SpoilerVertex spoilerVertex : this.getGameGraph().getSpoilerVertices()) {
            stringBuilder.append(string + "\t\t<(" + String.valueOf(spoilerVertex.getQ0()) + ", " + String.valueOf(spoilerVertex.getQ1()) + "), bnm:" + spoilerVertex.getBEff() + ">");
        }
        for (DuplicatorVertex duplicatorVertex : this.getGameGraph().getDuplicatorVertices()) {
            stringBuilder.append(string + "\t\t<(" + String.valueOf(duplicatorVertex.getQ0()) + ", " + String.valueOf(duplicatorVertex.getQ1()) + ", " + String.valueOf(duplicatorVertex.getLetter()) + "), bnm:" + duplicatorVertex.getBEff() + ">");
        }
        stringBuilder.append(string + "\t},");
        stringBuilder.append(string + "\tneighbor counter = {");
        for (SpoilerVertex spoilerVertex : this.getGameGraph().getSpoilerVertices()) {
            stringBuilder.append(string + "\t\t<(" + String.valueOf(spoilerVertex.getQ0()) + ", " + String.valueOf(spoilerVertex.getQ1()) + "), nc:" + spoilerVertex.getC() + ">");
        }
        for (DuplicatorVertex duplicatorVertex : this.getGameGraph().getDuplicatorVertices()) {
            stringBuilder.append(string + "\t\t<(" + String.valueOf(duplicatorVertex.getQ0()) + ", " + String.valueOf(duplicatorVertex.getQ1()) + ", " + String.valueOf(duplicatorVertex.getLetter()) + "), nc:" + duplicatorVertex.getC() + ">");
        }
        stringBuilder.append(string + "\t},");
        stringBuilder.append(string + ");");
        return stringBuilder.toString();
    }

    protected void addVertexToWorkingList(Vertex<LETTER, STATE> vertex) {
        this.mWorkingList.add(vertex);
        vertex.setInWL(true);
    }

    protected int calcBestNghbMeasure(Vertex<LETTER, STATE> vertex, int n, Set<Vertex<LETTER, STATE>> set) {
        AGameGraph<LETTER, STATE> aGameGraph = this.getGameGraph();
        boolean bl = vertex.isDuplicatorVertex();
        boolean bl2 = false;
        HashSet<Vertex<LETTER, STATE>> hashSet = null;
        if (aGameGraph.hasPushOverSuccessors(vertex)) {
            for (Vertex<LETTER, STATE> vertex2 : aGameGraph.getPushOverSuccessors(vertex)) {
                if (vertex2.getPM(set, aGameGraph.getGlobalInfinity()) != aGameGraph.getGlobalInfinity()) continue;
                if (hashSet == null) {
                    hashSet = new HashSet<Vertex<LETTER, STATE>>();
                    bl2 = true;
                }
                hashSet.add(vertex2);
            }
        }
        if (!aGameGraph.hasSuccessors(vertex) && !bl2) {
            if (bl) {
                return aGameGraph.getGlobalInfinity();
            }
            return 0;
        }
        int n2 = bl ? aGameGraph.getGlobalInfinity() : 0;
        HashSet hashSet2 = aGameGraph.getSuccessors(vertex);
        if (bl2) {
            hashSet2 = new HashSet(hashSet2);
            hashSet2.addAll(hashSet);
        }
        for (Vertex vertex3 : hashSet2) {
            int n3 = vertex3.getPM(set, aGameGraph.getGlobalInfinity());
            if (bl) {
                if (n3 >= n2) continue;
                n2 = n3;
                continue;
            }
            if (n3 <= n2) continue;
            n2 = n3;
        }
        return this.decreaseVector(aGameGraph.getPriority(vertex), n2, n);
    }

    protected int calcNghbCounter(Vertex<LETTER, STATE> vertex, int n, Set<Vertex<LETTER, STATE>> set) {
        AGameGraph<LETTER, STATE> aGameGraph = this.getGameGraph();
        boolean bl = false;
        HashSet<Vertex<LETTER, STATE>> hashSet = null;
        if (aGameGraph.hasPushOverSuccessors(vertex)) {
            for (Vertex<LETTER, STATE> vertex2 : aGameGraph.getPushOverSuccessors(vertex)) {
                if (vertex2.getPM(set, aGameGraph.getGlobalInfinity()) != aGameGraph.getGlobalInfinity()) continue;
                if (hashSet == null) {
                    hashSet = new HashSet<Vertex<LETTER, STATE>>();
                    bl = true;
                }
                hashSet.add(vertex2);
            }
        }
        if (!aGameGraph.hasSuccessors(vertex) && !bl) {
            return 0;
        }
        int n2 = 0;
        HashSet hashSet2 = aGameGraph.getSuccessors(vertex);
        if (bl) {
            hashSet2 = new HashSet(hashSet2);
            hashSet2.addAll(hashSet);
        }
        for (Vertex vertex3 : hashSet2) {
            if (this.decreaseVector(aGameGraph.getPriority(vertex), vertex3.getPM(set, aGameGraph.getGlobalInfinity()), n) != vertex.getBEff()) continue;
            ++n2;
        }
        return n2;
    }

    protected int calculateInfinityOfSCC(StronglyConnectedComponent<Vertex<LETTER, STATE>> stronglyConnectedComponent) {
        int n = 0;
        for (Vertex vertex : stronglyConnectedComponent.getNodes()) {
            if (this.getGameGraph().getPriority(vertex) != 1) continue;
            ++n;
        }
        return ++n;
    }

    protected void createWorkingList() {
        this.mWorkingList = new PriorityQueue(this.mVertexComp);
    }

    protected int decreaseVector(int n, int n2, int n3) {
        if (n2 >= n3) {
            return this.getGameGraph().getGlobalInfinity();
        }
        if (n == 0) {
            return 0;
        }
        return n2;
    }

    protected void efficientLiftingAlgorithm(int n, Set<Vertex<LETTER, STATE>> set) throws AutomataOperationCanceledException {
        AGameGraph<LETTER, STATE> aGameGraph = this.getGameGraph();
        int n2 = aGameGraph.getGlobalInfinity();
        this.createWorkingList();
        if (this.mUseSccs) {
            for (Vertex<LETTER, STATE> spoilerVertex : set) {
                this.initWorkingListAndCWithVertex(spoilerVertex, n, set);
            }
        } else {
            for (DuplicatorVertex<LETTER, STATE> duplicatorVertex : aGameGraph.getDuplicatorVertices()) {
                this.initWorkingListAndCWithVertex(duplicatorVertex, n, set);
            }
            for (SpoilerVertex spoilerVertex : aGameGraph.getSpoilerVertices()) {
                this.initWorkingListAndCWithVertex(spoilerVertex, n, set);
            }
        }
        while (!this.mWorkingList.isEmpty()) {
            boolean bl;
            this.mPerformance.increaseCountingMeasure(CountingMeasure.SIMULATION_STEPS);
            Vertex<LETTER, STATE> vertex = this.pollVertexFromWorkingList();
            int n3 = vertex.getPM(set, n2);
            vertex.setBEff(this.calcBestNghbMeasure(vertex, n, set));
            vertex.setC(this.calcNghbCounter(vertex, n, set));
            vertex.setPM(this.increaseVector(this.getGameGraph().getPriority(vertex), vertex.getBEff(), n));
            boolean bl2 = bl = vertex.getPM(set, n2) == n2 && aGameGraph.hasPushOverPredecessors(vertex);
            if (!aGameGraph.hasPredecessors(vertex) && !bl) continue;
            Set<Vertex<LETTER, STATE>> set2 = aGameGraph.getPredecessors(vertex);
            if (bl) {
                set2 = set2 != null ? new HashSet<Vertex<LETTER, STATE>>(set2) : new HashSet<Vertex<LETTER, STATE>>();
                set2.addAll(aGameGraph.getPushOverPredecessors(vertex));
            }
            for (Vertex<LETTER, STATE> vertex2 : set2) {
                if (this.mUseSccs && !set.contains(vertex2) || vertex2.isInWL() || this.decreaseVector(this.getGameGraph().getPriority(vertex2), vertex.getPM(set, n2), n) <= vertex2.getBEff()) continue;
                if (vertex2.isDuplicatorVertex() && this.decreaseVector(this.getGameGraph().getPriority(vertex2), n3, n) == vertex2.getBEff()) {
                    if (vertex2.getC() == 1) {
                        this.addVertexToWorkingList(vertex2);
                    }
                    if (vertex2.getC() <= 1) continue;
                    vertex2.setC(vertex2.getC() - 1);
                    continue;
                }
                if (!vertex2.isSpoilerVertex()) continue;
                this.addVertexToWorkingList(vertex2);
            }
            if (this.mProgressTimer.continueProcessing()) continue;
            this.mLogger.debug((Object)"Stopped in efficientLiftingAlgorithm");
            throw new AutomataOperationCanceledException(this.getClass());
        }
    }

    protected abstract AGameGraph<LETTER, STATE> getGameGraph();

    protected ILogger getLogger() {
        return this.mLogger;
    }

    protected IProgressAwareTimer getProgressTimer() {
        return this.mProgressTimer;
    }

    protected SccComputation<Vertex<LETTER, STATE>, StronglyConnectedComponent<Vertex<LETTER, STATE>>> getSccComp() {
        return this.mSccComp;
    }

    protected PriorityQueue<Vertex<LETTER, STATE>> getWorkingList() {
        return this.mWorkingList;
    }

    protected int increaseVector(int n, int n2, int n3) {
        if (n2 >= n3) {
            return this.getGameGraph().getGlobalInfinity();
        }
        if (n == 1) {
            int n4 = n2 + 1;
            if (n4 == n3) {
                return this.getGameGraph().getGlobalInfinity();
            }
            return n4;
        }
        return this.decreaseVector(n, n2, n3);
    }

    protected void initWorkingListAndCWithVertex(Vertex<LETTER, STATE> vertex, int n, Set<Vertex<LETTER, STATE>> set) {
        boolean bl;
        boolean bl2 = !this.getGameGraph().hasSuccessors(vertex);
        boolean bl3 = bl = vertex.getPM(set, this.getGameGraph().getGlobalInfinity()) != this.update(vertex, n, set);
        if (bl2 || bl) {
            this.addVertexToWorkingList(vertex);
        }
        if (this.mUseSccs) {
            vertex.setC(this.calcNghbCounter(vertex, n, set));
        } else if (this.getGameGraph().hasSuccessors(vertex)) {
            vertex.setC(this.getGameGraph().getSuccessors(vertex).size());
        } else {
            vertex.setC(0);
        }
    }

    protected boolean isUsingSCCs() {
        return this.mUseSccs;
    }

    protected Vertex<LETTER, STATE> pollVertexFromWorkingList() {
        Vertex<LETTER, STATE> vertex = this.mWorkingList.poll();
        if (vertex != null) {
            vertex.setInWL(false);
        }
        return vertex;
    }

    protected void retrieveGeneralAutomataPerformance() {
        AGameGraph<LETTER, STATE> aGameGraph = this.getGameGraph();
        AutomataLibraryServices automataLibraryServices = aGameGraph.getServices();
        INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton = aGameGraph.getAutomaton();
        Analyze<LETTER, STATE> analyze = new Analyze<LETTER, STATE>(automataLibraryServices, iNestedWordAutomaton, true);
        int n = analyze.getNumberOfStates();
        int n2 = analyze.getNumberOfTransitions(Analyze.SymbolType.TOTAL);
        this.mPerformance.setCountingMeasure(CountingMeasure.BUCHI_STATES, n);
        this.mPerformance.setCountingMeasure(CountingMeasure.BUCHI_NONDETERMINISTIC_STATES, analyze.getNumberOfNondeterministicStates());
        this.mPerformance.setCountingMeasure(CountingMeasure.BUCHI_ALPHABET_SIZE, analyze.getNumberOfSymbols(Analyze.SymbolType.TOTAL));
        this.mPerformance.setCountingMeasure(CountingMeasure.BUCHI_TRANSITIONS, n2);
        this.mPerformance.setCountingMeasure(CountingMeasure.BUCHI_TRANSITION_DENSITY_MILLION, (int)Math.round(analyze.getTransitionDensity(Analyze.SymbolType.TOTAL) * 1000000.0));
        if (this.mResult != null) {
            Analyze<LETTER, STATE> analyze2 = new Analyze<LETTER, STATE>(automataLibraryServices, this.mResult, true);
            int n3 = analyze2.getNumberOfStates();
            int n4 = analyze2.getNumberOfTransitions(Analyze.SymbolType.TOTAL);
            this.mPerformance.setCountingMeasure(CountingMeasure.RESULT_STATES, n3);
            this.mPerformance.setCountingMeasure(CountingMeasure.RESULT_NONDETERMINISTIC_STATES, analyze2.getNumberOfNondeterministicStates());
            this.mPerformance.setCountingMeasure(CountingMeasure.RESULT_ALPHABET_SIZE, analyze2.getNumberOfSymbols(Analyze.SymbolType.TOTAL));
            this.mPerformance.setCountingMeasure(CountingMeasure.RESULT_TRANSITIONS, n4);
            this.mPerformance.setCountingMeasure(CountingMeasure.RESULT_TRANSITION_DENSITY_MILLION, (int)Math.round(analyze2.getTransitionDensity(Analyze.SymbolType.TOTAL) * 1000000.0));
            this.mPerformance.setCountingMeasure(CountingMeasure.GAMEGRAPH_VERTICES, aGameGraph.getSize());
            this.mPerformance.setCountingMeasure(CountingMeasure.GAMEGRAPH_EDGES, aGameGraph.getAmountOfEdges());
            this.mPerformance.setCountingMeasure(CountingMeasure.GLOBAL_INFINITY, aGameGraph.getGlobalInfinity());
            this.mPerformance.setCountingMeasure(CountingMeasure.REMOVED_STATES, n - n3);
            this.mPerformance.setCountingMeasure(CountingMeasure.REMOVED_TRANSITIONS, n2 - n4);
        }
    }

    protected void setResult(INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton) {
        this.mResult = iNestedWordAutomaton;
    }

    protected void setSccComp(SccComputation<Vertex<LETTER, STATE>, StronglyConnectedComponent<Vertex<LETTER, STATE>>> sccComputation) {
        this.mSccComp = sccComputation;
    }

    protected void setUseSCCs(boolean bl) {
        this.mUseSccs = bl;
    }

    protected void simulationHook() throws AutomataOperationCanceledException {
    }

    protected int update(Vertex<LETTER, STATE> vertex, int n, Set<Vertex<LETTER, STATE>> set) {
        return this.increaseVector(this.getGameGraph().getPriority(vertex), this.calcBestNghbMeasure(vertex, n, set), n);
    }
}

