/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.nwa.graph.summarycomputationgraph;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.PriorityComparator;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.nwa.graph.game.IGameState;
import de.uni_freiburg.informatik.ultimate.util.datastructures.poset.CanonicalPartialComparatorForMaps;
import de.uni_freiburg.informatik.ultimate.util.datastructures.poset.IPartialComparator;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class WeightedSummaryTargets {
    private final Map<IGameState, Integer> mTarget2Priority;

    WeightedSummaryTargets(Map<IGameState, Integer> map) {
        this.mTarget2Priority = map;
    }

    public WeightedSummaryTargets(IGameState iGameState, int n) {
        this.mTarget2Priority = Collections.singletonMap(iGameState, n);
    }

    public Set<Map.Entry<IGameState, Integer>> entrySet() {
        return this.mTarget2Priority.entrySet();
    }

    public WeightedSummaryTargets computeUpdate(int n) {
        switch (n) {
            case 2: {
                return this;
            }
            case 0: 
            case 1: {
                HashMap<IGameState, Integer> hashMap = new HashMap<IGameState, Integer>();
                for (Map.Entry<IGameState, Integer> entry : this.mTarget2Priority.entrySet()) {
                    hashMap.put(entry.getKey(), Math.min(n, entry.getValue()));
                }
                return new WeightedSummaryTargets(hashMap);
            }
        }
        throw new IllegalArgumentException("unsupported value " + n);
    }

    public int hashCode() {
        return Objects.hash(this.mTarget2Priority);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        WeightedSummaryTargets weightedSummaryTargets = (WeightedSummaryTargets)object;
        return !(this.mTarget2Priority == null ? weightedSummaryTargets.mTarget2Priority != null : !this.mTarget2Priority.equals(weightedSummaryTargets.mTarget2Priority));
    }

    public String toString() {
        return this.mTarget2Priority.toString();
    }

    public static class WeightedSummaryTargetsComparator
    implements IPartialComparator<WeightedSummaryTargets> {
        public IPartialComparator.ComparisonResult compare(WeightedSummaryTargets weightedSummaryTargets, WeightedSummaryTargets weightedSummaryTargets2) {
            IPartialComparator.ComparisonResult comparisonResult = new CanonicalPartialComparatorForMaps((Comparator)new PriorityComparator()).compare(weightedSummaryTargets.mTarget2Priority, weightedSummaryTargets2.mTarget2Priority);
            return comparisonResult;
        }
    }
}

