/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.reachablestates;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedRun;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.UnaryNwaOperation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.BuchiAccepts;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.NestedLassoRun;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.reachablestates.NestedWordAutomatonReachableStates;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.reachablestates.StateContainer;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IncomingCallTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IncomingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IncomingReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingCallTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import de.uni_freiburg.informatik.ultimate.util.HashUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class ShortestLassoExtractor<LETTER, STATE>
extends UnaryNwaOperation<LETTER, STATE, IStateFactory<STATE>> {
    private final NestedWordAutomatonReachableStates<LETTER, STATE> mNwars;
    private final List<Set<StackOfFlaggedStates>> mIterations = new ArrayList<Set<StackOfFlaggedStates>>();
    private final StateContainer<LETTER, STATE> mGoal;
    private StateContainer<LETTER, STATE> mFirstFoundInitialState;
    private int mGoalFoundIteration = -1;
    private int mInitFoundIteration = -1;
    private final NestedLassoRun<LETTER, STATE> mNlr;
    private NestedRun<LETTER, STATE> mStem;
    private NestedRun<LETTER, STATE> mLoop;
    private NestedRun<LETTER, STATE> mConstructedNestedRun;

    public ShortestLassoExtractor(AutomataLibraryServices automataLibraryServices, NestedWordAutomatonReachableStates<LETTER, STATE> nestedWordAutomatonReachableStates, StateContainer<LETTER, STATE> stateContainer) {
        super(automataLibraryServices);
        this.mNwars = nestedWordAutomatonReachableStates;
        this.mGoal = stateContainer;
        this.addInitialStack(stateContainer);
        this.findPath(1);
        this.mLogger.debug((Object)("Stem length: " + this.mInitFoundIteration));
        this.mLogger.debug((Object)("Loop length: " + this.mGoalFoundIteration));
        this.constructStem();
        this.constructLoop();
        this.mNlr = new NestedLassoRun<LETTER, STATE>(this.mStem, this.mLoop);
        this.mLogger.debug((Object)("Stem " + String.valueOf(this.mStem)));
        this.mLogger.debug((Object)("Loop " + String.valueOf(this.mLoop)));
        try {
            assert (new BuchiAccepts<LETTER, STATE>(this.mServices, nestedWordAutomatonReachableStates, this.mNlr.getNestedLassoWord()).getResult().booleanValue());
        }
        catch (AutomataLibraryException automataLibraryException) {
            throw new AssertionError((Object)automataLibraryException);
        }
    }

    private StackOfFlaggedStates addInitialStack(StateContainer<LETTER, STATE> stateContainer) {
        StackOfFlaggedStates stackOfFlaggedStates = new StackOfFlaggedStates(stateContainer, false);
        HashSet<StackOfFlaggedStates> hashSet = new HashSet<StackOfFlaggedStates>();
        hashSet.add(stackOfFlaggedStates);
        this.mIterations.add(hashSet);
        return stackOfFlaggedStates;
    }

    public NestedLassoRun<LETTER, STATE> getNestedLassoRun() {
        return this.mNlr;
    }

    final void findPath(int n) {
        int n2 = n;
        while (this.mGoalFoundIteration == -1 || this.mInitFoundIteration == -1) {
            Set<StackOfFlaggedStates> set = this.mIterations.get(n2 - 1);
            HashSet<StackOfFlaggedStates> hashSet = new HashSet<StackOfFlaggedStates>();
            this.mIterations.add(hashSet);
            for (StackOfFlaggedStates stackOfFlaggedStates : set) {
                this.addPrecedingStacks(n2, hashSet, stackOfFlaggedStates);
            }
            ++n2;
        }
    }

    private void addPrecedingStacks(int n, Set<StackOfFlaggedStates> set, StackOfFlaggedStates stackOfFlaggedStates) {
        StackOfFlaggedStates stackOfFlaggedStates2;
        boolean bl;
        StateContainer<LETTER, STATE> stateContainer;
        StateContainer stateContainer2 = stackOfFlaggedStates.getTopmostState();
        for (IncomingInternalTransition iTransitionlet : stateContainer2.internalPredecessors()) {
            stateContainer = this.mNwars.obtainStateContainer(iTransitionlet.getPred());
            boolean bl2 = bl = stackOfFlaggedStates.getTopmostFlag() || this.mNwars.isFinal(iTransitionlet.getPred());
            if (bl && stackOfFlaggedStates.height() > 1 && !stackOfFlaggedStates.getSecondTopmostFlag()) continue;
            stackOfFlaggedStates2 = new StackOfFlaggedStates(stackOfFlaggedStates, iTransitionlet, bl);
            set.add(stackOfFlaggedStates2);
            this.checkIfGoalOrInitReached(n, stackOfFlaggedStates2, stateContainer);
        }
        if (stackOfFlaggedStates.height() == 1) {
            for (IncomingCallTransition incomingCallTransition : stateContainer2.callPredecessors()) {
                stateContainer = this.mNwars.obtainStateContainer(incomingCallTransition.getPred());
                bl = stackOfFlaggedStates.getTopmostFlag() || this.mNwars.isFinal(incomingCallTransition.getPred());
                stackOfFlaggedStates2 = new StackOfFlaggedStates(stackOfFlaggedStates, incomingCallTransition, bl);
                set.add(stackOfFlaggedStates2);
                this.checkIfGoalOrInitReached(n, stackOfFlaggedStates2, stateContainer);
            }
        } else {
            for (IncomingCallTransition incomingCallTransition : stateContainer2.callPredecessors()) {
                stateContainer = this.mNwars.obtainStateContainer(incomingCallTransition.getPred());
                boolean bl3 = bl = stackOfFlaggedStates.getTopmostFlag() || this.mNwars.isFinal(incomingCallTransition.getPred());
                if (!stackOfFlaggedStates.getSecondTopmostState().getState().equals(incomingCallTransition.getPred()) || bl != stackOfFlaggedStates.getSecondTopmostFlag() && !this.mNwars.isFinal(incomingCallTransition.getPred())) continue;
                stackOfFlaggedStates2 = new StackOfFlaggedStates(stackOfFlaggedStates, incomingCallTransition, bl);
                set.add(stackOfFlaggedStates2);
                this.checkIfGoalOrInitReached(n, stackOfFlaggedStates2, stateContainer);
            }
        }
        for (IncomingReturnTransition incomingReturnTransition : stateContainer2.returnPredecessors()) {
            int n2 = set.size();
            if (stackOfFlaggedStates.getTopmostFlag()) {
                StackOfFlaggedStates stackOfFlaggedStates3 = new StackOfFlaggedStates(stackOfFlaggedStates, incomingReturnTransition, true, true);
                set.add(stackOfFlaggedStates3);
            } else {
                boolean bl4 = this.mNwars.isFinal(incomingReturnTransition.getLinPred());
                this.addPrecedingStack(set, stackOfFlaggedStates, incomingReturnTransition, true, bl4);
                if (!this.mNwars.isFinal(incomingReturnTransition.getHierPred()) && !bl4) {
                    this.addPrecedingStack(set, stackOfFlaggedStates, incomingReturnTransition, false, bl4);
                }
            }
            assert (n2 + 2 >= set.size());
        }
    }

    private void addPrecedingStack(Set<StackOfFlaggedStates> set, StackOfFlaggedStates stackOfFlaggedStates, IncomingReturnTransition<LETTER, STATE> incomingReturnTransition, boolean bl, boolean bl2) {
        StackOfFlaggedStates stackOfFlaggedStates2 = new StackOfFlaggedStates(stackOfFlaggedStates, incomingReturnTransition, bl, bl2);
        set.add(stackOfFlaggedStates2);
    }

    final void constructStem() {
        StackOfFlaggedStates stackOfFlaggedStates;
        assert (this.mConstructedNestedRun == null);
        Set<StackOfFlaggedStates> set = this.mIterations.get(this.mInitFoundIteration);
        if (!set.contains(stackOfFlaggedStates = new StackOfFlaggedStates(this.mFirstFoundInitialState, true))) {
            stackOfFlaggedStates = new StackOfFlaggedStates(this.mFirstFoundInitialState, false);
        }
        assert (set.contains(stackOfFlaggedStates));
        StateContainer<LETTER, STATE> stateContainer = this.mFirstFoundInitialState;
        this.mConstructedNestedRun = new NestedRun(stateContainer.getState());
        int n = this.mInitFoundIteration - 1;
        while (n >= 0) {
            stackOfFlaggedStates = this.getSuccessorStack(stackOfFlaggedStates, this.mIterations.get(n));
            --n;
        }
        this.mStem = this.mConstructedNestedRun;
        this.mConstructedNestedRun = null;
    }

    final void constructLoop() {
        StackOfFlaggedStates stackOfFlaggedStates;
        Set<StackOfFlaggedStates> set = this.mIterations.get(this.mGoalFoundIteration);
        if (!set.contains(stackOfFlaggedStates = new StackOfFlaggedStates(this.mGoal, true))) {
            stackOfFlaggedStates = new StackOfFlaggedStates(this.mGoal, false);
        }
        assert (set.contains(stackOfFlaggedStates));
        StateContainer<LETTER, STATE> stateContainer = this.mGoal;
        this.mConstructedNestedRun = new NestedRun(stateContainer.getState());
        this.mLoop = new NestedRun(stateContainer.getState());
        int n = this.mGoalFoundIteration - 1;
        while (n >= 0) {
            stackOfFlaggedStates = this.getSuccessorStack(stackOfFlaggedStates, this.mIterations.get(n));
            --n;
        }
        this.mLoop = this.mConstructedNestedRun;
        this.mConstructedNestedRun = null;
    }

    StackOfFlaggedStates getSuccessorStack(StackOfFlaggedStates stackOfFlaggedStates, Set<StackOfFlaggedStates> set) {
        StackOfFlaggedStates stackOfFlaggedStates2;
        StackOfFlaggedStates iOutgoingTransitionlet2;
        StateContainer stateContainer = stackOfFlaggedStates.getTopmostState();
        if (stackOfFlaggedStates.getTopmostFlag() && (iOutgoingTransitionlet2 = this.getSuccessorStackGetTopmostFlag(stackOfFlaggedStates, set, stateContainer)) != null) {
            return iOutgoingTransitionlet2;
        }
        for (OutgoingInternalTransition outgoingInternalTransition : stateContainer.internalSuccessors()) {
            stackOfFlaggedStates2 = new StackOfFlaggedStates(stackOfFlaggedStates, outgoingInternalTransition, false);
            if (!set.contains(stackOfFlaggedStates2)) continue;
            NestedRun nestedRun = new NestedRun(stateContainer.getState(), outgoingInternalTransition.getLetter(), -2, outgoingInternalTransition.getSucc());
            this.mConstructedNestedRun = this.mConstructedNestedRun.concatenate(nestedRun);
            return stackOfFlaggedStates2;
        }
        for (OutgoingCallTransition outgoingCallTransition : stateContainer.callSuccessors()) {
            stackOfFlaggedStates2 = new StackOfFlaggedStates(stackOfFlaggedStates, outgoingCallTransition, false, false);
            if (set.contains(stackOfFlaggedStates2)) {
                NestedRun nestedRun = new NestedRun(stateContainer.getState(), outgoingCallTransition.getLetter(), Integer.MAX_VALUE, outgoingCallTransition.getSucc());
                this.mConstructedNestedRun = this.mConstructedNestedRun.concatenate(nestedRun);
                return stackOfFlaggedStates2;
            }
            if (stackOfFlaggedStates.height() != 1 || !set.contains(stackOfFlaggedStates2 = new StackOfFlaggedStates(stackOfFlaggedStates, outgoingCallTransition, false, true))) continue;
            NestedRun nestedRun = new NestedRun(stateContainer.getState(), outgoingCallTransition.getLetter(), Integer.MAX_VALUE, outgoingCallTransition.getSucc());
            this.mConstructedNestedRun = this.mConstructedNestedRun.concatenate(nestedRun);
            return stackOfFlaggedStates2;
        }
        if (stackOfFlaggedStates.height() > 1) {
            for (OutgoingReturnTransition outgoingReturnTransition : stateContainer.returnSuccessors()) {
                if (!stackOfFlaggedStates.getSecondTopmostState().getState().equals(outgoingReturnTransition.getHierPred()) || !set.contains(stackOfFlaggedStates2 = new StackOfFlaggedStates(stackOfFlaggedStates, outgoingReturnTransition, false))) continue;
                NestedRun nestedRun = new NestedRun(stateContainer.getState(), outgoingReturnTransition.getLetter(), Integer.MIN_VALUE, outgoingReturnTransition.getSucc());
                this.mConstructedNestedRun = this.mConstructedNestedRun.concatenate(nestedRun);
                return stackOfFlaggedStates2;
            }
        }
        throw new AssertionError((Object)"no corresponding state found");
    }

    private StackOfFlaggedStates getSuccessorStackGetTopmostFlag(StackOfFlaggedStates stackOfFlaggedStates, Set<StackOfFlaggedStates> set, StateContainer<LETTER, STATE> stateContainer) {
        StackOfFlaggedStates stackOfFlaggedStates2;
        for (OutgoingInternalTransition<LETTER, STATE> iOutgoingTransitionlet : stateContainer.internalSuccessors()) {
            stackOfFlaggedStates2 = new StackOfFlaggedStates(stackOfFlaggedStates, iOutgoingTransitionlet, true);
            if (!set.contains(stackOfFlaggedStates2)) continue;
            NestedRun<LETTER, STATE> nestedRun = new NestedRun<LETTER, STATE>(stateContainer.getState(), iOutgoingTransitionlet.getLetter(), -2, iOutgoingTransitionlet.getSucc());
            this.mConstructedNestedRun = this.mConstructedNestedRun.concatenate(nestedRun);
            return stackOfFlaggedStates2;
        }
        for (OutgoingCallTransition outgoingCallTransition : stateContainer.callSuccessors()) {
            stackOfFlaggedStates2 = new StackOfFlaggedStates(stackOfFlaggedStates, outgoingCallTransition, true, false);
            if (set.contains(stackOfFlaggedStates2)) {
                NestedRun nestedRun = new NestedRun(stateContainer.getState(), outgoingCallTransition.getLetter(), Integer.MAX_VALUE, outgoingCallTransition.getSucc());
                this.mConstructedNestedRun = this.mConstructedNestedRun.concatenate(nestedRun);
                return stackOfFlaggedStates2;
            }
            if (stackOfFlaggedStates.height() != 1 || !set.contains(stackOfFlaggedStates2 = new StackOfFlaggedStates(stackOfFlaggedStates, outgoingCallTransition, true, true))) continue;
            NestedRun nestedRun = new NestedRun(stateContainer.getState(), outgoingCallTransition.getLetter(), Integer.MAX_VALUE, outgoingCallTransition.getSucc());
            this.mConstructedNestedRun = this.mConstructedNestedRun.concatenate(nestedRun);
            return stackOfFlaggedStates2;
        }
        if (stackOfFlaggedStates.height() > 1) {
            for (OutgoingReturnTransition outgoingReturnTransition : stateContainer.returnSuccessors()) {
                if (!stackOfFlaggedStates.getSecondTopmostState().getState().equals(outgoingReturnTransition.getHierPred()) || !set.contains(stackOfFlaggedStates2 = new StackOfFlaggedStates(stackOfFlaggedStates, outgoingReturnTransition, true))) continue;
                NestedRun nestedRun = new NestedRun(stateContainer.getState(), outgoingReturnTransition.getLetter(), Integer.MIN_VALUE, outgoingReturnTransition.getSucc());
                this.mConstructedNestedRun = this.mConstructedNestedRun.concatenate(nestedRun);
                return stackOfFlaggedStates2;
            }
        }
        return null;
    }

    private void checkIfGoalOrInitReached(int n, StackOfFlaggedStates stackOfFlaggedStates, StateContainer<LETTER, STATE> stateContainer) {
        if (stateContainer == this.mGoal && stackOfFlaggedStates.hasOnlyTopmostElement() && stackOfFlaggedStates.getTopmostFlag()) {
            this.mGoalFoundIteration = n;
        }
        if (this.mFirstFoundInitialState == null && this.mNwars.isInitial(stateContainer.getState()) && stackOfFlaggedStates.hasOnlyTopmostElement()) {
            this.mInitFoundIteration = n;
            this.mFirstFoundInitialState = stateContainer;
        }
    }

    @Override
    public Object getResult() {
        return this.mNlr;
    }

    @Override
    protected INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> getOperand() {
        return this.mNwars;
    }

    class StackOfFlaggedStates {
        private final StateContainer<LETTER, STATE> mTopmostState;
        private final boolean mTopmostFlag;
        private final StateContainer<LETTER, STATE>[] mStateStack;
        private final boolean[] mFlagStack;

        public StackOfFlaggedStates(StateContainer<LETTER, STATE> stateContainer, boolean bl) {
            this.mStateStack = new StateContainer[0];
            this.mFlagStack = new boolean[0];
            this.mTopmostState = stateContainer;
            this.mTopmostFlag = bl;
        }

        public StackOfFlaggedStates(StackOfFlaggedStates stackOfFlaggedStates, IncomingInternalTransition<LETTER, STATE> incomingInternalTransition, boolean bl) {
            this.mStateStack = stackOfFlaggedStates.mStateStack;
            this.mFlagStack = stackOfFlaggedStates.mFlagStack;
            this.mTopmostState = ShortestLassoExtractor.this.mNwars.obtainStateContainer(incomingInternalTransition.getPred());
            this.mTopmostFlag = bl;
        }

        public StackOfFlaggedStates(StackOfFlaggedStates stackOfFlaggedStates, IncomingCallTransition<LETTER, STATE> incomingCallTransition, boolean bl) {
            if (stackOfFlaggedStates.mStateStack.length == 0) {
                this.mStateStack = stackOfFlaggedStates.mStateStack;
                this.mFlagStack = stackOfFlaggedStates.mFlagStack;
                this.mTopmostState = ShortestLassoExtractor.this.mNwars.obtainStateContainer(incomingCallTransition.getPred());
                this.mTopmostFlag = bl;
            } else {
                this.mStateStack = Arrays.copyOf(stackOfFlaggedStates.mStateStack, stackOfFlaggedStates.mStateStack.length - 1);
                this.mFlagStack = Arrays.copyOf(stackOfFlaggedStates.mFlagStack, stackOfFlaggedStates.mFlagStack.length - 1);
                this.mTopmostState = ShortestLassoExtractor.this.mNwars.obtainStateContainer(incomingCallTransition.getPred());
                this.mTopmostFlag = bl;
            }
        }

        public StackOfFlaggedStates(StackOfFlaggedStates stackOfFlaggedStates, IncomingReturnTransition<LETTER, STATE> incomingReturnTransition, boolean bl, boolean bl2) {
            this.mStateStack = Arrays.copyOf(stackOfFlaggedStates.mStateStack, stackOfFlaggedStates.mStateStack.length + 1);
            this.mFlagStack = Arrays.copyOf(stackOfFlaggedStates.mFlagStack, stackOfFlaggedStates.mFlagStack.length + 1);
            this.mStateStack[this.mStateStack.length - 1] = ShortestLassoExtractor.this.mNwars.obtainStateContainer(incomingReturnTransition.getHierPred());
            this.mFlagStack[this.mStateStack.length - 1] = bl;
            this.mTopmostState = ShortestLassoExtractor.this.mNwars.obtainStateContainer(incomingReturnTransition.getLinPred());
            this.mTopmostFlag = bl2;
        }

        public StackOfFlaggedStates(StackOfFlaggedStates stackOfFlaggedStates, OutgoingInternalTransition<LETTER, STATE> outgoingInternalTransition, boolean bl) {
            this.mStateStack = stackOfFlaggedStates.mStateStack;
            this.mFlagStack = stackOfFlaggedStates.mFlagStack;
            this.mTopmostState = ShortestLassoExtractor.this.mNwars.obtainStateContainer(outgoingInternalTransition.getSucc());
            this.mTopmostFlag = bl;
        }

        public StackOfFlaggedStates(StackOfFlaggedStates stackOfFlaggedStates, OutgoingCallTransition<LETTER, STATE> outgoingCallTransition, boolean bl, boolean bl2) {
            if (bl2) {
                this.mStateStack = stackOfFlaggedStates.mStateStack;
                this.mFlagStack = stackOfFlaggedStates.mFlagStack;
                this.mTopmostState = ShortestLassoExtractor.this.mNwars.obtainStateContainer(outgoingCallTransition.getSucc());
                this.mTopmostFlag = bl;
            } else {
                this.mStateStack = Arrays.copyOf(stackOfFlaggedStates.mStateStack, stackOfFlaggedStates.mStateStack.length + 1);
                this.mFlagStack = Arrays.copyOf(stackOfFlaggedStates.mFlagStack, stackOfFlaggedStates.mFlagStack.length + 1);
                this.mStateStack[this.mStateStack.length - 1] = stackOfFlaggedStates.mTopmostState;
                this.mFlagStack[this.mStateStack.length - 1] = stackOfFlaggedStates.mTopmostFlag;
                this.mTopmostState = ShortestLassoExtractor.this.mNwars.obtainStateContainer(outgoingCallTransition.getSucc());
                this.mTopmostFlag = bl;
            }
        }

        public StackOfFlaggedStates(StackOfFlaggedStates stackOfFlaggedStates, OutgoingReturnTransition<LETTER, STATE> outgoingReturnTransition, boolean bl) {
            this.mStateStack = Arrays.copyOf(stackOfFlaggedStates.mStateStack, stackOfFlaggedStates.mStateStack.length - 1);
            this.mFlagStack = Arrays.copyOf(stackOfFlaggedStates.mFlagStack, stackOfFlaggedStates.mFlagStack.length - 1);
            this.mTopmostState = ShortestLassoExtractor.this.mNwars.obtainStateContainer(outgoingReturnTransition.getSucc());
            this.mTopmostFlag = bl;
        }

        public int height() {
            return this.mStateStack.length + 1;
        }

        public boolean hasOnlyTopmostElement() {
            return this.mStateStack.length == 0;
        }

        public StateContainer<LETTER, STATE> getSecondTopmostState() {
            return this.mStateStack[this.mStateStack.length - 1];
        }

        public StateContainer<LETTER, STATE> getTopmostState() {
            return this.mTopmostState;
        }

        public boolean getSecondTopmostFlag() {
            return this.mFlagStack[this.mFlagStack.length - 1];
        }

        public boolean getTopmostFlag() {
            return this.mTopmostFlag;
        }

        public int hashCode() {
            int n = HashUtils.hashJenkins((int)Boolean.valueOf(this.mTopmostFlag).hashCode(), this.mTopmostState);
            n = HashUtils.hashJenkins((int)n, (Object[])this.mStateStack);
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            StackOfFlaggedStates stackOfFlaggedStates = (StackOfFlaggedStates)object;
            if (!this.getOuterType().equals(stackOfFlaggedStates.getOuterType())) {
                return false;
            }
            if (!Arrays.equals(this.mFlagStack, stackOfFlaggedStates.mFlagStack)) {
                return false;
            }
            if (!Arrays.equals(this.mStateStack, stackOfFlaggedStates.mStateStack)) {
                return false;
            }
            if (this.mTopmostFlag != stackOfFlaggedStates.mTopmostFlag) {
                return false;
            }
            return !(this.mTopmostState == null ? stackOfFlaggedStates.mTopmostState != null : !this.mTopmostState.equals(stackOfFlaggedStates.mTopmostState));
        }

        private ShortestLassoExtractor<LETTER, STATE> getOuterType() {
            return ShortestLassoExtractor.this;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            int n = 0;
            while (n < this.mStateStack.length) {
                stringBuilder.append("(" + String.valueOf(this.mStateStack[n].getState()) + "," + this.mFlagStack[n] + ")  ");
                ++n;
            }
            stringBuilder.append("(" + String.valueOf(this.mTopmostState.getState()) + "," + this.mTopmostFlag + ")");
            return stringBuilder.toString();
        }
    }
}

