/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.partialorder.visitors;

import de.uni_freiburg.informatik.ultimate.automata.partialorder.visitors.IDfsVisitor;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.visitors.WrapperVisitor;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Set;

public class ReachabilityCheckVisitor<L, S, V extends IDfsVisitor<L, S>>
extends WrapperVisitor<L, S, V> {
    private final Set<S> mCanReach;
    private final Set<S> mCanNotReach;
    private boolean mFound;
    private final Deque<S> mStateStack = new ArrayDeque<S>();
    private S mPendingState;

    public ReachabilityCheckVisitor(V v, Set<S> set, Set<S> set2) {
        super(v);
        this.mCanReach = set;
        this.mCanNotReach = set2;
    }

    @Override
    public boolean addStartState(S s) {
        assert (this.mStateStack.isEmpty()) : "start state must be first";
        this.mStateStack.addLast(s);
        this.checkState(s);
        return this.mCanNotReach.contains(s) || this.mUnderlying.addStartState(s);
    }

    @Override
    public boolean discoverTransition(S s, L l, S s2) {
        assert (!this.mFound) : "Unexpected transition discovery after abort";
        assert (this.mStateStack.getLast() == s) : "Unexpected transition from state " + String.valueOf(s);
        this.mPendingState = s2;
        return this.mCanNotReach.contains(s2) || this.mUnderlying.discoverTransition(s, l, s2);
    }

    @Override
    public boolean discoverState(S s) {
        assert (!this.mFound) : "Unexpected state discovery after abort";
        assert (!this.mCanNotReach.contains(s)) : "should have pruned transition to this state";
        if (this.mPendingState == null) {
            assert (this.mStateStack.size() == 1 && this.mStateStack.getLast() == s) : "Unexpected discovery of state " + String.valueOf(s);
        } else {
            assert (this.mPendingState == s) : "Unexpected discovery of state " + String.valueOf(s);
            this.mStateStack.addLast(this.mPendingState);
            this.mPendingState = null;
        }
        this.checkState(s);
        return this.mUnderlying.discoverState(s);
    }

    @Override
    public void backtrackState(S s, boolean bl) {
        assert (!this.mFound) : "Unexpected backtrack after abort";
        assert (this.mStateStack.getLast() == s) : "Unexpected backtrack of state " + String.valueOf(s);
        this.mPendingState = null;
        this.mStateStack.removeLast();
        if (bl) {
            this.mCanNotReach.add(s);
        }
        this.mUnderlying.backtrackState(s, bl);
    }

    @Override
    public boolean isFinished() {
        return this.mFound || this.mUnderlying.isFinished();
    }

    public boolean reachabilityConfirmed() {
        return this.mFound;
    }

    private void checkState(S s) {
        assert (!this.mFound) : "Unexpected call after abort";
        assert (this.mStateStack.getLast() == s) : "Checked state is expected to be on top of stack";
        this.mFound = this.mCanReach.contains(s);
        if (this.mFound) {
            this.mCanReach.addAll(this.mStateStack);
        }
    }
}

