/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding;

import de.uni_freiburg.informatik.ultimate.automata.Word;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.Marking;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.PetriNetLassoRun;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.PetriNetNot1SafeException;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.PetriNetRun;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.netdatastructures.Transition;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.BranchingProcess;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.Event;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class Events2PetriNetLassoRunBuchi<LETTER, PLACE> {
    private final BranchingProcess<LETTER, PLACE> mUnfolding;
    private final List<Event<LETTER, PLACE>> mConfigStemPart;
    private final List<Event<LETTER, PLACE>> mConfigLoopPart;

    public Events2PetriNetLassoRunBuchi(List<Event<LETTER, PLACE>> list, List<Event<LETTER, PLACE>> list2, BranchingProcess<LETTER, PLACE> branchingProcess) {
        this.mUnfolding = branchingProcess;
        this.mConfigStemPart = list2;
        this.mConfigLoopPart = list;
    }

    public boolean isAccepted() {
        return this.mConfigLoopPart.stream().flatMap(event -> event.getTransition().getSuccessors().stream()).anyMatch(this.mUnfolding.getNet()::isAccepting);
    }

    public PetriNetLassoRun<LETTER, PLACE> constructLassoRun() throws PetriNetNot1SafeException {
        List<Transition<LETTER, PLACE>> list = this.mConfigStemPart.stream().map(Event::getTransition).collect(Collectors.toList());
        List<Transition<LETTER, PLACE>> list2 = this.mConfigLoopPart.stream().map(Event::getTransition).collect(Collectors.toList());
        Marking marking = new Marking(ImmutableSet.of(this.mUnfolding.getNet().getInitialPlaces()));
        PetriNetRun petriNetRun = this.constructRun(marking, list);
        PetriNetRun petriNetRun2 = this.constructRun(petriNetRun.getMarking(petriNetRun.getLength() - 1), list2);
        return new PetriNetLassoRun(petriNetRun, petriNetRun2);
    }

    private final PetriNetRun<LETTER, PLACE> constructRun(Marking<PLACE> marking, List<Transition<LETTER, PLACE>> list) throws PetriNetNot1SafeException {
        ArrayList<LETTER> arrayList = new ArrayList<LETTER>();
        ArrayList arrayList2 = new ArrayList();
        arrayList2.add(marking);
        Marking<PLACE> marking2 = marking;
        for (Transition<LETTER, PLACE> transition : list) {
            arrayList.add(transition.getSymbol());
            marking2 = marking2.fireTransition(transition);
            arrayList2.add(marking2);
        }
        return new PetriNetRun(arrayList2, new Word<Object>(arrayList.toArray()), list);
    }
}

