/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result;

import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.StructConstructor;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.CTranslationUtil;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.IMemoryPointer;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.ICType;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.HeapLValue;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.LocalLValue;
import java.math.BigInteger;

public abstract class LRValue {
    private final ICType mCType;
    private final boolean mIsBoogieBool;
    private final boolean mIsIntFromPointer;

    public LRValue(ICType iCType, boolean bl, boolean bl2) {
        this.mCType = iCType;
        this.mIsBoogieBool = bl;
        this.mIsIntFromPointer = bl2;
    }

    public abstract Expression getValue();

    public ICType getCType() {
        return this.mCType;
    }

    public ICType getUnderlyingType() {
        return this.mCType.getUnderlyingType();
    }

    public boolean isBoogieBool() {
        return this.mIsBoogieBool;
    }

    public boolean isIntFromPointer() {
        return this.mIsIntFromPointer;
    }

    public final String toString() {
        if (this instanceof HeapLValue) {
            return "address: " + String.valueOf(((HeapLValue)this).getAddress());
        }
        if (this instanceof LocalLValue) {
            return "lhs: " + String.valueOf(((LocalLValue)this).getLhs());
        }
        return "value: " + String.valueOf(this.getValue());
    }

    public boolean isNullPointerConstant(IMemoryPointer iMemoryPointer) {
        if (!this.getCType().isVoidPointerType() && !this.getCType().isArithmeticType()) {
            return false;
        }
        if (this instanceof HeapLValue) {
            Expression expression = ((HeapLValue)this).getAddress();
            throw new AssertionError((Object)"unexpected: double check this case");
        }
        Expression expression = this.getValue();
        BigInteger bigInteger = CTranslationUtil.extractIntegerValue(expression);
        if (BigInteger.ZERO.equals(bigInteger)) {
            return true;
        }
        if (expression instanceof StructConstructor) {
            return iMemoryPointer.isNullPointer(expression);
        }
        return false;
    }
}

