/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.logic;

import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.DataType;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbolFactory;
import de.uni_freiburg.informatik.ultimate.logic.IRAWrapperFactory;
import de.uni_freiburg.informatik.ultimate.logic.IsConstructorFactory;
import de.uni_freiburg.informatik.ultimate.logic.LambdaTerm;
import de.uni_freiburg.informatik.ultimate.logic.LetTerm;
import de.uni_freiburg.informatik.ultimate.logic.Logics;
import de.uni_freiburg.informatik.ultimate.logic.MatchTerm;
import de.uni_freiburg.informatik.ultimate.logic.PolymorphicFunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.PrintTerm;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.QuotedObject;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.SortSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.HashUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ScopedHashMap;
import de.uni_freiburg.informatik.ultimate.util.datastructures.UnifyHash;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;

public class Theory {
    private SolverSetup mSolverSetup;
    private Logics mLogic;
    private Sort mNumericSort;
    private Sort mRealSort;
    private Sort mStringSort;
    private Sort mBooleanSort;
    private SortSymbol mBitVecSort;
    private SortSymbol mFloatingPointSort;
    private Sort mRoundingModeSort;
    private final ScopedHashMap<String, FunctionSymbolFactory> mFunFactory = new ScopedHashMap();
    private final UnifyHash<FunctionSymbol> mModelValueCache = new UnifyHash();
    private final ScopedHashMap<String, SortSymbol> mDeclaredSorts = new ScopedHashMap();
    private final ScopedHashMap<String, FunctionSymbol> mDeclaredFuns = new ScopedHashMap();
    private final UnifyHash<LetTerm> mLetCache = new UnifyHash();
    private final UnifyHash<Term> mTermCache = new UnifyHash();
    private final UnifyHash<TermVariable> mTvUnify = new UnifyHash();
    private IRAWrapperFactory mIRAWrappers;
    public final ApplicationTerm mTrue;
    public final ApplicationTerm mFalse;
    public final FunctionSymbol mAnd;
    public final FunctionSymbol mOr;
    public final FunctionSymbol mNot;
    public final FunctionSymbol mImplies;
    public final FunctionSymbol mXor;
    public final PolymorphicFunctionSymbol mEquals;
    public final PolymorphicFunctionSymbol mDistinct;
    static final Sort[] EMPTY_SORT_ARRAY = Script.EMPTY_SORT_ARRAY;
    static final TermVariable[] EMPTY_TERM_VARIABLE_ARRAY = new TermVariable[0];
    static final Term[] EMPTY_TERM_ARRAY = Script.EMPTY_TERM_ARRAY;
    private static final String MODEL_VALUE_PATTERN = "@\\d+";
    public static final String BITVEC_CONST_PATTERN = "bv\\d+";
    private int mTvarCtr = 0;
    private int mAuxCounter = 0;
    private boolean mGlobalDecls;

    public Theory() {
        this.mFalse = null;
        this.mTrue = null;
        this.mXor = null;
        this.mImplies = null;
        this.mNot = null;
        this.mOr = null;
        this.mAnd = null;
        this.mDistinct = null;
        this.mEquals = null;
    }

    public Theory(Logics logics) {
        this(logics, null);
    }

    public Theory(Logics logics, SolverSetup solverSetup) {
        this.mSolverSetup = solverSetup;
        Sort[] sortArray = new Sort[]{};
        this.mBooleanSort = this.declareInternalSort("Bool", 0, 0).getSort(null, sortArray);
        Sort[] sortArray2 = this.createSortVariables("A");
        Sort[] sortArray3 = new Sort[]{this.mBooleanSort};
        Sort[] sortArray4 = new Sort[]{this.mBooleanSort, this.mBooleanSort};
        Sort[] sortArray5 = new Sort[]{sortArray2[0], sortArray2[0]};
        this.mNot = this.declareInternalFunction("not", sortArray3, this.mBooleanSort, 0);
        this.mAnd = this.declareInternalFunction("and", sortArray4, this.mBooleanSort, 2);
        this.mOr = this.declareInternalFunction("or", sortArray4, this.mBooleanSort, 2);
        this.mImplies = this.declareInternalFunction("=>", sortArray4, this.mBooleanSort, 4);
        this.mEquals = this.declareInternalPolymorphicFunction("=", sortArray2, sortArray5, this.mBooleanSort, 6);
        this.mDistinct = this.declareInternalPolymorphicFunction("distinct", sortArray2, sortArray5, this.mBooleanSort, 8);
        this.mXor = this.declareInternalFunction("xor", sortArray4, this.mBooleanSort, 2);
        this.declareInternalPolymorphicFunction("ite", sortArray2, new Sort[]{this.mBooleanSort, sortArray2[0], sortArray2[0]}, sortArray2[0], 0);
        this.mTrue = (ApplicationTerm)this.term(this.declareInternalFunction("true", sortArray, this.mBooleanSort, 0), new Term[0]);
        this.mFalse = (ApplicationTerm)this.term(this.declareInternalFunction("false", sortArray, this.mBooleanSort, 0), new Term[0]);
        this.declareInternalSort("->", 2, 64);
        this.setLogic(logics);
    }

    public BigInteger toNumeral(String string) {
        try {
            return new BigInteger(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SMTLIBException("not a numeral: " + string, numberFormatException);
        }
    }

    public FunctionSymbol getFunctionSymbol(String string) {
        return (FunctionSymbol)this.mDeclaredFuns.get((Object)string);
    }

    private Term simplifyAndOr(FunctionSymbol functionSymbol, Term ... termArray) {
        Term[] termArray2;
        ApplicationTerm applicationTerm = functionSymbol == this.mAnd ? this.mTrue : this.mFalse;
        LinkedHashSet<Object> linkedHashSet = new LinkedHashSet<Object>();
        Term[] termArray3 = termArray;
        int n = termArray.length;
        int n2 = 0;
        while (n2 < n) {
            termArray2 = termArray3[n2];
            if (termArray2 == this.mTrue || termArray2 == this.mFalse) {
                if (termArray2 != applicationTerm) {
                    return termArray2;
                }
            } else if (termArray2 instanceof ApplicationTerm && ((ApplicationTerm)termArray2).getFunction() == functionSymbol) {
                Term[] termArray4 = ((ApplicationTerm)termArray2).getParameters();
                int n3 = termArray4.length;
                int n4 = 0;
                while (n4 < n3) {
                    Term term = termArray4[n4];
                    linkedHashSet.add(term);
                    ++n4;
                }
            } else {
                linkedHashSet.add(termArray2);
            }
            ++n2;
        }
        if (linkedHashSet.size() <= 1) {
            if (linkedHashSet.isEmpty()) {
                return applicationTerm;
            }
            return (Term)linkedHashSet.iterator().next();
        }
        termArray2 = linkedHashSet.toArray(new Term[linkedHashSet.size()]);
        return this.term(functionSymbol, termArray2);
    }

    public Term not(Term term) {
        if (term == this.mTrue) {
            return this.mFalse;
        }
        if (term == this.mFalse) {
            return this.mTrue;
        }
        if (term instanceof ApplicationTerm && ((ApplicationTerm)term).getFunction() == this.mNot) {
            return ((ApplicationTerm)term).getParameters()[0];
        }
        return this.term(this.mNot, term);
    }

    public Term and(Term ... termArray) {
        return this.simplifyAndOr(this.mAnd, termArray);
    }

    public Term or(Term ... termArray) {
        return this.simplifyAndOr(this.mOr, termArray);
    }

    public Term implies(Term term, Term term2) {
        if (term2 == this.mTrue || term == this.mTrue) {
            return term2;
        }
        if (term == this.mFalse) {
            return this.mTrue;
        }
        if (term2 == this.mFalse) {
            return this.not(term);
        }
        if (term == term2) {
            return this.mTrue;
        }
        return this.term(this.mImplies, term, term2);
    }

    public Term xor(Term term, Term term2) {
        if (term == this.mTrue) {
            return this.not(term2);
        }
        if (term2 == this.mTrue) {
            return this.not(term);
        }
        if (term == this.mFalse) {
            return term2;
        }
        if (term2 == this.mFalse) {
            return term;
        }
        if (term == term2) {
            return this.mFalse;
        }
        return this.term(this.mXor, term, term2);
    }

    public Term ifthenelse(Term term, Term term2, Term term3) {
        if (term == this.mTrue) {
            return term2;
        }
        if (term == this.mFalse) {
            return term3;
        }
        if (term2 == term3) {
            return term2;
        }
        if (term2 == this.mTrue && term3 == this.mFalse) {
            return term;
        }
        if (term2 == this.mFalse && term3 == this.mTrue) {
            return this.not(term);
        }
        if (term2 == this.mTrue) {
            return this.term(this.mOr, term, term3);
        }
        if (term2 == this.mFalse) {
            return this.term(this.mAnd, this.term(this.mNot, term), term3);
        }
        if (term3 == this.mTrue) {
            return this.term(this.mImplies, term, term2);
        }
        if (term3 == this.mFalse) {
            return this.term(this.mAnd, term, term2);
        }
        return this.term("ite", term, term2, term3);
    }

    public Term lambda(TermVariable[] termVariableArray, Term term) {
        Term term22;
        int n = LambdaTerm.hashLambda(termVariableArray, term);
        for (Term term22 : this.mTermCache.iterateHashCode(n)) {
            LambdaTerm lambdaTerm;
            if (!(term22 instanceof LambdaTerm) || (lambdaTerm = (LambdaTerm)term22).getSubterm() != term || !Arrays.equals(lambdaTerm.getVariables(), termVariableArray)) continue;
            return lambdaTerm;
        }
        term22 = new LambdaTerm(termVariableArray, term, n);
        this.mTermCache.put(n, (Object)term22);
        return term22;
    }

    private Term quantify(int n, TermVariable[] termVariableArray, Term term) {
        Term term22;
        int n2 = QuantifiedFormula.hashQuantifier(n, termVariableArray, term);
        for (Term term22 : this.mTermCache.iterateHashCode(n2)) {
            QuantifiedFormula quantifiedFormula;
            if (!(term22 instanceof QuantifiedFormula) || (quantifiedFormula = (QuantifiedFormula)term22).getQuantifier() != n || quantifiedFormula.getSubformula() != term || !Arrays.equals(termVariableArray, quantifiedFormula.getVariables())) continue;
            return quantifiedFormula;
        }
        term22 = new QuantifiedFormula(n, termVariableArray, term, n2);
        this.mTermCache.put(n2, (Object)term22);
        return term22;
    }

    public Term exists(TermVariable[] termVariableArray, Term term) {
        return this.quantify(0, termVariableArray, term);
    }

    public Term forall(TermVariable[] termVariableArray, Term term) {
        return this.quantify(1, termVariableArray, term);
    }

    public Term match(Term term, TermVariable[][] termVariableArray, Term[] termArray, DataType.Constructor[] constructorArray) {
        Term term22;
        int n = MatchTerm.hashMatch(term, termVariableArray, termArray);
        for (Term term22 : this.mTermCache.iterateHashCode(n)) {
            MatchTerm matchTerm;
            if (!(term22 instanceof MatchTerm) || (matchTerm = (MatchTerm)term22).getDataTerm() != term || !Arrays.equals(matchTerm.getCases(), termArray) || !Arrays.deepEquals((Object[])matchTerm.getVariables(), (Object[])termVariableArray) || !Arrays.equals(matchTerm.getConstructors(), constructorArray)) continue;
            return matchTerm;
        }
        term22 = new MatchTerm(n, term, termVariableArray, termArray, constructorArray);
        this.mTermCache.put(n, (Object)term22);
        return term22;
    }

    public Term let(TermVariable[] termVariableArray, Term[] termArray, Term term) {
        LetTerm letTerm2;
        assert (termVariableArray.length == termArray.length);
        if (termVariableArray.length == 0) {
            return term;
        }
        int n = LetTerm.hashLet(termVariableArray, termArray, term);
        for (LetTerm letTerm2 : this.mLetCache.iterateHashCode(n)) {
            if (letTerm2.getSubTerm() != term || !Arrays.equals(letTerm2.getVariables(), termVariableArray) || !Arrays.equals(letTerm2.getValues(), termArray)) continue;
            return letTerm2;
        }
        letTerm2 = new LetTerm(termVariableArray, termArray, term, n);
        this.mLetCache.put(n, (Object)letTerm2);
        return letTerm2;
    }

    public Term let(TermVariable termVariable, Term term, Term term2) {
        return this.let(new TermVariable[]{termVariable}, new Term[]{term}, term2);
    }

    public Term distinct(Term ... termArray) {
        if (termArray.length < 2) {
            return null;
        }
        if (termArray.length == 2) {
            if (termArray[0] == termArray[1]) {
                return this.mFalse;
            }
            if (termArray[0].getSort() == this.mBooleanSort) {
                if (termArray[0] == this.mFalse) {
                    return termArray[1];
                }
                if (termArray[1] == this.mFalse) {
                    return termArray[0];
                }
                if (termArray[0] == this.mTrue) {
                    return this.not(termArray[1]);
                }
                if (termArray[1] == this.mTrue) {
                    return this.not(termArray[0]);
                }
            }
            return this.term(this.mDistinct, termArray);
        }
        HashSet<Term> hashSet = new HashSet<Term>(Arrays.asList(termArray));
        if (hashSet.size() != termArray.length) {
            return this.mFalse;
        }
        return this.term(this.mDistinct, termArray);
    }

    public Term equals(Term ... termArray) {
        if (termArray.length < 2) {
            return null;
        }
        if (termArray.length == 2) {
            if (termArray[0] == termArray[1]) {
                return this.mTrue;
            }
            if (termArray[0].getSort() == this.mBooleanSort) {
                if (termArray[0] == this.mTrue) {
                    return termArray[1];
                }
                if (termArray[1] == this.mTrue) {
                    return termArray[0];
                }
                if (termArray[0] == this.mFalse) {
                    return this.not(termArray[1]);
                }
                if (termArray[1] == this.mFalse) {
                    return this.not(termArray[0]);
                }
            }
            return this.term(this.mEquals, termArray);
        }
        HashSet<Term> hashSet = new HashSet<Term>(Arrays.asList(termArray));
        if (hashSet.size() == 1) {
            return this.mTrue;
        }
        return this.term(this.mEquals, termArray);
    }

    public Term constant(Object object, Sort sort) {
        Term term2;
        Comparable<Rational> comparable;
        if (object instanceof Rational) {
            if (!sort.isNumericSort()) {
                throw new SMTLIBException("Not a numeric sort");
            }
            comparable = (Rational)object;
            if (!((Rational)comparable).isRational()) {
                throw new SMTLIBException("Infinite/NaN value");
            }
            if (sort.getName().equals("Int") && !((Rational)comparable).isIntegral()) {
                throw new SMTLIBException("Non-integral value with integer sort");
            }
        }
        if (sort.isBitVecSort() && object instanceof BigInteger && (((BigInteger)(comparable = (BigInteger)object)).signum() < 0 || ((BigInteger)comparable).bitLength() > Integer.valueOf(sort.getIndices()[0]))) {
            throw new SMTLIBException("Bitvector constant out of range");
        }
        int n = ConstantTerm.hashConstant(object, sort);
        for (Term term2 : this.mTermCache.iterateHashCode(n)) {
            ConstantTerm constantTerm;
            if (!(term2 instanceof ConstantTerm) || (constantTerm = (ConstantTerm)term2).getSort() != sort || !object.equals(constantTerm.getValue())) continue;
            return constantTerm;
        }
        term2 = new ConstantTerm(object, sort, n);
        this.mTermCache.put(n, (Object)term2);
        return term2;
    }

    public Term numeral(BigInteger bigInteger) {
        if (this.mNumericSort != this.mRealSort) {
            return this.constant(Rational.valueOf(bigInteger, BigInteger.ONE), this.mNumericSort);
        }
        return this.constant(bigInteger, this.mNumericSort);
    }

    public Term numeral(String string) {
        return this.numeral(this.toNumeral(string));
    }

    public Term decimal(BigDecimal bigDecimal) {
        if (bigDecimal.scale() <= 0 || bigDecimal.scale() == 1 && bigDecimal.remainder(BigDecimal.ONE).signum() == 0) {
            return this.constant(Rational.valueOf(bigDecimal.toBigIntegerExact(), BigInteger.ONE), this.mRealSort);
        }
        Term term = this.constant(bigDecimal.abs(), this.mRealSort);
        if (bigDecimal.signum() < 0) {
            FunctionSymbol functionSymbol = this.getFunction("-", this.mRealSort);
            term = this.term(functionSymbol, term);
        }
        return term;
    }

    public Term decimal(String string) {
        return this.decimal(new BigDecimal(string));
    }

    public Term rational(Rational rational, Sort sort) {
        return this.constant(rational, sort);
    }

    public Term binary(String string) {
        assert (string.startsWith("#b"));
        if (this.mBitVecSort == null) {
            return null;
        }
        String string2 = String.valueOf(string.length() - 2);
        Sort sort = this.mBitVecSort.getSort(new String[]{string2}, new Sort[0]);
        return new ConstantTerm(string, sort, ConstantTerm.hashConstant(string, sort));
    }

    public Term hexadecimal(String string) {
        assert (string.startsWith("#x"));
        if (this.mBitVecSort == null) {
            return null;
        }
        String string2 = String.valueOf(4 * (string.length() - 2));
        Sort sort = this.mBitVecSort.getSort(new String[]{string2}, new Sort[0]);
        return new ConstantTerm(string, sort, ConstantTerm.hashConstant(string, sort));
    }

    public Term modelRational(Rational rational, Sort sort) {
        BigInteger bigInteger = rational.numerator();
        BigInteger bigInteger2 = rational.denominator();
        if (sort == this.mRealSort) {
            if (this.mLogic.isIRA()) {
                FunctionSymbol functionSymbol = this.getFunction("/", this.mRealSort, this.mRealSort);
                FunctionSymbol functionSymbol2 = this.getFunction("to_real", this.mNumericSort);
                Term term = this.term(functionSymbol2, this.numeral(bigInteger.abs()));
                if (bigInteger.signum() < 0) {
                    term = this.term("-", term);
                }
                return this.term(functionSymbol, term, this.term(functionSymbol2, this.numeral(bigInteger2)));
            }
            if (bigInteger2.equals(BigInteger.ONE)) {
                return this.decimal(new BigDecimal(bigInteger));
            }
            FunctionSymbol functionSymbol = this.getFunction("/", this.mNumericSort, this.mNumericSort);
            return this.term(functionSymbol, this.numeral(bigInteger), this.numeral(bigInteger2));
        }
        assert (bigInteger2.equals(BigInteger.ONE));
        return this.numeral(rational.numerator());
    }

    public Term string(QuotedObject quotedObject) {
        return this.constant(quotedObject, this.mStringSort);
    }

    public Logics getLogic() {
        return this.mLogic;
    }

    public FunctionSymbol declareInternalFunction(String string, Sort[] sortArray, Sort sort, int n) {
        return this.defineFunction(string, sortArray, sort, null, null, n | 1);
    }

    public FunctionSymbol declareInternalFunction(String string, Sort[] sortArray, TermVariable[] termVariableArray, Term term, int n) {
        return this.defineFunction(string, sortArray, term.getSort(), termVariableArray, term, n | 1);
    }

    public PolymorphicFunctionSymbol declareInternalPolymorphicFunction(String string, Sort[] sortArray, Sort[] sortArray2, Sort sort, int n) {
        assert (!this.mFunFactory.containsKey((Object)string));
        PolymorphicFunctionSymbol polymorphicFunctionSymbol = new PolymorphicFunctionSymbol(string, sortArray, sortArray2, sort, n | 1);
        this.declareInternalFunctionFactory(polymorphicFunctionSymbol);
        return polymorphicFunctionSymbol;
    }

    private Term absDefinition(TermVariable termVariable) {
        Term term = Rational.ZERO.toTerm(termVariable.getSort());
        return this.term("ite", this.term("<", termVariable, term), this.term("-", termVariable), termVariable);
    }

    private void createNumericOperators(Sort sort, boolean bl) {
        Sort[] sortArray = new Sort[]{sort};
        Sort[] sortArray2 = new Sort[]{sort, sort};
        this.declareInternalFunction("+", sortArray2, sort, 2);
        this.declareInternalFunctionFactory(new MinusFunctionFactory(sort, sort));
        this.declareInternalFunction("*", sortArray2, sort, 2);
        if (bl) {
            this.declareInternalFunction("/", sortArray2, sort, 66);
        } else {
            this.declareInternalFunction("div", sortArray2, sort, 66);
            this.declareInternalFunction("mod", sortArray2, sort, 64);
            this.declareInternalFunctionFactory(new DivisibleFunctionFactory());
        }
        Sort sort2 = this.mBooleanSort;
        this.declareInternalFunction(">", sortArray2, sort2, 6);
        this.declareInternalFunction(">=", sortArray2, sort2, 6);
        this.declareInternalFunction("<", sortArray2, sort2, 6);
        this.declareInternalFunction("<=", sortArray2, sort2, 6);
        TermVariable termVariable = this.createTermVariable("x", sort);
        this.declareInternalFunction("abs", sortArray, new TermVariable[]{termVariable}, this.absDefinition(termVariable), 0);
    }

    private void createIRAOperators() {
        this.mIRAWrappers = new IRAWrapperFactory();
        class BinArithFactory
        extends FunctionSymbolFactory {
            Sort mReturnSort;
            int mFlags;

            BinArithFactory(String string, Sort sort, int n) {
                super(string);
                this.mReturnSort = sort;
                this.mFlags = n | 1;
            }

            @Override
            public int getFlags(String[] stringArray, Sort[] sortArray, Sort sort) {
                return this.mFlags;
            }

            @Override
            public Sort getResultSort(String[] stringArray, Sort[] sortArray, Sort sort) {
                if (stringArray == null && sortArray.length == 2 && sortArray[0] == sortArray[1] && (sortArray[0] == Theory.this.mNumericSort || sortArray[0] == Theory.this.mRealSort) && sort == null) {
                    return this.mReturnSort == null ? sortArray[0] : this.mReturnSort;
                }
                return null;
            }
        }
        this.declareInternalFunctionFactory(new BinArithFactory("+", null, 2));
        this.declareInternalFunctionFactory(new MinusFunctionFactory(this.mNumericSort, this.mRealSort));
        this.declareInternalFunctionFactory(new BinArithFactory("*", null, 2));
        this.declareInternalFunctionFactory(new BinArithFactory(">", this.mBooleanSort, 6));
        this.declareInternalFunctionFactory(new BinArithFactory(">=", this.mBooleanSort, 6));
        this.declareInternalFunctionFactory(new BinArithFactory("<", this.mBooleanSort, 6));
        this.declareInternalFunctionFactory(new BinArithFactory("<=", this.mBooleanSort, 6));
        Sort[] sortArray = new Sort[]{this.mNumericSort};
        Sort[] sortArray2 = new Sort[]{this.mNumericSort, this.mNumericSort};
        Sort[] sortArray3 = new Sort[]{this.mRealSort};
        Sort[] sortArray4 = new Sort[]{this.mRealSort, this.mRealSort};
        this.declareInternalFunction("/", sortArray4, this.mRealSort, 2);
        this.declareInternalFunction("div", sortArray2, this.mNumericSort, 2);
        this.declareInternalFunctionFactory(new DivisibleFunctionFactory());
        this.declareInternalFunction("to_real", sortArray, this.mRealSort, 0);
        this.declareInternalFunction("to_int", sortArray3, this.mNumericSort, 0);
        this.declareInternalFunction("mod", sortArray2, this.mNumericSort, 0);
        TermVariable termVariable = this.createTermVariable("x1", this.mRealSort);
        Term term = this.term("=", termVariable, this.term("to_real", this.term("to_int", termVariable)));
        this.declareInternalFunction("is_int", sortArray3, new TermVariable[]{termVariable}, term, 0);
        this.declareInternalFunctionFactory(new FunctionSymbolFactory("abs"){

            @Override
            public Term getDefinition(TermVariable[] termVariableArray, Sort sort) {
                return Theory.this.absDefinition(termVariableArray[0]);
            }

            @Override
            public Sort getResultSort(String[] stringArray, Sort[] sortArray, Sort sort) {
                if (stringArray == null && sortArray.length == 1 && (sortArray[0] == Theory.this.mNumericSort || sortArray[0] == Theory.this.mRealSort) && sort == null) {
                    return sortArray[0];
                }
                return null;
            }
        });
    }

    private void createArrayOperators() {
        Sort[] sortArray = this.createSortVariables("X", "Y");
        SortSymbol sortSymbol = this.declareInternalSort("Array", 2, 16);
        Sort sort = sortSymbol.getSort(null, sortArray);
        this.declareInternalPolymorphicFunction("select", sortArray, new Sort[]{sort, sortArray[0]}, sortArray[1], 0);
        this.declareInternalPolymorphicFunction("store", sortArray, new Sort[]{sort, sortArray[0], sortArray[1]}, sort, 0);
        this.declareInternalPolymorphicFunction("const", sortArray, new Sort[]{sortArray[1]}, sort, 17);
        Sort sort2 = this.getSort("->", sortArray);
        this.declareInternalPolymorphicFunction(".arrayof", sortArray, new Sort[]{sort2}, sort, 17);
    }

    private void createBitVecSort() {
        this.mBitVecSort = new SortSymbol(this, "BitVec", 0, null, 5){

            @Override
            public void checkArity(String[] stringArray, int n) {
                if (stringArray == null || stringArray.length != 1) {
                    throw new IllegalArgumentException("BitVec needs one index");
                }
                if (Theory.this.toNumeral(stringArray[0]).signum() <= 0) {
                    throw new IllegalArgumentException("BitVec index must be positive");
                }
                if (n != 0) {
                    throw new IllegalArgumentException("BitVec has no parameters");
                }
            }
        };
        this.mDeclaredSorts.put((Object)"BitVec", (Object)this.mBitVecSort);
    }

    private void createBitVecOperators() {
        this.declareInternalFunctionFactory(new FunctionSymbolFactory("concat"){

            @Override
            public int getFlags(String[] stringArray, Sort[] sortArray, Sort sort) {
                return 1;
            }

            @Override
            public Sort getResultSort(String[] stringArray, Sort[] sortArray, Sort sort) {
                if (stringArray != null || sortArray.length != 2 || sort != null || sortArray[0].getName() != "BitVec" || sortArray[1].getName() != "BitVec") {
                    return null;
                }
                BigInteger bigInteger = Theory.this.toNumeral(sortArray[0].getIndices()[0]);
                BigInteger bigInteger2 = Theory.this.toNumeral(sortArray[1].getIndices()[0]);
                BigInteger bigInteger3 = bigInteger.add(bigInteger2);
                return Theory.this.mBitVecSort.getSort(new String[]{bigInteger3.toString()}, new Sort[0]);
            }
        });
        this.declareInternalFunctionFactory(new FunctionSymbolFactory("extract"){

            @Override
            public Sort getResultSort(String[] stringArray, Sort[] sortArray, Sort sort) {
                if (stringArray == null || stringArray.length < 2 || sortArray.length != 1 || sort != null || sortArray[0].getName() != "BitVec") {
                    return null;
                }
                BigInteger bigInteger = Theory.this.toNumeral(stringArray[0]);
                BigInteger bigInteger2 = Theory.this.toNumeral(stringArray[1]);
                BigInteger bigInteger3 = Theory.this.toNumeral(sortArray[0].getIndices()[0]);
                if (bigInteger.compareTo(bigInteger2) < 0 || bigInteger3.compareTo(bigInteger) < 0) {
                    return null;
                }
                BigInteger bigInteger4 = bigInteger.subtract(bigInteger2).add(BigInteger.ONE);
                return Theory.this.mBitVecSort.getSort(new String[]{bigInteger4.toString()}, new Sort[0]);
            }
        });
        Sort sort = this.mBitVecSort.getSort(new String[]{BigInteger.ONE.toString()}, new Sort[0]);
        class RegularBitVecFunction
        extends FunctionSymbolFactory {
            int mNumArgs;
            int mFlags;
            Sort mResult;

            public RegularBitVecFunction(String string, int n, Sort sort, int n2) {
                super(string);
                this.mNumArgs = n;
                this.mResult = sort;
                this.mFlags = n2;
            }

            public RegularBitVecFunction(String string, int n, Sort sort) {
                this(string, n, sort, 1);
            }

            @Override
            public int getFlags(String[] stringArray, Sort[] sortArray, Sort sort) {
                return this.mFlags;
            }

            @Override
            public Sort getResultSort(String[] stringArray, Sort[] sortArray, Sort sort) {
                if (stringArray != null || sortArray.length != this.mNumArgs || sort != null || sortArray[0].getName() != "BitVec") {
                    return null;
                }
                int n = 1;
                while (n < this.mNumArgs) {
                    if (sortArray[n] != sortArray[0]) {
                        return null;
                    }
                    ++n;
                }
                return this.mResult == null ? sortArray[0] : this.mResult;
            }
        }
        this.declareInternalFunctionFactory(new RegularBitVecFunction("bvnot", 1, null));
        this.declareInternalFunctionFactory(new RegularBitVecFunction("bvand", 2, null, 3));
        this.declareInternalFunctionFactory(new RegularBitVecFunction("bvor", 2, null, 3));
        this.declareInternalFunctionFactory(new RegularBitVecFunction("bvneg", 1, null));
        this.declareInternalFunctionFactory(new RegularBitVecFunction("bvadd", 2, null, 3));
        this.declareInternalFunctionFactory(new RegularBitVecFunction("bvmul", 2, null, 3));
        this.declareInternalFunctionFactory(new RegularBitVecFunction("bvudiv", 2, null));
        this.declareInternalFunctionFactory(new RegularBitVecFunction("bvurem", 2, null));
        this.declareInternalFunctionFactory(new RegularBitVecFunction("bvshl", 2, null));
        this.declareInternalFunctionFactory(new RegularBitVecFunction("bvlshr", 2, null));
        this.declareInternalFunctionFactory(new RegularBitVecFunction("bvnand", 2, null));
        this.declareInternalFunctionFactory(new RegularBitVecFunction("bvnor", 2, null));
        this.declareInternalFunctionFactory(new RegularBitVecFunction("bvxor", 2, null, 3));
        this.declareInternalFunctionFactory(new RegularBitVecFunction("bvxnor", 2, null));
        this.declareInternalFunctionFactory(new RegularBitVecFunction("bvcomp", 2, sort));
        this.declareInternalFunctionFactory(new RegularBitVecFunction("bvsub", 2, null));
        this.declareInternalFunctionFactory(new RegularBitVecFunction("bvsdiv", 2, null));
        this.declareInternalFunctionFactory(new RegularBitVecFunction("bvsrem", 2, null));
        this.declareInternalFunctionFactory(new RegularBitVecFunction("bvsmod", 2, null));
        this.declareInternalFunctionFactory(new RegularBitVecFunction("bvashr", 2, null));
        this.declareInternalFunctionFactory(new FunctionSymbolFactory("repeat"){

            @Override
            public Sort getResultSort(String[] stringArray, Sort[] sortArray, Sort sort) {
                if (stringArray == null || stringArray.length != 1 || sortArray.length != 1 || sort != null || sortArray[0].getName() != "BitVec") {
                    return null;
                }
                BigInteger bigInteger = Theory.this.toNumeral(stringArray[0]).multiply(Theory.this.toNumeral(sortArray[0].getIndices()[0]));
                return Theory.this.mBitVecSort.getSort(new String[]{bigInteger.toString()}, new Sort[0]);
            }
        });
        class ExtendBitVecFunction
        extends FunctionSymbolFactory {
            public ExtendBitVecFunction(String string) {
                super(string);
            }

            @Override
            public Sort getResultSort(String[] stringArray, Sort[] sortArray, Sort sort) {
                if (stringArray == null || stringArray.length != 1 || sortArray.length != 1 || sort != null || sortArray[0].getName() != "BitVec") {
                    return null;
                }
                BigInteger bigInteger = Theory.this.toNumeral(stringArray[0]).add(Theory.this.toNumeral(sortArray[0].getIndices()[0]));
                return Theory.this.mBitVecSort.getSort(new String[]{bigInteger.toString()}, new Sort[0]);
            }
        }
        this.declareInternalFunctionFactory(new ExtendBitVecFunction("zero_extend"));
        this.declareInternalFunctionFactory(new ExtendBitVecFunction("sign_extend"));
        class RotateBitVecFunction
        extends FunctionSymbolFactory {
            public RotateBitVecFunction(String string) {
                super(string);
            }

            @Override
            public Sort getResultSort(String[] stringArray, Sort[] sortArray, Sort sort) {
                if (stringArray == null || stringArray.length != 1 || sortArray.length != 1 || sort != null || sortArray[0].getName() != "BitVec") {
                    return null;
                }
                return sortArray[0];
            }
        }
        this.declareInternalFunctionFactory(new RotateBitVecFunction("rotate_left"));
        this.declareInternalFunctionFactory(new RotateBitVecFunction("rotate_right"));
        this.declareInternalFunctionFactory(new RegularBitVecFunction("bvult", 2, this.mBooleanSort, 7));
        this.declareInternalFunctionFactory(new RegularBitVecFunction("bvule", 2, this.mBooleanSort, 7));
        this.declareInternalFunctionFactory(new RegularBitVecFunction("bvugt", 2, this.mBooleanSort, 7));
        this.declareInternalFunctionFactory(new RegularBitVecFunction("bvuge", 2, this.mBooleanSort, 7));
        this.declareInternalFunctionFactory(new RegularBitVecFunction("bvslt", 2, this.mBooleanSort, 7));
        this.declareInternalFunctionFactory(new RegularBitVecFunction("bvsle", 2, this.mBooleanSort, 7));
        this.declareInternalFunctionFactory(new RegularBitVecFunction("bvsgt", 2, this.mBooleanSort, 7));
        this.declareInternalFunctionFactory(new RegularBitVecFunction("bvsge", 2, this.mBooleanSort, 7));
        class Bv2NatFunction
        extends FunctionSymbolFactory {
            public Bv2NatFunction(String string) {
                super(string);
                if (!$assertionsDisabled && !string.equals("bv2nat")) {
                    throw new AssertionError((Object)("Wrong name: " + string));
                }
            }

            @Override
            public Sort getResultSort(String[] stringArray, Sort[] sortArray, Sort sort) {
                if (stringArray != null || sortArray.length != 1 || sortArray[0].getName() != "BitVec" || sort != null) {
                    return null;
                }
                return Theory.this.mNumericSort;
            }
        }
        this.declareInternalFunctionFactory(new Bv2NatFunction("bv2nat"));
        class Nat2BvFunction
        extends FunctionSymbolFactory {
            public Nat2BvFunction(String string) {
                super(string);
                if (!$assertionsDisabled && !string.equals("nat2bv")) {
                    throw new AssertionError((Object)("Wrong name: " + string));
                }
            }

            @Override
            public Sort getResultSort(String[] stringArray, Sort[] sortArray, Sort sort) {
                if (stringArray == null || stringArray.length != 1 || sortArray.length != 1 || !sortArray[0].getName().equals("Int") || sort != null) {
                    return null;
                }
                return Theory.this.mBitVecSort.getSort(stringArray, new Sort[0]);
            }
        }
        this.declareInternalFunctionFactory(new Nat2BvFunction("nat2bv"));
    }

    private void createFloatingPointOperators() {
        this.mFloatingPointSort = new SortSymbol(this, "FloatingPoint", 0, null, 5){

            @Override
            public void checkArity(String[] stringArray, int n) {
                if (stringArray == null || stringArray.length != 2) {
                    throw new IllegalArgumentException("Floating Point needs two indices");
                }
                if (Theory.this.toNumeral(stringArray[0]).signum() <= 0 || Theory.this.toNumeral(stringArray[1]).signum() <= 0) {
                    throw new IllegalArgumentException("FloatingPoint indices must be greater 0");
                }
                if (n != 0) {
                    throw new IllegalArgumentException("FloatingPoint has no parameters");
                }
            }
        };
        this.mDeclaredSorts.put((Object)"FloatingPoint", (Object)this.mFloatingPointSort);
        this.mRoundingModeSort = this.declareInternalSort("RoundingMode", 0, 0).getSort(null, new Sort[0]);
        this.declareInternalFunctionFactory(new FunctionSymbolFactory("fp"){

            @Override
            public Sort getResultSort(String[] stringArray, Sort[] sortArray, Sort sort) {
                if (stringArray != null || sortArray.length != 3 || sort != null || sortArray[0].getName() != "BitVec" || sortArray[1].getName() != "BitVec" || sortArray[2].getName() != "BitVec") {
                    return null;
                }
                BigInteger bigInteger = Theory.this.toNumeral(sortArray[0].getIndices()[0]);
                if (!bigInteger.equals(BigInteger.ONE)) {
                    return null;
                }
                String[] stringArray2 = new String[]{Theory.this.toNumeral(sortArray[1].getIndices()[0]).toString(), Theory.this.toNumeral(sortArray[2].getIndices()[0]).add(BigInteger.ONE).toString()};
                return Theory.this.mFloatingPointSort.getSort(stringArray2, new Sort[0]);
            }
        });
        this.declareInternalFunctionFactory(new FunctionSymbolFactory("to_fp"){

            @Override
            public Sort getResultSort(String[] stringArray, Sort[] sortArray, Sort sort) {
                if (stringArray == null || stringArray.length != 2 || sortArray == null) {
                    return null;
                }
                if (sortArray.length == 1 && sortArray[0].getName() == "BitVec") {
                    if (!Theory.this.toNumeral(stringArray[0]).add(Theory.this.toNumeral(stringArray[1])).equals(Theory.this.toNumeral(sortArray[0].getIndices()[0]))) {
                        return null;
                    }
                    return Theory.this.mFloatingPointSort.getSort(stringArray, new Sort[0]);
                }
                if (sortArray.length == 2 && sortArray[0].getName() == "RoundingMode" && sortArray[1].getName() == "FloatingPoint") {
                    return Theory.this.mFloatingPointSort.getSort(stringArray, new Sort[0]);
                }
                if (sortArray.length == 2 && sortArray[0].getName() == "RoundingMode" && sortArray[1].getName() == "Real") {
                    return Theory.this.mFloatingPointSort.getSort(stringArray, new Sort[0]);
                }
                if (sortArray.length == 2 && sortArray[0].getName() == "RoundingMode" && sortArray[1].getName() == "BitVec") {
                    return Theory.this.mFloatingPointSort.getSort(stringArray, new Sort[0]);
                }
                return null;
            }
        });
        this.declareInternalFunctionFactory(new FunctionSymbolFactory("to_fp_unsigned"){

            @Override
            public Sort getResultSort(String[] stringArray, Sort[] sortArray, Sort sort) {
                if (stringArray == null || stringArray.length != 2 || sortArray.length != 2 || sort != null || sortArray[0].getName() != "RoundingMode" || sortArray[1].getName() != "BitVec") {
                    return null;
                }
                return Theory.this.mFloatingPointSort.getSort(stringArray, new Sort[0]);
            }
        });
        this.declareInternalFunctionFactory(new FunctionSymbolFactory("fp.to_ubv"){

            @Override
            public Sort getResultSort(String[] stringArray, Sort[] sortArray, Sort sort) {
                if (stringArray == null || stringArray.length != 1 || sortArray.length != 2 || sort != null || sortArray[0].getName() != "RoundingMode" || sortArray[1].getName() != "FloatingPoint") {
                    return null;
                }
                return Theory.this.mBitVecSort.getSort(new String[]{stringArray[0]}, new Sort[0]);
            }
        });
        this.declareInternalFunctionFactory(new FunctionSymbolFactory("fp.to_sbv"){

            @Override
            public Sort getResultSort(String[] stringArray, Sort[] sortArray, Sort sort) {
                if (stringArray == null || stringArray.length != 1 || sortArray.length != 2 || sort != null || sortArray[0].getName() != "RoundingMode" || sortArray[1].getName() != "FloatingPoint") {
                    return null;
                }
                return Theory.this.mBitVecSort.getSort(new String[]{stringArray[0]}, new Sort[0]);
            }
        });
        class FloatingPointConstant
        extends FunctionSymbolFactory {
            public FloatingPointConstant(String string) {
                super(string);
            }

            @Override
            public Sort getResultSort(String[] stringArray, Sort[] sortArray, Sort sort) {
                if (stringArray.length != 2 || sortArray.length != 0 || sort != null) {
                    return null;
                }
                return Theory.this.mFloatingPointSort.getSort(stringArray, new Sort[0]);
            }
        }
        this.declareInternalFunctionFactory(new FloatingPointConstant("+oo"));
        this.declareInternalFunctionFactory(new FloatingPointConstant("-oo"));
        this.declareInternalFunctionFactory(new FloatingPointConstant("+zero"));
        this.declareInternalFunctionFactory(new FloatingPointConstant("-zero"));
        this.declareInternalFunctionFactory(new FloatingPointConstant("NaN"));
        this.defineSort("Float16", 0, this.mFloatingPointSort.getSort(new String[]{new String("5"), new String("11")}, new Sort[0]));
        this.defineSort("Float32", 0, this.mFloatingPointSort.getSort(new String[]{new String("8"), new String("24")}, new Sort[0]));
        this.defineSort("Float64", 0, this.mFloatingPointSort.getSort(new String[]{new String("11"), new String("53")}, new Sort[0]));
        this.defineSort("Float128", 0, this.mFloatingPointSort.getSort(new String[]{new String("15"), new String("113")}, new Sort[0]));
        this.declareInternalFunction("roundNearestTiesToEven", new Sort[0], this.mRoundingModeSort, 0);
        this.declareInternalFunction("roundNearestTiesToAway", new Sort[0], this.mRoundingModeSort, 0);
        this.declareInternalFunction("roundTowardPositive", new Sort[0], this.mRoundingModeSort, 0);
        this.declareInternalFunction("roundTowardNegative", new Sort[0], this.mRoundingModeSort, 0);
        this.declareInternalFunction("roundTowardZero", new Sort[0], this.mRoundingModeSort, 0);
        this.defineFunction("RNE", new Sort[0], this.mRoundingModeSort, new TermVariable[0], this.term("roundNearestTiesToEven", new Term[0]), 1);
        this.defineFunction("RNA", new Sort[0], this.mRoundingModeSort, new TermVariable[0], this.term("roundNearestTiesToAway", new Term[0]), 1);
        this.defineFunction("RTP", new Sort[0], this.mRoundingModeSort, new TermVariable[0], this.term("roundTowardPositive", new Term[0]), 1);
        this.defineFunction("RTN", new Sort[0], this.mRoundingModeSort, new TermVariable[0], this.term("roundTowardNegative", new Term[0]), 1);
        this.defineFunction("RTZ", new Sort[0], this.mRoundingModeSort, new TermVariable[0], this.term("roundTowardZero", new Term[0]), 1);
        class RegularFloatingPointFunction
        extends FunctionSymbolFactory {
            int mNumArgs;
            Sort mResult;
            int mFlags;
            int mFirstFloat;

            public RegularFloatingPointFunction(String string, int n, Sort sort, int n2) {
                super(string);
                this.mNumArgs = n;
                this.mResult = sort;
                this.mFlags = n2;
            }

            @Override
            public int getFlags(String[] stringArray, Sort[] sortArray, Sort sort) {
                return this.mFlags;
            }

            @Override
            public Sort getResultSort(String[] stringArray, Sort[] sortArray, Sort sort) {
                if (stringArray != null || sortArray.length != this.mNumArgs || sort != null) {
                    return null;
                }
                this.mFirstFloat = sortArray[0].getName() == "RoundingMode" ? 1 : 0;
                int n = this.mFirstFloat;
                while (n < this.mNumArgs) {
                    if (sortArray[n].getName() != "FloatingPoint") {
                        return null;
                    }
                    ++n;
                }
                return this.mResult == null ? sortArray[this.mFirstFloat] : this.mResult;
            }
        }
        this.declareInternalFunctionFactory(new RegularFloatingPointFunction("fp.abs", 1, null, 1));
        this.declareInternalFunctionFactory(new RegularFloatingPointFunction("fp.neg", 1, null, 1));
        this.declareInternalFunctionFactory(new RegularFloatingPointFunction("fp.min", 2, null, 1));
        this.declareInternalFunctionFactory(new RegularFloatingPointFunction("fp.max", 2, null, 1));
        this.declareInternalFunctionFactory(new RegularFloatingPointFunction("fp.rem", 2, null, 1));
        this.declareInternalFunctionFactory(new RegularFloatingPointFunction("fp.add", 3, null, 1));
        this.declareInternalFunctionFactory(new RegularFloatingPointFunction("fp.sub", 3, null, 1));
        this.declareInternalFunctionFactory(new RegularFloatingPointFunction("fp.mul", 3, null, 1));
        this.declareInternalFunctionFactory(new RegularFloatingPointFunction("fp.div", 3, null, 1));
        this.declareInternalFunctionFactory(new RegularFloatingPointFunction("fp.fma", 4, null, 1));
        this.declareInternalFunctionFactory(new RegularFloatingPointFunction("fp.sqrt", 2, null, 1));
        this.declareInternalFunctionFactory(new RegularFloatingPointFunction("fp.roundToIntegral", 2, null, 1));
        this.declareInternalFunctionFactory(new RegularFloatingPointFunction("fp.leq", 2, this.mBooleanSort, 7));
        this.declareInternalFunctionFactory(new RegularFloatingPointFunction("fp.lt", 2, this.mBooleanSort, 7));
        this.declareInternalFunctionFactory(new RegularFloatingPointFunction("fp.geq", 2, this.mBooleanSort, 7));
        this.declareInternalFunctionFactory(new RegularFloatingPointFunction("fp.gt", 2, this.mBooleanSort, 7));
        this.declareInternalFunctionFactory(new RegularFloatingPointFunction("fp.eq", 2, this.mBooleanSort, 7));
        this.declareInternalFunctionFactory(new RegularFloatingPointFunction("fp.isNormal", 1, this.mBooleanSort, 1));
        this.declareInternalFunctionFactory(new RegularFloatingPointFunction("fp.isSubnormal", 1, this.mBooleanSort, 1));
        this.declareInternalFunctionFactory(new RegularFloatingPointFunction("fp.isZero", 1, this.mBooleanSort, 1));
        this.declareInternalFunctionFactory(new RegularFloatingPointFunction("fp.isInfinite", 1, this.mBooleanSort, 1));
        this.declareInternalFunctionFactory(new RegularFloatingPointFunction("fp.isNaN", 1, this.mBooleanSort, 1));
        this.declareInternalFunctionFactory(new RegularFloatingPointFunction("fp.isNegative", 1, this.mBooleanSort, 1));
        this.declareInternalFunctionFactory(new RegularFloatingPointFunction("fp.isPositive", 1, this.mBooleanSort, 1));
        this.declareInternalFunctionFactory(new RegularFloatingPointFunction("fp.to_real", 1, this.mRealSort, 1));
    }

    private void createStringOperators() {
        final Sort sort = this.declareInternalSort("String", 0, 0).getSort(null, new Sort[0]);
        final Sort sort2 = this.declareInternalSort("RegLan", 0, 0).getSort(null, new Sort[0]);
        this.mStringSort = sort;
        Sort[] sortArray = new Sort[]{sort};
        Sort[] sortArray2 = new Sort[]{sort, sort};
        Sort[] sortArray3 = new Sort[]{sort, sort, sort};
        Sort[] sortArray4 = new Sort[]{sort, sort2};
        Sort[] sortArray5 = new Sort[]{sort, sort2, sort};
        Sort[] sortArray6 = new Sort[]{sort2};
        Sort[] sortArray7 = new Sort[]{sort2, sort2};
        this.declareInternalFunctionFactory(new FunctionSymbolFactory("char"){

            @Override
            public Sort getResultSort(String[] stringArray, Sort[] sortArray, Sort sort2) {
                if (stringArray == null || stringArray.length != 1 || sortArray.length != 0 || sort2 != null) {
                    return null;
                }
                String string = stringArray[0];
                if (!string.startsWith("#x") || string.length() <= 2 || string.length() > 7 || string.length() == 7 && string.charAt(2) > '2') {
                    return null;
                }
                return sort;
            }
        });
        this.declareInternalFunction("str.++", sortArray2, sort, 2);
        this.declareInternalFunction("str.<", sortArray2, this.mBooleanSort, 6);
        this.declareInternalFunction("str.to_re", sortArray, sort2, 0);
        this.declareInternalFunction("str.in_re", sortArray4, this.mBooleanSort, 0);
        this.declareInternalFunction("re.none", EMPTY_SORT_ARRAY, sort2, 0);
        this.declareInternalFunction("re.all", EMPTY_SORT_ARRAY, sort2, 0);
        this.declareInternalFunction("re.allchar", EMPTY_SORT_ARRAY, sort2, 0);
        this.declareInternalFunction("re.++", sortArray7, sort2, 2);
        this.declareInternalFunction("re.union", sortArray7, sort2, 2);
        this.declareInternalFunction("re.inter", sortArray7, sort2, 2);
        this.declareInternalFunction("re.*", sortArray6, sort2, 0);
        this.declareInternalFunction("str.<=", sortArray2, this.mBooleanSort, 6);
        this.declareInternalFunction("str.prefixof", sortArray2, this.mBooleanSort, 0);
        this.declareInternalFunction("str.suffixof", sortArray2, this.mBooleanSort, 0);
        this.declareInternalFunction("str.contains", sortArray2, this.mBooleanSort, 0);
        this.declareInternalFunction("str.replace", sortArray3, sort, 0);
        this.declareInternalFunction("str.replace_all", sortArray3, sort, 0);
        this.declareInternalFunction("str.replace_re", sortArray5, sort, 0);
        this.declareInternalFunction("str.replace_re_all", sortArray5, sort, 0);
        this.declareInternalFunction("re.comp", sortArray6, sort2, 0);
        this.declareInternalFunction("re.diff", sortArray7, sort2, 2);
        this.declareInternalFunction("re.+", sortArray6, sort2, 0);
        this.declareInternalFunction("re.opt", sortArray6, sort2, 0);
        this.declareInternalFunction("re.range", sortArray2, sort2, 0);
        this.declareInternalFunction("str.is_digit", sortArray, this.mBooleanSort, 0);
        this.declareInternalFunctionFactory(new FunctionSymbolFactory("re.^"){

            @Override
            public Sort getResultSort(String[] stringArray, Sort[] sortArray, Sort sort) {
                if (stringArray == null || stringArray.length != 1 || sortArray.length != 1 || sort != null || sortArray[0] != sort2) {
                    return null;
                }
                Theory.this.toNumeral(stringArray[0]);
                return sort2;
            }
        });
        this.declareInternalFunctionFactory(new FunctionSymbolFactory("re.loop"){

            @Override
            public Sort getResultSort(String[] stringArray, Sort[] sortArray, Sort sort) {
                if (stringArray == null || stringArray.length != 2 || sortArray.length != 1 || sort != null || sortArray[0] != sort2) {
                    return null;
                }
                Theory.this.toNumeral(stringArray[0]);
                Theory.this.toNumeral(stringArray[1]);
                return sort2;
            }
        });
        if (this.mLogic.hasIntegers()) {
            Sort[] sortArray8 = new Sort[]{this.mNumericSort};
            Sort[] sortArray9 = new Sort[]{sort, this.mNumericSort};
            Sort[] sortArray10 = new Sort[]{sort, sort, this.mNumericSort};
            Sort[] sortArray11 = new Sort[]{sort, this.mNumericSort, this.mNumericSort};
            this.declareInternalFunction("str.len", sortArray, this.mNumericSort, 0);
            this.declareInternalFunction("str.at", sortArray9, sort, 0);
            this.declareInternalFunction("str.substr", sortArray11, sort, 0);
            this.declareInternalFunction("str.indexof", sortArray10, this.mNumericSort, 0);
            this.declareInternalFunction("str.to_code", sortArray, this.mNumericSort, 0);
            this.declareInternalFunction("str.from_code", sortArray8, sort, 0);
            this.declareInternalFunction("str.to_int", sortArray, this.mNumericSort, 0);
            this.declareInternalFunction("str.from_int", sortArray8, sort, 0);
        }
    }

    private void setLogic(Logics logics) {
        this.mLogic = logics;
        if (logics.isArray()) {
            this.createArrayOperators();
        }
        if (logics.hasReals() || logics.isFloatingPoint()) {
            this.mRealSort = this.declareInternalSort("Real", 0, 8).getSort(null, new Sort[0]);
        }
        if (logics.isArithmetic() || logics.isBitVector()) {
            this.mNumericSort = logics.hasIntegers() || logics.isBitVector() ? this.declareInternalSort("Int", 0, 8).getSort(null, new Sort[0]) : this.mRealSort;
            if (logics.isIRA() || logics.isBitVector() && logics.hasReals()) {
                this.createIRAOperators();
            } else {
                this.createNumericOperators(this.mNumericSort, logics.hasReals());
            }
        }
        if (logics.isBitVector() || logics.isFloatingPoint()) {
            this.createBitVecSort();
        }
        if (logics.isBitVector()) {
            this.createBitVecOperators();
        }
        if (logics.isFloatingPoint()) {
            this.createFloatingPointOperators();
        }
        if (logics.isString()) {
            this.createStringOperators();
        }
        if (this.mSolverSetup != null) {
            this.mSolverSetup.setLogic(this, logics);
        }
        if (logics.isDatatype()) {
            this.declareInternalFunctionFactory(new IsConstructorFactory());
        }
    }

    private SortSymbol defineSort(String string, int n, Sort sort, int n2) {
        if ((n2 & 1) == 0 && sort == null && !this.mLogic.isUF() && !this.mLogic.isArray()) {
            throw new IllegalArgumentException("Free sorts are not allowed in this logic");
        }
        SortSymbol sortSymbol = (SortSymbol)this.mDeclaredSorts.get((Object)string);
        if (sortSymbol != null) {
            throw new IllegalArgumentException("Sort " + string + " already exists.");
        }
        sortSymbol = new SortSymbol(this, string, n, sort, n2);
        this.mDeclaredSorts.put((Object)string, (Object)sortSymbol);
        return sortSymbol;
    }

    public SortSymbol declareSort(String string, int n) {
        return this.defineSort(string, n, null, 0);
    }

    public SortSymbol defineSort(String string, int n, Sort sort) {
        return this.defineSort(string, n, sort, 0);
    }

    public Sort[] createSortVariables(String ... stringArray) {
        Sort[] sortArray = new Sort[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            sortArray[n] = new SortSymbol(this, stringArray[n], n, null, 2).getSort(null, new Sort[0]);
            ++n;
        }
        return sortArray;
    }

    public SortSymbol declareInternalSort(String string, int n, int n2) {
        return this.defineSort(string, n, null, n2 | 1);
    }

    public Sort getSort(String string, Sort ... sortArray) {
        return this.getSort(string, (String[])null, sortArray);
    }

    public Sort getSort(String string, String[] stringArray, Sort ... sortArray) {
        SortSymbol sortSymbol = (SortSymbol)this.mDeclaredSorts.get((Object)string);
        if (sortSymbol == null) {
            return null;
        }
        return sortSymbol.getSort(stringArray, sortArray);
    }

    public Sort getBooleanSort() {
        return this.mBooleanSort;
    }

    public Sort getNumericSort() {
        return this.mNumericSort;
    }

    public Sort getRealSort() {
        return this.mRealSort;
    }

    public Sort getStringSort() {
        return this.mStringSort;
    }

    public void declareInternalFunctionFactory(FunctionSymbolFactory functionSymbolFactory) {
        if (this.mFunFactory.put((Object)functionSymbolFactory.mFuncName, (Object)functionSymbolFactory) != null) {
            throw new AssertionError();
        }
    }

    private FunctionSymbol defineFunction(String string, Sort[] sortArray, Sort sort, TermVariable[] termVariableArray, Term term, int n) {
        if ((n & 1) == 0) {
            if (this.mLogic == null) {
                throw new IllegalArgumentException("Call set-logic first!");
            }
            if (!this.mLogic.isUF() && sortArray.length > 0 && term == null) {
                throw new IllegalArgumentException("Free functions are not allowed in this logic!");
            }
        }
        if (string.charAt(0) == '@' && string.matches(MODEL_VALUE_PATTERN)) {
            throw new IllegalArgumentException("Function " + string + " is reserved for internal purposes.");
        }
        if (this.mFunFactory.get((Object)string) != null || this.mDeclaredFuns.get((Object)string) != null) {
            throw new IllegalArgumentException("Function " + string + " is already defined.");
        }
        if (sortArray.length == 0) {
            sortArray = EMPTY_SORT_ARRAY;
        }
        if (termVariableArray != null && termVariableArray.length == 0) {
            termVariableArray = EMPTY_TERM_VARIABLE_ARRAY;
        }
        FunctionSymbol functionSymbol = new FunctionSymbol(string, null, sortArray, sort, termVariableArray, term, n);
        this.mDeclaredFuns.put((Object)string, (Object)functionSymbol);
        return functionSymbol;
    }

    public FunctionSymbol declareFunction(String string, Sort[] sortArray, Sort sort) {
        return this.defineFunction(string, sortArray, sort, null, null, 0);
    }

    public FunctionSymbol defineFunction(String string, TermVariable[] termVariableArray, Term term) {
        Sort[] sortArray = termVariableArray.length == 0 ? EMPTY_SORT_ARRAY : new Sort[termVariableArray.length];
        int n = 0;
        while (n < sortArray.length) {
            sortArray[n] = termVariableArray[n].getSort();
            ++n;
        }
        Sort sort = term.getSort();
        return this.defineFunction(string, sortArray, sort, termVariableArray, term, 0);
    }

    public FunctionSymbol getFunction(String string, Sort ... sortArray) {
        return this.getFunctionWithResult(string, null, null, sortArray);
    }

    public Map<String, FunctionSymbol> getDeclaredFunctions() {
        return this.mDeclaredFuns;
    }

    public Map<String, SortSymbol> getDeclaredSorts() {
        return this.mDeclaredSorts;
    }

    public Map<String, FunctionSymbolFactory> getFunctionFactories() {
        return this.mFunFactory;
    }

    private FunctionSymbol getModelValueSymbol(String string, Sort sort) {
        FunctionSymbol functionSymbol2;
        int n = HashUtils.hashJenkins((int)string.hashCode(), (Object)sort);
        for (FunctionSymbol functionSymbol2 : this.mModelValueCache.iterateHashCode(n)) {
            if (!functionSymbol2.getName().equals(string) || functionSymbol2.getReturnSort() != sort) continue;
            return functionSymbol2;
        }
        functionSymbol2 = new FunctionSymbol(string, null, EMPTY_SORT_ARRAY, sort, null, null, 49);
        this.mModelValueCache.put(n, (Object)functionSymbol2);
        return functionSymbol2;
    }

    public FunctionSymbol getFunctionWithResult(String string, String[] stringArray, Sort sort, Sort ... sortArray) {
        FunctionSymbolFactory functionSymbolFactory = (FunctionSymbolFactory)this.mFunFactory.get((Object)string);
        if (functionSymbolFactory != null) {
            FunctionSymbol functionSymbol = functionSymbolFactory.getFunctionWithResult(this, stringArray, sortArray, sort);
            if (functionSymbol == null && this.mIRAWrappers != null) {
                functionSymbol = this.mIRAWrappers.createWrapper(this, string, stringArray, sortArray, sort);
            }
            if (functionSymbol == null) {
                String string2;
                int n;
                StringBuilder stringBuilder = new StringBuilder();
                PrintTerm printTerm = new PrintTerm();
                stringBuilder.append("Builtin function ");
                if (stringArray != null) {
                    stringBuilder.append("(_ ").append(string);
                    String[] stringArray2 = stringArray;
                    n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        string2 = stringArray2[n2];
                        stringBuilder.append(" ").append(string2);
                        ++n2;
                    }
                    stringBuilder.append(") does not support indices or argument sorts (");
                } else {
                    stringBuilder.append(string);
                    stringBuilder.append(" does not support argument sorts (");
                }
                string2 = "";
                Sort[] sortArray2 = sortArray;
                int n3 = sortArray.length;
                n = 0;
                while (n < n3) {
                    Sort sort2 = sortArray2[n];
                    stringBuilder.append(string2);
                    printTerm.append((Appendable)stringBuilder, sort2);
                    string2 = " ";
                    ++n;
                }
                stringBuilder.append(")");
                throw new SMTLIBException(stringBuilder.toString());
            }
            return functionSymbol;
        }
        FunctionSymbol functionSymbol = (FunctionSymbol)this.mDeclaredFuns.get((Object)string);
        if (functionSymbol != null) {
            if (stringArray != null) {
                throw new SMTLIBException("Function " + string + " take no index.");
            }
            if (sort != null || !functionSymbol.typecheck(sortArray)) {
                if (this.mIRAWrappers != null && (functionSymbol = this.mIRAWrappers.createWrapper(this, string, stringArray, sortArray, sort)) != null) {
                    return functionSymbol;
                }
                throw new SMTLIBException("Application of function " + String.valueOf(functionSymbol) + " does not type check.");
            }
            return functionSymbol;
        }
        if (sort != null && stringArray == null && sortArray.length == 0 && string.matches(MODEL_VALUE_PATTERN)) {
            return this.getModelValueSymbol(string, sort);
        }
        throw new SMTLIBException("Unknown function symbol " + string + ".");
    }

    public Term term(FunctionSymbolFactory functionSymbolFactory, Term ... termArray) {
        Sort[] sortArray = termArray.length == 0 ? EMPTY_SORT_ARRAY : new Sort[termArray.length];
        int n = 0;
        while (n < termArray.length) {
            sortArray[n] = termArray[n].getSort();
            ++n;
        }
        FunctionSymbol functionSymbol = functionSymbolFactory.getFunctionWithResult(this, null, sortArray, null);
        if (functionSymbol == null) {
            throw new IllegalArgumentException("Did not find overload for function " + String.valueOf(functionSymbolFactory));
        }
        return this.term(functionSymbol, termArray);
    }

    public Term term(String string, String[] stringArray, Sort sort, Term ... termArray) throws SMTLIBException {
        if (this.mBitVecSort != null && stringArray != null && stringArray.length == 1 && sort == null && termArray.length == 0 && string.matches(BITVEC_CONST_PATTERN) && stringArray[0].matches("\\d+")) {
            BigInteger bigInteger = new BigInteger(string.substring(2));
            if (bigInteger.bitLength() > Integer.parseInt(stringArray[0])) {
                throw new SMTLIBException("Constant out of range: (_ " + string + " " + stringArray[0] + ")");
            }
            return this.constant(bigInteger, this.mBitVecSort.getSort(stringArray, new Sort[0]));
        }
        Sort[] sortArray = termArray.length == 0 ? Script.EMPTY_SORT_ARRAY : new Sort[termArray.length];
        int n = 0;
        while (n < sortArray.length) {
            sortArray[n] = termArray[n].getSort();
            ++n;
        }
        FunctionSymbol functionSymbol = this.getFunctionWithResult(string, stringArray, sort, sortArray);
        return this.term(functionSymbol, termArray);
    }

    public Term term(String string, Term ... termArray) {
        return this.term(string, (String[])null, (Sort)null, termArray);
    }

    public Term term(FunctionSymbol functionSymbol, Term ... termArray) {
        Object object;
        Object object22;
        ConstantTerm constantTerm;
        if (functionSymbol.isIntern() && functionSymbol.getName().equals("/") && termArray.length == 2 && termArray[0] instanceof ConstantTerm && termArray[1] instanceof ConstantTerm && termArray[0].getSort() == this.getRealSort() && termArray[1].getSort() == this.getRealSort()) {
            Rational rational;
            constantTerm = (ConstantTerm)termArray[0];
            object22 = (ConstantTerm)termArray[1];
            Object object3 = null;
            object = null;
            if (constantTerm.getValue() instanceof Rational && ((ConstantTerm)object22).getValue() instanceof Rational) {
                rational = (Rational)constantTerm.getValue();
                Rational rational2 = (Rational)((ConstantTerm)object22).getValue();
                if (rational.isIntegral() && rational2.isIntegral()) {
                    object3 = rational.numerator();
                    object = rational2.numerator();
                }
            }
            if (object3 != null && ((BigInteger)object).compareTo(BigInteger.ONE) > 0 && ((BigInteger)object3).gcd((BigInteger)object).equals(BigInteger.ONE)) {
                rational = Rational.valueOf(object3, (BigInteger)object);
                return this.constant(rational, this.getRealSort());
            }
        }
        if (functionSymbol.isIntern() && functionSymbol.getName().equals("-") && termArray.length == 1 && termArray[0] instanceof ConstantTerm && (termArray[0].getSort() == this.getNumericSort() || termArray[0].getSort() == this.getRealSort()) && ((constantTerm = (ConstantTerm)termArray[0]).getValue() instanceof Rational ? ((Rational)(object22 = (Rational)constantTerm.getValue())).isIntegral() && ((Rational)object22).signum() > 0 : constantTerm.getValue() instanceof BigInteger && ((BigInteger)(object22 = (BigInteger)constantTerm.getValue())).signum() > 0)) {
            return this.constant(((Rational)object22).negate(), constantTerm.getSort());
        }
        if (termArray.length == 0) {
            termArray = EMPTY_TERM_ARRAY;
        }
        int n = ApplicationTerm.hashApplication(functionSymbol, termArray);
        for (Object object22 : this.mTermCache.iterateHashCode(n)) {
            if (!(object22 instanceof ApplicationTerm) || functionSymbol != ((ApplicationTerm)(object = (ApplicationTerm)object22)).getFunction() || !Arrays.equals(((ApplicationTerm)object).getParameters(), termArray)) continue;
            return object;
        }
        object22 = new ApplicationTerm(functionSymbol, termArray, n);
        this.mTermCache.put(n, object22);
        return object22;
    }

    public TermVariable createFreshTermVariable(String string, Sort sort) {
        String string2 = "." + string + "." + this.mTvarCtr++;
        return new TermVariable(string2, sort, TermVariable.hashVariable(string2, sort));
    }

    public TermVariable createTermVariable(String string, Sort sort) {
        TermVariable termVariable2;
        int n = TermVariable.hashVariable(string, sort);
        for (TermVariable termVariable2 : this.mTvUnify.iterateHashCode(n)) {
            if (!termVariable2.getSort().equals(sort) || !termVariable2.getName().equals(string)) continue;
            return termVariable2;
        }
        termVariable2 = new TermVariable(string, sort, n);
        this.mTvUnify.put(n, (Object)termVariable2);
        return termVariable2;
    }

    public DataType.Constructor createConstructor(String string, String[] stringArray, Sort[] sortArray) {
        DataType.Constructor constructor = new DataType.Constructor(string, stringArray, sortArray);
        return constructor;
    }

    public DataType createDatatypes(String string, int n) {
        if (this.mDeclaredSorts.containsKey((Object)string)) {
            throw new SMTLIBException("Datatype " + string + " already exists.");
        }
        DataType dataType = new DataType(this, string, n);
        this.mDeclaredSorts.put((Object)string, (Object)dataType);
        return dataType;
    }

    public Term term(TermVariable termVariable) {
        return termVariable;
    }

    public Term annotatedTerm(Annotation[] annotationArray, Term term) {
        Term term22;
        int n = AnnotatedTerm.hashAnnotations(annotationArray, term);
        for (Term term22 : this.mTermCache.iterateHashCode(n)) {
            AnnotatedTerm annotatedTerm;
            if (!(term22 instanceof AnnotatedTerm) || term != (annotatedTerm = (AnnotatedTerm)term22).getSubterm() || !Arrays.equals(annotatedTerm.getAnnotations(), annotationArray)) continue;
            return annotatedTerm;
        }
        term22 = new AnnotatedTerm(annotationArray, term, n);
        this.mTermCache.put(n, (Object)term22);
        return term22;
    }

    public void push() {
        if (!this.mGlobalDecls) {
            this.mFunFactory.beginScope();
            this.mDeclaredFuns.beginScope();
            this.mDeclaredSorts.beginScope();
        }
    }

    public void pop() {
        if (!this.mGlobalDecls) {
            this.mFunFactory.endScope();
            this.mDeclaredFuns.endScope();
            this.mDeclaredSorts.endScope();
        }
    }

    public FunctionSymbol createFreshAuxFunction(TermVariable[] termVariableArray, Term term) {
        Sort[] sortArray = new Sort[termVariableArray.length];
        int n = 0;
        while (n < termVariableArray.length) {
            sortArray[n] = termVariableArray[n].getSort();
            ++n;
        }
        return this.declareInternalFunction("@AUX" + this.mAuxCounter++, sortArray, termVariableArray, term, 64);
    }

    /*
     * Unable to fully structure code
     */
    public void resetAssertions() {
        if (!this.mGlobalDecls) ** GOTO lbl4
        return;
lbl-1000:
        // 1 sources

        {
            this.mDeclaredFuns.endScope();
lbl4:
            // 2 sources

            ** while (this.mDeclaredFuns.getActiveScopeNum() > 1)
        }
lbl5:
        // 1 sources

        var1_1 = this.mDeclaredFuns.entrySet().iterator();
        while (var1_1.hasNext()) {
            var2_2 = (Map.Entry)var1_1.next();
            if (((FunctionSymbol)var2_2.getValue()).isIntern()) continue;
            var1_1.remove();
        }
        while (this.mFunFactory.getActiveScopeNum() > 1) {
            this.mFunFactory.endScope();
        }
        while (this.mDeclaredSorts.getActiveScopeNum() > 1) {
            this.mDeclaredSorts.endScope();
        }
        var1_1 = this.mDeclaredSorts.entrySet().iterator();
        while (var1_1.hasNext()) {
            var2_2 = (Map.Entry)var1_1.next();
            if (((SortSymbol)var2_2.getValue()).isIntern()) continue;
            var1_1.remove();
        }
    }

    public void setGlobalSymbols(boolean bl) {
        this.mGlobalDecls = bl;
    }

    class DivisibleFunctionFactory
    extends FunctionSymbolFactory {
        public DivisibleFunctionFactory() {
            super("divisible");
        }

        @Override
        public Sort getResultSort(String[] stringArray, Sort[] sortArray, Sort sort) {
            return stringArray != null && stringArray.length == 1 && Theory.this.toNumeral(stringArray[0]).signum() > 0 && sortArray.length == 1 && sortArray[0] == Theory.this.mNumericSort && sort == null ? Theory.this.mBooleanSort : null;
        }
    }

    class MinusFunctionFactory
    extends FunctionSymbolFactory {
        Sort mSort1;
        Sort mSort2;

        public MinusFunctionFactory(Sort sort, Sort sort2) {
            super("-");
            this.mSort1 = sort;
            this.mSort2 = sort2;
        }

        @Override
        public int getFlags(String[] stringArray, Sort[] sortArray, Sort sort) {
            return sortArray.length == 1 ? 1 : 3;
        }

        @Override
        public Sort getResultSort(String[] stringArray, Sort[] sortArray, Sort sort) {
            if (stringArray != null || sortArray.length == 0 || sortArray.length > 2 || sort != null || sortArray[0] != this.mSort1 && sortArray[0] != this.mSort2) {
                return null;
            }
            if (sortArray.length == 2 && sortArray[0] != sortArray[1]) {
                return null;
            }
            return sortArray[0];
        }
    }

    public static abstract class SolverSetup {
        public abstract void setLogic(Theory var1, Logics var2);

        protected static final void declareInternalSort(Theory theory, String string, int n, int n2) {
            theory.declareInternalSort(string, n, n2);
        }

        protected static final void declareInternalFunction(Theory theory, String string, Sort[] sortArray, Sort sort, int n) {
            theory.declareInternalFunction(string, sortArray, sort, n);
        }

        protected static final void declareInternalFunction(Theory theory, String string, Sort[] sortArray, TermVariable[] termVariableArray, Term term, int n) {
            theory.declareInternalFunction(string, sortArray, termVariableArray, term, n);
        }

        protected static final void declareInternalPolymorphicFunction(Theory theory, String string, Sort[] sortArray, Sort[] sortArray2, Sort sort, int n) {
            theory.declareInternalPolymorphicFunction(string, sortArray, sortArray2, sort, n);
        }

        protected static final void defineFunction(Theory theory, FunctionSymbolFactory functionSymbolFactory) {
            theory.declareInternalFunctionFactory(functionSymbolFactory);
        }
    }
}

