/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.jordan;

import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.jordan.JordanDecomposition;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.jordan.JordanLoopAcceleration;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.jordan.LinearUpdate;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.jordan.PolynomialTermMatrix;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.jordan.QuadraticMatrix;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.AffineTerm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.IPolynomialTerm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.PolynomialTerm;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap2;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class JordanUpdate {
    private final List<JordanUpdatePart> mParts;
    private final JordanDecomposition.JordanDecompositionStatus mJordanDecompositionStatus;
    private final NestedMap2<Integer, Integer, Integer> mJordanBlockSizes;

    public JordanUpdate(JordanDecomposition.JordanDecompositionStatus jordanDecompositionStatus, List<JordanUpdatePart> list) {
        this.mJordanDecompositionStatus = jordanDecompositionStatus;
        this.mParts = list;
        if (jordanDecompositionStatus == JordanDecomposition.JordanDecompositionStatus.UNSUPPORTED_EIGENVALUES) {
            this.mJordanBlockSizes = null;
        } else {
            this.mJordanBlockSizes = new NestedMap2();
            for (JordanUpdatePart jordanUpdatePart : list) {
                JordanUpdate.addJordanCodeBlockSizes(this.mJordanBlockSizes, jordanUpdatePart.getJordanDecomp().getJordanBlockSizes());
            }
        }
    }

    public static JordanUpdate fromLinearUpdate(LinearUpdate linearUpdate) {
        List<LinearUpdate> list = linearUpdate.partition();
        ArrayList<JordanUpdatePart> arrayList = new ArrayList<JordanUpdatePart>();
        for (LinearUpdate linearUpdate2 : list) {
            HashMap<Term, Integer> hashMap;
            QuadraticMatrix quadraticMatrix = JordanUpdate.computeUpdateMatrix(linearUpdate2, hashMap = JordanUpdate.determineMatrixIndices(linearUpdate2));
            JordanDecomposition jordanDecomposition = quadraticMatrix.constructJordanDecomposition();
            if (jordanDecomposition.getStatus() == JordanDecomposition.JordanDecompositionStatus.UNSUPPORTED_EIGENVALUES) {
                return new JordanUpdate(jordanDecomposition.getStatus(), null);
            }
            arrayList.add(new JordanUpdatePart(linearUpdate2, hashMap, jordanDecomposition));
        }
        return new JordanUpdate(JordanDecomposition.JordanDecompositionStatus.SUCCESS, arrayList);
    }

    public JordanDecomposition.JordanDecompositionStatus getStatus() {
        return this.mJordanDecompositionStatus;
    }

    public NestedMap2<Integer, Integer, Integer> getJordanBlockSizes() {
        return this.mJordanBlockSizes;
    }

    private static HashMap<Term, Integer> determineMatrixIndices(LinearUpdate linearUpdate) {
        HashMap<Term, Integer> hashMap = new HashMap<Term, Integer>();
        int n = 0;
        for (TermVariable termVariable : linearUpdate.getUpdateMap().keySet()) {
            assert (!hashMap.containsKey(termVariable)) : "cannot add same variable twice";
            hashMap.put((Term)termVariable, n);
            ++n;
        }
        for (Term term : linearUpdate.getReadonlyVariables()) {
            assert (!hashMap.containsKey(term)) : "cannot add same variable twice";
            hashMap.put(term, n);
            ++n;
        }
        return hashMap;
    }

    private static QuadraticMatrix computeUpdateMatrix(LinearUpdate linearUpdate, Map<Term, Integer> map) {
        int n = map.size() + 1;
        QuadraticMatrix quadraticMatrix = QuadraticMatrix.constructIdentityMatrix(n);
        for (Map.Entry<TermVariable, AffineTerm> entry : linearUpdate.getUpdateMap().entrySet()) {
            JordanUpdate.fillMatrixRow(quadraticMatrix, map, entry.getValue(), entry.getKey());
            int n2 = 0;
            while (n2 < n) {
                if (quadraticMatrix.getEntry(map.get(entry.getKey()), n2) == null) {
                    return null;
                }
                ++n2;
            }
        }
        return quadraticMatrix;
    }

    private static void fillMatrixRow(QuadraticMatrix quadraticMatrix, Map<Term, Integer> map, AffineTerm affineTerm, TermVariable termVariable) {
        int n = quadraticMatrix.getDimension() - 1;
        quadraticMatrix.setEntry(n, n, BigInteger.valueOf(1L));
        quadraticMatrix.setEntry(map.get(termVariable), map.get(termVariable), BigInteger.valueOf(0L));
        for (Term term : map.keySet()) {
            quadraticMatrix.setEntry(map.get(termVariable), map.get(term), JordanUpdate.determineCoefficient(affineTerm, term));
            if (quadraticMatrix.getEntry(map.get(termVariable), map.get(term)) == null) break;
            quadraticMatrix.setEntry(map.get(termVariable), n, JordanUpdate.determineConstant((IPolynomialTerm)affineTerm));
        }
    }

    private static BigInteger determineCoefficient(AffineTerm affineTerm, Term term) {
        Rational rational = (Rational)affineTerm.getVariable2Coefficient().get(term);
        if (rational != null) {
            if (!rational.isIntegral()) {
                throw new AssertionError((Object)"Some coefficient is not integral.");
            }
            return rational.numerator();
        }
        return BigInteger.ZERO;
    }

    private static BigInteger determineConstant(IPolynomialTerm iPolynomialTerm) {
        Rational rational = iPolynomialTerm.getConstant();
        if (!rational.denominator().equals(BigInteger.valueOf(1L))) {
            throw new AssertionError((Object)"Constant in some term is not integral.");
        }
        return rational.numerator();
    }

    private static IPolynomialTerm constructIterationCounter(Script script, JordanLoopAcceleration.Iterations iterations, TermVariable termVariable, TermVariable termVariable2) {
        Sort sort = SmtSortUtils.getIntSort((Script)script);
        return switch (iterations) {
            case JordanLoopAcceleration.Iterations.ALL -> AffineTerm.constructVariable((Term)termVariable);
            case JordanLoopAcceleration.Iterations.EVEN -> PolynomialTerm.mulPolynomials((IPolynomialTerm)AffineTerm.constructConstant((Sort)sort, (Rational)Rational.TWO), (IPolynomialTerm)AffineTerm.constructVariable((Term)termVariable2));
            case JordanLoopAcceleration.Iterations.ODD -> PolynomialTerm.sum((IPolynomialTerm[])new IPolynomialTerm[]{PolynomialTerm.mulPolynomials((IPolynomialTerm)AffineTerm.constructConstant((Sort)sort, (Rational)Rational.TWO), (IPolynomialTerm)AffineTerm.constructVariable((Term)termVariable2)), AffineTerm.constructConstant((Sort)sort, (Rational)Rational.ONE)});
            default -> throw new AssertionError((Object)("unknown value: " + String.valueOf((Object)iterations)));
        };
    }

    public Map<TermVariable, Term> constructClosedForm(ManagedScript managedScript, TermVariable termVariable, TermVariable termVariable2, JordanLoopAcceleration.Iterations iterations) {
        IPolynomialTerm iPolynomialTerm = JordanUpdate.constructIterationCounter(managedScript.getScript(), iterations, termVariable, termVariable2);
        return this.constructClosedForm(managedScript, iPolynomialTerm, iterations);
    }

    private Map<TermVariable, Term> constructClosedForm(ManagedScript managedScript, IPolynomialTerm iPolynomialTerm, JordanLoopAcceleration.Iterations iterations) {
        HashMap<TermVariable, Term> hashMap = new HashMap<TermVariable, Term>();
        for (JordanUpdatePart jordanUpdatePart : this.mParts) {
            PolynomialTermMatrix polynomialTermMatrix = PolynomialTermMatrix.computeClosedFormMatrix(managedScript, jordanUpdatePart.getJordanDecomp(), iPolynomialTerm, iterations);
            Map<TermVariable, Term> map = this.constructClosedForm(managedScript, polynomialTermMatrix, jordanUpdatePart.getLinearUpdate(), jordanUpdatePart.getVarMatrixIndexMap());
            hashMap.putAll(map);
        }
        return hashMap;
    }

    public Map<TermVariable, Term> constructClosedForm(ManagedScript managedScript, int n) {
        HashMap<TermVariable, Term> hashMap = new HashMap<TermVariable, Term>();
        for (JordanUpdatePart jordanUpdatePart : this.mParts) {
            PolynomialTermMatrix polynomialTermMatrix = PolynomialTermMatrix.computeClosedFormMatrix(managedScript, jordanUpdatePart.getJordanDecomp(), n);
            Map<TermVariable, Term> map = this.constructClosedForm(managedScript, polynomialTermMatrix, jordanUpdatePart.getLinearUpdate(), jordanUpdatePart.getVarMatrixIndexMap());
            hashMap.putAll(map);
        }
        return hashMap;
    }

    private Map<TermVariable, Term> constructClosedForm(ManagedScript managedScript, PolynomialTermMatrix polynomialTermMatrix, LinearUpdate linearUpdate, Map<Term, Integer> map) {
        Term term;
        Term[] termArray = new Term[map.size()];
        TermVariable termVariable2 = map.keySet().iterator();
        while (termVariable2.hasNext()) {
            termArray[map.get((Object)term).intValue()] = term = termVariable2.next();
        }
        term = new HashMap();
        for (TermVariable termVariable2 : linearUpdate.getUpdateMap().keySet()) {
            Term term2 = JordanUpdate.constructClosedForm(managedScript, polynomialTermMatrix, map, termArray, termVariable2);
            term.put(termVariable2, term2);
        }
        return term;
    }

    private static Term constructClosedForm(ManagedScript managedScript, PolynomialTermMatrix polynomialTermMatrix, Map<Term, Integer> map, Term[] termArray, TermVariable termVariable) {
        int n = map.get(termVariable);
        int n2 = polynomialTermMatrix.getDimension();
        Term[] termArray2 = new Term[n2];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2 - 1) {
            Rational rational;
            if (!polynomialTermMatrix.getEntry(n, n4).isConstant() || (rational = polynomialTermMatrix.getEntry(n, n4).getConstant()).numerator().intValue() != 0) {
                termArray2[n3] = polynomialTermMatrix.getEntry(n, n4).isConstant() ? ((rational = polynomialTermMatrix.getEntry(n, n4).getConstant()).numerator().intValue() == 1 && rational.denominator().intValue() == 1 ? termArray[n4] : managedScript.getScript().term("*", new Term[]{polynomialTermMatrix.getEntry(n, n4).toTerm(managedScript.getScript()), termArray[n4]})) : managedScript.getScript().term("*", new Term[]{polynomialTermMatrix.getEntry(n, n4).toTerm(managedScript.getScript()), termArray[n4]});
                ++n3;
            }
            ++n4;
        }
        if (polynomialTermMatrix.getEntry(n, n2 - 1).isConstant()) {
            Rational rational = polynomialTermMatrix.getEntry(n, n2 - 1).getConstant();
            if (rational.numerator().intValue() != 0) {
                termArray2[n3] = polynomialTermMatrix.getEntry(n, n2 - 1).toTerm(managedScript.getScript());
                ++n3;
            }
        } else {
            termArray2[n3] = polynomialTermMatrix.getEntry(n, n2 - 1).toTerm(managedScript.getScript());
            ++n3;
        }
        Term term = n3 == 0 ? managedScript.getScript().numeral(BigInteger.ZERO) : (n3 == 1 ? termArray2[0] : managedScript.getScript().term("+", Arrays.copyOfRange(termArray2, 0, n3)));
        return term;
    }

    private static void addJordanCodeBlockSizes(NestedMap2<Integer, Integer, Integer> nestedMap2, NestedMap2<Integer, Integer, Integer> nestedMap22) {
        for (Triple triple : nestedMap22.entrySet()) {
            Integer n = (Integer)nestedMap2.get((Object)((Integer)triple.getFirst()), (Object)((Integer)triple.getSecond()));
            if (n == null) {
                nestedMap2.put((Object)((Integer)triple.getFirst()), (Object)((Integer)triple.getSecond()), (Object)((Integer)triple.getThird()));
                continue;
            }
            nestedMap2.put((Object)((Integer)triple.getFirst()), (Object)((Integer)triple.getSecond()), (Object)(n + (Integer)triple.getThird()));
        }
    }

    public boolean isAlternatingClosedFormRequired() {
        boolean bl = this.mJordanBlockSizes.containsKey((Object)-1);
        boolean bl2 = this.hasEv1JordanBlockStrictlyGreater2();
        return bl || bl2;
    }

    public boolean hasEv1JordanBlockStrictlyGreater2() {
        if (!this.mJordanBlockSizes.containsKey((Object)1)) {
            return false;
        }
        boolean bl = false;
        Iterator iterator = this.mJordanBlockSizes.get((Object)1).keySet().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (n <= 2 || (Integer)this.mJordanBlockSizes.get((Object)1).get(n) == 0) continue;
            bl = true;
        }
        return bl;
    }

    public int computeSizeOfLargestEv0Block() {
        if (!this.mJordanBlockSizes.containsKey((Object)0)) {
            return 0;
        }
        int n = 0;
        Iterator iterator = this.mJordanBlockSizes.get((Object)0).keySet().iterator();
        while (iterator.hasNext()) {
            int n2 = (Integer)iterator.next();
            if (n2 <= n) continue;
            n = n2;
        }
        assert (n > 0);
        return n;
    }

    public boolean isBlockSizeConsistent(int n, int n2) {
        int n3 = 0;
        for (Triple triple : this.mJordanBlockSizes.entrySet()) {
            n3 += (Integer)triple.getSecond() * (Integer)triple.getThird();
        }
        return n + n2 + this.mParts.size() == n3;
    }

    private static class JordanUpdatePart {
        private final LinearUpdate mLinearUpdate;
        private final Map<Term, Integer> mVarMatrixIndexMap;
        private final JordanDecomposition mJordanDecomp;

        public JordanUpdatePart(LinearUpdate linearUpdate, Map<Term, Integer> map, JordanDecomposition jordanDecomposition) {
            this.mLinearUpdate = linearUpdate;
            this.mVarMatrixIndexMap = map;
            this.mJordanDecomp = jordanDecomposition;
        }

        public LinearUpdate getLinearUpdate() {
            return this.mLinearUpdate;
        }

        public Map<Term, Integer> getVarMatrixIndexMap() {
            return this.mVarMatrixIndexMap;
        }

        public JordanDecomposition getJordanDecomp() {
            return this.mJordanDecomp;
        }
    }
}

