/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.TypeHandler;
import org.apache.commons.cli.Util;

public class CommandLine
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<String> args = new LinkedList<String>();
    private final List<Option> options = new ArrayList<Option>();

    protected CommandLine() {
    }

    public boolean hasOption(String string) {
        return this.options.contains(this.resolveOption(string));
    }

    public boolean hasOption(char c) {
        return this.hasOption(String.valueOf(c));
    }

    @Deprecated
    public Object getOptionObject(String string) {
        try {
            return this.getParsedOptionValue(string);
        }
        catch (ParseException parseException) {
            System.err.println("Exception found converting " + string + " to desired type: " + parseException.getMessage());
            return null;
        }
    }

    public Object getParsedOptionValue(String string) throws ParseException {
        String string2 = this.getOptionValue(string);
        Option option = this.resolveOption(string);
        if (option == null || string2 == null) {
            return null;
        }
        return TypeHandler.createValue(string2, option.getType());
    }

    public Object[] getParsedOptionValues(String string) throws ParseException {
        String[] stringArray = this.getOptionValues(string);
        Option option = this.resolveOption(string);
        if (option == null || stringArray == null) {
            return null;
        }
        Object object = option.getType();
        Object[] objectArray = new Object[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            objectArray[n] = TypeHandler.createValue(stringArray[n], object);
            ++n;
        }
        return objectArray;
    }

    public Object getOptionObject(char c) {
        return this.getOptionObject(String.valueOf(c));
    }

    public String getOptionValue(String string) {
        String[] stringArray = this.getOptionValues(string);
        return stringArray == null ? null : stringArray[0];
    }

    public String getOptionValue(char c) {
        return this.getOptionValue(String.valueOf(c));
    }

    public String[] getOptionValues(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Option option : this.options) {
            if (!string.equals(option.getOpt()) && !string.equals(option.getLongOpt())) continue;
            arrayList.addAll(option.getValuesList());
        }
        return arrayList.isEmpty() ? null : arrayList.toArray(new String[arrayList.size()]);
    }

    private Option resolveOption(String string) {
        string = Util.stripLeadingHyphens(string);
        for (Option option : this.options) {
            if (string.equals(option.getOpt())) {
                return option;
            }
            if (!string.equals(option.getLongOpt())) continue;
            return option;
        }
        return null;
    }

    public String[] getOptionValues(char c) {
        return this.getOptionValues(String.valueOf(c));
    }

    public String getOptionValue(String string, String string2) {
        String string3 = this.getOptionValue(string);
        return string3 != null ? string3 : string2;
    }

    public String getOptionValue(char c, String string) {
        return this.getOptionValue(String.valueOf(c), string);
    }

    public Properties getOptionProperties(String string) {
        Properties properties = new Properties();
        for (Option option : this.options) {
            if (!string.equals(option.getOpt()) && !string.equals(option.getLongOpt())) continue;
            List<String> list = option.getValuesList();
            if (list.size() >= 2) {
                properties.put(list.get(0), list.get(1));
                continue;
            }
            if (list.size() != 1) continue;
            properties.put(list.get(0), "true");
        }
        return properties;
    }

    public String[] getArgs() {
        String[] stringArray = new String[this.args.size()];
        this.args.toArray(stringArray);
        return stringArray;
    }

    public List<String> getArgList() {
        return this.args;
    }

    protected void addArg(String string) {
        this.args.add(string);
    }

    protected void addOption(Option option) {
        this.options.add(option);
    }

    public Iterator<Option> iterator() {
        return this.options.iterator();
    }

    public Option[] getOptions() {
        List<Option> list = this.options;
        Option[] optionArray = new Option[list.size()];
        return list.toArray(optionArray);
    }
}

