/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.io.graphml.parser;

import edu.uci.ics.jung.graph.Hypergraph;
import edu.uci.ics.jung.io.GraphIOException;
import edu.uci.ics.jung.io.graphml.DataMetadata;
import edu.uci.ics.jung.io.graphml.ExceptionConverter;
import edu.uci.ics.jung.io.graphml.parser.AbstractElementParser;
import edu.uci.ics.jung.io.graphml.parser.ParserContext;
import java.util.Iterator;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataElementParser<G extends Hypergraph<V, E>, V, E>
extends AbstractElementParser<G, V, E> {
    public DataElementParser(ParserContext<G, V, E> parserContext) {
        super(parserContext);
    }

    @Override
    public DataMetadata parse(XMLEventReader xmlEventReader, StartElement start) throws GraphIOException {
        try {
            DataMetadata data = new DataMetadata();
            Iterator iterator = start.getAttributes();
            while (iterator.hasNext()) {
                Attribute attribute = (Attribute)iterator.next();
                String name = attribute.getName().getLocalPart();
                String value = attribute.getValue();
                if (data.getKey() != null || !"key".equals(name)) continue;
                data.setKey(value);
            }
            if (data.getKey() == null) {
                throw new GraphIOException("Element 'data' is missing attribute 'key'");
            }
            while (xmlEventReader.hasNext()) {
                XMLEvent event = xmlEventReader.nextEvent();
                if (event.isStartElement()) {
                    StartElement element = (StartElement)event;
                    this.getUnknownParser().parse(xmlEventReader, element);
                }
                if (event.isCharacters()) {
                    Characters characters = (Characters)event;
                    data.setValue(characters.getData());
                }
                if (!event.isEndElement()) continue;
                EndElement end = (EndElement)event;
                this.verifyMatch(start, end);
                break;
            }
            return data;
        }
        catch (Exception e) {
            ExceptionConverter.convert(e);
            return null;
        }
    }
}

