/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.lib.results;

import de.uni_freiburg.informatik.ultimate.core.lib.results.AbstractResult;
import de.uni_freiburg.informatik.ultimate.core.model.services.IBacktranslationService;
import de.uni_freiburg.informatik.ultimate.util.CoreUtil;
import java.util.Map;
import java.util.Set;

public class DangerInvariantResult<LOC, TERM>
extends AbstractResult {
    private final Map<LOC, TERM> mInvariants;
    private final Set<LOC> mErrorLocations;
    private final IBacktranslationService mBacktranslator;

    public DangerInvariantResult(String string, Map<LOC, TERM> map, Set<LOC> set, IBacktranslationService iBacktranslationService) {
        super(string);
        this.mInvariants = map;
        this.mErrorLocations = set;
        this.mBacktranslator = iBacktranslationService;
    }

    public String getShortDescription() {
        return "Danger Invariant";
    }

    public String getLongDescription() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Derived danger invariant for the following error locations: ");
        stringBuilder.append(this.mErrorLocations);
        for (Map.Entry<LOC, TERM> entry : this.mInvariants.entrySet()) {
            stringBuilder.append(CoreUtil.getPlatformLineSeparator());
            stringBuilder.append(entry.getKey());
            stringBuilder.append(": ");
            stringBuilder.append(this.mBacktranslator.translateExpressionToString(entry.getValue(), entry.getValue().getClass()));
        }
        return stringBuilder.toString();
    }
}

