/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.pea;

import de.uni_freiburg.informatik.ultimate.lib.pea.CDD;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import net.sourceforge.czt.z.util.ZString;

public class CounterTrace {
    public static final int BOUND_LESS = -2;
    public static final int BOUND_LESSEQUAL = -1;
    public static final int BOUND_NONE = 0;
    public static final int BOUND_GREATEREQUAL = 1;
    public static final int BOUND_GREATER = 2;
    private final DCPhase[] mPhases;

    public CounterTrace(DCPhase[] dCPhaseArray) {
        this.mPhases = dCPhaseArray;
    }

    public DCPhase[] getPhases() {
        return this.mPhases;
    }

    public DCPhase getSuccessor(DCPhase dCPhase) {
        int n = 0;
        while (n < this.getPhases().length) {
            if (this.getPhases()[n] == dCPhase && n < this.getPhases().length - 1) {
                return this.getPhases()[n + 1];
            }
            ++n;
        }
        return null;
    }

    public String toString() {
        return Arrays.stream(this.getPhases()).map(dCPhase -> dCPhase.toString(true)).collect(Collectors.joining(";"));
    }

    public static enum BoundTypes {
        LESS(-2),
        LESSEQUAL(-1),
        NONE(0),
        GREATEREQUAL(1),
        GREATER(2);

        private int mVal;

        private BoundTypes(int n2) {
            this.mVal = n2;
        }

        public int asValue() {
            return this.mVal;
        }
    }

    public static class DCPhase {
        private final CDD mEntryEvents;
        private final CDD mInvariant;
        private final int mBoundType;
        private final int mBound;
        private final Set<String> mForbid;
        private final boolean mAllowEmpty;

        public DCPhase(CDD cDD, CDD cDD2, int n, int n2, Set<String> set, boolean bl) {
            this.mEntryEvents = cDD;
            this.mInvariant = cDD2;
            this.mBound = n2;
            this.mBoundType = !bl && n2 == 0 && n > 0 ? 0 : n;
            this.mForbid = set;
            this.mAllowEmpty = bl;
        }

        public DCPhase(CDD cDD, CDD cDD2, int n, int n2, Set<String> set) {
            this(cDD, cDD2, n, n2, set, false);
        }

        public DCPhase(CDD cDD, int n, int n2, Set<String> set) {
            this(CDD.TRUE, cDD, n, n2, set, false);
        }

        public DCPhase(CDD cDD, CDD cDD2, Set<String> set) {
            this(cDD, cDD2, 0, 0, set, false);
        }

        public DCPhase(CDD cDD, Set<String> set) {
            this(CDD.TRUE, cDD, 0, 0, set, false);
        }

        public DCPhase(CDD cDD, CDD cDD2, int n, int n2) {
            this(cDD, cDD2, n, n2, Collections.emptySet(), false);
        }

        public DCPhase(CDD cDD, int n, int n2) {
            this(CDD.TRUE, cDD, n, n2, Collections.emptySet(), false);
        }

        public DCPhase(CDD cDD, CDD cDD2) {
            this(cDD, cDD2, 0, 0, Collections.emptySet(), false);
        }

        public DCPhase(CDD cDD) {
            this(CDD.TRUE, cDD, 0, 0, Collections.emptySet(), false);
        }

        public DCPhase(int n, int n2) {
            this(CDD.TRUE, CDD.TRUE, n, n2, Collections.emptySet(), n <= 0);
        }

        public DCPhase() {
            this(CDD.TRUE, CDD.TRUE, 0, 0, Collections.emptySet(), true);
        }

        public boolean isAllowEmpty() {
            return this.mAllowEmpty;
        }

        public String toString(boolean bl) {
            String string = bl ? ZString.AND : "/\\";
            String string2 = bl ? "\u229f" : "[-]";
            String string3 = bl ? "\u2080" : "0";
            String string4 = bl ? ZString.GEQ : ">=";
            String string5 = bl ? ZString.LEQ : "<=";
            String string6 = bl ? "\u2308" : "[";
            String string7 = bl ? "\u2309" : "]";
            String string8 = bl ? "\u2113" : "L";
            StringBuilder stringBuilder = new StringBuilder();
            if (this.getEntryEvents() != CDD.TRUE) {
                stringBuilder.append(this.getEntryEvents()).append(" ; ");
            }
            if (this.getInvariant() == CDD.TRUE && this.isAllowEmpty()) {
                stringBuilder.append(this.getInvariant());
            } else {
                stringBuilder.append(string6).append(this.getInvariant()).append(string7);
            }
            Iterator<String> iterator = this.mForbid.iterator();
            while (iterator.hasNext()) {
                stringBuilder.append(' ').append(string).append(' ').append(string2).append(' ').append((Object)iterator.next());
            }
            if (this.getBoundType() != 0) {
                stringBuilder.append(' ').append(string).append(' ').append(string8);
                switch (this.getBoundType()) {
                    case -2: {
                        if (!this.isAllowEmpty()) {
                            stringBuilder.append(" < ");
                            break;
                        }
                        stringBuilder.append(" <").append(string3).append(' ');
                        break;
                    }
                    case -1: {
                        if (!this.isAllowEmpty()) {
                            stringBuilder.append(' ').append(string5).append(' ');
                            break;
                        }
                        stringBuilder.append(' ').append(string5).append(string3).append(' ');
                        break;
                    }
                    case 2: {
                        if (!this.isAllowEmpty()) {
                            stringBuilder.append(" > ");
                            break;
                        }
                        stringBuilder.append(" >").append(string3).append(' ');
                        break;
                    }
                    case 1: {
                        if (!this.isAllowEmpty()) {
                            stringBuilder.append(' ').append(string4).append(' ');
                            break;
                        }
                        stringBuilder.append(' ').append(string4).append(string3).append(' ');
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                stringBuilder.append(this.getBound());
            }
            return stringBuilder.toString();
        }

        public String toString() {
            return this.toString(true);
        }

        public int getBoundType() {
            return this.mBoundType;
        }

        public Set<String> getForbid() {
            return this.mForbid;
        }

        public CDD getInvariant() {
            return this.mInvariant;
        }

        public CDD getEntryEvents() {
            return this.mEntryEvents;
        }

        public int getBound() {
            return this.mBound;
        }
    }
}

