/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.ast;

import de.uni_freiburg.informatik.ultimate.boogie.ast.ASTType;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BoogieASTNode;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstTransformer;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstVisitor;
import de.uni_freiburg.informatik.ultimate.core.model.models.IBoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;

public final class ArrayType
extends ASTType {
    private static final long serialVersionUID = 1L;
    private static final Predicate<BoogieASTNode> VALIDATOR = BoogieASTNode.VALIDATORS.get(ArrayType.class);
    String[] typeParams;
    ASTType[] indexTypes;
    ASTType valueType;

    public ArrayType(ILocation iLocation, String[] stringArray, ASTType[] aSTTypeArray, ASTType aSTType) {
        super(iLocation);
        this.typeParams = stringArray;
        this.indexTypes = aSTTypeArray;
        this.valueType = aSTType;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid ArrayType: " + String.valueOf((Object)this);
    }

    public ArrayType(ILocation iLocation, IBoogieType iBoogieType, String[] stringArray, ASTType[] aSTTypeArray, ASTType aSTType) {
        super(iLocation, iBoogieType);
        this.typeParams = stringArray;
        this.indexTypes = aSTTypeArray;
        this.valueType = aSTType;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid ArrayType: " + String.valueOf((Object)this);
    }

    @Override
    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ArrayType").append('[');
        if (this.typeParams == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append('[');
            n = 0;
            while (n < this.typeParams.length) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(this.typeParams[n]);
                ++n;
            }
            stringBuffer.append(']');
        }
        stringBuffer.append(',');
        if (this.indexTypes == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append('[');
            n = 0;
            while (n < this.indexTypes.length) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append((Object)this.indexTypes[n]);
                ++n;
            }
            stringBuffer.append(']');
        }
        stringBuffer.append(',').append((Object)this.valueType);
        return stringBuffer.append(']').toString();
    }

    public String[] getTypeParams() {
        return this.typeParams;
    }

    public ASTType[] getIndexTypes() {
        return this.indexTypes;
    }

    public ASTType getValueType() {
        return this.valueType;
    }

    @Override
    public List<BoogieASTNode> getOutgoingNodes() {
        List<BoogieASTNode> list = super.getOutgoingNodes();
        if (this.indexTypes != null) {
            list.addAll(Arrays.asList(this.indexTypes));
        }
        list.add(this.valueType);
        return list;
    }

    @Override
    public void accept(GeneratedBoogieAstVisitor generatedBoogieAstVisitor) {
        if (!generatedBoogieAstVisitor.visit((ASTType)this)) {
            return;
        }
        if (generatedBoogieAstVisitor.visit(this)) {
            if (this.indexTypes != null) {
                ASTType[] aSTTypeArray = this.indexTypes;
                int n = this.indexTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    ASTType aSTType = aSTTypeArray[n2];
                    aSTType.accept(generatedBoogieAstVisitor);
                    ++n2;
                }
            }
            if (this.valueType != null) {
                this.valueType.accept(generatedBoogieAstVisitor);
            }
        }
    }

    @Override
    public ASTType accept(GeneratedBoogieAstTransformer generatedBoogieAstTransformer) {
        ASTType aSTType;
        ASTType aSTType2 = generatedBoogieAstTransformer.transform(this);
        if (aSTType2 != this) {
            return aSTType2;
        }
        boolean bl = false;
        ArrayList<ASTType> arrayList = new ArrayList<ASTType>();
        if (this.indexTypes != null) {
            ASTType[] aSTTypeArray = this.indexTypes;
            int n = this.indexTypes.length;
            int n2 = 0;
            while (n2 < n) {
                aSTType = aSTTypeArray[n2];
                ASTType aSTType3 = aSTType.accept(generatedBoogieAstTransformer);
                bl = bl || aSTType3 != aSTType;
                arrayList.add(aSTType3);
                ++n2;
            }
        }
        aSTType = null;
        if (this.valueType != null) {
            aSTType = this.valueType.accept(generatedBoogieAstTransformer);
        }
        if (bl || this.valueType != aSTType) {
            return new ArrayType(this.loc, this.boogieType, this.typeParams, arrayList.toArray(new ASTType[0]), aSTType);
        }
        return this;
    }
}

